/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.ActivityManager;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.ImageView;
import android.widget.RemoteViews;
import com.android.internal.widget.LocalImageResolver;

@RemoteViews.RemoteView
public class BigPictureNotificationImageView
extends ImageView {
    private static final String TAG = BigPictureNotificationImageView.class.getSimpleName();
    private final int mMaximumDrawableWidth;
    private final int mMaximumDrawableHeight;

    public BigPictureNotificationImageView(Context context) {
        this(context, null, 0, 0);
    }

    public BigPictureNotificationImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0, 0);
    }

    public BigPictureNotificationImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public BigPictureNotificationImageView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        boolean isLowRam = ActivityManager.isLowRamDeviceStatic();
        this.mMaximumDrawableWidth = context.getResources().getDimensionPixelSize(isLowRam ? 17105380 : 17105379);
        this.mMaximumDrawableHeight = context.getResources().getDimensionPixelSize(isLowRam ? 17105378 : 17105377);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageURIAsync")
    public void setImageURI(Uri uri) {
        this.setImageDrawable(this.loadImage(uri));
    }

    @Override
    public Runnable setImageURIAsync(Uri uri) {
        Drawable drawable2 = this.loadImage(uri);
        return () -> this.setImageDrawable(drawable2);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setImageIconAsync")
    public void setImageIcon(Icon icon2) {
        this.setImageDrawable(this.loadImage(icon2));
    }

    @Override
    public Runnable setImageIconAsync(Icon icon2) {
        Drawable drawable2 = this.loadImage(icon2);
        return () -> this.setImageDrawable(drawable2);
    }

    private Drawable loadImage(Uri uri) {
        if (uri == null) {
            return null;
        }
        return LocalImageResolver.resolveImage(uri, this.mContext, this.mMaximumDrawableWidth, this.mMaximumDrawableHeight);
    }

    private Drawable loadImage(Icon icon2) {
        if (icon2 == null) {
            return null;
        }
        Drawable drawable2 = LocalImageResolver.resolveImage(icon2, this.mContext, this.mMaximumDrawableWidth, this.mMaximumDrawableHeight);
        if (drawable2 == null) {
            return icon2.loadDrawable(this.mContext);
        }
        return drawable2;
    }
}

