/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.app.Person;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.FrameLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.CachingIconView;
import com.android.internal.widget.PeopleHelper;

@RemoteViews.RemoteView
public class CallLayout
extends FrameLayout {
    private final PeopleHelper mPeopleHelper = new PeopleHelper();
    private int mLayoutColor;
    private Icon mLargeIcon;
    private Person mUser;
    private CachingIconView mConversationIconView;
    private CachingIconView mIcon;
    private CachingIconView mConversationIconBadgeBg;
    private TextView mConversationText;

    public CallLayout(Context context) {
        super(context);
    }

    public CallLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public CallLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public CallLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPeopleHelper.init(this.getContext());
        this.mConversationText = (TextView)this.findViewById(16908929);
        this.mConversationIconView = (CachingIconView)this.findViewById(16908923);
        this.mIcon = (CachingIconView)this.findViewById(16908294);
        this.mConversationIconBadgeBg = (CachingIconView)this.findViewById(16908925);
        this.mIcon.setOnForceHiddenChangedListener(forceHidden -> this.mPeopleHelper.animateViewForceHidden(this.mConversationIconBadgeBg, (boolean)forceHidden));
    }

    private void updateCallLayout() {
        CharSequence callerName = "";
        String symbol = "";
        Icon icon2 = null;
        if (this.mUser != null) {
            icon2 = this.mUser.getIcon();
            callerName = this.mUser.getName();
            symbol = this.mPeopleHelper.findNamePrefix(callerName, "");
        }
        if (icon2 == null) {
            icon2 = this.mLargeIcon;
        }
        if (icon2 == null) {
            icon2 = this.mPeopleHelper.createAvatarSymbol(callerName, symbol, this.mLayoutColor);
        }
        this.mConversationIconView.setImageIcon(icon2);
    }

    @RemotableViewMethod
    public void setLayoutColor(int color2) {
        this.mLayoutColor = color2;
    }

    @RemotableViewMethod
    public void setNotificationBackgroundColor(int color2) {
        this.mConversationIconBadgeBg.setImageTintList(ColorStateList.valueOf(color2));
    }

    @RemotableViewMethod
    public void setLargeIcon(Icon largeIcon) {
        this.mLargeIcon = largeIcon;
    }

    @RemotableViewMethod
    public void setData(Bundle extras) {
        this.setUser((Person)extras.getParcelable("android.callPerson"));
        this.updateCallLayout();
    }

    private void setUser(Person user) {
        this.mUser = user;
    }
}

