/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.view.View;
import android.view.ViewGroup;
import com.android.internal.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;

class ChildHelper {
    private static final boolean DEBUG = false;
    private static final String TAG = "ChildrenHelper";
    final Callback mCallback;
    final Bucket mBucket;
    final List<View> mHiddenViews;

    ChildHelper(Callback callback2) {
        this.mCallback = callback2;
        this.mBucket = new Bucket();
        this.mHiddenViews = new ArrayList<View>();
    }

    private void hideViewInternal(View child) {
        this.mHiddenViews.add(child);
        this.mCallback.onEnteredHiddenState(child);
    }

    private boolean unhideViewInternal(View child) {
        if (this.mHiddenViews.remove(child)) {
            this.mCallback.onLeftHiddenState(child);
            return true;
        }
        return false;
    }

    void addView(View child, boolean hidden) {
        this.addView(child, -1, hidden);
    }

    void addView(View child, int index, boolean hidden) {
        int offset2 = index < 0 ? this.mCallback.getChildCount() : this.getOffset(index);
        this.mBucket.insert(offset2, hidden);
        if (hidden) {
            this.hideViewInternal(child);
        }
        this.mCallback.addView(child, offset2);
    }

    private int getOffset(int index) {
        int diff;
        if (index < 0) {
            return -1;
        }
        int limit = this.mCallback.getChildCount();
        for (int offset2 = index; offset2 < limit; offset2 += diff) {
            int removedBefore = this.mBucket.countOnesBefore(offset2);
            diff = index - (offset2 - removedBefore);
            if (diff != 0) continue;
            while (this.mBucket.get(offset2)) {
                ++offset2;
            }
            return offset2;
        }
        return -1;
    }

    void removeView(View view2) {
        int index = this.mCallback.indexOfChild(view2);
        if (index < 0) {
            return;
        }
        if (this.mBucket.remove(index)) {
            this.unhideViewInternal(view2);
        }
        this.mCallback.removeViewAt(index);
    }

    void removeViewAt(int index) {
        int offset2 = this.getOffset(index);
        View view2 = this.mCallback.getChildAt(offset2);
        if (view2 == null) {
            return;
        }
        if (this.mBucket.remove(offset2)) {
            this.unhideViewInternal(view2);
        }
        this.mCallback.removeViewAt(offset2);
    }

    View getChildAt(int index) {
        int offset2 = this.getOffset(index);
        return this.mCallback.getChildAt(offset2);
    }

    void removeAllViewsUnfiltered() {
        this.mBucket.reset();
        for (int i = this.mHiddenViews.size() - 1; i >= 0; --i) {
            this.mCallback.onLeftHiddenState(this.mHiddenViews.get(i));
            this.mHiddenViews.remove(i);
        }
        this.mCallback.removeAllViews();
    }

    View findHiddenNonRemovedView(int position) {
        int count = this.mHiddenViews.size();
        for (int i = 0; i < count; ++i) {
            View view2 = this.mHiddenViews.get(i);
            RecyclerView.ViewHolder holder = this.mCallback.getChildViewHolder(view2);
            if (holder.getLayoutPosition() != position || holder.isInvalid() || holder.isRemoved()) continue;
            return view2;
        }
        return null;
    }

    void attachViewToParent(View child, int index, ViewGroup.LayoutParams layoutParams, boolean hidden) {
        int offset2 = index < 0 ? this.mCallback.getChildCount() : this.getOffset(index);
        this.mBucket.insert(offset2, hidden);
        if (hidden) {
            this.hideViewInternal(child);
        }
        this.mCallback.attachViewToParent(child, offset2, layoutParams);
    }

    int getChildCount() {
        return this.mCallback.getChildCount() - this.mHiddenViews.size();
    }

    int getUnfilteredChildCount() {
        return this.mCallback.getChildCount();
    }

    View getUnfilteredChildAt(int index) {
        return this.mCallback.getChildAt(index);
    }

    void detachViewFromParent(int index) {
        int offset2 = this.getOffset(index);
        this.mBucket.remove(offset2);
        this.mCallback.detachViewFromParent(offset2);
    }

    int indexOfChild(View child) {
        int index = this.mCallback.indexOfChild(child);
        if (index == -1) {
            return -1;
        }
        if (this.mBucket.get(index)) {
            return -1;
        }
        return index - this.mBucket.countOnesBefore(index);
    }

    boolean isHidden(View view2) {
        return this.mHiddenViews.contains(view2);
    }

    void hide(View view2) {
        int offset2 = this.mCallback.indexOfChild(view2);
        if (offset2 < 0) {
            throw new IllegalArgumentException("view is not a child, cannot hide " + view2);
        }
        this.mBucket.set(offset2);
        this.hideViewInternal(view2);
    }

    void unhide(View view2) {
        int offset2 = this.mCallback.indexOfChild(view2);
        if (offset2 < 0) {
            throw new IllegalArgumentException("view is not a child, cannot hide " + view2);
        }
        if (!this.mBucket.get(offset2)) {
            throw new RuntimeException("trying to unhide a view that was not hidden" + view2);
        }
        this.mBucket.clear(offset2);
        this.unhideViewInternal(view2);
    }

    public String toString() {
        return this.mBucket.toString() + ", hidden list:" + this.mHiddenViews.size();
    }

    boolean removeViewIfHidden(View view2) {
        int index = this.mCallback.indexOfChild(view2);
        if (index == -1) {
            if (this.unhideViewInternal(view2)) {
                // empty if block
            }
            return true;
        }
        if (this.mBucket.get(index)) {
            this.mBucket.remove(index);
            if (!this.unhideViewInternal(view2)) {
                // empty if block
            }
            this.mCallback.removeViewAt(index);
            return true;
        }
        return false;
    }

    static interface Callback {
        public int getChildCount();

        public void addView(View var1, int var2);

        public int indexOfChild(View var1);

        public void removeViewAt(int var1);

        public View getChildAt(int var1);

        public void removeAllViews();

        public RecyclerView.ViewHolder getChildViewHolder(View var1);

        public void attachViewToParent(View var1, int var2, ViewGroup.LayoutParams var3);

        public void detachViewFromParent(int var1);

        public void onEnteredHiddenState(View var1);

        public void onLeftHiddenState(View var1);
    }

    static class Bucket {
        static final int BITS_PER_WORD = 64;
        static final long LAST_BIT = Long.MIN_VALUE;
        long mData = 0L;
        Bucket mNext;

        Bucket() {
        }

        void set(int index) {
            if (index >= 64) {
                this.ensureNext();
                this.mNext.set(index - 64);
            } else {
                this.mData |= 1L << index;
            }
        }

        private void ensureNext() {
            if (this.mNext == null) {
                this.mNext = new Bucket();
            }
        }

        void clear(int index) {
            if (index >= 64) {
                if (this.mNext != null) {
                    this.mNext.clear(index - 64);
                }
            } else {
                this.mData &= 1L << index ^ 0xFFFFFFFFFFFFFFFFL;
            }
        }

        boolean get(int index) {
            if (index >= 64) {
                this.ensureNext();
                return this.mNext.get(index - 64);
            }
            return (this.mData & 1L << index) != 0L;
        }

        void reset() {
            this.mData = 0L;
            if (this.mNext != null) {
                this.mNext.reset();
            }
        }

        void insert(int index, boolean value2) {
            if (index >= 64) {
                this.ensureNext();
                this.mNext.insert(index - 64, value2);
            } else {
                boolean lastBit = (this.mData & Long.MIN_VALUE) != 0L;
                long mask = (1L << index) - 1L;
                long before = this.mData & mask;
                long after = (this.mData & (mask ^ 0xFFFFFFFFFFFFFFFFL)) << 1;
                this.mData = before | after;
                if (value2) {
                    this.set(index);
                } else {
                    this.clear(index);
                }
                if (lastBit || this.mNext != null) {
                    this.ensureNext();
                    this.mNext.insert(0, lastBit);
                }
            }
        }

        boolean remove(int index) {
            if (index >= 64) {
                this.ensureNext();
                return this.mNext.remove(index - 64);
            }
            long mask = 1L << index;
            boolean value2 = (this.mData & mask) != 0L;
            this.mData &= mask ^ 0xFFFFFFFFFFFFFFFFL;
            long before = this.mData & --mask;
            long after = Long.rotateRight(this.mData & (mask ^ 0xFFFFFFFFFFFFFFFFL), 1);
            this.mData = before | after;
            if (this.mNext != null) {
                if (this.mNext.get(0)) {
                    this.set(63);
                }
                this.mNext.remove(0);
            }
            return value2;
        }

        int countOnesBefore(int index) {
            if (this.mNext == null) {
                if (index >= 64) {
                    return Long.bitCount(this.mData);
                }
                return Long.bitCount(this.mData & (1L << index) - 1L);
            }
            if (index < 64) {
                return Long.bitCount(this.mData & (1L << index) - 1L);
            }
            return this.mNext.countOnesBefore(index - 64) + Long.bitCount(this.mData);
        }

        public String toString() {
            return this.mNext == null ? Long.toBinaryString(this.mData) : this.mNext.toString() + "xx" + Long.toBinaryString(this.mData);
        }
    }
}

