/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.app.Notification;
import android.app.Person;
import android.app.RemoteInputHistoryItem;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.RemotableViewMethod;
import android.view.TouchDelegate;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.CachingIconView;
import com.android.internal.widget.IMessagingLayout;
import com.android.internal.widget.ImageMessageConsumer;
import com.android.internal.widget.ImageResolver;
import com.android.internal.widget.MessagingGroup;
import com.android.internal.widget.MessagingImageMessage;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.MessagingMessage;
import com.android.internal.widget.MessagingPropertyAnimator;
import com.android.internal.widget.NotificationActionListLayout;
import com.android.internal.widget.NotificationExpandButton;
import com.android.internal.widget.ObservableTextView;
import com.android.internal.widget.PeopleHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@RemoteViews.RemoteView
public class ConversationLayout
extends FrameLayout
implements ImageMessageConsumer,
IMessagingLayout {
    public static final Interpolator LINEAR_OUT_SLOW_IN = new PathInterpolator(0.0f, 0.0f, 0.2f, 1.0f);
    public static final Interpolator FAST_OUT_LINEAR_IN = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator FAST_OUT_SLOW_IN = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.0f);
    public static final Interpolator OVERSHOOT = new PathInterpolator(0.4f, 0.0f, 0.2f, 1.4f);
    public static final View.OnLayoutChangeListener MESSAGING_PROPERTY_ANIMATOR = new MessagingPropertyAnimator();
    public static final int IMPORTANCE_ANIM_GROW_DURATION = 250;
    public static final int IMPORTANCE_ANIM_SHRINK_DURATION = 200;
    public static final int IMPORTANCE_ANIM_SHRINK_DELAY = 25;
    private final PeopleHelper mPeopleHelper = new PeopleHelper();
    private List<MessagingMessage> mMessages = new ArrayList<MessagingMessage>();
    private List<MessagingMessage> mHistoricMessages = new ArrayList<MessagingMessage>();
    private MessagingLinearLayout mMessagingLinearLayout;
    private boolean mShowHistoricMessages;
    private ArrayList<MessagingGroup> mGroups = new ArrayList();
    private int mLayoutColor;
    private int mSenderTextColor;
    private int mMessageTextColor;
    private Icon mAvatarReplacement;
    private boolean mIsOneToOne;
    private ArrayList<MessagingGroup> mAddedGroups = new ArrayList();
    private Person mUser;
    private CharSequence mNameReplacement;
    private boolean mIsCollapsed;
    private ImageResolver mImageResolver;
    private CachingIconView mConversationIconView;
    private View mConversationIconContainer;
    private int mConversationIconTopPaddingExpandedGroup;
    private int mConversationIconTopPadding;
    private int mExpandedGroupMessagePadding;
    private TextView mConversationText;
    private View mConversationIconBadge;
    private CachingIconView mConversationIconBadgeBg;
    private Icon mLargeIcon;
    private View mExpandButtonContainer;
    private ViewGroup mExpandButtonAndContentContainer;
    private NotificationExpandButton mExpandButton;
    private MessagingLinearLayout mImageMessageContainer;
    private int mBadgeProtrusion;
    private int mConversationAvatarSize;
    private int mConversationAvatarSizeExpanded;
    private CachingIconView mIcon;
    private CachingIconView mImportanceRingView;
    private int mExpandedGroupBadgeProtrusion;
    private int mExpandedGroupBadgeProtrusionFacePile;
    private View mConversationFacePile;
    private int mNotificationBackgroundColor;
    private CharSequence mFallbackChatName;
    private CharSequence mFallbackGroupChatName;
    private CharSequence mConversationTitle;
    private int mMessageSpacingStandard;
    private int mMessageSpacingGroup;
    private int mNotificationHeaderExpandedPadding;
    private View mConversationHeader;
    private View mContentContainer;
    private boolean mExpandable = true;
    private int mContentMarginEnd;
    private Rect mMessagingClipRect;
    private ObservableTextView mAppName;
    private NotificationActionListLayout mActions;
    private boolean mAppNameGone;
    private int mFacePileAvatarSize;
    private int mFacePileAvatarSizeExpandedGroup;
    private int mFacePileProtectionWidth;
    private int mFacePileProtectionWidthExpanded;
    private boolean mImportantConversation;
    private View mFeedbackIcon;
    private float mMinTouchSize;
    private Icon mConversationIcon;
    private Icon mShortcutIcon;
    private View mAppNameDivider;
    private TouchDelegateComposite mTouchDelegate = new TouchDelegateComposite(this);
    private ArrayList<MessagingLinearLayout.MessagingChild> mToRecycle = new ArrayList();

    public ConversationLayout(Context context) {
        super(context);
    }

    public ConversationLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ConversationLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ConversationLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mPeopleHelper.init(this.getContext());
        this.mMessagingLinearLayout = (MessagingLinearLayout)this.findViewById(16909294);
        this.mActions = (NotificationActionListLayout)this.findViewById(16908743);
        this.mImageMessageContainer = (MessagingLinearLayout)this.findViewById(16908928);
        DisplayMetrics displayMetrics = this.getResources().getDisplayMetrics();
        int size = Math.max(displayMetrics.widthPixels, displayMetrics.heightPixels);
        this.mMessagingClipRect = new Rect(0, 0, size, size);
        this.setMessagingClippingDisabled(false);
        this.mConversationIconView = (CachingIconView)this.findViewById(16908923);
        this.mConversationIconContainer = this.findViewById(16908927);
        this.mIcon = (CachingIconView)this.findViewById(16908294);
        this.mFeedbackIcon = this.findViewById(16908995);
        this.mMinTouchSize = 48.0f * this.getResources().getDisplayMetrics().density;
        this.mImportanceRingView = (CachingIconView)this.findViewById(16908926);
        this.mConversationIconBadge = this.findViewById(16908924);
        this.mConversationIconBadgeBg = (CachingIconView)this.findViewById(16908925);
        this.mIcon.setOnVisibilityChangedListener(visibility -> {
            boolean isRingGone;
            boolean wasGone;
            boolean isGone = visibility == 8;
            int oldVisibility = this.mConversationIconBadgeBg.getVisibility();
            boolean bl = wasGone = oldVisibility == 8;
            if (wasGone != isGone) {
                this.mConversationIconBadgeBg.animate().cancel();
                this.mConversationIconBadgeBg.setVisibility((int)visibility);
            }
            wasGone = (oldVisibility = this.mImportanceRingView.getVisibility()) == 8;
            visibility = !this.mImportantConversation ? 8 : visibility;
            boolean bl2 = isRingGone = visibility == 8;
            if (wasGone != isRingGone) {
                this.mImportanceRingView.animate().cancel();
                this.mImportanceRingView.setVisibility((int)visibility);
            }
            boolean bl3 = wasGone = (oldVisibility = this.mConversationIconBadge.getVisibility()) == 8;
            if (wasGone != isGone) {
                this.mConversationIconBadge.animate().cancel();
                this.mConversationIconBadge.setVisibility((int)visibility);
            }
        });
        this.mIcon.setOnForceHiddenChangedListener(forceHidden -> {
            this.mPeopleHelper.animateViewForceHidden(this.mConversationIconBadgeBg, (boolean)forceHidden);
            this.mPeopleHelper.animateViewForceHidden(this.mImportanceRingView, (boolean)forceHidden);
        });
        this.mConversationIconView.setOnForceHiddenChangedListener(forceHidden -> {
            this.mPeopleHelper.animateViewForceHidden(this.mConversationIconBadgeBg, (boolean)forceHidden);
            this.mPeopleHelper.animateViewForceHidden(this.mImportanceRingView, (boolean)forceHidden);
            this.mPeopleHelper.animateViewForceHidden(this.mIcon, (boolean)forceHidden);
        });
        this.mConversationText = (TextView)this.findViewById(16908929);
        this.mExpandButtonContainer = this.findViewById(16908984);
        this.mConversationHeader = this.findViewById(16908922);
        this.mContentContainer = this.findViewById(16909281);
        this.mExpandButtonAndContentContainer = (ViewGroup)this.findViewById(16908983);
        this.mExpandButton = (NotificationExpandButton)this.findViewById(16908982);
        this.mMessageSpacingStandard = this.getResources().getDimensionPixelSize(17105418);
        this.mMessageSpacingGroup = this.getResources().getDimensionPixelSize(17105419);
        this.mNotificationHeaderExpandedPadding = this.getResources().getDimensionPixelSize(17105138);
        this.mContentMarginEnd = this.getResources().getDimensionPixelSize(17105383);
        this.mBadgeProtrusion = this.getResources().getDimensionPixelSize(17105129);
        this.mConversationAvatarSize = this.getResources().getDimensionPixelSize(17105127);
        this.mConversationAvatarSizeExpanded = this.getResources().getDimensionPixelSize(17105128);
        this.mConversationIconTopPaddingExpandedGroup = this.getResources().getDimensionPixelSize(17105141);
        this.mConversationIconTopPadding = this.getResources().getDimensionPixelSize(17105140);
        this.mExpandedGroupMessagePadding = this.getResources().getDimensionPixelSize(17105210);
        this.mExpandedGroupBadgeProtrusion = this.getResources().getDimensionPixelSize(17105130);
        this.mExpandedGroupBadgeProtrusionFacePile = this.getResources().getDimensionPixelSize(17105131);
        this.mConversationFacePile = this.findViewById(16908918);
        this.mFacePileAvatarSize = this.getResources().getDimensionPixelSize(17105134);
        this.mFacePileAvatarSizeExpandedGroup = this.getResources().getDimensionPixelSize(17105135);
        this.mFacePileProtectionWidth = this.getResources().getDimensionPixelSize(17105136);
        this.mFacePileProtectionWidthExpanded = this.getResources().getDimensionPixelSize(17105137);
        this.mFallbackChatName = this.getResources().getString(17040087);
        this.mFallbackGroupChatName = this.getResources().getString(17040086);
        this.mAppName = (ObservableTextView)this.findViewById(16908784);
        this.mAppNameDivider = this.findViewById(16908783);
        this.mAppNameGone = this.mAppName.getVisibility() == 8;
        this.mAppName.setOnVisibilityChangedListener(visibility -> this.onAppNameVisibilityChanged());
    }

    @RemotableViewMethod
    public void setAvatarReplacement(Icon icon2) {
        this.mAvatarReplacement = icon2;
    }

    @RemotableViewMethod
    public void setNameReplacement(CharSequence nameReplacement) {
        this.mNameReplacement = nameReplacement;
    }

    @RemotableViewMethod
    public void setIsImportantConversation(boolean isImportantConversation) {
        this.setIsImportantConversation(isImportantConversation, false);
    }

    public void setIsImportantConversation(boolean isImportantConversation, boolean animate) {
        this.mImportantConversation = isImportantConversation;
        this.mImportanceRingView.setVisibility(isImportantConversation && this.mIcon.getVisibility() != 8 ? 0 : 8);
        if (animate && isImportantConversation) {
            GradientDrawable ring = (GradientDrawable)this.mImportanceRingView.getDrawable();
            ring.mutate();
            final GradientDrawable bg = (GradientDrawable)this.mConversationIconBadgeBg.getDrawable();
            bg.mutate();
            int ringColor = this.getResources().getColor(17170819);
            int standardThickness = this.getResources().getDimensionPixelSize(17105253);
            int largeThickness = this.getResources().getDimensionPixelSize(17105251);
            int standardSize = this.getResources().getDimensionPixelSize(17105252);
            final int baseSize = standardSize - standardThickness * 2;
            final int bgSize = this.getResources().getDimensionPixelSize(17105142);
            ValueAnimator.AnimatorUpdateListener animatorUpdateListener = animation -> {
                int strokeWidth = Math.round(((Float)animation.getAnimatedValue()).floatValue());
                ring.setStroke(strokeWidth, ringColor);
                int newSize = baseSize + strokeWidth * 2;
                ring.setSize(newSize, newSize);
                this.mImportanceRingView.invalidate();
            };
            ValueAnimator growAnimation = ValueAnimator.ofFloat(0.0f, largeThickness);
            growAnimation.setInterpolator(LINEAR_OUT_SLOW_IN);
            growAnimation.setDuration(250L);
            growAnimation.addUpdateListener(animatorUpdateListener);
            ValueAnimator shrinkAnimation = ValueAnimator.ofFloat(largeThickness, standardThickness);
            shrinkAnimation.setDuration(200L);
            shrinkAnimation.setStartDelay(25L);
            shrinkAnimation.setInterpolator(OVERSHOOT);
            shrinkAnimation.addUpdateListener(animatorUpdateListener);
            shrinkAnimation.addListener(new AnimatorListenerAdapter(){

                @Override
                public void onAnimationStart(Animator animation) {
                    bg.setSize(baseSize, baseSize);
                    ConversationLayout.this.mConversationIconBadgeBg.invalidate();
                }

                @Override
                public void onAnimationEnd(Animator animation) {
                    bg.setSize(bgSize, bgSize);
                    ConversationLayout.this.mConversationIconBadgeBg.invalidate();
                }
            });
            AnimatorSet anims = new AnimatorSet();
            anims.playSequentially(growAnimation, shrinkAnimation);
            anims.start();
        }
    }

    public boolean isImportantConversation() {
        return this.mImportantConversation;
    }

    @RemotableViewMethod
    public void setIsCollapsed(boolean isCollapsed) {
        this.mIsCollapsed = isCollapsed;
        this.mMessagingLinearLayout.setMaxDisplayedLines(isCollapsed ? 1 : Integer.MAX_VALUE);
        this.updateExpandButton();
        this.updateContentEndPaddings();
    }

    @RemotableViewMethod
    public void setData(Bundle extras) {
        Parcelable[] messages = extras.getParcelableArray("android.messages");
        List<Notification.MessagingStyle.Message> newMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(messages);
        Parcelable[] histMessages = extras.getParcelableArray("android.messages.historic");
        List<Notification.MessagingStyle.Message> newHistoricMessages = Notification.MessagingStyle.Message.getMessagesFromBundleArray(histMessages);
        this.setUser((Person)extras.getParcelable("android.messagingUser"));
        RemoteInputHistoryItem[] history = (RemoteInputHistoryItem[])extras.getParcelableArray("android.remoteInputHistoryItems");
        this.addRemoteInputHistoryToMessages(newMessages, history);
        boolean showSpinner = extras.getBoolean("android.remoteInputSpinner", false);
        this.bind(newMessages, newHistoricMessages, showSpinner);
        int unreadCount = extras.getInt("android.conversationUnreadMessageCount");
        this.setUnreadCount(unreadCount);
    }

    @Override
    public void setImageResolver(ImageResolver resolver) {
        this.mImageResolver = resolver;
    }

    public void setUnreadCount(int unreadCount) {
        this.mExpandButton.setNumber(unreadCount);
    }

    private void addRemoteInputHistoryToMessages(List<Notification.MessagingStyle.Message> newMessages, RemoteInputHistoryItem[] remoteInputHistory) {
        if (remoteInputHistory == null || remoteInputHistory.length == 0) {
            return;
        }
        for (int i = remoteInputHistory.length - 1; i >= 0; --i) {
            RemoteInputHistoryItem historyMessage = remoteInputHistory[i];
            Notification.MessagingStyle.Message message = new Notification.MessagingStyle.Message(historyMessage.getText(), 0L, null, true);
            if (historyMessage.getUri() != null) {
                message.setData(historyMessage.getMimeType(), historyMessage.getUri());
            }
            newMessages.add(message);
        }
    }

    private void bind(List<Notification.MessagingStyle.Message> newMessages, List<Notification.MessagingStyle.Message> newHistoricMessages, boolean showSpinner) {
        List<MessagingMessage> historicMessages = this.createMessages(newHistoricMessages, true);
        List<MessagingMessage> messages = this.createMessages(newMessages, false);
        ArrayList<MessagingGroup> oldGroups = new ArrayList<MessagingGroup>(this.mGroups);
        ArrayList<List<MessagingMessage>> groups2 = new ArrayList<List<MessagingMessage>>();
        ArrayList<Person> senders = new ArrayList<Person>();
        this.findGroups(historicMessages, messages, groups2, senders);
        this.createGroupViews(groups2, senders, showSpinner);
        this.removeGroups(oldGroups);
        for (MessagingMessage message : this.mMessages) {
            message.removeMessage(this.mToRecycle);
        }
        for (MessagingMessage historicMessage : this.mHistoricMessages) {
            historicMessage.removeMessage(this.mToRecycle);
        }
        this.mMessages = messages;
        this.mHistoricMessages = historicMessages;
        this.updateHistoricMessageVisibility();
        this.updateTitleAndNamesDisplay();
        this.updateConversationLayout();
        for (MessagingLinearLayout.MessagingChild child : this.mToRecycle) {
            child.recycle();
        }
        this.mToRecycle.clear();
    }

    private void updateConversationLayout() {
        CharSequence conversationText = this.mConversationTitle;
        this.mConversationIcon = this.mShortcutIcon;
        if (this.mIsOneToOne) {
            CharSequence userKey = this.getKey(this.mUser);
            for (int i = this.mGroups.size() - 1; i >= 0; --i) {
                MessagingGroup messagingGroup = this.mGroups.get(i);
                Person messageSender = messagingGroup.getSender();
                if ((messageSender == null || TextUtils.equals(userKey, this.getKey(messageSender))) && i != 0) continue;
                if (TextUtils.isEmpty(conversationText)) {
                    conversationText = messagingGroup.getSenderName();
                }
                if (this.mConversationIcon != null) break;
                Icon avatarIcon = messagingGroup.getAvatarIcon();
                if (avatarIcon == null) {
                    avatarIcon = this.mPeopleHelper.createAvatarSymbol(conversationText, "", this.mLayoutColor);
                }
                this.mConversationIcon = avatarIcon;
                break;
            }
        }
        if (this.mConversationIcon == null) {
            this.mConversationIcon = this.mLargeIcon;
        }
        if (this.mIsOneToOne || this.mConversationIcon != null) {
            this.mConversationIconView.setVisibility(0);
            this.mConversationFacePile.setVisibility(8);
            this.mConversationIconView.setImageIcon(this.mConversationIcon);
        } else {
            this.mConversationIconView.setVisibility(8);
            this.mConversationFacePile.setVisibility(0);
            this.mConversationFacePile = this.findViewById(16908918);
            this.bindFacePile();
        }
        if (TextUtils.isEmpty(conversationText)) {
            conversationText = this.mIsOneToOne ? this.mFallbackChatName : this.mFallbackGroupChatName;
        }
        this.mConversationText.setText(conversationText);
        this.mPeopleHelper.maybeHideFirstSenderName(this.mGroups, this.mIsOneToOne, conversationText);
        this.updateAppName();
        this.updateIconPositionAndSize();
        this.updateImageMessages();
        this.updatePaddingsBasedOnContentAvailability();
        this.updateActionListPadding();
        this.updateAppNameDividerVisibility();
    }

    private void updateActionListPadding() {
        if (this.mActions != null) {
            this.mActions.setCollapsibleIndentDimen(17104975);
        }
    }

    private void updateImageMessages() {
        View previousMessage;
        MessagingGroup messagingGroup;
        MessagingImageMessage isolatedMessage;
        View newMessage = null;
        if (this.mIsCollapsed && this.mGroups.size() > 0 && (isolatedMessage = (messagingGroup = this.mGroups.get(this.mGroups.size() - 1)).getIsolatedMessage()) != null) {
            newMessage = isolatedMessage.getView();
        }
        if ((previousMessage = this.mImageMessageContainer.getChildAt(0)) != newMessage) {
            this.mImageMessageContainer.removeView(previousMessage);
            if (newMessage != null) {
                this.mImageMessageContainer.addView(newMessage);
            }
        }
        this.mImageMessageContainer.setVisibility(newMessage != null ? 0 : 8);
    }

    public void bindFacePile(ImageView bottomBackground, ImageView bottomView, ImageView topView) {
        this.applyNotificationBackgroundColor(bottomBackground);
        Icon secondLastIcon = null;
        CharSequence lastKey = null;
        Icon lastIcon = null;
        CharSequence userKey = this.getKey(this.mUser);
        for (int i = this.mGroups.size() - 1; i >= 0; --i) {
            boolean notIncluded;
            MessagingGroup messagingGroup = this.mGroups.get(i);
            Person messageSender = messagingGroup.getSender();
            boolean notUser = messageSender != null && !TextUtils.equals(userKey, this.getKey(messageSender));
            boolean bl = notIncluded = messageSender != null && !TextUtils.equals(lastKey, this.getKey(messageSender));
            if ((!notUser || !notIncluded) && (i != 0 || lastKey != null)) continue;
            if (lastIcon == null) {
                lastIcon = messagingGroup.getAvatarIcon();
                lastKey = this.getKey(messageSender);
                continue;
            }
            secondLastIcon = messagingGroup.getAvatarIcon();
            break;
        }
        if (lastIcon == null) {
            lastIcon = this.mPeopleHelper.createAvatarSymbol(" ", "", this.mLayoutColor);
        }
        bottomView.setImageIcon(lastIcon);
        if (secondLastIcon == null) {
            secondLastIcon = this.mPeopleHelper.createAvatarSymbol("", "", this.mLayoutColor);
        }
        topView.setImageIcon(secondLastIcon);
    }

    private void bindFacePile() {
        int facePileBackgroundSize;
        int facepileAvatarSize;
        int conversationAvatarSize;
        ImageView bottomBackground = (ImageView)this.mConversationFacePile.findViewById(16908920);
        ImageView bottomView = (ImageView)this.mConversationFacePile.findViewById(16908919);
        ImageView topView = (ImageView)this.mConversationFacePile.findViewById(16908921);
        this.bindFacePile(bottomBackground, bottomView, topView);
        if (this.mIsCollapsed) {
            conversationAvatarSize = this.mConversationAvatarSize;
            facepileAvatarSize = this.mFacePileAvatarSize;
            facePileBackgroundSize = facepileAvatarSize + 2 * this.mFacePileProtectionWidth;
        } else {
            conversationAvatarSize = this.mConversationAvatarSizeExpanded;
            facepileAvatarSize = this.mFacePileAvatarSizeExpandedGroup;
            facePileBackgroundSize = facepileAvatarSize + 2 * this.mFacePileProtectionWidthExpanded;
        }
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)this.mConversationFacePile.getLayoutParams();
        layoutParams.width = conversationAvatarSize;
        layoutParams.height = conversationAvatarSize;
        this.mConversationFacePile.setLayoutParams(layoutParams);
        layoutParams = (FrameLayout.LayoutParams)bottomView.getLayoutParams();
        layoutParams.width = facepileAvatarSize;
        layoutParams.height = facepileAvatarSize;
        bottomView.setLayoutParams(layoutParams);
        layoutParams = (FrameLayout.LayoutParams)topView.getLayoutParams();
        layoutParams.width = facepileAvatarSize;
        layoutParams.height = facepileAvatarSize;
        topView.setLayoutParams(layoutParams);
        layoutParams = (FrameLayout.LayoutParams)bottomBackground.getLayoutParams();
        layoutParams.width = facePileBackgroundSize;
        layoutParams.height = facePileBackgroundSize;
        bottomBackground.setLayoutParams(layoutParams);
    }

    private void updateAppName() {
        this.mAppName.setVisibility(this.mIsCollapsed ? 8 : 0);
    }

    public boolean shouldHideAppName() {
        return this.mIsCollapsed;
    }

    private void updateIconPositionAndSize() {
        FrameLayout.LayoutParams layoutParams;
        int conversationAvatarSize;
        int badgeProtrusion;
        if (this.mIsOneToOne || this.mIsCollapsed) {
            badgeProtrusion = this.mBadgeProtrusion;
            conversationAvatarSize = this.mConversationAvatarSize;
        } else {
            badgeProtrusion = this.mConversationFacePile.getVisibility() == 0 ? this.mExpandedGroupBadgeProtrusionFacePile : this.mExpandedGroupBadgeProtrusion;
            conversationAvatarSize = this.mConversationAvatarSizeExpanded;
        }
        if (this.mConversationIconView.getVisibility() == 0) {
            layoutParams = (FrameLayout.LayoutParams)this.mConversationIconView.getLayoutParams();
            layoutParams.width = conversationAvatarSize;
            layoutParams.height = conversationAvatarSize;
            layoutParams.leftMargin = badgeProtrusion;
            layoutParams.rightMargin = badgeProtrusion;
            layoutParams.bottomMargin = badgeProtrusion;
            this.mConversationIconView.setLayoutParams(layoutParams);
        }
        if (this.mConversationFacePile.getVisibility() == 0) {
            layoutParams = (FrameLayout.LayoutParams)this.mConversationFacePile.getLayoutParams();
            layoutParams.leftMargin = badgeProtrusion;
            layoutParams.rightMargin = badgeProtrusion;
            layoutParams.bottomMargin = badgeProtrusion;
            this.mConversationFacePile.setLayoutParams(layoutParams);
        }
    }

    private void updatePaddingsBasedOnContentAvailability() {
        this.mMessagingLinearLayout.setSpacing(this.mIsOneToOne ? this.mMessageSpacingStandard : this.mMessageSpacingGroup);
        int messagingPadding = this.mIsOneToOne || this.mIsCollapsed ? 0 : this.mExpandedGroupMessagePadding;
        int iconPadding = this.mIsOneToOne || this.mIsCollapsed ? this.mConversationIconTopPadding : this.mConversationIconTopPaddingExpandedGroup;
        this.mConversationIconContainer.setPaddingRelative(this.mConversationIconContainer.getPaddingStart(), iconPadding, this.mConversationIconContainer.getPaddingEnd(), this.mConversationIconContainer.getPaddingBottom());
        this.mMessagingLinearLayout.setPaddingRelative(this.mMessagingLinearLayout.getPaddingStart(), messagingPadding, this.mMessagingLinearLayout.getPaddingEnd(), this.mMessagingLinearLayout.getPaddingBottom());
    }

    @RemotableViewMethod
    public void setLargeIcon(Icon largeIcon) {
        this.mLargeIcon = largeIcon;
    }

    @RemotableViewMethod
    public void setShortcutIcon(Icon shortcutIcon) {
        this.mShortcutIcon = shortcutIcon;
    }

    @RemotableViewMethod
    public void setConversationTitle(CharSequence conversationTitle) {
        this.mConversationTitle = conversationTitle != null ? conversationTitle.toString() : null;
    }

    public CharSequence getConversationTitle() {
        return this.mConversationText.getText();
    }

    private void removeGroups(ArrayList<MessagingGroup> oldGroups) {
        int size = oldGroups.size();
        for (int i = 0; i < size; ++i) {
            MessagingGroup group = oldGroups.get(i);
            if (this.mGroups.contains(group)) continue;
            List<MessagingMessage> messages = group.getMessages();
            boolean wasShown = group.isShown();
            this.mMessagingLinearLayout.removeView(group);
            if (wasShown && !MessagingLinearLayout.isGone(group)) {
                this.mMessagingLinearLayout.addTransientView(group, 0);
                group.removeGroupAnimated(() -> {
                    this.mMessagingLinearLayout.removeTransientView(group);
                    group.recycle();
                });
            } else {
                this.mToRecycle.add(group);
            }
            this.mMessages.removeAll(messages);
            this.mHistoricMessages.removeAll(messages);
        }
    }

    private void updateTitleAndNamesDisplay() {
        MessagingGroup group;
        int i;
        Map<CharSequence, String> uniqueNames = this.mPeopleHelper.mapUniqueNamesToPrefix(this.mGroups);
        ArrayMap<CharSequence, Icon> cachedAvatars = new ArrayMap<CharSequence, Icon>();
        for (i = 0; i < this.mGroups.size(); ++i) {
            String symbol;
            Icon cachedIcon;
            group = this.mGroups.get(i);
            boolean isOwnMessage = group.getSender() == this.mUser;
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName) || this.mIsOneToOne && this.mAvatarReplacement != null && !isOwnMessage || (cachedIcon = group.getAvatarSymbolIfMatching(senderName, symbol = uniqueNames.get(senderName), this.mLayoutColor)) == null) continue;
            cachedAvatars.put(senderName, cachedIcon);
        }
        for (i = 0; i < this.mGroups.size(); ++i) {
            group = this.mGroups.get(i);
            CharSequence senderName = group.getSenderName();
            if (!group.needsGeneratedAvatar() || TextUtils.isEmpty(senderName)) continue;
            if (this.mIsOneToOne && this.mAvatarReplacement != null && group.getSender() != this.mUser) {
                group.setAvatar(this.mAvatarReplacement);
                continue;
            }
            Icon cachedIcon = (Icon)cachedAvatars.get(senderName);
            if (cachedIcon == null) {
                cachedIcon = this.mPeopleHelper.createAvatarSymbol(senderName, uniqueNames.get(senderName), this.mLayoutColor);
                cachedAvatars.put(senderName, cachedIcon);
            }
            group.setCreatedAvatar(cachedIcon, senderName, uniqueNames.get(senderName), this.mLayoutColor);
        }
    }

    @RemotableViewMethod
    public void setLayoutColor(int color2) {
        this.mLayoutColor = color2;
    }

    @RemotableViewMethod
    public void setIsOneToOne(boolean oneToOne) {
        this.mIsOneToOne = oneToOne;
    }

    @RemotableViewMethod
    public void setSenderTextColor(int color2) {
        this.mSenderTextColor = color2;
        this.mConversationText.setTextColor(color2);
    }

    @RemotableViewMethod
    public void setNotificationBackgroundColor(int color2) {
        this.mNotificationBackgroundColor = color2;
        this.applyNotificationBackgroundColor(this.mConversationIconBadgeBg);
    }

    private void applyNotificationBackgroundColor(ImageView view2) {
        view2.setImageTintList(ColorStateList.valueOf(this.mNotificationBackgroundColor));
    }

    @RemotableViewMethod
    public void setMessageTextColor(int color2) {
        this.mMessageTextColor = color2;
    }

    private void setUser(Person user) {
        this.mUser = user;
        if (this.mUser.getIcon() == null) {
            Icon userIcon = Icon.createWithResource(this.getContext(), 17303075);
            userIcon.setTint(this.mLayoutColor);
            this.mUser = this.mUser.toBuilder().setIcon(userIcon).build();
        }
    }

    private void createGroupViews(List<List<MessagingMessage>> groups2, List<Person> senders, boolean showSpinner) {
        this.mGroups.clear();
        for (int groupIndex = 0; groupIndex < groups2.size(); ++groupIndex) {
            MessagingMessage message;
            List<MessagingMessage> group = groups2.get(groupIndex);
            View newGroup = null;
            for (int messageIndex = group.size() - 1; messageIndex >= 0 && (newGroup = (message = group.get(messageIndex)).getGroup()) == null; --messageIndex) {
            }
            if (newGroup == null) {
                newGroup = MessagingGroup.createGroup(this.mMessagingLinearLayout);
                this.mAddedGroups.add((MessagingGroup)newGroup);
            } else if (newGroup.getParent() != this.mMessagingLinearLayout) {
                throw new IllegalStateException("group parent was " + newGroup.getParent() + " but expected " + this.mMessagingLinearLayout);
            }
            ((MessagingGroup)newGroup).setImageDisplayLocation(this.mIsCollapsed ? 2 : 0);
            ((MessagingGroup)newGroup).setIsInConversation(true);
            ((MessagingGroup)newGroup).setLayoutColor(this.mLayoutColor);
            ((MessagingGroup)newGroup).setTextColors(this.mSenderTextColor, this.mMessageTextColor);
            Person sender = senders.get(groupIndex);
            CharSequence nameOverride = null;
            if (sender != this.mUser && this.mNameReplacement != null) {
                nameOverride = this.mNameReplacement;
            }
            ((MessagingGroup)newGroup).setShowingAvatar(!this.mIsOneToOne && !this.mIsCollapsed);
            ((MessagingGroup)newGroup).setSingleLine(this.mIsCollapsed);
            ((MessagingGroup)newGroup).setSender(sender, nameOverride);
            ((MessagingGroup)newGroup).setSending(groupIndex == groups2.size() - 1 && showSpinner);
            this.mGroups.add((MessagingGroup)newGroup);
            if (this.mMessagingLinearLayout.indexOfChild(newGroup) != groupIndex) {
                this.mMessagingLinearLayout.removeView(newGroup);
                this.mMessagingLinearLayout.addView(newGroup, groupIndex);
            }
            ((MessagingGroup)newGroup).setMessages(group);
        }
    }

    private void findGroups(List<MessagingMessage> historicMessages, List<MessagingMessage> messages, List<List<MessagingMessage>> groups2, List<Person> senders) {
        CharSequence currentSenderKey = null;
        ArrayList<MessagingMessage> currentGroup = null;
        int histSize = historicMessages.size();
        for (int i = 0; i < histSize + messages.size(); ++i) {
            MessagingMessage message = i < histSize ? historicMessages.get(i) : messages.get(i - histSize);
            boolean isNewGroup = currentGroup == null;
            Person sender = message.getMessage().getSenderPerson();
            CharSequence key = this.getKey(sender);
            if (isNewGroup |= !TextUtils.equals(key, currentSenderKey)) {
                currentGroup = new ArrayList<MessagingMessage>();
                groups2.add(currentGroup);
                sender = sender == null ? this.mUser : sender.toBuilder().setName(Objects.toString(sender.getName())).build();
                senders.add(sender);
                currentSenderKey = key;
            }
            currentGroup.add(message);
        }
    }

    private CharSequence getKey(Person person) {
        return person == null ? null : (person.getKey() == null ? person.getName() : person.getKey());
    }

    private List<MessagingMessage> createMessages(List<Notification.MessagingStyle.Message> newMessages, boolean historic) {
        ArrayList<MessagingMessage> result = new ArrayList<MessagingMessage>();
        for (int i = 0; i < newMessages.size(); ++i) {
            Notification.MessagingStyle.Message m = newMessages.get(i);
            MessagingMessage message = this.findAndRemoveMatchingMessage(m);
            if (message == null) {
                message = MessagingMessage.createMessage(this, m, this.mImageResolver);
            }
            message.setIsHistoric(historic);
            result.add(message);
        }
        return result;
    }

    private MessagingMessage findAndRemoveMatchingMessage(Notification.MessagingStyle.Message m) {
        MessagingMessage existing;
        int i;
        for (i = 0; i < this.mMessages.size(); ++i) {
            existing = this.mMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mMessages.remove(i);
            return existing;
        }
        for (i = 0; i < this.mHistoricMessages.size(); ++i) {
            existing = this.mHistoricMessages.get(i);
            if (!existing.sameAs(m)) continue;
            this.mHistoricMessages.remove(i);
            return existing;
        }
        return null;
    }

    public void showHistoricMessages(boolean show2) {
        this.mShowHistoricMessages = show2;
        this.updateHistoricMessageVisibility();
    }

    private void updateHistoricMessageVisibility() {
        int numHistoric = this.mHistoricMessages.size();
        for (int i = 0; i < numHistoric; ++i) {
            MessagingMessage existing = this.mHistoricMessages.get(i);
            existing.setVisibility(this.mShowHistoricMessages ? 0 : 8);
        }
        int numGroups = this.mGroups.size();
        for (int i = 0; i < numGroups; ++i) {
            MessagingGroup group = this.mGroups.get(i);
            int visibleChildren = 0;
            List<MessagingMessage> messages = group.getMessages();
            int numGroupMessages = messages.size();
            for (int j = 0; j < numGroupMessages; ++j) {
                MessagingMessage message = messages.get(j);
                if (message.getVisibility() == 8) continue;
                ++visibleChildren;
            }
            if (visibleChildren > 0 && group.getVisibility() == 8) {
                group.setVisibility(0);
                continue;
            }
            if (visibleChildren != 0 || group.getVisibility() == 8) continue;
            group.setVisibility(8);
        }
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right2, int bottom2) {
        super.onLayout(changed, left, top, right2, bottom2);
        if (!this.mAddedGroups.isEmpty()) {
            this.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    for (MessagingGroup group : ConversationLayout.this.mAddedGroups) {
                        if (!group.isShown()) continue;
                        MessagingPropertyAnimator.fadeIn(group.getAvatar());
                        MessagingPropertyAnimator.fadeIn(group.getSenderView());
                        MessagingPropertyAnimator.startLocalTranslationFrom(group, group.getHeight(), LINEAR_OUT_SLOW_IN);
                    }
                    ConversationLayout.this.mAddedGroups.clear();
                    ConversationLayout.this.getViewTreeObserver().removeOnPreDrawListener(this);
                    return true;
                }
            });
        }
        this.mTouchDelegate.clear();
        if (this.mFeedbackIcon.getVisibility() == 0) {
            float width2 = Math.max(this.mMinTouchSize, (float)this.mFeedbackIcon.getWidth());
            float height2 = Math.max(this.mMinTouchSize, (float)this.mFeedbackIcon.getHeight());
            Rect feedbackTouchRect = new Rect();
            feedbackTouchRect.left = (int)((float)(this.mFeedbackIcon.getLeft() + this.mFeedbackIcon.getRight()) / 2.0f - width2 / 2.0f);
            feedbackTouchRect.top = (int)((float)(this.mFeedbackIcon.getTop() + this.mFeedbackIcon.getBottom()) / 2.0f - height2 / 2.0f);
            feedbackTouchRect.bottom = (int)((float)feedbackTouchRect.top + height2);
            feedbackTouchRect.right = (int)((float)feedbackTouchRect.left + width2);
            this.getRelativeTouchRect(feedbackTouchRect, this.mFeedbackIcon);
            this.mTouchDelegate.add(new TouchDelegate(feedbackTouchRect, this.mFeedbackIcon));
        }
        this.setTouchDelegate(this.mTouchDelegate);
    }

    private void getRelativeTouchRect(Rect touchRect, View view2) {
        for (ViewGroup viewGroup = (ViewGroup)view2.getParent(); viewGroup != this; viewGroup = (ViewGroup)viewGroup.getParent()) {
            touchRect.offset(viewGroup.getLeft(), viewGroup.getTop());
        }
    }

    @Override
    public MessagingLinearLayout getMessagingLinearLayout() {
        return this.mMessagingLinearLayout;
    }

    public ViewGroup getImageMessageContainer() {
        return this.mImageMessageContainer;
    }

    @Override
    public ArrayList<MessagingGroup> getMessagingGroups() {
        return this.mGroups;
    }

    private void updateExpandButton() {
        ViewGroup newContainer;
        int buttonGravity;
        if (this.mIsCollapsed) {
            buttonGravity = 17;
            newContainer = this.mExpandButtonAndContentContainer;
        } else {
            buttonGravity = 49;
            newContainer = this;
        }
        this.mExpandButton.setExpanded(!this.mIsCollapsed);
        if (newContainer != this.mExpandButtonContainer.getParent()) {
            ((ViewGroup)this.mExpandButtonContainer.getParent()).removeView(this.mExpandButtonContainer);
            newContainer.addView(this.mExpandButtonContainer);
        }
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)this.mExpandButton.getLayoutParams();
        layoutParams.gravity = buttonGravity;
        this.mExpandButton.setLayoutParams(layoutParams);
    }

    private void updateContentEndPaddings() {
        int contentPaddingEnd;
        int headerPaddingEnd;
        if (!this.mExpandable) {
            headerPaddingEnd = 0;
            contentPaddingEnd = this.mContentMarginEnd;
        } else if (this.mIsCollapsed) {
            headerPaddingEnd = 0;
            contentPaddingEnd = 0;
        } else {
            headerPaddingEnd = this.mNotificationHeaderExpandedPadding;
            contentPaddingEnd = this.mContentMarginEnd;
        }
        this.mConversationHeader.setPaddingRelative(this.mConversationHeader.getPaddingStart(), this.mConversationHeader.getPaddingTop(), headerPaddingEnd, this.mConversationHeader.getPaddingBottom());
        this.mContentContainer.setPaddingRelative(this.mContentContainer.getPaddingStart(), this.mContentContainer.getPaddingTop(), contentPaddingEnd, this.mContentContainer.getPaddingBottom());
    }

    private void onAppNameVisibilityChanged() {
        boolean appNameGone;
        boolean bl = appNameGone = this.mAppName.getVisibility() == 8;
        if (appNameGone != this.mAppNameGone) {
            this.mAppNameGone = appNameGone;
            this.updateAppNameDividerVisibility();
        }
    }

    private void updateAppNameDividerVisibility() {
        this.mAppNameDivider.setVisibility(this.mAppNameGone ? 8 : 0);
    }

    public void updateExpandability(boolean expandable, View.OnClickListener onClickListener) {
        this.mExpandable = expandable;
        if (expandable) {
            this.mExpandButtonContainer.setVisibility(0);
            this.mExpandButton.setOnClickListener(onClickListener);
            this.mConversationIconContainer.setOnClickListener(onClickListener);
        } else {
            this.mExpandButtonContainer.setVisibility(8);
            this.mConversationIconContainer.setOnClickListener(null);
        }
        this.mExpandButton.setVisibility(0);
        this.updateContentEndPaddings();
    }

    @Override
    public void setMessagingClippingDisabled(boolean clippingDisabled) {
        this.mMessagingLinearLayout.setClipBounds(clippingDisabled ? null : this.mMessagingClipRect);
    }

    public CharSequence getConversationSenderName() {
        if (this.mGroups.isEmpty()) {
            return null;
        }
        CharSequence name = this.mGroups.get(this.mGroups.size() - 1).getSenderName();
        return this.getResources().getString(17040085, name);
    }

    public boolean isOneToOne() {
        return this.mIsOneToOne;
    }

    public CharSequence getConversationText() {
        if (this.mMessages.isEmpty()) {
            return null;
        }
        MessagingMessage messagingMessage = this.mMessages.get(this.mMessages.size() - 1);
        CharSequence text = messagingMessage.getMessage().getText();
        if (text == null && messagingMessage instanceof MessagingImageMessage) {
            String unformatted = this.getResources().getString(17040084);
            SpannableString spannableString = new SpannableString(unformatted);
            spannableString.setSpan(new StyleSpan(2), 0, spannableString.length(), 17);
            return spannableString;
        }
        return text;
    }

    public Icon getConversationIcon() {
        return this.mConversationIcon;
    }

    private static class TouchDelegateComposite
    extends TouchDelegate {
        private final ArrayList<TouchDelegate> mDelegates = new ArrayList();

        private TouchDelegateComposite(View view2) {
            super(new Rect(), view2);
        }

        public void add(TouchDelegate delegate) {
            this.mDelegates.add(delegate);
        }

        public void clear() {
            this.mDelegates.clear();
        }

        @Override
        public boolean onTouchEvent(MotionEvent event) {
            float x = event.getX();
            float y = event.getY();
            for (TouchDelegate delegate : this.mDelegates) {
                event.setLocation(x, y);
                if (!delegate.onTouchEvent(event)) continue;
                return true;
            }
            return false;
        }
    }
}

