/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.os.Trace;
import android.view.View;
import com.android.internal.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.TimeUnit;

class GapWorker
implements Runnable {
    static final ThreadLocal<GapWorker> sGapWorker = new ThreadLocal();
    ArrayList<RecyclerView> mRecyclerViews = new ArrayList();
    long mPostTimeNs;
    long mFrameIntervalNs;
    private ArrayList<Task> mTasks = new ArrayList();
    static Comparator<Task> sTaskComparator = new Comparator<Task>(){

        @Override
        public int compare(Task lhs, Task rhs) {
            if (lhs.view == null != (rhs.view == null)) {
                return lhs.view == null ? 1 : -1;
            }
            if (lhs.immediate != rhs.immediate) {
                return lhs.immediate ? -1 : 1;
            }
            int deltaViewVelocity = rhs.viewVelocity - lhs.viewVelocity;
            if (deltaViewVelocity != 0) {
                return deltaViewVelocity;
            }
            int deltaDistanceToItem = lhs.distanceToItem - rhs.distanceToItem;
            if (deltaDistanceToItem != 0) {
                return deltaDistanceToItem;
            }
            return 0;
        }
    };

    GapWorker() {
    }

    public void add(RecyclerView recyclerView) {
        this.mRecyclerViews.add(recyclerView);
    }

    public void remove(RecyclerView recyclerView) {
        boolean removeSuccess = this.mRecyclerViews.remove(recyclerView);
    }

    void postFromTraversal(RecyclerView recyclerView, int prefetchDx, int prefetchDy) {
        if (recyclerView.isAttachedToWindow() && this.mPostTimeNs == 0L) {
            this.mPostTimeNs = recyclerView.getNanoTime();
            recyclerView.post(this);
        }
        recyclerView.mPrefetchRegistry.setPrefetchVector(prefetchDx, prefetchDy);
    }

    private void buildTaskList() {
        int viewCount = this.mRecyclerViews.size();
        int totalTaskCount = 0;
        for (int i = 0; i < viewCount; ++i) {
            RecyclerView view2 = this.mRecyclerViews.get(i);
            view2.mPrefetchRegistry.collectPrefetchPositionsFromView(view2, false);
            totalTaskCount += view2.mPrefetchRegistry.mCount;
        }
        this.mTasks.ensureCapacity(totalTaskCount);
        int totalTaskIndex = 0;
        for (int i = 0; i < viewCount; ++i) {
            RecyclerView view3 = this.mRecyclerViews.get(i);
            LayoutPrefetchRegistryImpl prefetchRegistry = view3.mPrefetchRegistry;
            int viewVelocity = Math.abs(prefetchRegistry.mPrefetchDx) + Math.abs(prefetchRegistry.mPrefetchDy);
            for (int j = 0; j < prefetchRegistry.mCount * 2; j += 2) {
                Task task2;
                if (totalTaskIndex >= this.mTasks.size()) {
                    task2 = new Task();
                    this.mTasks.add(task2);
                } else {
                    task2 = this.mTasks.get(totalTaskIndex);
                }
                int distanceToItem = prefetchRegistry.mPrefetchArray[j + 1];
                task2.immediate = distanceToItem <= viewVelocity;
                task2.viewVelocity = viewVelocity;
                task2.distanceToItem = distanceToItem;
                task2.view = view3;
                task2.position = prefetchRegistry.mPrefetchArray[j];
                ++totalTaskIndex;
            }
        }
        Collections.sort(this.mTasks, sTaskComparator);
    }

    static boolean isPrefetchPositionAttached(RecyclerView view2, int position) {
        int childCount = view2.mChildHelper.getUnfilteredChildCount();
        for (int i = 0; i < childCount; ++i) {
            View attachedView = view2.mChildHelper.getUnfilteredChildAt(i);
            RecyclerView.ViewHolder holder = RecyclerView.getChildViewHolderInt(attachedView);
            if (holder.mPosition != position || holder.isInvalid()) continue;
            return true;
        }
        return false;
    }

    private RecyclerView.ViewHolder prefetchPositionWithDeadline(RecyclerView view2, int position, long deadlineNs) {
        if (GapWorker.isPrefetchPositionAttached(view2, position)) {
            return null;
        }
        RecyclerView.Recycler recycler = view2.mRecycler;
        RecyclerView.ViewHolder holder = recycler.tryGetViewHolderForPositionByDeadline(position, false, deadlineNs);
        if (holder != null) {
            if (holder.isBound()) {
                recycler.recycleView(holder.itemView);
            } else {
                recycler.addViewHolderToRecycledViewPool(holder, false);
            }
        }
        return holder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prefetchInnerRecyclerViewWithDeadline(RecyclerView innerView, long deadlineNs) {
        if (innerView == null) {
            return;
        }
        if (innerView.mDataSetHasChangedAfterLayout && innerView.mChildHelper.getUnfilteredChildCount() != 0) {
            innerView.removeAndRecycleViews();
        }
        LayoutPrefetchRegistryImpl innerPrefetchRegistry = innerView.mPrefetchRegistry;
        innerPrefetchRegistry.collectPrefetchPositionsFromView(innerView, true);
        if (innerPrefetchRegistry.mCount != 0) {
            try {
                Trace.beginSection("RV Nested Prefetch");
                innerView.mState.prepareForNestedPrefetch(innerView.mAdapter);
                for (int i = 0; i < innerPrefetchRegistry.mCount * 2; i += 2) {
                    int innerPosition = innerPrefetchRegistry.mPrefetchArray[i];
                    this.prefetchPositionWithDeadline(innerView, innerPosition, deadlineNs);
                }
            }
            finally {
                Trace.endSection();
            }
        }
    }

    private void flushTaskWithDeadline(Task task2, long deadlineNs) {
        long taskDeadlineNs = task2.immediate ? Long.MAX_VALUE : deadlineNs;
        RecyclerView.ViewHolder holder = this.prefetchPositionWithDeadline(task2.view, task2.position, taskDeadlineNs);
        if (holder != null && holder.mNestedRecyclerView != null) {
            this.prefetchInnerRecyclerViewWithDeadline((RecyclerView)holder.mNestedRecyclerView.get(), deadlineNs);
        }
    }

    private void flushTasksWithDeadline(long deadlineNs) {
        for (int i = 0; i < this.mTasks.size(); ++i) {
            Task task2 = this.mTasks.get(i);
            if (task2.view == null) break;
            this.flushTaskWithDeadline(task2, deadlineNs);
            task2.clear();
        }
    }

    void prefetch(long deadlineNs) {
        this.buildTaskList();
        this.flushTasksWithDeadline(deadlineNs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            Trace.beginSection("RV Prefetch");
            if (this.mRecyclerViews.isEmpty()) {
                return;
            }
            long lastFrameVsyncNs = TimeUnit.MILLISECONDS.toNanos(this.mRecyclerViews.get(0).getDrawingTime());
            if (lastFrameVsyncNs == 0L) {
                return;
            }
            long nextFrameNs = lastFrameVsyncNs + this.mFrameIntervalNs;
            this.prefetch(nextFrameNs);
        }
        finally {
            this.mPostTimeNs = 0L;
            Trace.endSection();
        }
    }

    static class LayoutPrefetchRegistryImpl
    implements RecyclerView.LayoutManager.LayoutPrefetchRegistry {
        int mPrefetchDx;
        int mPrefetchDy;
        int[] mPrefetchArray;
        int mCount;

        LayoutPrefetchRegistryImpl() {
        }

        void setPrefetchVector(int dx, int dy) {
            this.mPrefetchDx = dx;
            this.mPrefetchDy = dy;
        }

        void collectPrefetchPositionsFromView(RecyclerView view2, boolean nested) {
            this.mCount = 0;
            if (this.mPrefetchArray != null) {
                Arrays.fill(this.mPrefetchArray, -1);
            }
            RecyclerView.LayoutManager layout2 = view2.mLayout;
            if (view2.mAdapter != null && layout2 != null && layout2.isItemPrefetchEnabled()) {
                if (nested) {
                    if (!view2.mAdapterHelper.hasPendingUpdates()) {
                        layout2.collectInitialPrefetchPositions(view2.mAdapter.getItemCount(), this);
                    }
                } else if (!view2.hasPendingAdapterUpdates()) {
                    layout2.collectAdjacentPrefetchPositions(this.mPrefetchDx, this.mPrefetchDy, view2.mState, this);
                }
                if (this.mCount > layout2.mPrefetchMaxCountObserved) {
                    layout2.mPrefetchMaxCountObserved = this.mCount;
                    layout2.mPrefetchMaxObservedInInitialPrefetch = nested;
                    view2.mRecycler.updateViewCacheSize();
                }
            }
        }

        @Override
        public void addPosition(int layoutPosition, int pixelDistance) {
            if (pixelDistance < 0) {
                throw new IllegalArgumentException("Pixel distance must be non-negative");
            }
            int storagePosition = this.mCount * 2;
            if (this.mPrefetchArray == null) {
                this.mPrefetchArray = new int[4];
                Arrays.fill(this.mPrefetchArray, -1);
            } else if (storagePosition >= this.mPrefetchArray.length) {
                int[] oldArray = this.mPrefetchArray;
                this.mPrefetchArray = new int[storagePosition * 2];
                System.arraycopy(oldArray, 0, this.mPrefetchArray, 0, oldArray.length);
            }
            this.mPrefetchArray[storagePosition] = layoutPosition;
            this.mPrefetchArray[storagePosition + 1] = pixelDistance;
            ++this.mCount;
        }

        boolean lastPrefetchIncludedPosition(int position) {
            if (this.mPrefetchArray != null) {
                int count = this.mCount * 2;
                for (int i = 0; i < count; i += 2) {
                    if (this.mPrefetchArray[i] != position) continue;
                    return true;
                }
            }
            return false;
        }

        void clearPrefetchPositions() {
            if (this.mPrefetchArray != null) {
                Arrays.fill(this.mPrefetchArray, -1);
            }
        }
    }

    static class Task {
        public boolean immediate;
        public int viewVelocity;
        public int distanceToItem;
        public RecyclerView view;
        public int position;

        Task() {
        }

        public void clear() {
            this.immediate = false;
            this.viewVelocity = 0;
            this.distanceToItem = 0;
            this.view = null;
            this.position = 0;
        }
    }
}

