/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.ValueAnimator;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.CanvasProperty;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RecordingCanvas;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.IntArray;
import android.util.SparseArray;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.RenderNodeAnimator;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import com.android.internal.R;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.widget.ExploreByTouchHelper;
import com.android.internal.widget.LockPatternUtils;
import java.util.ArrayList;
import java.util.List;

public class LockPatternView
extends View {
    private static final int ASPECT_SQUARE = 0;
    private static final int ASPECT_LOCK_WIDTH = 1;
    private static final int ASPECT_LOCK_HEIGHT = 2;
    private static final boolean PROFILE_DRAWING = false;
    private static final int LINE_END_ANIMATION_DURATION_MILLIS = 50;
    private static final int DOT_ACTIVATION_DURATION_MILLIS = 50;
    private static final int DOT_RADIUS_INCREASE_DURATION_MILLIS = 96;
    private static final int DOT_RADIUS_DECREASE_DURATION_MILLIS = 192;
    private static final float MIN_DOT_HIT_FACTOR = 0.2f;
    private final CellState[][] mCellStates;
    private final int mDotSize;
    private final int mDotSizeActivated;
    private final float mDotHitFactor;
    private final int mPathWidth;
    private final int mLineFadeOutAnimationDurationMs;
    private final int mLineFadeOutAnimationDelayMs;
    private boolean mDrawingProfilingStarted = false;
    @UnsupportedAppUsage
    private final Paint mPaint = new Paint();
    @UnsupportedAppUsage
    private final Paint mPathPaint = new Paint();
    private static final int MILLIS_PER_CIRCLE_ANIMATING = 700;
    private static final float DRAG_THRESHHOLD = 0.0f;
    public static final int VIRTUAL_BASE_VIEW_ID = 1;
    public static final boolean DEBUG_A11Y = false;
    private static final String TAG = "LockPatternView";
    private OnPatternListener mOnPatternListener;
    @UnsupportedAppUsage
    private final ArrayList<Cell> mPattern = new ArrayList(9);
    private final boolean[][] mPatternDrawLookup = new boolean[3][3];
    private float mInProgressX = -1.0f;
    private float mInProgressY = -1.0f;
    private long mAnimatingPeriodStart;
    private long[] mLineFadeStart = new long[9];
    @UnsupportedAppUsage
    private DisplayMode mPatternDisplayMode = DisplayMode.Correct;
    private boolean mInputEnabled = true;
    @UnsupportedAppUsage
    private boolean mInStealthMode = false;
    @UnsupportedAppUsage
    private boolean mPatternInProgress = false;
    private boolean mFadePattern = true;
    @UnsupportedAppUsage
    private float mSquareWidth;
    @UnsupportedAppUsage
    private float mSquareHeight;
    private float mDotHitRadius;
    private final LinearGradient mFadeOutGradientShader;
    private final Path mCurrentPath = new Path();
    private final Rect mInvalidate = new Rect();
    private final Rect mTmpInvalidateRect = new Rect();
    private int mAspect;
    private int mRegularColor;
    private int mErrorColor;
    private int mSuccessColor;
    private int mDotColor;
    private int mDotActivatedColor;
    private final Interpolator mFastOutSlowInInterpolator;
    private final Interpolator mLinearOutSlowInInterpolator;
    private final PatternExploreByTouchHelper mExploreByTouchHelper;
    private Drawable mSelectedDrawable;
    private Drawable mNotSelectedDrawable;
    private boolean mUseLockPatternDrawable;

    public LockPatternView(Context context) {
        this(context, null);
    }

    @UnsupportedAppUsage
    public LockPatternView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LockPatternView, 17956990, 16975064);
        String aspect = a.getString(0);
        this.mAspect = "square".equals(aspect) ? 0 : ("lock_width".equals(aspect) ? 1 : ("lock_height".equals(aspect) ? 2 : 0));
        this.setClickable(true);
        this.mPathPaint.setAntiAlias(true);
        this.mPathPaint.setDither(true);
        this.mRegularColor = a.getColor(5, 0);
        this.mErrorColor = a.getColor(3, 0);
        this.mSuccessColor = a.getColor(6, 0);
        this.mDotColor = a.getColor(2, this.mRegularColor);
        this.mDotActivatedColor = a.getColor(1, this.mDotColor);
        int pathColor = a.getColor(4, this.mRegularColor);
        this.mPathPaint.setColor(pathColor);
        this.mPathPaint.setStyle(Paint.Style.STROKE);
        this.mPathPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPathPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPathWidth = this.getResources().getDimensionPixelSize(17105337);
        this.mPathPaint.setStrokeWidth(this.mPathWidth);
        this.mLineFadeOutAnimationDurationMs = this.getResources().getInteger(17695005);
        this.mLineFadeOutAnimationDelayMs = this.getResources().getInteger(17695004);
        this.mDotSize = this.getResources().getDimensionPixelSize(17105338);
        this.mDotSizeActivated = this.getResources().getDimensionPixelSize(17105339);
        TypedValue outValue = new TypedValue();
        this.getResources().getValue(17105336, outValue, true);
        this.mDotHitFactor = Math.max(Math.min(outValue.getFloat(), 1.0f), 0.2f);
        this.mUseLockPatternDrawable = this.getResources().getBoolean(17891859);
        if (this.mUseLockPatternDrawable) {
            this.mSelectedDrawable = this.getResources().getDrawable(17303050);
            this.mNotSelectedDrawable = this.getResources().getDrawable(17303048);
        }
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mCellStates = new CellState[3][3];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mCellStates[i][j] = new CellState();
                this.mCellStates[i][j].radius = this.mDotSize / 2;
                this.mCellStates[i][j].row = i;
                this.mCellStates[i][j].col = j;
            }
        }
        this.mFastOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563661);
        this.mLinearOutSlowInInterpolator = AnimationUtils.loadInterpolator(context, 17563662);
        this.mExploreByTouchHelper = new PatternExploreByTouchHelper(this);
        this.setAccessibilityDelegate(this.mExploreByTouchHelper);
        int fadeAwayGradientWidth = this.getResources().getDimensionPixelSize(17105340);
        this.mFadeOutGradientShader = new LinearGradient((float)(-fadeAwayGradientWidth) / 2.0f, 0.0f, (float)fadeAwayGradientWidth / 2.0f, 0.0f, 0, pathColor, Shader.TileMode.CLAMP);
        a.recycle();
    }

    @UnsupportedAppUsage
    public CellState[][] getCellStates() {
        return this.mCellStates;
    }

    public boolean isInStealthMode() {
        return this.mInStealthMode;
    }

    @UnsupportedAppUsage
    public void setInStealthMode(boolean inStealthMode) {
        this.mInStealthMode = inStealthMode;
    }

    public void setFadePattern(boolean fadePattern) {
        this.mFadePattern = fadePattern;
    }

    @UnsupportedAppUsage
    public void setOnPatternListener(OnPatternListener onPatternListener) {
        this.mOnPatternListener = onPatternListener;
    }

    public void setPattern(DisplayMode displayMode, List<Cell> pattern) {
        this.mPattern.clear();
        this.mPattern.addAll(pattern);
        this.clearPatternDrawLookup();
        for (Cell cell : pattern) {
            this.mPatternDrawLookup[cell.getRow()][cell.getColumn()] = true;
        }
        this.setDisplayMode(displayMode);
    }

    @UnsupportedAppUsage
    public void setDisplayMode(DisplayMode displayMode) {
        this.mPatternDisplayMode = displayMode;
        if (displayMode == DisplayMode.Animate) {
            if (this.mPattern.size() == 0) {
                throw new IllegalStateException("you must have a pattern to animate if you want to set the display mode to animate");
            }
            this.mAnimatingPeriodStart = SystemClock.elapsedRealtime();
            Cell first = this.mPattern.get(0);
            this.mInProgressX = this.getCenterXForColumn(first.getColumn());
            this.mInProgressY = this.getCenterYForRow(first.getRow());
            this.clearPatternDrawLookup();
        }
        this.invalidate();
    }

    public void startCellStateAnimation(CellState cellState, float startAlpha, float endAlpha, float startTranslationY, float endTranslationY, float startScale, float endScale, long delay, long duration, Interpolator interpolator2, Runnable finishRunnable) {
        if (this.isHardwareAccelerated()) {
            this.startCellStateAnimationHw(cellState, startAlpha, endAlpha, startTranslationY, endTranslationY, startScale, endScale, delay, duration, interpolator2, finishRunnable);
        } else {
            this.startCellStateAnimationSw(cellState, startAlpha, endAlpha, startTranslationY, endTranslationY, startScale, endScale, delay, duration, interpolator2, finishRunnable);
        }
    }

    private void startCellStateAnimationSw(final CellState cellState, final float startAlpha, final float endAlpha, final float startTranslationY, final float endTranslationY, final float startScale, final float endScale, long delay, long duration, Interpolator interpolator2, final Runnable finishRunnable) {
        cellState.alpha = startAlpha;
        cellState.translationY = startTranslationY;
        cellState.radius = (float)(this.mDotSize / 2) * startScale;
        ValueAnimator animator2 = ValueAnimator.ofFloat(0.0f, 1.0f);
        animator2.setDuration(duration);
        animator2.setStartDelay(delay);
        animator2.setInterpolator(interpolator2);
        animator2.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            @Override
            public void onAnimationUpdate(ValueAnimator animation) {
                float t = ((Float)animation.getAnimatedValue()).floatValue();
                cellState.alpha = (1.0f - t) * startAlpha + t * endAlpha;
                cellState.translationY = (1.0f - t) * startTranslationY + t * endTranslationY;
                cellState.radius = (float)(LockPatternView.this.mDotSize / 2) * ((1.0f - t) * startScale + t * endScale);
                LockPatternView.this.invalidate();
            }
        });
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                if (finishRunnable != null) {
                    finishRunnable.run();
                }
            }
        });
        animator2.start();
    }

    private void startCellStateAnimationHw(final CellState cellState, float startAlpha, float endAlpha, float startTranslationY, float endTranslationY, float startScale, float endScale, long delay, long duration, Interpolator interpolator2, final Runnable finishRunnable) {
        cellState.alpha = endAlpha;
        cellState.translationY = endTranslationY;
        cellState.radius = (float)(this.mDotSize / 2) * endScale;
        cellState.hwAnimating = true;
        cellState.hwCenterY = CanvasProperty.createFloat(this.getCenterYForRow(cellState.row) + startTranslationY);
        cellState.hwCenterX = CanvasProperty.createFloat(this.getCenterXForColumn(cellState.col));
        cellState.hwRadius = CanvasProperty.createFloat((float)(this.mDotSize / 2) * startScale);
        this.mPaint.setColor(this.getDotColor());
        this.mPaint.setAlpha((int)(startAlpha * 255.0f));
        cellState.hwPaint = CanvasProperty.createPaint(new Paint(this.mPaint));
        this.startRtFloatAnimation(cellState.hwCenterY, this.getCenterYForRow(cellState.row) + endTranslationY, delay, duration, interpolator2);
        this.startRtFloatAnimation(cellState.hwRadius, (float)(this.mDotSize / 2) * endScale, delay, duration, interpolator2);
        this.startRtAlphaAnimation(cellState, endAlpha, delay, duration, interpolator2, new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                cellState.hwAnimating = false;
                if (finishRunnable != null) {
                    finishRunnable.run();
                }
            }
        });
        this.invalidate();
    }

    private void startRtAlphaAnimation(CellState cellState, float endAlpha, long delay, long duration, Interpolator interpolator2, Animator.AnimatorListener listener2) {
        RenderNodeAnimator animator2 = new RenderNodeAnimator(cellState.hwPaint, 1, (int)(endAlpha * 255.0f));
        animator2.setDuration(duration);
        animator2.setStartDelay(delay);
        animator2.setInterpolator(interpolator2);
        animator2.setTarget(this);
        animator2.addListener(listener2);
        animator2.start();
    }

    private void startRtFloatAnimation(CanvasProperty<Float> property, float endValue, long delay, long duration, Interpolator interpolator2) {
        RenderNodeAnimator animator2 = new RenderNodeAnimator(property, endValue);
        animator2.setDuration(duration);
        animator2.setStartDelay(delay);
        animator2.setInterpolator(interpolator2);
        animator2.setTarget(this);
        animator2.start();
    }

    private void notifyCellAdded() {
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCellAdded(this.mPattern);
        }
        this.mExploreByTouchHelper.invalidateRoot();
    }

    private void notifyPatternStarted() {
        this.sendAccessEvent(17040604);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternStart();
        }
    }

    @UnsupportedAppUsage
    private void notifyPatternDetected() {
        this.sendAccessEvent(17040603);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternDetected(this.mPattern);
        }
    }

    private void notifyPatternCleared() {
        this.sendAccessEvent(17040602);
        if (this.mOnPatternListener != null) {
            this.mOnPatternListener.onPatternCleared();
        }
    }

    @UnsupportedAppUsage
    public void clearPattern() {
        this.resetPattern();
    }

    @Override
    protected boolean dispatchHoverEvent(MotionEvent event) {
        boolean handled = super.dispatchHoverEvent(event);
        return handled |= this.mExploreByTouchHelper.dispatchHoverEvent(event);
    }

    private void resetPattern() {
        this.mPattern.clear();
        this.clearPatternDrawLookup();
        this.mPatternDisplayMode = DisplayMode.Correct;
        this.invalidate();
    }

    public boolean isEmpty() {
        return this.mPattern.isEmpty();
    }

    private void clearPatternDrawLookup() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.mPatternDrawLookup[i][j] = false;
                this.mLineFadeStart[i + j * 3] = 0L;
            }
        }
    }

    @UnsupportedAppUsage
    public void disableInput() {
        this.mInputEnabled = false;
    }

    @UnsupportedAppUsage
    public void enableInput() {
        this.mInputEnabled = true;
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        int width2 = w - this.mPaddingLeft - this.mPaddingRight;
        this.mSquareWidth = (float)width2 / 3.0f;
        int height2 = h - this.mPaddingTop - this.mPaddingBottom;
        this.mSquareHeight = (float)height2 / 3.0f;
        this.mExploreByTouchHelper.invalidateRoot();
        this.mDotHitRadius = Math.min(this.mSquareHeight / 2.0f, this.mSquareWidth / 2.0f) * this.mDotHitFactor;
        if (this.mUseLockPatternDrawable) {
            this.mNotSelectedDrawable.setBounds(this.mPaddingLeft, this.mPaddingTop, width2, height2);
            this.mSelectedDrawable.setBounds(this.mPaddingLeft, this.mPaddingTop, width2, height2);
        }
    }

    private int resolveMeasured(int measureSpec, int desired) {
        int result = 0;
        int specSize = View.MeasureSpec.getSize(measureSpec);
        switch (View.MeasureSpec.getMode(measureSpec)) {
            case 0: {
                result = desired;
                break;
            }
            case -2147483648: {
                result = Math.max(specSize, desired);
                break;
            }
            default: {
                result = specSize;
            }
        }
        return result;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = this.getSuggestedMinimumWidth();
        int minimumHeight = this.getSuggestedMinimumHeight();
        int viewWidth = this.resolveMeasured(widthMeasureSpec, minimumWidth);
        int viewHeight = this.resolveMeasured(heightMeasureSpec, minimumHeight);
        switch (this.mAspect) {
            case 0: {
                viewWidth = viewHeight = Math.min(viewWidth, viewHeight);
                break;
            }
            case 1: {
                viewHeight = Math.min(viewWidth, viewHeight);
                break;
            }
            case 2: {
                viewWidth = Math.min(viewWidth, viewHeight);
            }
        }
        this.setMeasuredDimension(viewWidth, viewHeight);
    }

    private Cell detectAndAddHit(float x, float y) {
        Cell cell = this.checkForNewHit(x, y);
        if (cell != null) {
            Cell fillInGapCell = null;
            ArrayList<Cell> pattern = this.mPattern;
            if (!pattern.isEmpty()) {
                Cell lastCell = pattern.get(pattern.size() - 1);
                int dRow = cell.row - lastCell.row;
                int dColumn = cell.column - lastCell.column;
                int fillInRow = lastCell.row;
                int fillInColumn = lastCell.column;
                if (Math.abs(dRow) == 2 && Math.abs(dColumn) != 1) {
                    fillInRow = lastCell.row + (dRow > 0 ? 1 : -1);
                }
                if (Math.abs(dColumn) == 2 && Math.abs(dRow) != 1) {
                    fillInColumn = lastCell.column + (dColumn > 0 ? 1 : -1);
                }
                fillInGapCell = Cell.of(fillInRow, fillInColumn);
            }
            if (fillInGapCell != null && !this.mPatternDrawLookup[fillInGapCell.row][fillInGapCell.column]) {
                this.addCellToPattern(fillInGapCell);
            }
            this.addCellToPattern(cell);
            this.performHapticFeedback(1, 1);
            return cell;
        }
        return null;
    }

    private void addCellToPattern(Cell newCell) {
        this.mPatternDrawLookup[newCell.getRow()][newCell.getColumn()] = true;
        this.mPattern.add(newCell);
        if (!this.mInStealthMode) {
            this.startCellActivatedAnimation(newCell);
        }
        this.notifyCellAdded();
    }

    private void startCellActivatedAnimation(Cell cell) {
        final CellState cellState = this.mCellStates[cell.row][cell.column];
        if (cellState.activationAnimator != null) {
            cellState.activationAnimator.cancel();
        }
        AnimatorSet animatorSet = new AnimatorSet();
        AnimatorSet.Builder animatorSetBuilder = animatorSet.play(this.createLineDisappearingAnimation()).with(this.createLineEndAnimation(cellState, this.mInProgressX, this.mInProgressY, this.getCenterXForColumn(cell.column), this.getCenterYForRow(cell.row)));
        if (this.mDotSize != this.mDotSizeActivated) {
            animatorSetBuilder.with(this.createDotRadiusAnimation(cellState));
        }
        if (this.mDotColor != this.mDotActivatedColor) {
            animatorSetBuilder.with(this.createDotActivationColorAnimation(cellState));
        }
        animatorSet.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                cellState.activationAnimator = null;
                LockPatternView.this.invalidate();
            }
        });
        cellState.activationAnimator = animatorSet;
        animatorSet.start();
    }

    private Animator createDotActivationColorAnimation(CellState cellState) {
        ValueAnimator.AnimatorUpdateListener updateListener = valueAnimator -> {
            cellState.activationAnimationProgress = ((Float)valueAnimator.getAnimatedValue()).floatValue();
            this.invalidate();
        };
        ValueAnimator activateAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
        ValueAnimator deactivateAnimator = ValueAnimator.ofFloat(1.0f, 0.0f);
        activateAnimator.addUpdateListener(updateListener);
        deactivateAnimator.addUpdateListener(updateListener);
        activateAnimator.setInterpolator(this.mFastOutSlowInInterpolator);
        deactivateAnimator.setInterpolator(this.mLinearOutSlowInInterpolator);
        activateAnimator.setDuration(50L);
        deactivateAnimator.setDuration(50L);
        AnimatorSet set = new AnimatorSet();
        set.play(deactivateAnimator).after(this.mLineFadeOutAnimationDelayMs + this.mLineFadeOutAnimationDurationMs - 100).after(activateAnimator);
        return set;
    }

    private Animator createLineEndAnimation(CellState state, float startX, float startY, float targetX, float targetY) {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
        valueAnimator.addUpdateListener(animation -> {
            float t = ((Float)animation.getAnimatedValue()).floatValue();
            state.lineEndX = (1.0f - t) * startX + t * targetX;
            state.lineEndY = (1.0f - t) * startY + t * targetY;
            this.invalidate();
        });
        valueAnimator.setInterpolator(this.mFastOutSlowInInterpolator);
        valueAnimator.setDuration(50L);
        return valueAnimator;
    }

    private Animator createLineDisappearingAnimation() {
        ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
        valueAnimator.addUpdateListener(animation -> this.invalidate());
        valueAnimator.setStartDelay(this.mLineFadeOutAnimationDelayMs);
        valueAnimator.setDuration(this.mLineFadeOutAnimationDurationMs);
        return valueAnimator;
    }

    private Animator createDotRadiusAnimation(CellState state) {
        float defaultRadius = (float)this.mDotSize / 2.0f;
        float activatedRadius = (float)this.mDotSizeActivated / 2.0f;
        ValueAnimator.AnimatorUpdateListener animatorUpdateListener = animation -> {
            state.radius = ((Float)animation.getAnimatedValue()).floatValue();
            this.invalidate();
        };
        ValueAnimator activationAnimator = ValueAnimator.ofFloat(defaultRadius, activatedRadius);
        activationAnimator.addUpdateListener(animatorUpdateListener);
        activationAnimator.setInterpolator(this.mLinearOutSlowInInterpolator);
        activationAnimator.setDuration(96L);
        ValueAnimator deactivationAnimator = ValueAnimator.ofFloat(activatedRadius, defaultRadius);
        deactivationAnimator.addUpdateListener(animatorUpdateListener);
        deactivationAnimator.setInterpolator(this.mFastOutSlowInInterpolator);
        deactivationAnimator.setDuration(192L);
        AnimatorSet set = new AnimatorSet();
        set.playSequentially(activationAnimator, deactivationAnimator);
        return set;
    }

    private Cell checkForNewHit(float x, float y) {
        Cell cellHit = this.detectCellHit(x, y);
        if (cellHit != null && !this.mPatternDrawLookup[cellHit.row][cellHit.column]) {
            return cellHit;
        }
        return null;
    }

    private Cell detectCellHit(float x, float y) {
        float hitRadiusSquared = this.mDotHitRadius * this.mDotHitRadius;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 3; ++column) {
                float centerY = this.getCenterYForRow(row);
                float centerX = this.getCenterXForColumn(column);
                if (!((x - centerX) * (x - centerX) + (y - centerY) * (y - centerY) < hitRadiusSquared)) continue;
                return Cell.of(row, column);
            }
        }
        return null;
    }

    @Override
    public boolean onHoverEvent(MotionEvent event) {
        if (AccessibilityManager.getInstance(this.mContext).isTouchExplorationEnabled()) {
            int action2 = event.getAction();
            switch (action2) {
                case 9: {
                    event.setAction(0);
                    break;
                }
                case 7: {
                    event.setAction(2);
                    break;
                }
                case 10: {
                    event.setAction(1);
                }
            }
            this.onTouchEvent(event);
            event.setAction(action2);
        }
        return super.onHoverEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mInputEnabled || !this.isEnabled()) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.handleActionDown(event);
                return true;
            }
            case 1: {
                this.handleActionUp();
                return true;
            }
            case 2: {
                this.handleActionMove(event);
                return true;
            }
            case 3: {
                if (this.mPatternInProgress) {
                    this.setPatternInProgress(false);
                    this.resetPattern();
                    this.notifyPatternCleared();
                }
                return true;
            }
        }
        return false;
    }

    private void setPatternInProgress(boolean progress) {
        this.mPatternInProgress = progress;
        this.mExploreByTouchHelper.invalidateRoot();
    }

    private void handleActionMove(MotionEvent event) {
        float radius = this.mPathWidth;
        int historySize = event.getHistorySize();
        this.mTmpInvalidateRect.setEmpty();
        boolean invalidateNow = false;
        for (int i = 0; i < historySize + 1; ++i) {
            float x = i < historySize ? event.getHistoricalX(i) : event.getX();
            float y = i < historySize ? event.getHistoricalY(i) : event.getY();
            Cell hitCell = this.detectAndAddHit(x, y);
            int patternSize = this.mPattern.size();
            if (hitCell != null && patternSize == 1) {
                this.setPatternInProgress(true);
                this.notifyPatternStarted();
            }
            float dx = Math.abs(x - this.mInProgressX);
            float dy = Math.abs(y - this.mInProgressY);
            if (dx > 0.0f || dy > 0.0f) {
                invalidateNow = true;
            }
            if (!this.mPatternInProgress || patternSize <= 0) continue;
            ArrayList<Cell> pattern = this.mPattern;
            Cell lastCell = pattern.get(patternSize - 1);
            float lastCellCenterX = this.getCenterXForColumn(lastCell.column);
            float lastCellCenterY = this.getCenterYForRow(lastCell.row);
            float left = Math.min(lastCellCenterX, x) - radius;
            float right2 = Math.max(lastCellCenterX, x) + radius;
            float top = Math.min(lastCellCenterY, y) - radius;
            float bottom2 = Math.max(lastCellCenterY, y) + radius;
            if (hitCell != null) {
                float width2 = this.mSquareWidth * 0.5f;
                float height2 = this.mSquareHeight * 0.5f;
                float hitCellCenterX = this.getCenterXForColumn(hitCell.column);
                float hitCellCenterY = this.getCenterYForRow(hitCell.row);
                left = Math.min(hitCellCenterX - width2, left);
                right2 = Math.max(hitCellCenterX + width2, right2);
                top = Math.min(hitCellCenterY - height2, top);
                bottom2 = Math.max(hitCellCenterY + height2, bottom2);
            }
            this.mTmpInvalidateRect.union(Math.round(left), Math.round(top), Math.round(right2), Math.round(bottom2));
        }
        this.mInProgressX = event.getX();
        this.mInProgressY = event.getY();
        if (invalidateNow) {
            this.mInvalidate.union(this.mTmpInvalidateRect);
            this.invalidate(this.mInvalidate);
            this.mInvalidate.set(this.mTmpInvalidateRect);
        }
    }

    private void sendAccessEvent(int resId) {
        this.announceForAccessibility(this.mContext.getString(resId));
    }

    private void handleActionUp() {
        if (!this.mPattern.isEmpty()) {
            this.setPatternInProgress(false);
            this.cancelLineAnimations();
            this.notifyPatternDetected();
            if (this.mFadePattern) {
                this.clearPatternDrawLookup();
                this.mPatternDisplayMode = DisplayMode.Correct;
            }
            this.invalidate();
        }
    }

    private void cancelLineAnimations() {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                CellState state = this.mCellStates[i][j];
                if (state.activationAnimator == null) continue;
                state.activationAnimator.cancel();
                state.activationAnimator = null;
                state.radius = (float)this.mDotSize / 2.0f;
                state.activationAnimationProgress = 0.0f;
                state.lineEndX = Float.MIN_VALUE;
                state.lineEndY = Float.MIN_VALUE;
            }
        }
    }

    private void handleActionDown(MotionEvent event) {
        this.resetPattern();
        float x = event.getX();
        float y = event.getY();
        Cell hitCell = this.detectAndAddHit(x, y);
        if (hitCell != null) {
            this.setPatternInProgress(true);
            this.mPatternDisplayMode = DisplayMode.Correct;
            this.notifyPatternStarted();
        } else if (this.mPatternInProgress) {
            this.setPatternInProgress(false);
            this.notifyPatternCleared();
        }
        if (hitCell != null) {
            float startX = this.getCenterXForColumn(hitCell.column);
            float startY = this.getCenterYForRow(hitCell.row);
            float widthOffset = this.mSquareWidth / 2.0f;
            float heightOffset = this.mSquareHeight / 2.0f;
            this.invalidate((int)(startX - widthOffset), (int)(startY - heightOffset), (int)(startX + widthOffset), (int)(startY + heightOffset));
        }
        this.mInProgressX = x;
        this.mInProgressY = y;
    }

    public void setColors(int regularColor, int successColor, int errorColor) {
        this.mRegularColor = regularColor;
        this.mErrorColor = errorColor;
        this.mSuccessColor = successColor;
        this.mPathPaint.setColor(regularColor);
        this.invalidate();
    }

    private float getCenterXForColumn(int column) {
        return (float)this.mPaddingLeft + (float)column * this.mSquareWidth + this.mSquareWidth / 2.0f;
    }

    private float getCenterYForRow(int row) {
        return (float)this.mPaddingTop + (float)row * this.mSquareHeight + this.mSquareHeight / 2.0f;
    }

    @Override
    protected void onDraw(Canvas canvas) {
        boolean drawPath;
        float centerX;
        ArrayList<Cell> pattern = this.mPattern;
        int count = pattern.size();
        boolean[][] drawLookup = this.mPatternDrawLookup;
        if (this.mPatternDisplayMode == DisplayMode.Animate) {
            boolean needToUpdateInProgressPoint;
            int oneCycle = (count + 1) * 700;
            int spotInCycle = (int)(SystemClock.elapsedRealtime() - this.mAnimatingPeriodStart) % oneCycle;
            int numCircles = spotInCycle / 700;
            this.clearPatternDrawLookup();
            for (int i = 0; i < numCircles; ++i) {
                Cell cell = pattern.get(i);
                drawLookup[cell.getRow()][cell.getColumn()] = true;
            }
            boolean bl = needToUpdateInProgressPoint = numCircles > 0 && numCircles < count;
            if (needToUpdateInProgressPoint) {
                float percentageOfNextCircle = (float)(spotInCycle % 700) / 700.0f;
                Cell currentCell = pattern.get(numCircles - 1);
                centerX = this.getCenterXForColumn(currentCell.column);
                float centerY = this.getCenterYForRow(currentCell.row);
                Cell nextCell = pattern.get(numCircles);
                float dx = percentageOfNextCircle * (this.getCenterXForColumn(nextCell.column) - centerX);
                float dy = percentageOfNextCircle * (this.getCenterYForRow(nextCell.row) - centerY);
                this.mInProgressX = centerX + dx;
                this.mInProgressY = centerY + dy;
            }
            this.invalidate();
        }
        Path currentPath = this.mCurrentPath;
        currentPath.rewind();
        boolean bl = drawPath = !this.mInStealthMode;
        if (drawPath) {
            this.mPathPaint.setColor(this.getCurrentColor(true));
            boolean anyCircles = false;
            float lastX = 0.0f;
            float lastY = 0.0f;
            long elapsedRealtime = SystemClock.elapsedRealtime();
            for (int i = 0; i < count; ++i) {
                Cell cell = pattern.get(i);
                if (!drawLookup[cell.row][cell.column]) break;
                anyCircles = true;
                if (this.mLineFadeStart[i] == 0L) {
                    this.mLineFadeStart[i] = SystemClock.elapsedRealtime();
                }
                float centerX2 = this.getCenterXForColumn(cell.column);
                float centerY = this.getCenterYForRow(cell.row);
                if (i != 0) {
                    float endY;
                    float endX;
                    CellState state = this.mCellStates[cell.row][cell.column];
                    currentPath.rewind();
                    if (state.lineEndX != Float.MIN_VALUE && state.lineEndY != Float.MIN_VALUE) {
                        endX = state.lineEndX;
                        endY = state.lineEndY;
                    } else {
                        endX = centerX2;
                        endY = centerY;
                    }
                    this.drawLineSegment(canvas, lastX, lastY, endX, endY, this.mLineFadeStart[i], elapsedRealtime);
                }
                lastX = centerX2;
                lastY = centerY;
            }
            if ((this.mPatternInProgress || this.mPatternDisplayMode == DisplayMode.Animate) && anyCircles) {
                currentPath.rewind();
                currentPath.moveTo(lastX, lastY);
                currentPath.lineTo(this.mInProgressX, this.mInProgressY);
                this.mPathPaint.setAlpha((int)(this.calculateLastSegmentAlpha(this.mInProgressX, this.mInProgressY, lastX, lastY) * 255.0f));
                canvas.drawPath(currentPath, this.mPathPaint);
            }
        }
        for (int i = 0; i < 3; ++i) {
            float centerY = this.getCenterYForRow(i);
            for (int j = 0; j < 3; ++j) {
                CellState cellState = this.mCellStates[i][j];
                centerX = this.getCenterXForColumn(j);
                float translationY = cellState.translationY;
                if (this.mUseLockPatternDrawable) {
                    this.drawCellDrawable(canvas, i, j, cellState.radius, drawLookup[i][j]);
                    continue;
                }
                if (this.isHardwareAccelerated() && cellState.hwAnimating) {
                    RecordingCanvas recordingCanvas = (RecordingCanvas)canvas;
                    recordingCanvas.drawCircle(cellState.hwCenterX, cellState.hwCenterY, cellState.hwRadius, cellState.hwPaint);
                    continue;
                }
                this.drawCircle(canvas, (int)centerX, (float)((int)centerY) + translationY, cellState.radius, drawLookup[i][j], cellState.alpha, cellState.activationAnimationProgress);
            }
        }
    }

    private void drawLineSegment(Canvas canvas, float startX, float startY, float endX, float endY, long lineFadeStart, long elapsedRealtime) {
        if (this.mFadePattern) {
            if (elapsedRealtime - lineFadeStart >= (long)(this.mLineFadeOutAnimationDelayMs + this.mLineFadeOutAnimationDurationMs)) {
                return;
            }
            float fadeAwayProgress = Math.max((float)(elapsedRealtime - lineFadeStart - (long)this.mLineFadeOutAnimationDelayMs) / (float)this.mLineFadeOutAnimationDurationMs, 0.0f);
            this.drawFadingAwayLineSegment(canvas, startX, startY, endX, endY, fadeAwayProgress);
        } else {
            this.mPathPaint.setAlpha(255);
            canvas.drawLine(startX, startY, endX, endY, this.mPathPaint);
        }
    }

    private void drawFadingAwayLineSegment(Canvas canvas, float startX, float startY, float endX, float endY, float fadeAwayProgress) {
        this.mPathPaint.setAlpha((int)(255.0f * (1.0f - fadeAwayProgress)));
        this.mPathPaint.setShader(this.mFadeOutGradientShader);
        canvas.save();
        float gradientMidX = endX * fadeAwayProgress + startX * (1.0f - fadeAwayProgress);
        float gradientMidY = endY * fadeAwayProgress + startY * (1.0f - fadeAwayProgress);
        canvas.translate(gradientMidX, gradientMidY);
        double segmentAngleRad = Math.atan((endY - startY) / (endX - startX));
        float segmentAngleDegrees = (float)Math.toDegrees(segmentAngleRad);
        if (endX - startX < 0.0f) {
            segmentAngleDegrees += 180.0f;
        }
        canvas.rotate(segmentAngleDegrees);
        float segmentLength = (float)Math.hypot(endX - startX, endY - startY);
        canvas.drawLine(-segmentLength * fadeAwayProgress, 0.0f, segmentLength * (1.0f - fadeAwayProgress), 0.0f, this.mPathPaint);
        canvas.restore();
        this.mPathPaint.setShader(null);
    }

    private float calculateLastSegmentAlpha(float x, float y, float lastX, float lastY) {
        float diffX = x - lastX;
        float diffY = y - lastY;
        float dist = (float)Math.sqrt(diffX * diffX + diffY * diffY);
        float frac = dist / this.mSquareWidth;
        return Math.min(1.0f, Math.max(0.0f, (frac - 0.3f) * 4.0f));
    }

    private int getDotColor() {
        if (this.mInStealthMode) {
            return this.mDotColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Wrong) {
            return this.mErrorColor;
        }
        return this.mDotColor;
    }

    private int getCurrentColor(boolean partOfPattern) {
        if (!partOfPattern || this.mInStealthMode || this.mPatternInProgress) {
            return this.mRegularColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Wrong) {
            return this.mErrorColor;
        }
        if (this.mPatternDisplayMode == DisplayMode.Correct || this.mPatternDisplayMode == DisplayMode.Animate) {
            return this.mSuccessColor;
        }
        throw new IllegalStateException("unknown display mode " + (Object)((Object)this.mPatternDisplayMode));
    }

    private void drawCircle(Canvas canvas, float centerX, float centerY, float radius, boolean partOfPattern, float alpha, float activationAnimationProgress) {
        if (this.mFadePattern && !this.mInStealthMode) {
            int resultColor = ColorUtils.blendARGB(this.mDotColor, this.mDotActivatedColor, activationAnimationProgress);
            this.mPaint.setColor(resultColor);
        } else {
            this.mPaint.setColor(this.getDotColor());
        }
        this.mPaint.setAlpha((int)(alpha * 255.0f));
        canvas.drawCircle(centerX, centerY, radius, this.mPaint);
    }

    private void drawCellDrawable(Canvas canvas, int i, int j, float radius, boolean partOfPattern) {
        Rect dst = new Rect((int)((float)this.mPaddingLeft + (float)j * this.mSquareWidth), (int)((float)this.mPaddingTop + (float)i * this.mSquareHeight), (int)((float)this.mPaddingLeft + (float)(j + 1) * this.mSquareWidth), (int)((float)this.mPaddingTop + (float)(i + 1) * this.mSquareHeight));
        float scale = radius / (float)(this.mDotSize / 2);
        canvas.save();
        canvas.clipRect(dst);
        canvas.scale(scale, scale, dst.centerX(), dst.centerY());
        if (!partOfPattern || scale > 1.0f) {
            this.mNotSelectedDrawable.draw(canvas);
        } else {
            this.mSelectedDrawable.draw(canvas);
        }
        canvas.restore();
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        byte[] patternBytes = LockPatternUtils.patternToByteArray(this.mPattern);
        String patternString = patternBytes != null ? new String(patternBytes) : null;
        return new SavedState(superState, patternString, this.mPatternDisplayMode.ordinal(), this.mInputEnabled, this.mInStealthMode);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setPattern(DisplayMode.Correct, LockPatternUtils.byteArrayToPattern(ss.getSerializedPattern().getBytes()));
        this.mPatternDisplayMode = DisplayMode.values()[ss.getDisplayMode()];
        this.mInputEnabled = ss.isInputEnabled();
        this.mInStealthMode = ss.isInStealthMode();
    }

    private class PatternExploreByTouchHelper
    extends ExploreByTouchHelper {
        private Rect mTempRect;
        private final SparseArray<VirtualViewContainer> mItems;

        public PatternExploreByTouchHelper(View forView) {
            super(forView);
            this.mTempRect = new Rect();
            this.mItems = new SparseArray();
            for (int i = 1; i < 10; ++i) {
                this.mItems.put(i, new VirtualViewContainer(this.getTextForVirtualView(i)));
            }
        }

        @Override
        protected int getVirtualViewAt(float x, float y) {
            return this.getVirtualViewIdForHit(x, y);
        }

        @Override
        protected void getVisibleVirtualViews(IntArray virtualViewIds) {
            if (!LockPatternView.this.mPatternInProgress) {
                return;
            }
            for (int i = 1; i < 10; ++i) {
                virtualViewIds.add(i);
            }
        }

        @Override
        protected void onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            VirtualViewContainer container = this.mItems.get(virtualViewId);
            if (container != null) {
                event.getText().add(container.description);
            }
        }

        @Override
        public void onPopulateAccessibilityEvent(View host, AccessibilityEvent event) {
            super.onPopulateAccessibilityEvent(host, event);
            if (!LockPatternView.this.mPatternInProgress) {
                CharSequence contentDescription = LockPatternView.this.getContext().getText(17040599);
                event.setContentDescription(contentDescription);
            }
        }

        @Override
        protected void onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            node.setText(this.getTextForVirtualView(virtualViewId));
            node.setContentDescription(this.getTextForVirtualView(virtualViewId));
            if (LockPatternView.this.mPatternInProgress) {
                node.setFocusable(true);
                if (this.isClickable(virtualViewId)) {
                    node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
                    node.setClickable(this.isClickable(virtualViewId));
                }
            }
            Rect bounds2 = this.getBoundsForVirtualView(virtualViewId);
            node.setBoundsInParent(bounds2);
        }

        private boolean isClickable(int virtualViewId) {
            if (virtualViewId != Integer.MIN_VALUE) {
                int row = (virtualViewId - 1) / 3;
                int col = (virtualViewId - 1) % 3;
                if (row < 3) {
                    return !LockPatternView.this.mPatternDrawLookup[row][col];
                }
            }
            return false;
        }

        @Override
        protected boolean onPerformActionForVirtualView(int virtualViewId, int action2, Bundle arguments) {
            switch (action2) {
                case 16: {
                    return this.onItemClicked(virtualViewId);
                }
            }
            return false;
        }

        boolean onItemClicked(int index) {
            this.invalidateVirtualView(index);
            this.sendEventForVirtualView(index, 1);
            return true;
        }

        private Rect getBoundsForVirtualView(int virtualViewId) {
            int ordinal = virtualViewId - 1;
            Rect bounds2 = this.mTempRect;
            int row = ordinal / 3;
            int col = ordinal % 3;
            float centerX = LockPatternView.this.getCenterXForColumn(col);
            float centerY = LockPatternView.this.getCenterYForRow(row);
            float cellHitRadius = LockPatternView.this.mDotHitRadius;
            bounds2.left = (int)(centerX - cellHitRadius);
            bounds2.right = (int)(centerX + cellHitRadius);
            bounds2.top = (int)(centerY - cellHitRadius);
            bounds2.bottom = (int)(centerY + cellHitRadius);
            return bounds2;
        }

        private CharSequence getTextForVirtualView(int virtualViewId) {
            Resources res = LockPatternView.this.getResources();
            return res.getString(17040601, virtualViewId);
        }

        private int getVirtualViewIdForHit(float x, float y) {
            Cell cellHit = LockPatternView.this.detectCellHit(x, y);
            if (cellHit == null) {
                return Integer.MIN_VALUE;
            }
            boolean dotAvailable = LockPatternView.this.mPatternDrawLookup[cellHit.row][cellHit.column];
            int dotId = cellHit.row * 3 + cellHit.column + 1;
            int view2 = dotAvailable ? dotId : Integer.MIN_VALUE;
            return view2;
        }

        class VirtualViewContainer {
            CharSequence description;

            public VirtualViewContainer(CharSequence description) {
                this.description = description;
            }
        }
    }

    private static class SavedState
    extends View.BaseSavedState {
        private final String mSerializedPattern;
        private final int mDisplayMode;
        private final boolean mInputEnabled;
        private final boolean mInStealthMode;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        @UnsupportedAppUsage
        private SavedState(Parcelable superState, String serializedPattern, int displayMode, boolean inputEnabled, boolean inStealthMode) {
            super(superState);
            this.mSerializedPattern = serializedPattern;
            this.mDisplayMode = displayMode;
            this.mInputEnabled = inputEnabled;
            this.mInStealthMode = inStealthMode;
        }

        @UnsupportedAppUsage
        private SavedState(Parcel in) {
            super(in);
            this.mSerializedPattern = in.readString();
            this.mDisplayMode = in.readInt();
            this.mInputEnabled = (Boolean)in.readValue(null);
            this.mInStealthMode = (Boolean)in.readValue(null);
        }

        public String getSerializedPattern() {
            return this.mSerializedPattern;
        }

        public int getDisplayMode() {
            return this.mDisplayMode;
        }

        public boolean isInputEnabled() {
            return this.mInputEnabled;
        }

        public boolean isInStealthMode() {
            return this.mInStealthMode;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.mSerializedPattern);
            dest.writeInt(this.mDisplayMode);
            dest.writeValue(this.mInputEnabled);
            dest.writeValue(this.mInStealthMode);
        }
    }

    public static interface OnPatternListener {
        public void onPatternStart();

        public void onPatternCleared();

        public void onPatternCellAdded(List<Cell> var1);

        public void onPatternDetected(List<Cell> var1);
    }

    public static enum DisplayMode {
        Correct,
        Animate,
        Wrong;

    }

    public static class CellState {
        int row;
        int col;
        boolean hwAnimating;
        CanvasProperty<Float> hwRadius;
        CanvasProperty<Float> hwCenterX;
        CanvasProperty<Float> hwCenterY;
        CanvasProperty<Paint> hwPaint;
        float radius;
        float translationY;
        float alpha = 1.0f;
        float activationAnimationProgress;
        public float lineEndX = Float.MIN_VALUE;
        public float lineEndY = Float.MIN_VALUE;
        Animator activationAnimator;
    }

    public static class Cell {
        @UnsupportedAppUsage
        final int row;
        @UnsupportedAppUsage
        final int column;
        private static final Cell[][] sCells = Cell.createCells();

        private static Cell[][] createCells() {
            Cell[][] res = new Cell[3][3];
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    res[i][j] = new Cell(i, j);
                }
            }
            return res;
        }

        private Cell(int row, int column) {
            Cell.checkRange(row, column);
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }

        public static Cell of(int row, int column) {
            Cell.checkRange(row, column);
            return sCells[row][column];
        }

        private static void checkRange(int row, int column) {
            if (row < 0 || row > 2) {
                throw new IllegalArgumentException("row must be in range 0-2");
            }
            if (column < 0 || column > 2) {
                throw new IllegalArgumentException("column must be in range 0-2");
            }
        }

        public String toString() {
            return "(row=" + this.row + ",clmn=" + this.column + ")";
        }
    }
}

