/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.util.IntProperty;
import android.view.View;
import android.view.animation.Interpolator;
import android.view.animation.PathInterpolator;
import com.android.internal.widget.MessagingLayout;
import com.android.internal.widget.MessagingLinearLayout;
import com.android.internal.widget.ViewClippingUtil;

public class MessagingPropertyAnimator
implements View.OnLayoutChangeListener {
    private static final long APPEAR_ANIMATION_LENGTH = 210L;
    public static final Interpolator ALPHA_IN = new PathInterpolator(0.4f, 0.0f, 1.0f, 1.0f);
    public static final Interpolator ALPHA_OUT = new PathInterpolator(0.0f, 0.0f, 0.8f, 1.0f);
    private static final int TAG_TOP_ANIMATOR = 16909576;
    private static final int TAG_TOP = 16909577;
    private static final int TAG_LAYOUT_TOP = 16909573;
    private static final int TAG_FIRST_LAYOUT = 16909571;
    private static final int TAG_ALPHA_ANIMATOR = 16909570;
    private static final ViewClippingUtil.ClippingParameters CLIPPING_PARAMETERS = view2 -> view2.getId() == 16909294;
    private static final IntProperty<View> TOP = new IntProperty<View>("top"){

        @Override
        public void setValue(View object, int value2) {
            MessagingPropertyAnimator.setTop(object, value2);
        }

        @Override
        public Integer get(View object) {
            return MessagingPropertyAnimator.getTop(object);
        }
    };

    @Override
    public void onLayoutChange(View v, int left, int top, int right2, int bottom2, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        MessagingPropertyAnimator.setLayoutTop(v, top);
        if (MessagingPropertyAnimator.isFirstLayout(v)) {
            MessagingPropertyAnimator.setFirstLayout(v, false);
            MessagingPropertyAnimator.setTop(v, top);
            return;
        }
        MessagingPropertyAnimator.startTopAnimation(v, MessagingPropertyAnimator.getTop(v), top, MessagingLayout.FAST_OUT_SLOW_IN);
    }

    private static boolean isFirstLayout(View view2) {
        Boolean tag2 = (Boolean)view2.getTag(16909571);
        if (tag2 == null) {
            return true;
        }
        return tag2;
    }

    public static void recycle(View view2) {
        MessagingPropertyAnimator.setFirstLayout(view2, true);
    }

    private static void setFirstLayout(View view2, boolean first) {
        view2.setTagInternal(16909571, first);
    }

    private static void setLayoutTop(View view2, int top) {
        view2.setTagInternal(16909573, top);
    }

    public static int getLayoutTop(View view2) {
        Integer tag2 = (Integer)view2.getTag(16909573);
        if (tag2 == null) {
            return MessagingPropertyAnimator.getTop(view2);
        }
        return tag2;
    }

    public static void startLocalTranslationFrom(View view2, int startTranslation, Interpolator interpolator2) {
        MessagingPropertyAnimator.startTopAnimation(view2, MessagingPropertyAnimator.getTop(view2) + startTranslation, MessagingPropertyAnimator.getLayoutTop(view2), interpolator2);
    }

    public static void startLocalTranslationTo(View view2, int endTranslation, Interpolator interpolator2) {
        int top = MessagingPropertyAnimator.getTop(view2);
        MessagingPropertyAnimator.startTopAnimation(view2, top, top + endTranslation, interpolator2);
    }

    public static int getTop(View v) {
        Integer tag2 = (Integer)v.getTag(16909577);
        if (tag2 == null) {
            return v.getTop();
        }
        return tag2;
    }

    private static void setTop(View v, int value2) {
        v.setTagInternal(16909577, value2);
        MessagingPropertyAnimator.updateTopAndBottom(v);
    }

    private static void updateTopAndBottom(View v) {
        int top = MessagingPropertyAnimator.getTop(v);
        int height2 = v.getHeight();
        v.setTop(top);
        v.setBottom(height2 + top);
    }

    private static void startTopAnimation(final View v, int start, int end, Interpolator interpolator2) {
        ObjectAnimator existing = (ObjectAnimator)v.getTag(16909576);
        if (existing != null) {
            existing.cancel();
        }
        if (!v.isShown() || start == end || MessagingLinearLayout.isGone(v) && !MessagingPropertyAnimator.isHidingAnimated(v)) {
            MessagingPropertyAnimator.setTop(v, end);
            return;
        }
        ObjectAnimator animator2 = ObjectAnimator.ofInt(v, TOP, start, end);
        MessagingPropertyAnimator.setTop(v, start);
        animator2.setInterpolator(interpolator2);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){
            public boolean mCancelled;

            @Override
            public void onAnimationEnd(Animator animation) {
                v.setTagInternal(16909576, null);
                MessagingPropertyAnimator.setClippingDeactivated(v, false);
            }

            @Override
            public void onAnimationCancel(Animator animation) {
                this.mCancelled = true;
            }
        });
        MessagingPropertyAnimator.setClippingDeactivated(v, true);
        v.setTagInternal(16909576, animator2);
        animator2.start();
    }

    private static boolean isHidingAnimated(View v) {
        if (v instanceof MessagingLinearLayout.MessagingChild) {
            return ((MessagingLinearLayout.MessagingChild)((Object)v)).isHidingAnimated();
        }
        return false;
    }

    public static void fadeIn(final View v) {
        ObjectAnimator existing = (ObjectAnimator)v.getTag(16909570);
        if (existing != null) {
            existing.cancel();
        }
        if (v.getVisibility() == 4) {
            v.setVisibility(0);
        }
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(v, View.ALPHA, 0.0f, 1.0f);
        v.setAlpha(0.0f);
        animator2.setInterpolator(ALPHA_IN);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                v.setTagInternal(16909570, null);
                MessagingPropertyAnimator.updateLayerType(v, false);
            }
        });
        MessagingPropertyAnimator.updateLayerType(v, true);
        v.setTagInternal(16909570, animator2);
        animator2.start();
    }

    private static void updateLayerType(View view2, boolean animating) {
        if (view2.hasOverlappingRendering() && animating) {
            view2.setLayerType(2, null);
        } else if (view2.getLayerType() == 2) {
            view2.setLayerType(0, null);
        }
    }

    public static void fadeOut(final View view2, final Runnable endAction) {
        ObjectAnimator existing = (ObjectAnimator)view2.getTag(16909570);
        if (existing != null) {
            existing.cancel();
        }
        if (!view2.isShown() || MessagingLinearLayout.isGone(view2) && !MessagingPropertyAnimator.isHidingAnimated(view2)) {
            view2.setAlpha(0.0f);
            if (endAction != null) {
                endAction.run();
            }
            return;
        }
        ObjectAnimator animator2 = ObjectAnimator.ofFloat(view2, View.ALPHA, view2.getAlpha(), 0.0f);
        animator2.setInterpolator(ALPHA_OUT);
        animator2.setDuration(210L);
        animator2.addListener(new AnimatorListenerAdapter(){

            @Override
            public void onAnimationEnd(Animator animation) {
                view2.setTagInternal(16909570, null);
                MessagingPropertyAnimator.updateLayerType(view2, false);
                if (endAction != null) {
                    endAction.run();
                }
            }
        });
        MessagingPropertyAnimator.updateLayerType(view2, true);
        view2.setTagInternal(16909570, animator2);
        animator2.start();
    }

    public static void setClippingDeactivated(View transformedView, boolean deactivated) {
        ViewClippingUtil.setClippingDeactivated(transformedView, deactivated, CLIPPING_PARAMETERS);
    }

    public static boolean isAnimatingTranslation(View v) {
        return v.getTag(16909576) != null;
    }

    public static boolean isAnimatingAlpha(View v) {
        return v.getTag(16909570) != null;
    }

    public static void setToLaidOutPosition(View view2) {
        MessagingPropertyAnimator.setTop(view2, MessagingPropertyAnimator.getLayoutTop(view2));
    }
}

