/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.StateSet;
import android.view.KeyEvent;
import android.widget.TextView;

public class NumericTextView
extends TextView {
    private static final int RADIX = 10;
    private static final double LOG_RADIX = Math.log(10.0);
    private int mMinValue = 0;
    private int mMaxValue = 99;
    private int mMaxCount = 2;
    private boolean mShowLeadingZeroes = true;
    private int mValue;
    private int mCount;
    private int mPreviousValue;
    private OnValueChangedListener mListener;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public NumericTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
        int textColorDisabled = this.getTextColors().getColorForState(StateSet.get(0), 0);
        this.setHintTextColor(textColorDisabled);
        this.setFocusable(true);
    }

    @Override
    protected void onFocusChanged(boolean focused, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(focused, direction, previouslyFocusedRect);
        if (focused) {
            this.mPreviousValue = this.mValue;
            this.mValue = 0;
            this.mCount = 0;
            this.setHint(this.getText());
            this.setText("");
        } else {
            if (this.mCount == 0) {
                this.mValue = this.mPreviousValue;
                this.setText(this.getHint());
                this.setHint("");
            }
            if (this.mValue < this.mMinValue) {
                this.mValue = this.mMinValue;
            }
            this.setValue(this.mValue);
            if (this.mListener != null) {
                this.mListener.onValueChanged(this, this.mValue, true, true);
            }
        }
    }

    public void setValue(int value2) {
        if (this.mValue != value2) {
            this.mValue = value2;
            this.updateDisplayedValue();
        }
    }

    public int getValue() {
        return this.mValue;
    }

    public void setRange(int minValue, int maxValue) {
        if (this.mMinValue != minValue) {
            this.mMinValue = minValue;
        }
        if (this.mMaxValue != maxValue) {
            this.mMaxValue = maxValue;
            this.mMaxCount = 1 + (int)(Math.log(maxValue) / LOG_RADIX);
            this.updateMinimumWidth();
            this.updateDisplayedValue();
        }
    }

    public int getRangeMinimum() {
        return this.mMinValue;
    }

    public int getRangeMaximum() {
        return this.mMaxValue;
    }

    public void setShowLeadingZeroes(boolean showLeadingZeroes) {
        if (this.mShowLeadingZeroes != showLeadingZeroes) {
            this.mShowLeadingZeroes = showLeadingZeroes;
            this.updateDisplayedValue();
        }
    }

    public boolean getShowLeadingZeroes() {
        return this.mShowLeadingZeroes;
    }

    private void updateDisplayedValue() {
        String format = this.mShowLeadingZeroes ? "%0" + this.mMaxCount + "d" : "%d";
        this.setText(String.format(format, this.mValue));
    }

    private void updateMinimumWidth() {
        CharSequence previousText = this.getText();
        int maxWidth = 0;
        for (int i = 0; i < this.mMaxValue; ++i) {
            this.setText(String.format("%0" + this.mMaxCount + "d", i));
            this.measure(0, 0);
            int width2 = this.getMeasuredWidth();
            if (width2 <= maxWidth) continue;
            maxWidth = width2;
        }
        this.setText(previousText);
        this.setMinWidth(maxWidth);
        this.setMinimumWidth(maxWidth);
    }

    public void setOnDigitEnteredListener(OnValueChangedListener listener2) {
        this.mListener = listener2;
    }

    public OnValueChangedListener getOnDigitEnteredListener() {
        return this.mListener;
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        return NumericTextView.isKeyCodeNumeric(keyCode) || keyCode == 67 || super.onKeyDown(keyCode, event);
    }

    @Override
    public boolean onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return NumericTextView.isKeyCodeNumeric(keyCode) || keyCode == 67 || super.onKeyMultiple(keyCode, repeatCount, event);
    }

    @Override
    public boolean onKeyUp(int keyCode, KeyEvent event) {
        return this.handleKeyUp(keyCode) || super.onKeyUp(keyCode, event);
    }

    private boolean handleKeyUp(int keyCode) {
        if (keyCode == 67) {
            if (this.mCount > 0) {
                this.mValue /= 10;
                --this.mCount;
            }
        } else if (NumericTextView.isKeyCodeNumeric(keyCode)) {
            int keyValue;
            int newValue;
            if (this.mCount < this.mMaxCount && (newValue = this.mValue * 10 + (keyValue = NumericTextView.numericKeyCodeToInt(keyCode))) <= this.mMaxValue) {
                this.mValue = newValue;
                ++this.mCount;
            }
        } else {
            return false;
        }
        String formattedValue = this.mCount > 0 ? String.format("%0" + this.mCount + "d", this.mValue) : "";
        this.setText(formattedValue);
        if (this.mListener != null) {
            boolean isValid = this.mValue >= this.mMinValue;
            boolean isFinished = this.mCount >= this.mMaxCount || this.mValue * 10 > this.mMaxValue;
            this.mListener.onValueChanged(this, this.mValue, isValid, isFinished);
        }
        return true;
    }

    private static boolean isKeyCodeNumeric(int keyCode) {
        return keyCode == 7 || keyCode == 8 || keyCode == 9 || keyCode == 10 || keyCode == 11 || keyCode == 12 || keyCode == 13 || keyCode == 14 || keyCode == 15 || keyCode == 16;
    }

    private static int numericKeyCodeToInt(int keyCode) {
        return keyCode - 7;
    }

    public static interface OnValueChangedListener {
        public void onValueChanged(NumericTextView var1, int var2, boolean var3, boolean var4);
    }
}

