/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import java.util.ArrayList;

@RemoteViews.RemoteView
public class RemeasuringLinearLayout
extends LinearLayout {
    private ArrayList<View> mMatchParentViews = new ArrayList();

    public RemeasuringLinearLayout(Context context) {
        super(context);
    }

    public RemeasuringLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RemeasuringLinearLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public RemeasuringLinearLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int count = this.getChildCount();
        int height2 = 0;
        boolean isVertical = this.getOrientation() == 1;
        boolean isWrapContent = this.getLayoutParams().height == -2;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == null || child.getVisibility() == 8) continue;
            LinearLayout.LayoutParams lp = (LinearLayout.LayoutParams)child.getLayoutParams();
            if (!isWrapContent || lp.height != -1 || isVertical) {
                int childHeight = child.getMeasuredHeight() + lp.topMargin + lp.bottomMargin;
                height2 = Math.max(height2, isVertical ? height2 + childHeight : childHeight);
                continue;
            }
            this.mMatchParentViews.add(child);
        }
        if (this.mMatchParentViews.size() > 0) {
            int exactHeightSpec = View.MeasureSpec.makeMeasureSpec(height2, 0x40000000);
            for (View child : this.mMatchParentViews) {
                child.measure(RemeasuringLinearLayout.getChildMeasureSpec(widthMeasureSpec, this.getPaddingStart() + this.getPaddingEnd(), child.getLayoutParams().width), exactHeightSpec);
            }
        }
        this.mMatchParentViews.clear();
        this.setMeasuredDimension(this.getMeasuredWidth(), height2);
    }
}

