/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.view.View;
import com.android.internal.widget.OrientationHelper;
import com.android.internal.widget.RecyclerView;

class ScrollbarHelper {
    ScrollbarHelper() {
    }

    static int computeScrollOffset(RecyclerView.State state, OrientationHelper orientation2, View startChild, View endChild, RecyclerView.LayoutManager lm, boolean smoothScrollbarEnabled, boolean reverseLayout) {
        int itemsBefore;
        if (lm.getChildCount() == 0 || state.getItemCount() == 0 || startChild == null || endChild == null) {
            return 0;
        }
        int minPosition = Math.min(lm.getPosition(startChild), lm.getPosition(endChild));
        int maxPosition = Math.max(lm.getPosition(startChild), lm.getPosition(endChild));
        int n = itemsBefore = reverseLayout ? Math.max(0, state.getItemCount() - maxPosition - 1) : Math.max(0, minPosition);
        if (!smoothScrollbarEnabled) {
            return itemsBefore;
        }
        int laidOutArea = Math.abs(orientation2.getDecoratedEnd(endChild) - orientation2.getDecoratedStart(startChild));
        int itemRange = Math.abs(lm.getPosition(startChild) - lm.getPosition(endChild)) + 1;
        float avgSizePerRow = (float)laidOutArea / (float)itemRange;
        return Math.round((float)itemsBefore * avgSizePerRow + (float)(orientation2.getStartAfterPadding() - orientation2.getDecoratedStart(startChild)));
    }

    static int computeScrollExtent(RecyclerView.State state, OrientationHelper orientation2, View startChild, View endChild, RecyclerView.LayoutManager lm, boolean smoothScrollbarEnabled) {
        if (lm.getChildCount() == 0 || state.getItemCount() == 0 || startChild == null || endChild == null) {
            return 0;
        }
        if (!smoothScrollbarEnabled) {
            return Math.abs(lm.getPosition(startChild) - lm.getPosition(endChild)) + 1;
        }
        int extend = orientation2.getDecoratedEnd(endChild) - orientation2.getDecoratedStart(startChild);
        return Math.min(orientation2.getTotalSpace(), extend);
    }

    static int computeScrollRange(RecyclerView.State state, OrientationHelper orientation2, View startChild, View endChild, RecyclerView.LayoutManager lm, boolean smoothScrollbarEnabled) {
        if (lm.getChildCount() == 0 || state.getItemCount() == 0 || startChild == null || endChild == null) {
            return 0;
        }
        if (!smoothScrollbarEnabled) {
            return state.getItemCount();
        }
        int laidOutArea = orientation2.getDecoratedEnd(endChild) - orientation2.getDecoratedStart(startChild);
        int laidOutRange = Math.abs(lm.getPosition(startChild) - lm.getPosition(endChild)) + 1;
        return (int)((float)laidOutArea / (float)laidOutRange * (float)state.getItemCount());
    }
}

