/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import java.util.ArrayList;
import java.util.function.Predicate;

public class WatchHeaderListView
extends ListView {
    private View mTopPanel;

    public WatchHeaderListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public WatchHeaderListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public WatchHeaderListView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    @Override
    protected HeaderViewListAdapter wrapHeaderListAdapterInternal(ArrayList<ListView.FixedViewInfo> headerViewInfos, ArrayList<ListView.FixedViewInfo> footerViewInfos, ListAdapter adapter) {
        return new WatchHeaderListAdapter(headerViewInfos, footerViewInfos, adapter);
    }

    @Override
    public void addView(View child, ViewGroup.LayoutParams params) {
        if (this.mTopPanel != null) {
            throw new IllegalStateException("WatchHeaderListView can host only one header");
        }
        this.setTopPanel(child);
    }

    public void setTopPanel(View v) {
        this.mTopPanel = v;
        this.wrapAdapterIfNecessary();
    }

    @Override
    public void setAdapter(ListAdapter adapter) {
        super.setAdapter(adapter);
        this.wrapAdapterIfNecessary();
    }

    protected View findViewTraversal(int id2) {
        Object v = super.findViewTraversal(id2);
        if (v == null && this.mTopPanel != null && !this.mTopPanel.isRootNamespace()) {
            return this.mTopPanel.findViewById(id2);
        }
        return v;
    }

    protected View findViewWithTagTraversal(Object tag2) {
        Object v = super.findViewWithTagTraversal(tag2);
        if (v == null && this.mTopPanel != null && !this.mTopPanel.isRootNamespace()) {
            return this.mTopPanel.findViewWithTag(tag2);
        }
        return v;
    }

    @Override
    protected <T extends View> T findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        Object v = super.findViewByPredicateTraversal(predicate, childToSkip);
        if (v == null && this.mTopPanel != null && this.mTopPanel != childToSkip && !this.mTopPanel.isRootNamespace()) {
            return this.mTopPanel.findViewByPredicate(predicate);
        }
        return v;
    }

    @Override
    public int getHeaderViewsCount() {
        return this.mTopPanel == null ? super.getHeaderViewsCount() : super.getHeaderViewsCount() + (this.mTopPanel.getVisibility() == 8 ? 0 : 1);
    }

    private void wrapAdapterIfNecessary() {
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && this.mTopPanel != null) {
            if (!(adapter instanceof WatchHeaderListAdapter)) {
                this.wrapHeaderListAdapterInternal();
            }
            ((WatchHeaderListAdapter)this.getAdapter()).setTopPanel(this.mTopPanel);
            this.dispatchDataSetObserverOnChangedInternal();
        }
    }

    private static class WatchHeaderListAdapter
    extends HeaderViewListAdapter {
        private View mTopPanel;

        public WatchHeaderListAdapter(ArrayList<ListView.FixedViewInfo> headerViewInfos, ArrayList<ListView.FixedViewInfo> footerViewInfos, ListAdapter adapter) {
            super(headerViewInfos, footerViewInfos, adapter);
        }

        public void setTopPanel(View v) {
            this.mTopPanel = v;
        }

        private int getTopPanelCount() {
            return this.mTopPanel == null || this.mTopPanel.getVisibility() == 8 ? 0 : 1;
        }

        @Override
        public int getCount() {
            return super.getCount() + this.getTopPanelCount();
        }

        @Override
        public boolean areAllItemsEnabled() {
            return this.getTopPanelCount() == 0 && super.areAllItemsEnabled();
        }

        @Override
        public boolean isEnabled(int position) {
            int topPanelCount = this.getTopPanelCount();
            return position < topPanelCount ? false : super.isEnabled(position - topPanelCount);
        }

        @Override
        public Object getItem(int position) {
            int topPanelCount = this.getTopPanelCount();
            return position < topPanelCount ? null : super.getItem(position - topPanelCount);
        }

        @Override
        public long getItemId(int position) {
            int adapterCount;
            int adjPosition;
            int numHeaders = this.getHeadersCount() + this.getTopPanelCount();
            if (this.getWrappedAdapter() != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.getWrappedAdapter().getCount())) {
                return this.getWrappedAdapter().getItemId(adjPosition);
            }
            return -1L;
        }

        @Override
        public View getView(int position, View convertView, ViewGroup parent) {
            int topPanelCount = this.getTopPanelCount();
            return position < topPanelCount ? this.mTopPanel : super.getView(position - topPanelCount, convertView, parent);
        }

        @Override
        public int getItemViewType(int position) {
            int adapterCount;
            int adjPosition;
            int numHeaders = this.getHeadersCount() + this.getTopPanelCount();
            if (this.getWrappedAdapter() != null && position >= numHeaders && (adjPosition = position - numHeaders) < (adapterCount = this.getWrappedAdapter().getCount())) {
                return this.getWrappedAdapter().getItemViewType(adjPosition);
            }
            return -2;
        }
    }
}

