/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge;

import android.content.res.BridgeAssetManager;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.fonts.SystemFonts_Delegate;
import android.hardware.input.IInputManager;
import android.hardware.input.InputManager;
import android.icu.util.ULocale;
import android.os.Looper;
import android.os.Looper_Accessor;
import android.os.SystemProperties;
import android.util.Pair;
import android.util.SparseArray;
import android.view.InputDevice;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.ide.common.rendering.api.DrawableParams;
import com.android.ide.common.rendering.api.ILayoutLog;
import com.android.ide.common.rendering.api.RenderSession;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.Result;
import com.android.ide.common.rendering.api.SessionParams;
import com.android.ide.common.rendering.api.XmlParserFactory;
import com.android.internal.R;
import com.android.layoutlib.bridge.BridgeRenderSession;
import com.android.layoutlib.bridge.MockView;
import com.android.layoutlib.bridge.android.RenderParamsFlags;
import com.android.layoutlib.bridge.impl.ParserFactory;
import com.android.layoutlib.bridge.impl.RenderDrawable;
import com.android.layoutlib.bridge.impl.RenderSessionImpl;
import com.android.layoutlib.bridge.util.DynamicIdMap;
import com.android.layoutlib.common.util.ReflectionUtils;
import com.android.resources.ResourceType;
import com.android.tools.layoutlib.create.MethodAdapter;
import com.android.tools.layoutlib.create.NativeConfig;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.lang.ref.SoftReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.ReentrantLock;
import libcore.io.MemoryMappedFile_Delegate;
import org.kxml2.io.KXmlParser;
import org.xmlpull.v1.XmlPullParser;

public final class Bridge
extends com.android.ide.common.rendering.api.Bridge {
    private static final String ICU_LOCALE_DIRECTION_RTL = "right-to-left";
    private static final ReentrantLock sLock = new ReentrantLock();
    private static final Map<Integer, Pair<ResourceType, String>> sRMap = new HashMap<Integer, Pair<ResourceType, String>>();
    private static final Map<ResourceType, Map<String, Integer>> sRevRMap = new EnumMap<ResourceType, Map<String, Integer>>(ResourceType.class);
    private static final int DYNAMIC_ID_SEED_START = 0x1FF0000;
    private static final DynamicIdMap sDynamicIds = new DynamicIdMap(0x1FF0000);
    private static final Map<Object, Map<String, SoftReference<Bitmap>>> sProjectBitmapCache = new WeakHashMap<Object, Map<String, SoftReference<Bitmap>>>();
    private static final Map<Object, Map<String, SoftReference<Rect>>> sProjectBitmapPaddingCache = new WeakHashMap<Object, Map<String, SoftReference<Rect>>>();
    private static final Map<String, SoftReference<Bitmap>> sFrameworkBitmapCache = new HashMap<String, SoftReference<Bitmap>>();
    private static final Map<String, SoftReference<Rect>> sFrameworkBitmapPaddingCache = new HashMap<String, SoftReference<Rect>>();
    private static Map<String, Map<String, Integer>> sEnumValueMap;
    private static Map<String, String> sPlatformProperties;
    private static final ILayoutLog sDefaultLog;
    private static ILayoutLog sCurrentLog;
    private static String sIcuDataPath;
    private static String[] sKeyboardPaths;
    private static final String[] LINUX_NATIVE_LIBRARIES;
    private static final String[] MAC_NATIVE_LIBRARIES;
    private static final String[] WINDOWS_NATIVE_LIBRARIES;
    private static boolean sJniLibLoadAttempted;
    private static boolean sJniLibLoaded;

    public boolean init(Map<String, String> platformProperties, File fontLocation, String nativeLibPath, String icuDataPath, String[] keyboardPaths, Map<String, Map<String, Integer>> enumValueMap, ILayoutLog log) {
        sPlatformProperties = platformProperties;
        sEnumValueMap = enumValueMap;
        sIcuDataPath = icuDataPath;
        sKeyboardPaths = keyboardPaths;
        sCurrentLog = log;
        if (!Bridge.loadNativeLibrariesIfNeeded(log, nativeLibPath)) {
            return false;
        }
        final String debug = System.getenv("DEBUG_LAYOUT");
        if (debug != null && !debug.equals("0") && !debug.equals("false")) {
            OverrideMethod.setDefaultListener(new MethodAdapter(){

                @Override
                public void onInvokeV(String signature, boolean isNative, Object caller) {
                    sDefaultLog.error(null, "Missing Stub: " + signature + (isNative ? " (native)" : ""), null, null);
                    if (debug.equalsIgnoreCase("throw")) {
                        throw new StaticMethodNotImplementedException(signature);
                    }
                }
            });
        }
        try {
            BridgeAssetManager.initSystem();
            SystemFonts_Delegate.setFontLocation(fontLocation.getAbsolutePath() + File.separator);
            MemoryMappedFile_Delegate.setDataDir(fontLocation.getAbsoluteFile().getParentFile());
            ParserFactory.setParserFactory(new XmlParserFactory(){

                public XmlPullParser createXmlParserForPsiFile(String fileName) {
                    return null;
                }

                public XmlPullParser createXmlParserForFile(String fileName) {
                    return null;
                }

                public XmlPullParser createXmlParser() {
                    return new KXmlParser();
                }
            });
            for (String deferredClass : NativeConfig.DEFERRED_STATIC_INITIALIZER_CLASSES) {
                ReflectionUtils.invokeStatic(deferredClass, "deferredStaticInitializer", new Object[0]);
            }
            Typeface.loadPreinstalledSystemFontMap();
            ParserFactory.setParserFactory(null);
        }
        catch (Throwable t) {
            if (log != null) {
                log.error("broken", "Layoutlib Bridge initialization failed", t, null, null);
            }
            return false;
        }
        try {
            Class<R> r = R.class;
            Bridge.parseStyleable();
            for (Class<?> inner : r.getDeclaredClasses()) {
                String resTypeName;
                ResourceType resType;
                if (inner == R.styleable.class || (resType = ResourceType.fromClassName((String)(resTypeName = inner.getSimpleName()))) == null) continue;
                Map<String, Integer> fullMap = null;
                switch (resType) {
                    case ATTR: {
                        fullMap = sRevRMap.get(ResourceType.ATTR);
                        break;
                    }
                    case STRING: 
                    case STYLE: {
                        fullMap = new HashMap<String, Integer>(1280);
                    }
                    default: {
                        if (fullMap == null) {
                            fullMap = new HashMap<String, Integer>();
                        }
                        sRevRMap.put(resType, fullMap);
                    }
                }
                for (Field f : inner.getDeclaredFields()) {
                    Class<?> type;
                    if (!Bridge.isValidRField(f) || (type = f.getType()).isArray()) continue;
                    Integer value2 = (Integer)f.get(null);
                    sRMap.put(value2, Pair.create(resType, f.getName()));
                    fullMap.put(f.getName(), value2);
                }
            }
        }
        catch (Exception throwable) {
            if (log != null) {
                log.error("broken", "Failed to load com.android.internal.R from the layout library jar", (Throwable)throwable, null, null);
            }
            return false;
        }
        return true;
    }

    private static void setSystemProperties() {
        for (Map.Entry<String, String> property : sPlatformProperties.entrySet()) {
            SystemProperties.set(property.getKey(), property.getValue());
        }
    }

    private static boolean isValidRField(Field field) {
        int modifiers = field.getModifiers();
        boolean isAcceptable = Modifier.isPublic(modifiers) && Modifier.isStatic(modifiers);
        Class<?> type = field.getType();
        return isAcceptable && type == Integer.TYPE || type.isArray() && type.getComponentType() == Integer.TYPE;
    }

    private static void parseStyleable() throws Exception {
        HashMap<String, Integer> revRAttrMap = new HashMap<String, Integer>(2048);
        sRevRMap.put(ResourceType.ATTR, revRAttrMap);
        HashMap<String, Integer> revRStyleableMap = new HashMap<String, Integer>(3072);
        sRevRMap.put(ResourceType.STYLEABLE, revRStyleableMap);
        Class<R.styleable> c = R.styleable.class;
        Field[] fields = c.getDeclaredFields();
        Arrays.sort(fields, (o1, o2) -> {
            if (o1 == o2) {
                return 0;
            }
            Class<?> t1 = o1.getType();
            Class<?> t2 = o2.getType();
            if (t1.isArray() && !t2.isArray()) {
                return -1;
            }
            if (t2.isArray() && !t1.isArray()) {
                return 1;
            }
            return o1.getName().compareTo(o2.getName());
        });
        HashMap<String, int[]> styleables = new HashMap<String, int[]>();
        for (Field field : fields) {
            int index;
            if (!Bridge.isValidRField(field)) continue;
            String name = field.getName();
            if (field.getType().isArray()) {
                int[] styleableValue = (int[])field.get(null);
                styleables.put(name, styleableValue);
                continue;
            }
            String arrayName = name;
            int[] arrayValue = null;
            while ((index = arrayName.lastIndexOf(95)) >= 0 && (arrayValue = (int[])styleables.get(arrayName = arrayName.substring(0, index))) == null) {
            }
            index = (Integer)field.get(null);
            if (arrayValue != null) {
                String attrName = name.substring(arrayName.length() + 1);
                int attrValue = arrayValue[index];
                sRMap.put(attrValue, Pair.create(ResourceType.ATTR, attrName));
                revRAttrMap.put(attrName, attrValue);
            }
            sRMap.put(index, Pair.create(ResourceType.STYLEABLE, name));
            revRStyleableMap.put(name, index);
        }
    }

    public boolean dispose() {
        BridgeAssetManager.clearSystem();
        if (SystemFonts_Delegate.sIsTypefaceInitialized) {
            Typeface.sDynamicTypefaceCache.evictAll();
        }
        sProjectBitmapCache.clear();
        sProjectBitmapPaddingCache.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RenderSession createSession(SessionParams params) {
        try {
            Result lastResult;
            RenderSessionImpl scene = new RenderSessionImpl(params);
            try {
                Bridge.prepareThread();
                lastResult = scene.init(params.getTimeout());
                if (lastResult.isSuccess()) {
                    lastResult = scene.inflate();
                    boolean doNotRenderOnCreate = Boolean.TRUE.equals(params.getFlag(RenderParamsFlags.FLAG_DO_NOT_RENDER_ON_CREATE));
                    if (lastResult.isSuccess() && !doNotRenderOnCreate) {
                        lastResult = scene.render(true);
                    }
                }
            }
            finally {
                scene.release();
                Bridge.cleanupThread();
            }
            return new BridgeRenderSession(scene, lastResult);
        }
        catch (Throwable t) {
            Throwable t2 = t;
            while (t2.getCause() != null) {
                t2 = t2.getCause();
            }
            return new BridgeRenderSession(null, Result.Status.ERROR_UNKNOWN.createResult(t2.getMessage(), t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result renderDrawable(DrawableParams params) {
        try {
            Result lastResult;
            RenderDrawable action2 = new RenderDrawable(params);
            try {
                Bridge.prepareThread();
                lastResult = action2.init(params.getTimeout());
                if (lastResult.isSuccess()) {
                    lastResult = action2.render();
                }
            }
            finally {
                action2.release();
                Bridge.cleanupThread();
            }
            return lastResult;
        }
        catch (Throwable t) {
            Throwable t2 = t;
            while (t2.getCause() != null) {
                t2 = t.getCause();
            }
            return Result.Status.ERROR_UNKNOWN.createResult(t2.getMessage(), t);
        }
    }

    public void clearResourceCaches(Object projectKey) {
        if (projectKey != null) {
            sProjectBitmapCache.remove(projectKey);
            sProjectBitmapPaddingCache.remove(projectKey);
        }
    }

    public void clearAllCaches(Object projectKey) {
        this.clearResourceCaches(projectKey);
    }

    public Result getViewParent(Object viewObject) {
        if (viewObject instanceof View) {
            return Result.Status.SUCCESS.createResult((Object)((View)viewObject).getParent());
        }
        throw new IllegalArgumentException("viewObject is not a View");
    }

    public Result getViewIndex(Object viewObject) {
        if (viewObject instanceof View) {
            View view2 = (View)viewObject;
            ViewParent parentView = view2.getParent();
            if (parentView instanceof ViewGroup) {
                Result.Status.SUCCESS.createResult((Object)((ViewGroup)parentView).indexOfChild(view2));
            }
            return Result.Status.SUCCESS.createResult();
        }
        throw new IllegalArgumentException("viewObject is not a View");
    }

    public boolean isRtl(String locale) {
        return Bridge.isLocaleRtl(locale);
    }

    public static boolean isLocaleRtl(String locale) {
        if (locale == null) {
            locale = "";
        }
        ULocale uLocale = new ULocale(locale);
        return uLocale.getCharacterOrientation().equals(ICU_LOCALE_DIRECTION_RTL);
    }

    public static ReentrantLock getLock() {
        return sLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void prepareThread() {
        if (Looper.myLooper() != null) return;
        Class<Looper> clazz = Looper.class;
        synchronized (Looper.class) {
            if (Looper.getMainLooper() != null) return;
            Looper.prepareMainLooper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static synchronized void cleanupThread() {
        Looper_Accessor.cleanupThread();
    }

    public static ILayoutLog getLog() {
        return sCurrentLog;
    }

    public static void setLog(ILayoutLog log) {
        if (!sLock.isHeldByCurrentThread()) {
            throw new IllegalStateException("scene must be acquired first. see #acquire(long)");
        }
        sCurrentLog = log != null ? log : sDefaultLog;
    }

    public static ResourceReference resolveResourceId(int value2) {
        Pair<ResourceType, String> pair = sRMap.get(value2);
        if (pair == null) {
            pair = sDynamicIds.resolveId(value2);
        }
        if (pair != null) {
            return new ResourceReference(ResourceNamespace.ANDROID, (ResourceType)pair.first, (String)pair.second);
        }
        return null;
    }

    public static int getResourceId(ResourceType type, String name) {
        Map<String, Integer> map2 = sRevRMap.get(type);
        Integer value2 = map2 == null ? null : map2.get(name);
        return value2 == null ? sDynamicIds.getId(type, name) : value2;
    }

    public static Map<String, Integer> getEnumValues(String attributeName) {
        if (sEnumValueMap != null) {
            return sEnumValueMap.get(attributeName);
        }
        return null;
    }

    public static Bitmap getCachedBitmap(String value2, Object projectKey) {
        if (projectKey != null) {
            SoftReference<Bitmap> ref;
            Map<String, SoftReference<Bitmap>> map2 = sProjectBitmapCache.get(projectKey);
            if (map2 != null && (ref = map2.get(value2)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<Bitmap> ref = sFrameworkBitmapCache.get(value2);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    public static Rect getCachedBitmapPadding(String value2, Object projectKey) {
        if (projectKey != null) {
            SoftReference<Rect> ref;
            Map<String, SoftReference<Rect>> map2 = sProjectBitmapPaddingCache.get(projectKey);
            if (map2 != null && (ref = map2.get(value2)) != null) {
                return ref.get();
            }
        } else {
            SoftReference<Rect> ref = sFrameworkBitmapPaddingCache.get(value2);
            if (ref != null) {
                return ref.get();
            }
        }
        return null;
    }

    public static void setCachedBitmap(String value2, Bitmap bmp, Object projectKey) {
        if (projectKey != null) {
            Map map2 = sProjectBitmapCache.computeIfAbsent(projectKey, k -> new HashMap());
            map2.put(value2, new SoftReference<Bitmap>(bmp));
        } else {
            sFrameworkBitmapCache.put(value2, new SoftReference<Bitmap>(bmp));
        }
    }

    public static void setCachedBitmapPadding(String value2, Rect padding, Object projectKey) {
        if (projectKey != null) {
            Map map2 = sProjectBitmapPaddingCache.computeIfAbsent(projectKey, k -> new HashMap());
            map2.put(value2, new SoftReference<Rect>(padding));
        } else {
            sFrameworkBitmapPaddingCache.put(value2, new SoftReference<Rect>(padding));
        }
    }

    public static String getIcuDataPath() {
        return sIcuDataPath;
    }

    private static void setInputManager(InputDevice[] devices) {
        final int[] ids = Arrays.stream(devices).mapToInt(InputDevice::getId).toArray();
        final SparseArray<InputDevice> idToDevice = new SparseArray<InputDevice>(devices.length);
        for (InputDevice device : devices) {
            idToDevice.append(device.getId(), device);
        }
        InputManager.sInstance = new InputManager(new IInputManager.Default(){

            @Override
            public int[] getInputDeviceIds() {
                return ids;
            }

            @Override
            public InputDevice getInputDevice(int deviceId) {
                return (InputDevice)idToDevice.get(deviceId);
            }
        });
    }

    private static synchronized boolean loadNativeLibrariesIfNeeded(ILayoutLog log, String nativeLibDir) {
        if (!sJniLibLoadAttempted) {
            try {
                Bridge.loadNativeLibraries(nativeLibDir);
            }
            catch (Throwable t) {
                log.error("broken", "Native layoutlib failed to load", t, null, null);
            }
        }
        return sJniLibLoaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void loadNativeLibraries(String nativeLibDir) {
        if (sJniLibLoadAttempted) {
            return;
        }
        try {
            System.setProperty("core_native_classes", String.join((CharSequence)",", NativeConfig.CORE_CLASS_NATIVES));
            System.setProperty("graphics_native_classes", String.join((CharSequence)",", NativeConfig.GRAPHICS_CLASS_NATIVES));
            System.setProperty("icu.data.path", Bridge.getIcuDataPath());
            System.setProperty("use_bridge_for_logging", "true");
            System.setProperty("register_properties_during_load", "true");
            System.setProperty("keyboard_paths", String.join((CharSequence)",", sKeyboardPaths));
            for (String library : Bridge.getNativeLibraries()) {
                String path = new File(nativeLibDir, library).getAbsolutePath();
                System.load(path);
            }
        }
        finally {
            sJniLibLoadAttempted = true;
        }
        sJniLibLoaded = true;
    }

    private static String[] getNativeLibraries() {
        String osName = System.getProperty("os.name").toLowerCase(Locale.US);
        if (osName.startsWith("windows")) {
            return WINDOWS_NATIVE_LIBRARIES;
        }
        if (osName.startsWith("mac")) {
            return MAC_NATIVE_LIBRARIES;
        }
        return LINUX_NATIVE_LIBRARIES;
    }

    public void clearFontCache(String path) {
        if (SystemFonts_Delegate.sIsTypefaceInitialized) {
            String key = Typeface.Builder.createAssetUid(BridgeAssetManager.initSystem(), path, 0, null, Typeface.RESOLVE_BY_FONT_TABLE, Typeface.RESOLVE_BY_FONT_TABLE, Typeface.DEFAULT_FAMILY);
            Typeface.sDynamicTypefaceCache.remove(key);
        }
    }

    public Object createMockView(String label, Class<?>[] signature, Object[] args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor constructor = MockView.class.getConstructor(signature);
        MockView mockView = (MockView)constructor.newInstance(args);
        mockView.setText(label);
        mockView.setGravity(17);
        return mockView;
    }

    static {
        sCurrentLog = sDefaultLog = new ILayoutLog(){

            public void error(String tag2, String message, Object viewCookie, Object data) {
                System.err.println(message);
            }

            public void error(String tag2, String message, Throwable throwable, Object viewCookie, Object data) {
                System.err.println(message);
            }

            public void warning(String tag2, String message, Object viewCookie, Object data) {
                System.out.println(message);
            }

            public void logAndroidFramework(int priority, String tag2, String message) {
                System.out.println(message);
            }
        };
        LINUX_NATIVE_LIBRARIES = new String[]{"libandroid_runtime.so"};
        MAC_NATIVE_LIBRARIES = new String[]{"libandroid_runtime.dylib"};
        WINDOWS_NATIVE_LIBRARIES = new String[]{"libicuuc_stubdata.dll", "libicuuc-host.dll", "libandroid_runtime.dll"};
    }

    public static class StaticMethodNotImplementedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public StaticMethodNotImplementedException(String msg) {
            super(msg);
        }
    }
}

