/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.bars;

import android.util.DisplayMetrics;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.bars.CustomBar;
import com.android.resources.Density;

public class NavigationBar
extends CustomBar {
    private static final String ATTR_COLOR = "navigationBarColor";
    public static final String ATTR_TRANSLUCENT = "windowTranslucentNavigation";
    private static final int PADDING_WIDTH_DEFAULT = 36;
    private static final int PADDING_WIDTH_SW360 = 40;
    private static final int PADDING_WIDTH_SW400 = 50;
    private static final int WIDTH_DEFAULT = 36;
    private static final int WIDTH_SW360 = 40;
    private static final int WIDTH_SW600 = 48;
    protected static final String LAYOUT_XML = "navigation_bar.xml";
    private static final String LAYOUT_600DP_XML = "navigation_bar600dp.xml";

    public NavigationBar(BridgeContext context, Density density, int orientation2, boolean isRtl, boolean rtlEnabled, int simulatedPlatformVersion, boolean quickStepEnabled) {
        this(context, density, orientation2, isRtl, rtlEnabled, simulatedPlatformVersion, NavigationBar.getShortestWidth(context) >= 600.0f ? LAYOUT_600DP_XML : LAYOUT_XML, quickStepEnabled);
    }

    protected NavigationBar(BridgeContext context, Density density, int orientation2, boolean isRtl, boolean rtlEnabled, int simulatedPlatformVersion, String layoutPath, boolean quickStepEnabled) {
        super(context, orientation2, layoutPath, simulatedPlatformVersion);
        int color2 = this.getBarColor(ATTR_COLOR, ATTR_TRANSLUCENT);
        this.setBackgroundColor(color2 == 0 ? -16777216 : color2);
        int back = 1;
        int recent = 5;
        if (orientation2 == 1 || isRtl && !rtlEnabled) {
            back = 5;
            recent = 1;
        }
        this.loadIcon(back, quickStepEnabled ? "ic_sysbar_back_quick_step.png" : "ic_sysbar_back.png", density, isRtl);
        this.loadIcon(3, quickStepEnabled ? "ic_sysbar_home_quick_step.png" : "ic_sysbar_home.png", density, isRtl);
        if (!quickStepEnabled) {
            this.loadIcon(recent, "ic_sysbar_recent.png", density, isRtl);
        }
        this.setupNavBar(context, orientation2);
    }

    private void setupNavBar(BridgeContext context, int orientation2) {
        float sw = NavigationBar.getShortestWidth(context);
        View leftPadding = this.getChildAt(0);
        View rightPadding = this.getChildAt(6);
        NavigationBar.setSize(context, leftPadding, orientation2, this.getSidePadding(sw));
        NavigationBar.setSize(context, rightPadding, orientation2, this.getSidePadding(sw));
        int navButtonWidth = NavigationBar.getWidth(sw);
        for (int i = 1; i < 6; i += 2) {
            View navButton = this.getChildAt(i);
            NavigationBar.setSize(context, navButton, orientation2, navButtonWidth);
        }
        if (sw >= 600.0f) {
            NavigationBar.setSize(context, this.getChildAt(2), orientation2, 128);
            NavigationBar.setSize(context, this.getChildAt(4), orientation2, 128);
        }
    }

    private static void setSize(BridgeContext context, View view2, int orientation2, int size) {
        size = (int)((float)size * context.getMetrics().density);
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams)view2.getLayoutParams();
        if (orientation2 == 0) {
            layoutParams.width = size;
        } else {
            layoutParams.height = size;
        }
        view2.setLayoutParams(layoutParams);
    }

    protected int getSidePadding(float sw) {
        if (sw >= 400.0f) {
            return 50;
        }
        if (sw >= 360.0f) {
            return 40;
        }
        return 36;
    }

    private static int getWidth(float sw) {
        if (sw >= 600.0f) {
            return 48;
        }
        if (sw >= 360.0f) {
            return 40;
        }
        return 36;
    }

    private static float getShortestWidth(BridgeContext context) {
        DisplayMetrics metrics = context.getMetrics();
        float sw = metrics.widthPixels < metrics.heightPixels ? (float)metrics.widthPixels : (float)metrics.heightPixels;
        return sw /= metrics.density;
    }

    @Override
    protected TextView getStyleableTextView() {
        return null;
    }
}

