/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class NinePatchInputStream
extends InputStream {
    private final InputStream mDelegate;
    private boolean mFakeMarkSupport = true;
    private final String mPath;

    public NinePatchInputStream(File file2) throws FileNotFoundException {
        this.mDelegate = new FileInputStream(file2);
        this.mPath = file2.getPath();
    }

    public NinePatchInputStream(InputStream stream, String path) {
        this.mDelegate = stream;
        this.mPath = path;
    }

    public String getPath() {
        return this.mPath;
    }

    @Override
    public boolean markSupported() {
        return this.mFakeMarkSupport || this.mDelegate.markSupported();
    }

    public void disableFakeMarkSupport() {
        this.mFakeMarkSupport = false;
    }

    @Override
    public int read() throws IOException {
        return this.mDelegate.read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.mDelegate.read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.mDelegate.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.mDelegate.skip(n);
    }

    @Override
    public int available() throws IOException {
        return this.mDelegate.available();
    }

    @Override
    public void close() throws IOException {
        this.mDelegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.mDelegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.mDelegate.reset();
    }
}

