/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.protobuf;

import com.android.layoutlib.protobuf.MessageInfo;
import com.android.layoutlib.protobuf.MessageLite;
import com.android.layoutlib.protobuf.ProtoSyntax;

final class RawMessageInfo
implements MessageInfo {
    private final MessageLite defaultInstance;
    private final String info;
    private final Object[] objects;
    private final int flags;

    RawMessageInfo(MessageLite defaultInstance, String info, Object[] objects) {
        this.defaultInstance = defaultInstance;
        this.info = info;
        this.objects = objects;
        int position = 0;
        char value2 = info.charAt(position++);
        if (value2 < '\ud800') {
            this.flags = value2;
        } else {
            int result = value2 & 0x1FFF;
            int shift = 13;
            while ((value2 = info.charAt(position++)) >= '\ud800') {
                result |= (value2 & 0x1FFF) << shift;
                shift += 13;
            }
            this.flags = result | value2 << shift;
        }
    }

    String getStringInfo() {
        return this.info;
    }

    Object[] getObjects() {
        return this.objects;
    }

    @Override
    public MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public ProtoSyntax getSyntax() {
        return (this.flags & 1) == 1 ? ProtoSyntax.PROTO2 : ProtoSyntax.PROTO3;
    }

    @Override
    public boolean isMessageSetWireFormat() {
        return (this.flags & 2) == 2;
    }
}

