/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.protobuf;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.Unsafe;

final class UnsafeUtil {
    private static final Logger logger = Logger.getLogger(UnsafeUtil.class.getName());
    private static final Unsafe UNSAFE = UnsafeUtil.getUnsafe();
    private static final MemoryAccessor MEMORY_ACCESSOR = UnsafeUtil.getMemoryAccessor();
    private static final boolean HAS_UNSAFE_BYTEBUFFER_OPERATIONS = UnsafeUtil.supportsUnsafeByteBufferOperations();
    private static final boolean HAS_UNSAFE_ARRAY_OPERATIONS = UnsafeUtil.supportsUnsafeArrayOperations();
    static final long BYTE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(byte[].class);
    private static final long BOOLEAN_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(boolean[].class);
    private static final long BOOLEAN_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(boolean[].class);
    private static final long INT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(int[].class);
    private static final long INT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(int[].class);
    private static final long LONG_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(long[].class);
    private static final long LONG_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(long[].class);
    private static final long FLOAT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(float[].class);
    private static final long FLOAT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(float[].class);
    private static final long DOUBLE_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(double[].class);
    private static final long DOUBLE_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(double[].class);
    private static final long OBJECT_ARRAY_BASE_OFFSET = UnsafeUtil.arrayBaseOffset(Object[].class);
    private static final long OBJECT_ARRAY_INDEX_SCALE = UnsafeUtil.arrayIndexScale(Object[].class);
    private static final long BUFFER_ADDRESS_OFFSET = UnsafeUtil.fieldOffset(UnsafeUtil.bufferAddressField());
    private static final int STRIDE = 8;
    private static final int STRIDE_ALIGNMENT_MASK = 7;
    private static final int BYTE_ARRAY_ALIGNMENT = (int)(BYTE_ARRAY_BASE_OFFSET & 7L);
    static final boolean IS_BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;

    private UnsafeUtil() {
    }

    static boolean hasUnsafeArrayOperations() {
        return HAS_UNSAFE_ARRAY_OPERATIONS;
    }

    static boolean hasUnsafeByteBufferOperations() {
        return HAS_UNSAFE_BYTEBUFFER_OPERATIONS;
    }

    static <T> T allocateInstance(Class<T> clazz) {
        try {
            return (T)UNSAFE.allocateInstance(clazz);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    static long objectFieldOffset(Field field) {
        return MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static int arrayBaseOffset(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayBaseOffset(clazz) : -1;
    }

    private static int arrayIndexScale(Class<?> clazz) {
        return HAS_UNSAFE_ARRAY_OPERATIONS ? MEMORY_ACCESSOR.arrayIndexScale(clazz) : -1;
    }

    static byte getByte(Object target, long offset2) {
        return MEMORY_ACCESSOR.getByte(target, offset2);
    }

    static void putByte(Object target, long offset2, byte value2) {
        MEMORY_ACCESSOR.putByte(target, offset2, value2);
    }

    static int getInt(Object target, long offset2) {
        return MEMORY_ACCESSOR.getInt(target, offset2);
    }

    static void putInt(Object target, long offset2, int value2) {
        MEMORY_ACCESSOR.putInt(target, offset2, value2);
    }

    static long getLong(Object target, long offset2) {
        return MEMORY_ACCESSOR.getLong(target, offset2);
    }

    static void putLong(Object target, long offset2, long value2) {
        MEMORY_ACCESSOR.putLong(target, offset2, value2);
    }

    static boolean getBoolean(Object target, long offset2) {
        return MEMORY_ACCESSOR.getBoolean(target, offset2);
    }

    static void putBoolean(Object target, long offset2, boolean value2) {
        MEMORY_ACCESSOR.putBoolean(target, offset2, value2);
    }

    static float getFloat(Object target, long offset2) {
        return MEMORY_ACCESSOR.getFloat(target, offset2);
    }

    static void putFloat(Object target, long offset2, float value2) {
        MEMORY_ACCESSOR.putFloat(target, offset2, value2);
    }

    static double getDouble(Object target, long offset2) {
        return MEMORY_ACCESSOR.getDouble(target, offset2);
    }

    static void putDouble(Object target, long offset2, double value2) {
        MEMORY_ACCESSOR.putDouble(target, offset2, value2);
    }

    static Object getObject(Object target, long offset2) {
        return MEMORY_ACCESSOR.getObject(target, offset2);
    }

    static void putObject(Object target, long offset2, Object value2) {
        MEMORY_ACCESSOR.putObject(target, offset2, value2);
    }

    static byte getByte(byte[] target, long index) {
        return MEMORY_ACCESSOR.getByte(target, BYTE_ARRAY_BASE_OFFSET + index);
    }

    static void putByte(byte[] target, long index, byte value2) {
        MEMORY_ACCESSOR.putByte(target, BYTE_ARRAY_BASE_OFFSET + index, value2);
    }

    static int getInt(int[] target, long index) {
        return MEMORY_ACCESSOR.getInt(target, INT_ARRAY_BASE_OFFSET + index * INT_ARRAY_INDEX_SCALE);
    }

    static void putInt(int[] target, long index, int value2) {
        MEMORY_ACCESSOR.putInt(target, INT_ARRAY_BASE_OFFSET + index * INT_ARRAY_INDEX_SCALE, value2);
    }

    static long getLong(long[] target, long index) {
        return MEMORY_ACCESSOR.getLong(target, LONG_ARRAY_BASE_OFFSET + index * LONG_ARRAY_INDEX_SCALE);
    }

    static void putLong(long[] target, long index, long value2) {
        MEMORY_ACCESSOR.putLong(target, LONG_ARRAY_BASE_OFFSET + index * LONG_ARRAY_INDEX_SCALE, value2);
    }

    static boolean getBoolean(boolean[] target, long index) {
        return MEMORY_ACCESSOR.getBoolean(target, BOOLEAN_ARRAY_BASE_OFFSET + index * BOOLEAN_ARRAY_INDEX_SCALE);
    }

    static void putBoolean(boolean[] target, long index, boolean value2) {
        MEMORY_ACCESSOR.putBoolean(target, BOOLEAN_ARRAY_BASE_OFFSET + index * BOOLEAN_ARRAY_INDEX_SCALE, value2);
    }

    static float getFloat(float[] target, long index) {
        return MEMORY_ACCESSOR.getFloat(target, FLOAT_ARRAY_BASE_OFFSET + index * FLOAT_ARRAY_INDEX_SCALE);
    }

    static void putFloat(float[] target, long index, float value2) {
        MEMORY_ACCESSOR.putFloat(target, FLOAT_ARRAY_BASE_OFFSET + index * FLOAT_ARRAY_INDEX_SCALE, value2);
    }

    static double getDouble(double[] target, long index) {
        return MEMORY_ACCESSOR.getDouble(target, DOUBLE_ARRAY_BASE_OFFSET + index * DOUBLE_ARRAY_INDEX_SCALE);
    }

    static void putDouble(double[] target, long index, double value2) {
        MEMORY_ACCESSOR.putDouble(target, DOUBLE_ARRAY_BASE_OFFSET + index * DOUBLE_ARRAY_INDEX_SCALE, value2);
    }

    static Object getObject(Object[] target, long index) {
        return MEMORY_ACCESSOR.getObject(target, OBJECT_ARRAY_BASE_OFFSET + index * OBJECT_ARRAY_INDEX_SCALE);
    }

    static void putObject(Object[] target, long index, Object value2) {
        MEMORY_ACCESSOR.putObject(target, OBJECT_ARRAY_BASE_OFFSET + index * OBJECT_ARRAY_INDEX_SCALE, value2);
    }

    static void copyMemory(byte[] src, long srcIndex, long targetOffset, long length) {
        MEMORY_ACCESSOR.copyMemory(src, srcIndex, targetOffset, length);
    }

    static void copyMemory(long srcOffset, byte[] target, long targetIndex, long length) {
        MEMORY_ACCESSOR.copyMemory(srcOffset, target, targetIndex, length);
    }

    static void copyMemory(byte[] src, long srcIndex, byte[] target, long targetIndex, long length) {
        System.arraycopy(src, (int)srcIndex, target, (int)targetIndex, (int)length);
    }

    static byte getByte(long address) {
        return MEMORY_ACCESSOR.getByte(address);
    }

    static void putByte(long address, byte value2) {
        MEMORY_ACCESSOR.putByte(address, value2);
    }

    static int getInt(long address) {
        return MEMORY_ACCESSOR.getInt(address);
    }

    static void putInt(long address, int value2) {
        MEMORY_ACCESSOR.putInt(address, value2);
    }

    static long getLong(long address) {
        return MEMORY_ACCESSOR.getLong(address);
    }

    static void putLong(long address, long value2) {
        MEMORY_ACCESSOR.putLong(address, value2);
    }

    static long addressOffset(ByteBuffer buffer) {
        return MEMORY_ACCESSOR.getLong(buffer, BUFFER_ADDRESS_OFFSET);
    }

    static Object getStaticObject(Field field) {
        return MEMORY_ACCESSOR.getStaticObject(field);
    }

    static Unsafe getUnsafe() {
        Unsafe unsafe = null;
        try {
            unsafe = AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                @Override
                public Unsafe run() throws Exception {
                    Class<Unsafe> k = Unsafe.class;
                    for (Field f : k.getDeclaredFields()) {
                        f.setAccessible(true);
                        Object x = f.get(null);
                        if (!k.isInstance(x)) continue;
                        return (Unsafe)k.cast(x);
                    }
                    return null;
                }
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return unsafe;
    }

    private static MemoryAccessor getMemoryAccessor() {
        if (UNSAFE == null) {
            return null;
        }
        return new JvmMemoryAccessor(UNSAFE);
    }

    private static boolean supportsUnsafeArrayOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("arrayBaseOffset", Class.class);
            clazz.getMethod("arrayIndexScale", Class.class);
            clazz.getMethod("getInt", Object.class, Long.TYPE);
            clazz.getMethod("putInt", Object.class, Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            clazz.getMethod("putLong", Object.class, Long.TYPE, Long.TYPE);
            clazz.getMethod("getObject", Object.class, Long.TYPE);
            clazz.getMethod("putObject", Object.class, Long.TYPE, Object.class);
            clazz.getMethod("getByte", Object.class, Long.TYPE);
            clazz.getMethod("putByte", Object.class, Long.TYPE, Byte.TYPE);
            clazz.getMethod("getBoolean", Object.class, Long.TYPE);
            clazz.getMethod("putBoolean", Object.class, Long.TYPE, Boolean.TYPE);
            clazz.getMethod("getFloat", Object.class, Long.TYPE);
            clazz.getMethod("putFloat", Object.class, Long.TYPE, Float.TYPE);
            clazz.getMethod("getDouble", Object.class, Long.TYPE);
            clazz.getMethod("putDouble", Object.class, Long.TYPE, Double.TYPE);
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + e);
            return false;
        }
    }

    private static boolean supportsUnsafeByteBufferOperations() {
        if (UNSAFE == null) {
            return false;
        }
        try {
            Class<?> clazz = UNSAFE.getClass();
            clazz.getMethod("objectFieldOffset", Field.class);
            clazz.getMethod("getLong", Object.class, Long.TYPE);
            if (UnsafeUtil.bufferAddressField() == null) {
                return false;
            }
            clazz.getMethod("getByte", Long.TYPE);
            clazz.getMethod("putByte", Long.TYPE, Byte.TYPE);
            clazz.getMethod("getInt", Long.TYPE);
            clazz.getMethod("putInt", Long.TYPE, Integer.TYPE);
            clazz.getMethod("getLong", Long.TYPE);
            clazz.getMethod("putLong", Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Long.TYPE, Long.TYPE, Long.TYPE);
            clazz.getMethod("copyMemory", Object.class, Long.TYPE, Object.class, Long.TYPE, Long.TYPE);
            return true;
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "platform method missing - proto runtime falling back to safer methods: " + e);
            return false;
        }
    }

    private static Field bufferAddressField() {
        Field field = UnsafeUtil.field(Buffer.class, "address");
        return field != null && field.getType() == Long.TYPE ? field : null;
    }

    private static int firstDifferingByteIndexNativeEndian(long left, long right2) {
        int n = IS_BIG_ENDIAN ? Long.numberOfLeadingZeros(left ^ right2) : Long.numberOfTrailingZeros(left ^ right2);
        return n >> 3;
    }

    static int mismatch(byte[] left, int leftOff, byte[] right2, int rightOff, int length) {
        if (leftOff < 0 || rightOff < 0 || length < 0 || leftOff + length > left.length || rightOff + length > right2.length) {
            throw new IndexOutOfBoundsException();
        }
        int index = 0;
        if (HAS_UNSAFE_ARRAY_OPERATIONS) {
            int leftAlignment = BYTE_ARRAY_ALIGNMENT + leftOff & 7;
            while (index < length && (leftAlignment & 7) != 0) {
                if (left[leftOff + index] != right2[rightOff + index]) {
                    return index;
                }
                ++index;
                ++leftAlignment;
            }
            int strideLength = (length - index & 0xFFFFFFF8) + index;
            while (index < strideLength) {
                long rightLongWord;
                long leftLongWord = UnsafeUtil.getLong((Object)left, BYTE_ARRAY_BASE_OFFSET + (long)leftOff + (long)index);
                if (leftLongWord != (rightLongWord = UnsafeUtil.getLong((Object)right2, BYTE_ARRAY_BASE_OFFSET + (long)rightOff + (long)index))) {
                    return index + UnsafeUtil.firstDifferingByteIndexNativeEndian(leftLongWord, rightLongWord);
                }
                index += 8;
            }
        }
        while (index < length) {
            if (left[leftOff + index] != right2[rightOff + index]) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    private static long fieldOffset(Field field) {
        return field == null || MEMORY_ACCESSOR == null ? -1L : MEMORY_ACCESSOR.objectFieldOffset(field);
    }

    private static Field field(Class<?> clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (Throwable t) {
            field = null;
        }
        return field;
    }

    private static final class JvmMemoryAccessor
    extends MemoryAccessor {
        JvmMemoryAccessor(Unsafe unsafe) {
            super(unsafe);
        }

        @Override
        public byte getByte(long address) {
            return this.unsafe.getByte(address);
        }

        @Override
        public void putByte(long address, byte value2) {
            this.unsafe.putByte(address, value2);
        }

        @Override
        public int getInt(long address) {
            return this.unsafe.getInt(address);
        }

        @Override
        public void putInt(long address, int value2) {
            this.unsafe.putInt(address, value2);
        }

        @Override
        public long getLong(long address) {
            return this.unsafe.getLong(address);
        }

        @Override
        public void putLong(long address, long value2) {
            this.unsafe.putLong(address, value2);
        }

        @Override
        public byte getByte(Object target, long offset2) {
            return this.unsafe.getByte(target, offset2);
        }

        @Override
        public void putByte(Object target, long offset2, byte value2) {
            this.unsafe.putByte(target, offset2, value2);
        }

        @Override
        public boolean getBoolean(Object target, long offset2) {
            return this.unsafe.getBoolean(target, offset2);
        }

        @Override
        public void putBoolean(Object target, long offset2, boolean value2) {
            this.unsafe.putBoolean(target, offset2, value2);
        }

        @Override
        public float getFloat(Object target, long offset2) {
            return this.unsafe.getFloat(target, offset2);
        }

        @Override
        public void putFloat(Object target, long offset2, float value2) {
            this.unsafe.putFloat(target, offset2, value2);
        }

        @Override
        public double getDouble(Object target, long offset2) {
            return this.unsafe.getDouble(target, offset2);
        }

        @Override
        public void putDouble(Object target, long offset2, double value2) {
            this.unsafe.putDouble(target, offset2, value2);
        }

        @Override
        public void copyMemory(long srcOffset, byte[] target, long targetIndex, long length) {
            this.unsafe.copyMemory(null, srcOffset, target, BYTE_ARRAY_BASE_OFFSET + targetIndex, length);
        }

        @Override
        public void copyMemory(byte[] src, long srcIndex, long targetOffset, long length) {
            this.unsafe.copyMemory(src, BYTE_ARRAY_BASE_OFFSET + srcIndex, null, targetOffset, length);
        }

        @Override
        public Object getStaticObject(Field field) {
            return this.getObject(this.unsafe.staticFieldBase(field), this.unsafe.staticFieldOffset(field));
        }
    }

    private static abstract class MemoryAccessor {
        Unsafe unsafe;

        MemoryAccessor(Unsafe unsafe) {
            this.unsafe = unsafe;
        }

        public final long objectFieldOffset(Field field) {
            return this.unsafe.objectFieldOffset(field);
        }

        public abstract byte getByte(Object var1, long var2);

        public abstract void putByte(Object var1, long var2, byte var4);

        public final int getInt(Object target, long offset2) {
            return this.unsafe.getInt(target, offset2);
        }

        public final void putInt(Object target, long offset2, int value2) {
            this.unsafe.putInt(target, offset2, value2);
        }

        public final long getLong(Object target, long offset2) {
            return this.unsafe.getLong(target, offset2);
        }

        public final void putLong(Object target, long offset2, long value2) {
            this.unsafe.putLong(target, offset2, value2);
        }

        public abstract boolean getBoolean(Object var1, long var2);

        public abstract void putBoolean(Object var1, long var2, boolean var4);

        public abstract float getFloat(Object var1, long var2);

        public abstract void putFloat(Object var1, long var2, float var4);

        public abstract double getDouble(Object var1, long var2);

        public abstract void putDouble(Object var1, long var2, double var4);

        public final Object getObject(Object target, long offset2) {
            return this.unsafe.getObject(target, offset2);
        }

        public final void putObject(Object target, long offset2, Object value2) {
            this.unsafe.putObject(target, offset2, value2);
        }

        public final int arrayBaseOffset(Class<?> clazz) {
            return this.unsafe.arrayBaseOffset(clazz);
        }

        public final int arrayIndexScale(Class<?> clazz) {
            return this.unsafe.arrayIndexScale(clazz);
        }

        public abstract byte getByte(long var1);

        public abstract void putByte(long var1, byte var3);

        public abstract int getInt(long var1);

        public abstract void putInt(long var1, int var3);

        public abstract long getLong(long var1);

        public abstract void putLong(long var1, long var3);

        public abstract Object getStaticObject(Field var1);

        public abstract void copyMemory(long var1, byte[] var3, long var4, long var6);

        public abstract void copyMemory(byte[] var1, long var2, long var4, long var6);
    }
}

