/*
 * Decompiled with CFR 0.152.
 */
package com.android.telephony;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Rlog {
    private static final boolean USER_BUILD = TelephonyUtils.IS_USER;

    private Rlog() {
    }

    private static int log(int priority, String tag2, String msg) {
        return Log.logToRadioBuffer(priority, tag2, msg);
    }

    public static int v(String tag2, String msg) {
        return Rlog.log(2, tag2, msg);
    }

    public static int v(String tag2, String msg, Throwable tr) {
        return Rlog.log(2, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int d(String tag2, String msg) {
        return Rlog.log(3, tag2, msg);
    }

    public static int d(String tag2, String msg, Throwable tr) {
        return Rlog.log(3, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int i(String tag2, String msg) {
        return Rlog.log(4, tag2, msg);
    }

    public static int i(String tag2, String msg, Throwable tr) {
        return Rlog.log(4, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag2, String msg) {
        return Rlog.log(5, tag2, msg);
    }

    public static int w(String tag2, String msg, Throwable tr) {
        return Rlog.log(5, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag2, Throwable tr) {
        return Rlog.log(5, tag2, Log.getStackTraceString(tr));
    }

    public static int e(String tag2, String msg) {
        return Rlog.log(6, tag2, msg);
    }

    public static int e(String tag2, String msg, Throwable tr) {
        return Rlog.log(6, tag2, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int println(int priority, String tag2, String msg) {
        return Rlog.log(priority, tag2, msg);
    }

    public static boolean isLoggable(String tag2, int level) {
        return Log.isLoggable(tag2, level);
    }

    public static String pii(String tag2, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || Rlog.isLoggable(tag2, 2)) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    public static String pii(boolean enablePiiLogging, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || enablePiiLogging) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    private static String secureHash(byte[] input) {
        MessageDigest messageDigest;
        if (USER_BUILD) {
            return "****";
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return "####";
        }
        byte[] result = messageDigest.digest(input);
        return Base64.encodeToString(result, 11);
    }
}

