/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\tH\u0016J\u0013\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/common/actions/BufferedImageTransferable;", "Ljava/awt/datatransfer/Transferable;", "image", "Ljava/awt/image/BufferedImage;", "(Ljava/awt/image/BufferedImage;)V", "getImage", "()Ljava/awt/image/BufferedImage;", "getTransferData", "flavor", "Ljava/awt/datatransfer/DataFlavor;", "getTransferDataFlavors", "", "()[Ljava/awt/datatransfer/DataFlavor;", "isDataFlavorSupported", "", "intellij.android.designer"})
final class BufferedImageTransferable
implements Transferable {
    @NotNull
    private final BufferedImage image;

    public BufferedImageTransferable(@NotNull BufferedImage image) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        this.image = image;
    }

    @NotNull
    public final BufferedImage getImage() {
        return this.image;
    }

    @Override
    @NotNull
    public BufferedImage getTransferData(@NotNull DataFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        if (!Intrinsics.areEqual((Object)flavor, (Object)DataFlavor.imageFlavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.image;
    }

    @Override
    @NotNull
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] dataFlavorArray = new DataFlavor[1];
        Intrinsics.checkNotNullExpressionValue((Object)DataFlavor.imageFlavor, (String)"imageFlavor");
        return dataFlavorArray;
    }

    @Override
    public boolean isDataFlavorSupported(@NotNull DataFlavor flavor) {
        Intrinsics.checkNotNullParameter((Object)flavor, (String)"flavor");
        return ArraysKt.contains((Object[])this.getTransferDataFlavors(), (Object)flavor);
    }
}

