/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.PsiNavigateUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoComponentAction
extends DumbAwareAction {
    @NotNull
    private final DesignSurface<?> mySurface;

    public GotoComponentAction(@NotNull DesignSurface<?> surface2) {
        if (surface2 == null) {
            GotoComponentAction.$$$reportNull$$$0(0);
        }
        super("Go to XML");
        this.mySurface = surface2;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        ImmutableList<NlComponent> components;
        DesignToolsSplitEditor splitEditor;
        InputEvent inputEvent;
        if (e == null) {
            GotoComponentAction.$$$reportNull$$$0(1);
        }
        if ((inputEvent = e.getInputEvent()) instanceof MouseEvent && (this.mySurface.getGuiInputHandler().interceptPanInteraction((MouseEvent)inputEvent) || AdtUiUtils.isActionKeyDown((InputEvent)inputEvent))) {
            return;
        }
        FileEditor selectedEditor = FileEditorManager.getInstance((Project)this.mySurface.getProject()).getSelectedEditor();
        if (selectedEditor instanceof DesignToolsSplitEditor && (splitEditor = (DesignToolsSplitEditor)selectedEditor).isDesignMode()) {
            splitEditor.selectTextMode(false);
        }
        SelectionModel selectionModel = this.mySurface.getSelectionModel();
        NlComponent primary = selectionModel.getPrimary();
        NlModel model2 = this.mySurface.getModel();
        NlComponent componentToNavigate = null;
        if (primary != null) {
            componentToNavigate = primary;
        } else if (!selectionModel.getSelection().isEmpty()) {
            componentToNavigate = selectionModel.getSelection().get(0);
        } else if (model2 != null && !(components = model2.getComponents()).isEmpty()) {
            componentToNavigate = (NlComponent)components.get(0);
        }
        this.mySurface.deactivate();
        if (model2 != null && !GotoComponentAction.navigateToXml(componentToNavigate)) {
            this.switchTab(model2);
        }
    }

    private static boolean navigateToXml(@Nullable NlComponent component2) {
        if (component2 == null) {
            return false;
        }
        XmlTag tag2 = component2.getTag();
        if (tag2 == null) {
            return false;
        }
        PsiNavigateUtil.navigate((PsiElement)tag2);
        return true;
    }

    private void switchTab(@NotNull NlModel model2) {
        if (model2 == null) {
            GotoComponentAction.$$$reportNull$$$0(2);
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)this.mySurface.getProject());
        editorManager.openTextEditor(new OpenFileDescriptor(model2.getProject(), model2.getVirtualFile(), 0), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/common/actions/GotoComponentAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "switchTab";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

