/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.error.IssuePanelServiceKt;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.NlSupportedActionsKt;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintService;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final String DEFAULT_TOOLTIP = "Toggle visibility of issue panel";
    @VisibleForTesting
    public static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR_INLINE);

    @NotNull
    protected Pair<Icon, String> getNoErrorsIconAndDescription(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(0);
        }
        return new Pair(null, null);
    }

    @NotNull
    public static IssueNotificationAction getInstance() {
        IssueNotificationAction issueNotificationAction = (IssueNotificationAction)ActionManager.getInstance().getAction("Android.Designer.IssueNotificationAction");
        if (issueNotificationAction == null) {
            IssueNotificationAction.$$$reportNull$$$0(1);
        }
        return issueNotificationAction;
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            IssueNotificationAction.$$$reportNull$$$0(2);
        }
        if (DesignerActionUtils.isActionEventFromJTextField(event)) {
            event.getPresentation().setEnabled(false);
            return;
        }
        super.update(event);
        DesignSurface surface2 = (DesignSurface)event.getData(DesignerDataKeys.DESIGN_SURFACE);
        Presentation presentation = event.getPresentation();
        if (surface2 == null || !NlSupportedActionsKt.isActionSupported(surface2, NlSupportedActions.TOGGLE_ISSUE_PANEL)) {
            event.getPresentation().setEnabled(false);
            presentation.setText(SHOW_ISSUE);
            presentation.setDescription(DEFAULT_TOOLTIP);
            presentation.setIcon(DISABLED_ICON);
        } else {
            event.getPresentation().setEnabled(true);
            IssueModel issueModel = surface2.getIssueModel();
            int markerCount = issueModel.getIssueCount();
            VisualLintService service = VisualLintService.getInstance((Project)event.getRequiredData(PlatformDataKeys.PROJECT));
            List<VirtualFile> files = surface2.getModels().stream().map(NlModel::getVirtualFile).toList();
            Set<Issue> visualLintIssues = service.getIssueModel().getIssues().stream().filter(it -> files.contains(it.getSource().getFile())).collect(Collectors.toSet());
            presentation.setDescription((markerCount += visualLintIssues.size()) == 0 ? NO_ISSUE : SHOW_ISSUE);
            if (markerCount == 0) {
                Pair<Icon, String> iconAndDescription = this.getNoErrorsIconAndDescription(event);
                if (iconAndDescription.getSecond() != null) {
                    presentation.setText((String)iconAndDescription.getSecond());
                }
                if (iconAndDescription.getFirst() == null) {
                    presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel, visualLintIssues));
                } else {
                    presentation.setIcon((Icon)iconAndDescription.getFirst());
                }
            } else {
                presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel, visualLintIssues));
                presentation.setText(DEFAULT_TOOLTIP);
            }
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        DesignSurface surface2;
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(3);
        }
        if ((surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE)) == null) {
            return false;
        }
        return IssuePanelService.getInstance(surface2.getProject()).isIssuePanelVisible(surface2);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        DesignSurface surface2;
        if (e == null) {
            IssueNotificationAction.$$$reportNull$$$0(4);
        }
        if ((surface2 = (DesignSurface)e.getData(DesignerDataKeys.DESIGN_SURFACE)) == null) {
            return;
        }
        IssuePanelServiceKt.setIssuePanelVisibility(surface2, state, true, () -> {
            Project project;
            if (((Boolean)StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()).booleanValue() && (project = (Project)e.getData(PlatformDataKeys.PROJECT)) != null) {
                IssuePanelService.getInstance(project).focusIssuePanelIfVisible();
            }
        });
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel, @NotNull Set<Issue> visualLintIssues) {
        if (issueModel == null) {
            IssueNotificationAction.$$$reportNull$$$0(5);
        }
        if (visualLintIssues == null) {
            IssueNotificationAction.$$$reportNull$$$0(6);
        }
        Set visualLintSeverities = visualLintIssues.stream().map(Issue::getSeverity).collect(Collectors.toSet());
        Icon icon2 = issueModel.getErrorCount() > 0 || visualLintSeverities.contains(HighlightSeverity.ERROR) ? StudioIcons.Common.ERROR_INLINE : (issueModel.getWarningCount() > 0 || visualLintSeverities.contains(HighlightSeverity.WARNING) ? StudioIcons.Common.WARNING_INLINE : (issueModel.getIssueCount() > 0 || !visualLintSeverities.isEmpty() ? StudioIcons.Common.INFO_INLINE : DISABLED_ICON));
        Icon icon3 = icon2;
        if (icon3 == null) {
            IssueNotificationAction.$$$reportNull$$$0(7);
        }
        return icon3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "issueModel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visualLintIssues";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/actions/IssueNotificationAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getIssueTypeIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNoErrorsIconAndDescription";
                break;
            }
            case 1: 
            case 7: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setSelected";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getIssueTypeIcon";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 7 -> new IllegalStateException(string2);
        };
    }
}

