/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.analytics.CommonUsageTrackerKt;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.rendering.RenderContext;
import com.android.tools.idea.rendering.RenderErrorModelFactory;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.errors.ui.RenderErrorModel;
import com.android.tools.idea.ui.designer.EditorDesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorRenderResult;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.Random;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommonUsageTrackerImpl
implements CommonUsageTracker {
    private static final Random sRandom = new Random();
    private static final String CUSTOM_AVD_ID = "_custom_avd";
    private final Executor myExecutor;
    private final WeakReference<DesignSurface<?>> myDesignSurfaceRef;
    private final Consumer<AndroidStudioEvent.Builder> myEventLogger;

    public CommonUsageTrackerImpl(@NotNull Executor executor, @Nullable DesignSurface<?> surface2, @NotNull Consumer<AndroidStudioEvent.Builder> eventLogger) {
        if (executor == null) {
            CommonUsageTrackerImpl.$$$reportNull$$$0(0);
        }
        if (eventLogger == null) {
            CommonUsageTrackerImpl.$$$reportNull$$$0(1);
        }
        this.myExecutor = executor;
        this.myDesignSurfaceRef = new WeakReference(surface2);
        this.myEventLogger = eventLogger;
    }

    @NotNull
    static LayoutEditorState getState(@Nullable DesignSurface<?> surface2) {
        Configuration configuration;
        LayoutEditorState.Builder builder2 = LayoutEditorState.newBuilder();
        if (surface2 == null) {
            LayoutEditorState layoutEditorState = builder2.build();
            if (layoutEditorState == null) {
                CommonUsageTrackerImpl.$$$reportNull$$$0(2);
            }
            return layoutEditorState;
        }
        double scale = surface2.getScale();
        if (SystemInfo.isMac && UIUtil.isRetina()) {
            scale *= 2.0;
        }
        if ((configuration = surface2.getConfiguration()) != null) {
            State deviceState = configuration.getDeviceState();
            if (deviceState != null) {
                switch (deviceState.getOrientation()) {
                    case PORTRAIT: {
                        builder2.setConfigOrientation(LayoutEditorState.Orientation.PORTRAIT);
                        break;
                    }
                    case LANDSCAPE: {
                        builder2.setConfigOrientation(LayoutEditorState.Orientation.LANDSCAPE);
                        break;
                    }
                }
            }
            if (configuration.getTarget() != null) {
                builder2.setConfigApiLevel(configuration.getTarget().getVersion().getApiString());
            }
        }
        if (scale >= 0.0) {
            builder2.setConfigZoomLevel((int)(scale * 100.0));
        }
        LayoutEditorState layoutEditorState = builder2.setType(surface2.getAnalyticsManager().getLayoutType()).setMode(surface2.getAnalyticsManager().getEditorMode()).setSurfaces(surface2.getAnalyticsManager().getSurfaceType()).build();
        if (layoutEditorState == null) {
            CommonUsageTrackerImpl.$$$reportNull$$$0(3);
        }
        return layoutEditorState;
    }

    @VisibleForTesting
    boolean shouldLog(int percentage) {
        return sRandom.nextInt(100) >= 100 - percentage - 1;
    }

    @Override
    public void logStudioEvent(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType, @Nullable Consumer<LayoutEditorEvent.Builder> consumer) {
        if (eventType == null) {
            CommonUsageTrackerImpl.$$$reportNull$$$0(4);
        }
        try {
            this.myExecutor.execute(() -> {
                LayoutEditorEvent.Builder builder2 = LayoutEditorEvent.newBuilder().setType(eventType).setState(CommonUsageTrackerImpl.getState((DesignSurface)this.myDesignSurfaceRef.get()));
                if (consumer != null) {
                    consumer.accept(builder2);
                }
                AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.LAYOUT_EDITOR).setKind(AndroidStudioEvent.EventKind.LAYOUT_EDITOR_EVENT).setLayoutEditorEvent(builder2.build());
                CommonUsageTrackerKt.setApplicationId(studioEvent, (DesignSurface)this.myDesignSurfaceRef.get());
                this.myEventLogger.accept(studioEvent);
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
    }

    @Override
    public void logAction(@NotNull LayoutEditorEvent.LayoutEditorEventType eventType) {
        if (eventType == null) {
            CommonUsageTrackerImpl.$$$reportNull$$$0(5);
        }
        assert (!LayoutEditorEvent.LayoutEditorEventType.RENDER.equals((Object)eventType)) : "RENDER actions should be logged through logRenderResult";
        assert (!LayoutEditorEvent.LayoutEditorEventType.DROP_VIEW_FROM_PALETTE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logDropFromPalette";
        assert (!LayoutEditorEvent.LayoutEditorEventType.ATTRIBUTE_CHANGE.equals((Object)eventType)) : "DROP_VIEW_FROM_PALETTE actions should be logged through logPropertyChange";
        assert (!LayoutEditorEvent.LayoutEditorEventType.FAVORITE_CHANGE.equals((Object)eventType)) : "FAVORITE_CHANGE actions should be logged through logFavoritesChange";
        this.logStudioEvent(eventType, null);
    }

    @Override
    public void logRenderResult(@Nullable LayoutEditorRenderResult.Trigger trigger, @NotNull RenderResult result, @NotNull CommonUsageTracker.RenderResultType type) {
        if (result == null) {
            CommonUsageTrackerImpl.$$$reportNull$$$0(6);
        }
        if (type == null) {
            CommonUsageTrackerImpl.$$$reportNull$$$0(7);
        }
        if (!this.shouldLog(type.getLogPercent())) {
            return;
        }
        this.logStudioEvent(type.getLoggingType(), event -> {
            Device device;
            RenderContext context;
            LayoutEditorRenderResult.Builder builder2 = LayoutEditorRenderResult.newBuilder().setResultCode(result.getRenderResult().getStatus().ordinal()).setTotalRenderTimeMs(type.getDurationProvider().apply(result));
            if (trigger != null) {
                builder2.setTrigger(trigger);
            }
            builder2.setComponentCount((int)result.getRootViews().stream().flatMap(s -> Stream.concat(s.getChildren().stream(), Stream.of(s))).count());
            RenderErrorModel errorModel = RenderErrorModelFactory.createErrorModel((EditorDesignSurface)((EditorDesignSurface)this.myDesignSurfaceRef.get()), (RenderResult)result, null);
            builder2.setTotalIssueCount(errorModel.getIssues().size());
            if (!errorModel.getIssues().isEmpty()) {
                int errorCount = 0;
                int fidelityWarningCount = 0;
                for (RenderErrorModel.Issue issue : errorModel.getIssues()) {
                    if (HighlightSeverity.ERROR.getName().equals(issue.getSeverity().getName())) {
                        ++errorCount;
                        continue;
                    }
                    if (!issue.getSummary().startsWith("Layout fid")) continue;
                    ++fidelityWarningCount;
                }
                builder2.setErrorCount(errorCount).setFidelityWarningCount(fidelityWarningCount);
            }
            if ((context = result.getRenderContext()) != null && (device = context.getConfiguration().getDevice()) != null) {
                if (ConfigurationManager.isAvdDevice((Device)device)) {
                    builder2.setDeviceId(CUSTOM_AVD_ID);
                } else {
                    builder2.setDeviceId(device.getId());
                }
            }
            event.setRenderResult(builder2.build());
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventLogger";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/analytics/CommonUsageTrackerImpl";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/analytics/CommonUsageTrackerImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "logStudioEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "logAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "logRenderResult";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3 -> new IllegalStateException(string2);
        };
    }
}

