/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.dom.attrs.AttributeDefinition;
import com.android.tools.dom.attrs.AttributeDefinitions;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidAttribute;
import com.google.wireless.android.sdk.stats.AndroidView;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UsageTrackerUtil {
    @VisibleForTesting
    public static final String CUSTOM_NAME = "CUSTOM";

    private UsageTrackerUtil() {
    }

    @NotNull
    public static AndroidAttribute convertAttribute(@NotNull String attributeName, @NotNull AndroidFacet facet) {
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(0);
        }
        if (facet == null) {
            UsageTrackerUtil.$$$reportNull$$$0(1);
        }
        AndroidAttribute.AttributeNamespace namespace = null;
        if (attributeName.startsWith("tools:")) {
            namespace = AndroidAttribute.AttributeNamespace.TOOLS;
            attributeName = StringUtil.trimStart((String)attributeName, (String)"tools:");
        }
        NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
        if (namespace == null) {
            namespace = lookup.getNamespace();
        }
        AndroidAttribute androidAttribute = AndroidAttribute.newBuilder().setAttributeName(UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet)).setAttributeNamespace(namespace).build();
        if (androidAttribute == null) {
            UsageTrackerUtil.$$$reportNull$$$0(2);
        }
        return androidAttribute;
    }

    @NotNull
    public static AndroidAttribute.AttributeNamespace convertNamespace(@Nullable String namespace) {
        if (StringUtil.isEmpty((String)namespace)) {
            AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.ANDROID;
            if (attributeNamespace == null) {
                UsageTrackerUtil.$$$reportNull$$$0(3);
            }
            return attributeNamespace;
        }
        switch (namespace) {
            case "http://schemas.android.com/tools": {
                AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.TOOLS;
                if (attributeNamespace == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(4);
                }
                return attributeNamespace;
            }
            case "http://schemas.android.com/apk/res/android": {
                AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.ANDROID;
                if (attributeNamespace == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(5);
                }
                return attributeNamespace;
            }
        }
        AndroidAttribute.AttributeNamespace attributeNamespace = AndroidAttribute.AttributeNamespace.APPLICATION;
        if (attributeNamespace == null) {
            UsageTrackerUtil.$$$reportNull$$$0(6);
        }
        return attributeNamespace;
    }

    @NotNull
    public static String convertAttributeName(@NotNull String attributeName, @NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName, @NotNull AndroidFacet facet) {
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(7);
        }
        if (namespace == null) {
            UsageTrackerUtil.$$$reportNull$$$0(8);
        }
        if (facet == null) {
            UsageTrackerUtil.$$$reportNull$$$0(9);
        }
        switch (namespace) {
            case ANDROID: {
                String string2 = attributeName;
                if (string2 == null) {
                    UsageTrackerUtil.$$$reportNull$$$0(10);
                }
                return string2;
            }
            case APPLICATION: {
                return libraryName != null && UsageTrackerUtil.acceptedGoogleLibraryNamespace(libraryName) ? attributeName : CUSTOM_NAME;
            }
            case TOOLS: {
                NamespaceAndLibraryNamePair lookup = UsageTrackerUtil.lookupAttributeResource(facet, attributeName);
                assert (lookup.getNamespace() != AndroidAttribute.AttributeNamespace.TOOLS);
                return UsageTrackerUtil.convertAttributeName(attributeName, lookup.getNamespace(), lookup.getLibraryName(), facet);
            }
        }
        return CUSTOM_NAME;
    }

    @NotNull
    public static AndroidView convertTagName(@NotNull String tagName) {
        if (tagName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(11);
        }
        tagName = UsageTrackerUtil.acceptedGoogleTagNamespace(tagName) ? StringUtil.getShortName((String)tagName, (char)'.') : CUSTOM_NAME;
        AndroidView androidView = AndroidView.newBuilder().setTagName(tagName).build();
        if (androidView == null) {
            UsageTrackerUtil.$$$reportNull$$$0(12);
        }
        return androidView;
    }

    @VisibleForTesting
    static boolean acceptedGoogleLibraryNamespace(@NotNull String libraryName) {
        if (libraryName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(13);
        }
        return libraryName.startsWith("com.android.") || libraryName.startsWith("com.google.") || libraryName.startsWith("constraint-layout") || libraryName.startsWith("flexbox") || libraryName.startsWith("design-") || libraryName.startsWith("appcompat-v7-") || libraryName.startsWith("cardview-v7-") || libraryName.startsWith("gridlayout-v7") || libraryName.startsWith("recyclerview-v7") || libraryName.startsWith("coordinatorlayout-v7") || libraryName.startsWith("play-services-maps-") || libraryName.startsWith("play-services-ads-") || libraryName.startsWith("leanback-v17-");
    }

    @VisibleForTesting
    static boolean acceptedGoogleTagNamespace(@NotNull String fullyQualifiedTagName) {
        if (fullyQualifiedTagName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(14);
        }
        return fullyQualifiedTagName.indexOf(46) < 0 || fullyQualifiedTagName.startsWith("com.android.") || fullyQualifiedTagName.startsWith("com.google.") || fullyQualifiedTagName.startsWith("android.support.") || fullyQualifiedTagName.startsWith("android.databinding.");
    }

    @NotNull
    @VisibleForTesting
    static NamespaceAndLibraryNamePair lookupAttributeResource(@NotNull AndroidFacet facet, @NotNull String attributeName) {
        ModuleResourceManagers resourceManagers;
        FrameworkResourceManager frameworkResourceManager;
        if (facet == null) {
            UsageTrackerUtil.$$$reportNull$$$0(15);
        }
        if (attributeName == null) {
            UsageTrackerUtil.$$$reportNull$$$0(16);
        }
        if ((frameworkResourceManager = (resourceManagers = ModuleResourceManagers.getInstance((AndroidFacet)facet)).getFrameworkResourceManager()) == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        AttributeDefinitions localAttributeDefinitions = localResourceManager.getAttributeDefinitions();
        AttributeDefinitions systemAttributeDefinitions = frameworkResourceManager.getAttributeDefinitions();
        if (systemAttributeDefinitions != null && systemAttributeDefinitions.getAttrs().contains(ResourceReference.attr((ResourceNamespace)ResourceNamespace.ANDROID, (String)attributeName))) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.ANDROID);
        }
        if (localAttributeDefinitions == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        AttributeDefinition definition = localAttributeDefinitions.getAttrDefinition(ResourceReference.attr((ResourceNamespace)ResourceNamespace.TODO(), (String)attributeName));
        if (definition == null) {
            return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION);
        }
        return new NamespaceAndLibraryNamePair(AndroidAttribute.AttributeNamespace.APPLICATION, definition.getLibraryName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 10, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 1: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/analytics/UsageTrackerUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fullyQualifiedTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/analytics/UsageTrackerUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttribute";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "convertNamespace";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAttributeName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "convertTagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "convertAttribute";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 12: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "convertAttributeName";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "convertTagName";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "acceptedGoogleLibraryNamespace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "acceptedGoogleTagNamespace";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lookupAttributeResource";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5, 6, 10, 12 -> new IllegalStateException(string2);
        };
    }

    @VisibleForTesting
    static class NamespaceAndLibraryNamePair {
        private final AndroidAttribute.AttributeNamespace myNamespace;
        private final String myLibraryName;

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace) {
            if (namespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(0);
            }
            this(namespace, null);
        }

        @VisibleForTesting
        NamespaceAndLibraryNamePair(@NotNull AndroidAttribute.AttributeNamespace namespace, @Nullable String libraryName) {
            if (namespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(1);
            }
            this.myNamespace = namespace;
            this.myLibraryName = libraryName;
        }

        @NotNull
        public AndroidAttribute.AttributeNamespace getNamespace() {
            AndroidAttribute.AttributeNamespace attributeNamespace = this.myNamespace;
            if (attributeNamespace == null) {
                NamespaceAndLibraryNamePair.$$$reportNull$$$0(2);
            }
            return attributeNamespace;
        }

        @Nullable
        public String getLibraryName() {
            return this.myLibraryName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/android/tools/idea/common/analytics/UsageTrackerUtil$NamespaceAndLibraryNamePair";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/android/tools/idea/common/analytics/UsageTrackerUtil$NamespaceAndLibraryNamePair";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string2);
                case 2 -> new IllegalStateException(string2);
            };
        }
    }
}

