/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.editor.SplitEditorPreviewNotificationHandler;
import com.android.tools.idea.common.lint.BackgroundEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditor
extends UserDataHolderBase
implements FileEditor,
SplitEditorPreviewNotificationHandler {
    protected final Project myProject;
    protected final VirtualFile myFile;
    private DesignerEditorPanel myEditorPanel;
    private BackgroundEditorHighlighter myBackgroundHighlighter;

    public DesignerEditor(@NotNull VirtualFile file2, @NotNull Project project) {
        if (file2 == null) {
            DesignerEditor.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DesignerEditor.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myFile = file2;
    }

    @NotNull
    public abstract String getEditorId();

    @NotNull
    protected abstract DesignerEditorPanel createEditorPanel();

    @NotNull
    public DesignerEditorPanel getComponent() {
        if (this.myEditorPanel == null) {
            this.myEditorPanel = this.createEditorPanel();
            Disposer.register((Disposable)this, (Disposable)this.myEditorPanel);
        }
        DesignerEditorPanel designerEditorPanel = this.myEditorPanel;
        if (designerEditorPanel == null) {
            DesignerEditor.$$$reportNull$$$0(2);
        }
        return designerEditorPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getComponent().getPreferredFocusedComponent();
    }

    public void setState(@NotNull FileEditorState state) {
        if (state == null) {
            DesignerEditor.$$$reportNull$$$0(3);
        }
    }

    public void dispose() {
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public boolean isModified() {
        return false;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DesignerEditor.$$$reportNull$$$0(4);
        }
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
        if (listener2 == null) {
            DesignerEditor.$$$reportNull$$$0(5);
        }
    }

    @NotNull
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new BackgroundEditorHighlighter(this.myEditorPanel, this.myEditorPanel.getModelLintIssueAnnotator());
        }
        BackgroundEditorHighlighter backgroundEditorHighlighter = this.myBackgroundHighlighter;
        if (backgroundEditorHighlighter == null) {
            DesignerEditor.$$$reportNull$$$0(6);
        }
        return backgroundEditorHighlighter;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public void updateNotifications() {
        DesignerEditorPanel currentPanel = this.myEditorPanel;
        if (currentPanel != null) {
            currentPanel.updateNotifications(this.getFile(), this, this.myProject);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/DesignerEditor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/DesignerEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBackgroundHighlighter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPropertyChangeListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removePropertyChangeListener";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 6 -> new IllegalStateException(string2);
        };
    }
}

