/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.Bridge;
import com.android.tools.adtui.common.AdtPrimaryPanel;
import com.android.tools.adtui.workbench.ToolWindowDefinition;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.error.IssuePanelSplitter;
import com.android.tools.idea.common.lint.ModelLintIssueAnnotator;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.notifications.NotificationPanel;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.startup.ClearResourceCacheAfterFirstBuild;
import com.android.tools.idea.uibuilder.editor.NlActionManager;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.idea.uibuilder.scene.RenderListener;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.NlScreenViewProvider;
import com.android.tools.idea.uibuilder.surface.ScreenViewProvider;
import com.android.tools.idea.uibuilder.type.FileTypeUtilsKt;
import com.android.tools.idea.util.SyncUtil;
import com.intellij.CommonBundle;
import com.intellij.ProjectTopics;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.EdtExecutorService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.android.download.AndroidLayoutlibDownloader;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class DesignerEditorPanel
extends JPanel
implements Disposable {
    private static final String DESIGN_UNAVAILABLE_MESSAGE = "Design editor is unavailable until after a successful project sync";
    private static final String ACCESSORY_PROPORTION = "AndroidStudio.AccessoryProportion";
    @NotNull
    private final DesignerEditor myEditor;
    @NotNull
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;
    @NotNull
    private final DesignSurface<?> mySurface;
    @NotNull
    private final Map<LayoutlibSceneManager, RenderListener> mySceneManagerToRenderListeners;
    @NotNull
    private final ModelLintIssueAnnotator myModelLintIssueAnnotator;
    @NotNull
    private final Consumer<NlComponent> myComponentRegistrar;
    @NotNull
    private final ModelProvider myModelProvider;
    @NotNull
    private final MyContentPanel myContentPanel;
    @NotNull
    private final WorkBench<DesignSurface<?>> myWorkBench;
    private final JBSplitter mySplitter;
    @Nullable
    private final JPanel myAccessoryPanel;
    @Nullable
    private JComponent myBottomComponent;
    private boolean myGradleSyncHappenedAfterModelCreation;
    @NotNull
    private final Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface<?>>>> myToolWindowDefinitions;
    @NotNull
    private State myState;
    @NotNull
    private final AtomicBoolean myIsModelInitializated;
    NotificationPanel myNotificationPanel;

    public DesignerEditorPanel(@NotNull DesignerEditor editor, @NotNull Project project, @NotNull VirtualFile file2, @NotNull WorkBench<DesignSurface<?>> workBench, @NotNull Function<DesignerEditorPanel, DesignSurface<?>> surface2, @NotNull Consumer<NlComponent> componentConsumer, @NotNull ModelProvider modelProvider, @NotNull Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface<?>>>> toolWindowDefinitions, final @Nullable BiFunction<DesignerEditorPanel, ? super NlModel, JComponent> bottomModelComponent, @NotNull State defaultEditorPanelState) {
        if (editor == null) {
            DesignerEditorPanel.$$$reportNull$$$0(0);
        }
        if (project == null) {
            DesignerEditorPanel.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(2);
        }
        if (workBench == null) {
            DesignerEditorPanel.$$$reportNull$$$0(3);
        }
        if (surface2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(4);
        }
        if (componentConsumer == null) {
            DesignerEditorPanel.$$$reportNull$$$0(5);
        }
        if (modelProvider == null) {
            DesignerEditorPanel.$$$reportNull$$$0(6);
        }
        if (toolWindowDefinitions == null) {
            DesignerEditorPanel.$$$reportNull$$$0(7);
        }
        if (defaultEditorPanelState == null) {
            DesignerEditorPanel.$$$reportNull$$$0(8);
        }
        super(new BorderLayout());
        this.mySceneManagerToRenderListeners = new HashMap<LayoutlibSceneManager, RenderListener>();
        this.myIsModelInitializated = new AtomicBoolean(false);
        this.myNotificationPanel = new NotificationPanel((ExtensionPointName<EditorNotificationProvider>)ExtensionPointName.create((String)"com.android.tools.idea.uibuilder.editorNotificationProvider"));
        this.myEditor = editor;
        this.myProject = project;
        this.myFile = file2;
        this.myWorkBench = workBench;
        this.myContentPanel = new MyContentPanel();
        this.mySurface = surface2.apply(this);
        Disposer.register((Disposable)this, this.mySurface);
        this.myModelLintIssueAnnotator = new ModelLintIssueAnnotator(this.mySurface);
        this.myComponentRegistrar = componentConsumer;
        this.myModelProvider = modelProvider;
        this.myAccessoryPanel = this.mySurface.getAccessoryPanel();
        JComponent toolbar = DesignerEditorPanel.createSurfaceToolbar(this.mySurface);
        JPanel toolbarAndNotification = new JPanel();
        toolbarAndNotification.setLayout(new BorderLayout());
        toolbarAndNotification.add((Component)toolbar, "North");
        toolbarAndNotification.add((Component)this.myNotificationPanel, "South");
        this.myContentPanel.add(toolbarAndNotification, "North");
        this.myWorkBench.setLoadingText(CommonBundle.getLoadingTreeNodeText());
        this.myState = defaultEditorPanelState;
        this.mySurface.getAnalyticsManager().setEditorModeWithoutTracking(this.myState);
        this.onStateChange();
        this.mySplitter = new IssuePanelSplitter(file2, this.mySurface, (JComponent)this.myWorkBench);
        this.add((Component)this.mySplitter);
        this.myToolWindowDefinitions = toolWindowDefinitions;
        if (bottomModelComponent != null) {
            this.mySurface.addListener(new DesignSurfaceListener(){

                @Override
                @UiThread
                public void modelChanged(@NotNull DesignSurface<?> surface2, @Nullable NlModel model2) {
                    if (surface2 == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (DesignerEditorPanel.this.myBottomComponent != null) {
                        DesignerEditorPanel.this.myContentPanel.remove(DesignerEditorPanel.this.myBottomComponent);
                    }
                    DesignerEditorPanel.this.myBottomComponent = (JComponent)bottomModelComponent.apply(DesignerEditorPanel.this, model2);
                    if (DesignerEditorPanel.this.myBottomComponent != null) {
                        DesignerEditorPanel.this.myContentPanel.add(DesignerEditorPanel.this.myBottomComponent, "South");
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/common/editor/DesignerEditorPanel$1", "modelChanged"));
                }
            });
        }
    }

    public void setState(@NotNull State state) {
        if (state == null) {
            DesignerEditorPanel.$$$reportNull$$$0(9);
        }
        this.mySurface.getAnalyticsManager().setEditorModeWithoutTracking(state);
        if (this.myState != state) {
            this.myState = state;
            this.onStateChange();
        }
    }

    private void onStateChange() {
        State currentState = this.getState();
        this.myWorkBench.setContext(currentState.name());
        this.myWorkBench.setDefaultPropertiesForContext(currentState == State.SPLIT);
        if (currentState != State.DEACTIVATED && !this.myIsModelInitializated.getAndSet(true)) {
            ClearResourceCacheAfterFirstBuild.getInstance((Project)this.myProject).runWhenResourceCacheClean(this::initNeleModel, this::buildError);
        }
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            DesignerEditorPanel.$$$reportNull$$$0(10);
        }
        return state;
    }

    public DesignerEditorPanel(@NotNull DesignerEditor editor, @NotNull Project project, @NotNull VirtualFile file2, @NotNull WorkBench<DesignSurface<?>> workBench, @NotNull Function<DesignerEditorPanel, DesignSurface<?>> surface2, @NotNull Consumer<NlComponent> componentRegistrar, @NotNull Function<AndroidFacet, List<ToolWindowDefinition<DesignSurface<?>>>> toolWindowDefinitions, @NotNull State defaultState) {
        if (editor == null) {
            DesignerEditorPanel.$$$reportNull$$$0(11);
        }
        if (project == null) {
            DesignerEditorPanel.$$$reportNull$$$0(12);
        }
        if (file2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(13);
        }
        if (workBench == null) {
            DesignerEditorPanel.$$$reportNull$$$0(14);
        }
        if (surface2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(15);
        }
        if (componentRegistrar == null) {
            DesignerEditorPanel.$$$reportNull$$$0(16);
        }
        if (toolWindowDefinitions == null) {
            DesignerEditorPanel.$$$reportNull$$$0(17);
        }
        if (defaultState == null) {
            DesignerEditorPanel.$$$reportNull$$$0(18);
        }
        this(editor, project, file2, workBench, surface2, componentRegistrar, ModelProvider.defaultModelProvider, toolWindowDefinitions, null, defaultState);
    }

    void updateNotifications(@NotNull VirtualFile file2, @NotNull DesignerEditor editor, @NotNull Project project) {
        if (file2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(19);
        }
        if (editor == null) {
            DesignerEditorPanel.$$$reportNull$$$0(20);
        }
        if (project == null) {
            DesignerEditorPanel.$$$reportNull$$$0(21);
        }
        this.myNotificationPanel.updateNotifications(file2, editor, project);
    }

    @NotNull
    private static JComponent createSurfaceToolbar(@NotNull DesignSurface<?> surface2) {
        if (surface2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(22);
        }
        JComponent jComponent = surface2.getActionManager().createToolbar();
        if (jComponent == null) {
            DesignerEditorPanel.$$$reportNull$$$0(23);
        }
        return jComponent;
    }

    private void buildError() {
        this.myWorkBench.loadingStopped(DESIGN_UNAVAILABLE_MESSAGE);
    }

    public void initNeleModel() {
        SyncUtil.runWhenSmartAndSynced((Project)this.myProject, (Disposable)this, result -> {
            if (result.isSuccessful()) {
                this.initNeleModelWhenSmart();
            } else {
                this.buildError();
                SyncUtil.listenUntilNextSync((Project)this.myProject, (Disposable)this, ignore -> this.initNeleModel());
            }
        });
    }

    private void initNeleModelWhenSmart() {
        if (Disposer.isDisposed((Disposable)this.myEditor)) {
            return;
        }
        CompletableFuture.supplyAsync(this::createAndInitNeleModel, AppExecutorUtil.getAppExecutorService()).whenComplete((model2, exception) -> {
            if (exception == null) {
                this.mySurface.goingToSetModel((NlModel)model2).join();
                this.myWorkBench.setLoadingText("Waiting for build to finish...");
                SyncUtil.runWhenSmartAndSyncedOnEdt((Project)this.myProject, (Disposable)this, result -> {
                    if (Bridge.hasNativeCrash()) {
                        DesignSurfaceHelper.handleLayoutlibNativeCrash(this.myWorkBench, this::initNeleModel);
                        return;
                    }
                    this.myWorkBench.setLoadingText("Initializing...");
                    if (result.isSuccessful()) {
                        this.initNeleModelOnEventDispatchThread((NlModel)model2);
                    } else {
                        this.buildError();
                        SyncUtil.listenUntilNextSync((Project)this.myProject, (Disposable)this, ignore -> this.initNeleModel());
                    }
                });
            } else {
                Throwable cause = exception.getCause();
                if (cause instanceof WaitingForGradleSyncException) {
                    Logger.getInstance(DesignerEditorPanel.class).info(cause.getMessage());
                    SyncUtil.listenUntilNextSync((Project)this.myProject, (Disposable)this, ignore -> this.initNeleModel());
                    this.myWorkBench.loadingStopped("Design editor is unavailable until next gradle sync.");
                    return;
                }
                if (cause instanceof ProcessCanceledException) {
                    this.myWorkBench.loadingStopped("Failed to initialize editor (operation canceled).");
                    assert (!IdeInfo.getInstance().isAndroidStudio()) : "AndroidStudio has all the resources bundled with the IDE.";
                    return;
                }
                this.myWorkBench.loadingStopped("Failed to initialize editor.");
                Logger.getInstance(DesignerEditorPanel.class).warn("Failed to initialize DesignerEditorPanel", exception);
            }
        });
    }

    @NotNull
    private NlModel createAndInitNeleModel() {
        AndroidLayoutlibDownloader.getInstance().makeSureComponentIsInPlace();
        XmlFile file2 = (XmlFile)ReadAction.compute(() -> this.getFile());
        AndroidFacet facet = AndroidFacet.getInstance((PsiElement)file2);
        if (facet == null) {
            if (this.myGradleSyncHappenedAfterModelCreation) {
                throw new IllegalStateException("Could not init NlModel. AndroidFacet is unexpectedly null. That might happen if the file does not belong to an Android module of the project.");
            }
            this.myGradleSyncHappenedAfterModelCreation = true;
            throw new WaitingForGradleSyncException("Waiting for next gradle sync to set AndroidFacet.");
        }
        NlModel model2 = this.myModelProvider.createModel((Disposable)this.myEditor, this.myProject, facet, this.myComponentRegistrar, this.myFile);
        final Module modelModule = AndroidPsiUtils.getModuleSafely((Project)this.myProject, (VirtualFile)this.myFile);
        this.myProject.getMessageBus().connect(this.mySurface).subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleRemoved(@NotNull Project project, @NotNull Module module2) {
                if (project == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (module2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (module2.equals(modelModule)) {
                    Disposer.dispose(DesignerEditorPanel.this.mySurface);
                    DesignerEditorPanel.this.myWorkBench.loadingStopped("This file does not belong to the project.");
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "com/android/tools/idea/common/editor/DesignerEditorPanel$2";
                objectArray[2] = "moduleRemoved";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        NlModel nlModel = model2;
        if (nlModel == null) {
            DesignerEditorPanel.$$$reportNull$$$0(24);
        }
        return nlModel;
    }

    @UiThread
    private void initNeleModelOnEventDispatchThread(final @NotNull NlModel model2) {
        if (model2 == null) {
            DesignerEditorPanel.$$$reportNull$$$0(25);
        }
        if (Disposer.isDisposed((Disposable)model2)) {
            return;
        }
        this.mySurface.getModels().stream().map(this.mySurface::getSceneManager).filter(it -> it instanceof LayoutlibSceneManager).forEach(it -> {
            LayoutlibSceneManager manager = (LayoutlibSceneManager)it;
            RenderListener listener2 = this.mySceneManagerToRenderListeners.remove(manager);
            if (listener2 != null) {
                manager.removeRenderListener(listener2);
            }
        });
        CompletableFuture<Void> modelSetFuture = this.mySurface.setModel(model2);
        modelSetFuture.whenComplete((result, ex) -> {
            LayoutlibSceneManager manager = (LayoutlibSceneManager)this.mySurface.getSceneManager(model2);
            assert (manager != null);
            RenderListener listener2 = new RenderListener(){

                @Override
                public void onRenderCompleted() {
                    this.annotateRenderInformation();
                }

                @Override
                public void onRenderFailed(@NotNull Throwable e) {
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    this.annotateRenderInformation();
                }

                private void annotateRenderInformation() {
                    DesignerEditorPanel.this.myModelLintIssueAnnotator.annotateRenderInformationToLint(model2);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/common/editor/DesignerEditorPanel$3", "onRenderFailed"));
                }
            };
            this.mySceneManagerToRenderListeners.put(manager, listener2);
            manager.addRenderListener(listener2);
        });
        if (this.myAccessoryPanel != null) {
            boolean verticalSplitter = (Boolean)StudioFlags.NELE_MOTION_HORIZONTAL.get();
            float initialProportion = PropertiesComponent.getInstance().getFloat(ACCESSORY_PROPORTION, 0.5f);
            final OnePixelSplitter splitter = new OnePixelSplitter(verticalSplitter, initialProportion, 0.05f, 0.95f);
            splitter.setHonorComponentsMinimumSize(false);
            splitter.setFirstComponent(this.mySurface);
            splitter.setSecondComponent((JComponent)this.myAccessoryPanel);
            this.mySurface.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (DesignerEditorPanel.this.myAccessoryPanel.isVisible()) {
                        float proportion = splitter.getProportion();
                        PropertiesComponent.getInstance().setValue(DesignerEditorPanel.ACCESSORY_PROPORTION, proportion, 0.5f);
                    }
                }
            });
            this.myContentPanel.add((Component)splitter, "Center");
        } else {
            this.myContentPanel.add((Component)((Object)this.mySurface), "Center");
        }
        modelSetFuture.whenCompleteAsync((result, ex) -> {
            this.myWorkBench.setContext(this.getState().name());
            this.myWorkBench.init((JComponent)((Object)this.myContentPanel), this.mySurface, this.myToolWindowDefinitions.apply(model2.getFacet()), this.getState() == State.SPLIT);
        }, (Executor)EdtExecutorService.getInstance());
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.mySurface.getPreferredFocusedComponent();
    }

    public void activate() {
        this.mySurface.activate();
    }

    public void deactivate() {
        this.mySurface.deactivate();
    }

    @NotNull
    public DesignSurface<?> getSurface() {
        DesignSurface<?> designSurface = this.mySurface;
        if (designSurface == null) {
            DesignerEditorPanel.$$$reportNull$$$0(26);
        }
        return designSurface;
    }

    @NotNull
    public ModelLintIssueAnnotator getModelLintIssueAnnotator() {
        ModelLintIssueAnnotator modelLintIssueAnnotator = this.myModelLintIssueAnnotator;
        if (modelLintIssueAnnotator == null) {
            DesignerEditorPanel.$$$reportNull$$$0(27);
        }
        return modelLintIssueAnnotator;
    }

    @NotNull
    private XmlFile getFile() {
        XmlFile file2 = (XmlFile)AndroidPsiUtils.getPsiFileSafely((Project)this.myProject, (VirtualFile)this.myFile);
        assert (file2 != null);
        XmlFile xmlFile = file2;
        if (xmlFile == null) {
            DesignerEditorPanel.$$$reportNull$$$0(28);
        }
        return xmlFile;
    }

    @TestOnly
    public void setIssuePanelProportion(float proportion) {
        this.mySplitter.setProportion(proportion);
    }

    public void dispose() {
        Set<LayoutlibSceneManager> keys = this.mySceneManagerToRenderListeners.keySet();
        for (LayoutlibSceneManager manager : keys) {
            RenderListener listener2 = this.mySceneManagerToRenderListeners.remove(manager);
            if (listener2 == null) continue;
            manager.removeRenderListener(listener2);
        }
    }

    @NotNull
    public WorkBench<DesignSurface<?>> getWorkBench() {
        WorkBench<DesignSurface<?>> workBench = this.myWorkBench;
        if (workBench == null) {
            DesignerEditorPanel.$$$reportNull$$$0(29);
        }
        return workBench;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 10, 23, 24, 26, 27, 28, 29 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 12: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workBench";
                break;
            }
            case 4: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentConsumer";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelProvider";
                break;
            }
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowDefinitions";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultEditorPanelState";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 10: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/DesignerEditorPanel";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentRegistrar";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultState";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/DesignerEditorPanel";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createSurfaceToolbar";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "createAndInitNeleModel";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getSurface";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelLintIssueAnnotator";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getWorkBench";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setState";
                break;
            }
            case 10: 
            case 23: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "updateNotifications";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSurfaceToolbar";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "initNeleModelOnEventDispatchThread";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 10, 23, 24, 26, 27, 28, 29 -> new IllegalStateException(string2);
        };
    }

    private class MyContentPanel
    extends AdtPrimaryPanel
    implements DataProvider {
        private MyContentPanel() {
            super((LayoutManager)new BorderLayout());
        }

        @Nullable
        public Object getData(@NotNull String dataId) {
            ScreenViewProvider mode;
            DesignSurface<?> surface2;
            if (dataId == null) {
                MyContentPanel.$$$reportNull$$$0(0);
            }
            if (DesignerDataKeys.DESIGN_SURFACE.is(dataId)) {
                return DesignerEditorPanel.this.getSurface();
            }
            if (NlActionManager.LAYOUT_EDITOR.is(dataId) && (surface2 = DesignerEditorPanel.this.getSurface()) instanceof NlDesignSurface && ((mode = ((NlDesignSurface)surface2).getScreenViewProvider()) == NlScreenViewProvider.RENDER || mode == NlScreenViewProvider.BLUEPRINT || mode == NlScreenViewProvider.RENDER_AND_BLUEPRINT)) {
                return surface2;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/android/tools/idea/common/editor/DesignerEditorPanel$MyContentPanel", "getData"));
        }
    }

    public static interface ModelProvider {
        public static final ModelProvider defaultModelProvider = (disposable, project, facet, componentRegistrar, file2) -> {
            Configuration configuration = FileTypeUtilsKt.getConfiguration(file2, ConfigurationManager.getOrCreateInstance((Module)facet.getModule()));
            NlModel model2 = NlModel.builder(facet, file2, configuration).withParentDisposable(disposable).withComponentRegistrar(componentRegistrar).build();
            model2.setModelDisplayName("");
            return model2;
        };

        public NlModel createModel(@NotNull Disposable var1, @NotNull Project var2, @NotNull AndroidFacet var3, @NotNull Consumer<NlComponent> var4, @NotNull VirtualFile var5);
    }

    public static enum State {
        FULL,
        SPLIT,
        DEACTIVATED;

    }

    private static class WaitingForGradleSyncException
    extends RuntimeException {
        private WaitingForGradleSyncException(@NotNull String message) {
            if (message == null) {
                WaitingForGradleSyncException.$$$reportNull$$$0(0);
            }
            super(message);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/common/editor/DesignerEditorPanel$WaitingForGradleSyncException", "<init>"));
        }
    }
}

