/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.editor.DesignerEditor;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceListener;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerTypeRegistrar;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.text.QuickDefinitionProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditorProvider
implements FileEditorProvider,
QuickDefinitionProvider,
DumbAware {
    @NotNull
    private final List<DesignerEditorFileType> myAcceptedTypes;

    protected DesignerEditorProvider(@NotNull List<DesignerEditorFileType> acceptedTypes) {
        if (acceptedTypes == null) {
            DesignerEditorProvider.$$$reportNull$$$0(0);
        }
        this.myAcceptedTypes = acceptedTypes;
        this.myAcceptedTypes.forEach(DesignerTypeRegistrar.INSTANCE::register);
    }

    public boolean accept(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
        PsiFile psiFile2;
        if (project == null) {
            DesignerEditorProvider.$$$reportNull$$$0(1);
        }
        if (virtualFile2 == null) {
            DesignerEditorProvider.$$$reportNull$$$0(2);
        }
        if ((psiFile2 = AndroidPsiUtils.getPsiFileSafely((Project)project, (VirtualFile)virtualFile2)) instanceof XmlFile) {
            XmlFile xmlFile = (XmlFile)psiFile2;
            return this.myAcceptedTypes.stream().anyMatch(type -> type.isResourceTypeOf((PsiFile)xmlFile));
        }
        return false;
    }

    @NotNull
    public final FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file2) {
        if (project == null) {
            DesignerEditorProvider.$$$reportNull$$$0(3);
        }
        if (file2 == null) {
            DesignerEditorProvider.$$$reportNull$$$0(4);
        }
        DesignerEditor designEditor = this.createDesignEditor(project, file2);
        DesignerEditorPanel editorPanel2 = designEditor.getComponent();
        TextEditor textEditor = (TextEditor)TextEditorProvider.getInstance().createEditor(project, file2);
        this.addCaretListener(textEditor, designEditor);
        editorPanel2.getSurface().setFileEditorDelegate((FileEditor)textEditor);
        DesignToolsSplitEditor splitEditor = new DesignToolsSplitEditor(textEditor, designEditor, project);
        editorPanel2.getWorkBench().setFileEditor((FileEditor)splitEditor);
        DataManager.registerDataProvider((JComponent)editorPanel2, (DataProvider)splitEditor);
        DesignToolsSplitEditor designToolsSplitEditor = splitEditor;
        if (designToolsSplitEditor == null) {
            DesignerEditorProvider.$$$reportNull$$$0(5);
        }
        return designToolsSplitEditor;
    }

    private void addCaretListener(final @NotNull TextEditor editor, final @NotNull DesignerEditor designEditor) {
        if (editor == null) {
            DesignerEditorProvider.$$$reportNull$$$0(6);
        }
        if (designEditor == null) {
            DesignerEditorProvider.$$$reportNull$$$0(7);
        }
        final CaretModel caretModel = editor.getEditor().getCaretModel();
        final MergingUpdateQueue updateQueue = new MergingUpdateQueue("split.editor.preview.edit", 250, true, null, (Disposable)designEditor, null, Alarm.ThreadToUse.SWING_THREAD);
        updateQueue.setRestartTimerOnAdd(true);
        final CaretListener caretListener2 = new CaretListener(){

            public void caretAdded(@NotNull CaretEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                this.caretPositionChanged(event);
            }

            public void caretPositionChanged(@NotNull CaretEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                final DesignSurface<?> surface2 = designEditor.getComponent().getSurface();
                SceneView sceneView = surface2.getFocusedSceneView();
                int offset2 = caretModel.getOffset();
                if (sceneView == null || offset2 == -1) {
                    return;
                }
                NlModel model2 = sceneView.getSceneManager().getModel();
                ImmutableList<NlComponent> views = model2.findByOffset(offset2);
                if (views.isEmpty()) {
                    views = model2.getComponents();
                }
                DesignerEditorProvider.this.handleCaretChanged(sceneView, views);
                updateQueue.queue(new Update("Design editor update"){

                    public void run() {
                        surface2.repaint();
                    }

                    public boolean canEat(@NotNull Update update2) {
                        if (update2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return true;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "update", "com/android/tools/idea/common/editor/DesignerEditorProvider$1$1", "canEat"));
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/android/tools/idea/common/editor/DesignerEditorProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretAdded";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "caretPositionChanged";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        caretModel.addCaretListener(caretListener2);
        designEditor.getComponent().getSurface().addListener(new DesignSurfaceListener(){

            @Override
            @UiThread
            public void modelChanged(@NotNull DesignSurface<?> surface2, @Nullable NlModel model2) {
                if (surface2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                surface2.removeListener(this);
                CaretModel caretModel = editor.getEditor().getCaretModel();
                caretListener2.caretPositionChanged(new CaretEvent(caretModel.getCurrentCaret(), caretModel.getLogicalPosition(), caretModel.getLogicalPosition()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "surface", "com/android/tools/idea/common/editor/DesignerEditorProvider$2", "modelChanged"));
            }
        });
    }

    protected abstract void handleCaretChanged(@NotNull SceneView var1, @NotNull ImmutableList<NlComponent> var2);

    @NotNull
    public abstract DesignerEditor createDesignEditor(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    public abstract String getEditorTypeId();

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.HIDE_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            DesignerEditorProvider.$$$reportNull$$$0(8);
        }
        return fileEditorPolicy;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "acceptedTypes";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/editor/DesignerEditorProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/editor/DesignerEditorProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPolicy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addCaretListener";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 5, 8 -> new IllegalStateException(string2);
        };
    }
}

