/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.OnePixelSplitter;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/common/error/IssuePanelSplitter;", "Lcom/intellij/ui/OnePixelSplitter;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "content", "Ljavax/swing/JComponent;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/android/tools/idea/common/surface/DesignSurface;Ljavax/swing/JComponent;)V", "createIssueEventListener", "Lcom/android/tools/idea/common/error/IssuePanel$EventListener;", "issuePanel", "Lcom/android/tools/idea/common/error/IssuePanel;", "updateSplitter", "", "isExpanded", "", "height", "", "intellij.android.designer"})
public final class IssuePanelSplitter
extends OnePixelSplitter {
    @NotNull
    private final DesignSurface<?> surface;

    public IssuePanelSplitter(@Nullable VirtualFile file2, @NotNull DesignSurface<?> surface2, @NotNull JComponent content2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
        super(true, 1.0f, 0.5f, 1.0f);
        this.surface = surface2;
        Disposer.register((Disposable)this.surface, () -> IssuePanelSplitter._init_$lambda$0(file2, this));
        this.setFirstComponent(content2);
        Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        if (((Boolean)object).booleanValue()) {
            this.setSecondComponent(null);
            if (file2 != null) {
                Project project = this.surface.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"surface.project");
                IssuePanelService.Companion.getInstance(project).registerFile(file2, this.surface.getName());
            }
        } else {
            IssuePanel issuePanel2 = this.surface.getIssuePanel();
            Intrinsics.checkNotNullExpressionValue((Object)issuePanel2, (String)"surface.issuePanel");
            IssuePanel issuePanel3 = issuePanel2;
            issuePanel3.addEventListener(this.createIssueEventListener(issuePanel3));
            this.setHonorComponentsMinimumSize(true);
            this.setSecondComponent(issuePanel3);
        }
    }

    private final void updateSplitter(boolean isExpanded, int height2) {
        float f;
        boolean showDivider = isExpanded;
        this.setShowDividerIcon(showDivider);
        this.setShowDividerControls(showDivider);
        this.setResizeEnabled(showDivider);
        if (!isExpanded) {
            f = 1.0f;
        } else {
            float newProportion = 1.0f - (float)height2 / (float)this.getParent().getHeight();
            f = Math.max(0.5f, newProportion);
        }
        this.setProportion(f);
    }

    private final IssuePanel.EventListener createIssueEventListener(IssuePanel issuePanel2) {
        return new IssuePanel.EventListener(this, issuePanel2){
            final /* synthetic */ IssuePanelSplitter this$0;
            final /* synthetic */ IssuePanel $issuePanel;
            {
                this.this$0 = $receiver;
                this.$issuePanel = $issuePanel;
            }

            public void onPanelExpanded(boolean isExpanded) {
                IssuePanelSplitter.access$getSurface$p(this.this$0).getAnalyticsManager().trackIssuePanel(!isExpanded);
                IssuePanelSplitter.access$updateSplitter(this.this$0, isExpanded, this.$issuePanel.getSuggestedHeight());
            }

            public void onIssueExpanded(@Nullable Issue issue, boolean isExpanded) {
            }
        };
    }

    private static final void _init_$lambda$0(VirtualFile $file, IssuePanelSplitter this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        if (((Boolean)object).booleanValue() && $file != null) {
            Project project = this$0.surface.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"surface.project");
            IssuePanelService.Companion.getInstance(project).unregisterFile($file);
        }
    }

    public static final /* synthetic */ DesignSurface access$getSurface$p(IssuePanelSplitter $this) {
        return $this.surface;
    }

    public static final /* synthetic */ void access$updateSplitter(IssuePanelSplitter $this, boolean isExpanded, int height2) {
        $this.updateSplitter(isExpanded, height2);
    }
}

