/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueNode;
import com.android.tools.idea.common.error.QuickFixableCellRenderer;
import com.android.tools.idea.common.error.ShowQuickFixesAction;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.util.containers.UtilKt;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import java.util.stream.Stream;
import javax.swing.ListCellRenderer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/common/error/ShowQuickFixesAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "intellij.android.designer"})
public final class ShowQuickFixesAction
extends AnAction {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent event) {
        IssueNode node;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Presentation presentation = event.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"event.presentation");
        Presentation presentation2 = presentation;
        String string2 = ActionsBundle.actionText((String)"ProblemsView.QuickFixes");
        if (string2 == null) {
            string2 = "Show Quick Fix";
        }
        presentation2.setText(string2);
        Object object = event.getData(PlatformDataKeys.SELECTED_ITEM);
        IssueNode issueNode = node = object instanceof IssueNode ? (IssueNode)((Object)object) : null;
        if (node == null) {
            presentation2.setEnabled(false);
            return;
        }
        Stream<Issue.Fix> fixes = node.getIssue().getFixes();
        Stream<Issue.Suppress> suppress = node.getIssue().getSuppresses();
        if (UtilKt.isEmpty(fixes) && UtilKt.isEmpty(suppress)) {
            presentation2.setText("No Quick Fix for This Issue");
            presentation2.setEnabled(false);
        } else {
            presentation2.setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = event.getData(PlatformDataKeys.SELECTED_ITEM);
        IssueNode issueNode = object instanceof IssueNode ? (IssueNode)((Object)object) : null;
        if (issueNode == null) {
            return;
        }
        IssueNode node = issueNode;
        Issue issue = node.getIssue();
        List<Issue.Fix> list = issue.getFixes().toList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"issue.fixes.toList()");
        Collection collection = list;
        List<Issue.Suppress> list2 = issue.getSuppresses().toList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"issue.suppresses.toList()");
        List fixable = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(fixable).setRenderer((ListCellRenderer)((Object)new QuickFixableCellRenderer())).setItemChosenCallback(arg_0 -> ShowQuickFixesAction.actionPerformed$lambda$0(actionPerformed.popup.1.INSTANCE, arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"getInstance().createPopu\u2026() }\n      .createPopup()");
        JBPopup popup2 = jBPopup;
        InputEvent inputEvent = event.getInputEvent();
        MouseEvent mouseEvent = inputEvent instanceof MouseEvent ? (MouseEvent)inputEvent : null;
        if (mouseEvent == null) {
            popup2.showInBestPositionFor(event.getDataContext());
            return;
        }
        MouseEvent mouse = mouseEvent;
        Object object2 = mouse.getSource();
        ActionButton actionButton = object2 instanceof ActionButton ? (ActionButton)object2 : null;
        if (actionButton == null) {
            popup2.showInBestPositionFor(event.getDataContext());
            return;
        }
        ActionButton button = actionButton;
        popup2.showUnderneathOf((Component)button);
    }

    private static final void actionPerformed$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }
}

