/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.lint;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.tools.idea.common.lint.AttributeKey;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintExternalAnnotator;
import com.android.tools.idea.lint.common.LintProblemData;
import com.android.tools.lint.detector.api.Issue;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.lang.ref.WeakReference;
import java.util.concurrent.Executor;
import kotlin.Pair;
import net.jcip.annotations.GuardedBy;
import org.jetbrains.annotations.NotNull;

public class ModelLintIssueAnnotator {
    private final WeakReference<DesignSurface<?>> mySurfaceRef;
    private final Executor myExecutor;
    private final Object myRunningTaskLock;
    @GuardedBy(value="myRunningTaskLock")
    private Runnable myRunningTask;

    public ModelLintIssueAnnotator(@NotNull DesignSurface<?> surface2) {
        if (surface2 == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(0);
        }
        this(surface2, AppExecutorUtil.getAppExecutorService());
    }

    public ModelLintIssueAnnotator(@NotNull DesignSurface<?> surface2, @NotNull Executor executor) {
        if (surface2 == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(1);
        }
        if (executor == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(2);
        }
        this.myRunningTaskLock = new Object();
        this.mySurfaceRef = new WeakReference(surface2);
        this.myExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotateRenderInformationToLint(@NotNull NlModel model2) {
        DesignSurface surface2;
        if (model2 == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(3);
        }
        if ((surface2 = (DesignSurface)this.mySurfaceRef.get()) == null) {
            return;
        }
        Runnable annotatingTask = () -> {
            LintAnnotationsModel lintAnnotationsModel;
            try {
                lintAnnotationsModel = (LintAnnotationsModel)ApplicationManager.getApplication().runReadAction(() -> ModelLintIssueAnnotator.getAnnotations(model2));
            }
            finally {
                Object object = this.myRunningTaskLock;
                synchronized (object) {
                    this.myRunningTask = null;
                }
            }
            UIUtil.invokeLaterIfNeeded(() -> ModelLintIssueAnnotator.updateLintAnnotationsModelToSurface(surface2, model2, lintAnnotationsModel));
        };
        Object object = this.myRunningTaskLock;
        synchronized (object) {
            if (this.myRunningTask == null) {
                this.myRunningTask = annotatingTask;
                this.myExecutor.execute(annotatingTask);
            }
        }
    }

    private static void updateLintAnnotationsModelToSurface(@NotNull DesignSurface<?> surface2, @NotNull NlModel model2, @NotNull LintAnnotationsModel annotationsModel) {
        if (surface2 == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(4);
        }
        if (model2 == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(5);
        }
        if (annotationsModel == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(6);
        }
        model2.setLintAnnotationsModel(annotationsModel);
        surface2.setLintAnnotationsModel(annotationsModel);
        surface2.repaint();
    }

    @NotNull
    private static LintAnnotationsModel getAnnotations(@NotNull NlModel model2) {
        if (model2 == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(7);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        LintAnnotationsModel lintModel = new LintAnnotationsModel();
        XmlFile xmlFile = model2.getFile();
        LintExternalAnnotator annotator = new LintExternalAnnotator();
        LintEditorResult lintResult = annotator.collectInformation((PsiFile)xmlFile);
        if (lintResult != null) {
            lintResult = annotator.doAnnotate(lintResult);
        }
        if (lintResult == null) {
            LintAnnotationsModel lintAnnotationsModel = lintModel;
            if (lintAnnotationsModel == null) {
                ModelLintIssueAnnotator.$$$reportNull$$$0(8);
            }
            return lintAnnotationsModel;
        }
        for (LintProblemData problemData : lintResult.getProblems()) {
            AndroidLintInspectionBase inspection;
            NlComponent component2;
            TextRange range = problemData.getTextRange();
            PsiElement startElement = xmlFile.findElementAt(range.getStartOffset());
            PsiElement endElement = xmlFile.findElementAt(range.getEndOffset());
            if (startElement == null || endElement == null || (component2 = model2.findViewByPsi(startElement)) == null) continue;
            ResourceReference attribute = model2.findAttributeByPsi(startElement);
            AttributeKey attributeKey = attribute != null ? new AttributeKey(component2, attribute.getNamespace().getXmlNamespaceUri(), attribute.getName()) : null;
            Issue issue = problemData.getIssue();
            Pair pair = LintExternalAnnotator.Companion.getHighlightLevelAndInspection(xmlFile.getProject(), issue, (PsiElement)xmlFile);
            if (pair == null || (inspection = (AndroidLintInspectionBase)pair.getFirst()) == null) continue;
            HighlightDisplayLevel level = (HighlightDisplayLevel)pair.getSecond();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)inspection.getShortName());
            if (key == null) continue;
            SmartPsiElementPointer startElementPointer = SmartPointerManager.getInstance((Project)model2.getProject()).createSmartPsiElementPointer(startElement, (PsiFile)xmlFile);
            SmartPsiElementPointer endElementPointer = SmartPointerManager.getInstance((Project)model2.getProject()).createSmartPsiElementPointer(endElement, (PsiFile)xmlFile);
            lintModel.addIssue(component2, attributeKey, issue, problemData.getMessage(), inspection, level, (SmartPsiElementPointer<PsiElement>)startElementPointer, (SmartPsiElementPointer<PsiElement>)endElementPointer, problemData.getQuickfixData());
        }
        LintAnnotationsModel lintAnnotationsModel = lintModel;
        if (lintAnnotationsModel == null) {
            ModelLintIssueAnnotator.$$$reportNull$$$0(9);
        }
        return lintAnnotationsModel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationsModel";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/lint/ModelLintIssueAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/lint/ModelLintIssueAnnotator";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "annotateRenderInformationToLint";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateLintAnnotationsModelToSurface";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotations";
                break;
            }
            case 8: 
            case 9: {
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 8, 9 -> new IllegalStateException(string2);
        };
    }
}

