/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultModelUpdater
implements NlModel.NlModelUpdaterInterface {
    private void recordComponentMapping(@NotNull XmlTag tag2, @NotNull NlComponent component2, ModelUpdaterData data) {
        XmlTag prevTag;
        if (tag2 == null) {
            DefaultModelUpdater.$$$reportNull$$$0(0);
        }
        if (component2 == null) {
            DefaultModelUpdater.$$$reportNull$$$0(1);
        }
        if ((prevTag = data.myComponentToTagMap.get(component2)) != null) {
            data.myTagToComponentMap.remove(prevTag);
        }
        data.myComponentToTagMap.put(component2, tag2);
        data.myTagToComponentMap.put(tag2, component2);
    }

    @Override
    @VisibleForTesting
    public void updateFromTagSnapshot(@NotNull NlModel model2, @Nullable XmlTag newRoot, @NotNull List<NlModel.TagSnapshotTreeNode> roots) {
        if (model2 == null) {
            DefaultModelUpdater.$$$reportNull$$$0(2);
        }
        if (roots == null) {
            DefaultModelUpdater.$$$reportNull$$$0(3);
        }
        ModelUpdaterData data = new ModelUpdaterData();
        data.myModel = model2;
        if (newRoot == null) {
            data.myModel.setRootComponent(null);
            return;
        }
        data.myModel.setRootComponent((NlComponent)ApplicationManager.getApplication().runReadAction(() -> {
            if (!newRoot.isValid()) {
                return null;
            }
            for (NlModel.TagSnapshotTreeNode tagSnapshotTreeNode : roots) {
                DefaultModelUpdater.gatherTagsAndSnapshots(tagSnapshotTreeNode, data.myTagToSnapshot);
            }
            this.mapOldToNew(newRoot, data);
            for (Map.Entry entry : data.myTagToComponentMap.entrySet()) {
                XmlTag tag2 = (XmlTag)entry.getKey();
                NlComponent component2 = (NlComponent)entry.getValue();
                if (component2.getTagName().equals(tag2.getName())) continue;
                data.myTagToComponentMap.clear();
                data.myComponentToTagMap.clear();
                break;
            }
            return this.createTree(newRoot, data);
        }));
        for (NlComponent component2 : data.myTagToComponentMap.values()) {
            component2.setSnapshot(null);
        }
        for (NlModel.TagSnapshotTreeNode root : roots) {
            this.updateHierarchy(root, data);
        }
    }

    @Override
    public void updateFromViewInfo(@NotNull NlModel model2, @NotNull List<ViewInfo> viewInfos) {
        if (model2 == null) {
            DefaultModelUpdater.$$$reportNull$$$0(4);
        }
        if (viewInfos == null) {
            DefaultModelUpdater.$$$reportNull$$$0(5);
        }
    }

    private void mapOldToNew(@NotNull XmlTag newRootTag, ModelUpdaterData data) {
        XmlTag oldTag;
        TagSnapshot snapshot;
        NlComponent component2;
        if (newRootTag == null) {
            DefaultModelUpdater.$$$reportNull$$$0(6);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (NlComponent component3 : data.myModel.getComponents()) {
            this.gatherTagsAndSnapshots(component3, data);
        }
        ArrayList<XmlTag> missing = new ArrayList<XmlTag>();
        Set remaining = Sets.newIdentityHashSet();
        remaining.addAll(data.myTagToComponentMap.keySet());
        DefaultModelUpdater.checkMissing(newRootTag, remaining, missing);
        if (missing.isEmpty()) {
            return;
        }
        if (remaining.isEmpty()) {
            return;
        }
        HashMap<String, NlComponent> oldIds = new HashMap<String, NlComponent>();
        for (Map.Entry<TagSnapshot, NlComponent> entry : data.mySnapshotToComponent.entrySet()) {
            String id2;
            TagSnapshot snapshot2 = entry.getKey();
            if (snapshot2 == null || (id2 = snapshot2.getAttribute("id", "http://schemas.android.com/apk/res/android")) == null) continue;
            oldIds.put(id2, entry.getValue());
        }
        ListIterator missingIterator = missing.listIterator();
        while (missingIterator.hasNext()) {
            XmlTag tag2 = (XmlTag)missingIterator.next();
            String id3 = tag2.getAttributeValue("id", "http://schemas.android.com/apk/res/android");
            if (id3 == null || (component2 = (NlComponent)oldIds.get(id3)) == null) continue;
            this.recordComponentMapping(tag2, component2, data);
            remaining.remove(component2.getTagDeprecated());
            missingIterator.remove();
        }
        if (missing.isEmpty() || remaining.isEmpty()) {
            return;
        }
        ArrayListMultimap snapshotIds = ArrayListMultimap.create();
        for (XmlTag old : remaining) {
            NlComponent component4 = data.myTagToComponentMap.get(old);
            if (component4 == null || (snapshot = component4.getSnapshot()) == null) continue;
            snapshotIds.put((Object)snapshot.getSignature(), (Object)snapshot);
        }
        missingIterator = missing.listIterator();
        while (missingIterator.hasNext()) {
            TagSnapshot first;
            NlComponent component5;
            long signature;
            Collection snapshots;
            XmlTag tag3 = (XmlTag)missingIterator.next();
            TagSnapshot snapshot3 = data.myTagToSnapshot.get(tag3);
            if (snapshot3 == null || (snapshots = snapshotIds.get((Object)(signature = snapshot3.getSignature()))).isEmpty() || (component5 = data.mySnapshotToComponent.get(first = (TagSnapshot)snapshots.iterator().next())) == null) continue;
            this.recordComponentMapping(tag3, component5, data);
            remaining.remove(component5.getTagDeprecated());
            missingIterator.remove();
        }
        if (missing.size() == 1 && remaining.size() == 1 && (component2 = data.myTagToComponentMap.get(oldTag = (XmlTag)remaining.iterator().next())) != null) {
            XmlTag newTag = (XmlTag)missing.get(0);
            snapshot = component2.getSnapshot();
            if (snapshot != null && snapshot.tagName.equals(newTag.getName())) {
                this.recordComponentMapping(newTag, component2, data);
            }
        }
    }

    private static void checkMissing(XmlTag tag2, Set<XmlTag> remaining, List<XmlTag> missing) {
        boolean found = remaining.remove(tag2);
        if (!found) {
            missing.add(tag2);
        }
        for (XmlTag child : tag2.getSubTags()) {
            DefaultModelUpdater.checkMissing(child, remaining, missing);
        }
    }

    private void gatherTagsAndSnapshots(@NotNull NlComponent component2, ModelUpdaterData data) {
        if (component2 == null) {
            DefaultModelUpdater.$$$reportNull$$$0(7);
        }
        XmlTag tag2 = component2.getTagDeprecated();
        this.recordComponentMapping(tag2, component2, data);
        data.mySnapshotToComponent.put(component2.getSnapshot(), component2);
        for (NlComponent child : component2.getChildren()) {
            this.gatherTagsAndSnapshots(child, data);
        }
    }

    private static void gatherTagsAndSnapshots(@NotNull NlModel.TagSnapshotTreeNode node, @NotNull Map<XmlTag, TagSnapshot> map2) {
        RenderXmlTag renderXmlTag;
        TagSnapshot snapshot;
        if (node == null) {
            DefaultModelUpdater.$$$reportNull$$$0(8);
        }
        if (map2 == null) {
            DefaultModelUpdater.$$$reportNull$$$0(9);
        }
        if ((snapshot = node.getTagSnapshot()) != null && (renderXmlTag = snapshot.tag) instanceof PsiXmlTag) {
            PsiXmlTag xmlTag = (PsiXmlTag)renderXmlTag;
            map2.put(xmlTag.getPsiXmlTag(), snapshot);
        }
        for (NlModel.TagSnapshotTreeNode child : node.getChildren()) {
            DefaultModelUpdater.gatherTagsAndSnapshots(child, map2);
        }
    }

    @NotNull
    private NlComponent createTree(@NotNull XmlTag tag2, ModelUpdaterData data) {
        XmlTag[] subTags;
        NlComponent component2;
        if (tag2 == null) {
            DefaultModelUpdater.$$$reportNull$$$0(10);
        }
        if ((component2 = data.myTagToComponentMap.get(tag2)) == null) {
            component2 = data.myModel.createComponent(tag2);
            this.recordComponentMapping(tag2, component2, data);
        }
        if ((subTags = tag2.getSubTags()).length > 0) {
            ArrayList<NlComponent> children = new ArrayList<NlComponent>(subTags.length);
            for (XmlTag subtag : subTags) {
                NlComponent child = this.createTree(subtag, data);
                children.add(child);
            }
            component2.setChildren(children);
        } else {
            component2.setChildren(null);
        }
        NlComponent nlComponent = component2;
        if (nlComponent == null) {
            DefaultModelUpdater.$$$reportNull$$$0(11);
        }
        return nlComponent;
    }

    private void updateHierarchy(@NotNull NlModel.TagSnapshotTreeNode node, ModelUpdaterData data) {
        if (node == null) {
            DefaultModelUpdater.$$$reportNull$$$0(12);
        }
        TagSnapshot snapshot = (TagSnapshot)ApplicationManager.getApplication().runReadAction(node::getTagSnapshot);
        if (snapshot != null) {
            NlComponent component2 = data.mySnapshotToComponent.get(snapshot);
            if (component2 == null) {
                PsiXmlTag psiXmlTag = (PsiXmlTag)snapshot.tag;
                component2 = data.myTagToComponentMap.get(psiXmlTag != null ? psiXmlTag.getPsiXmlTag() : null);
            }
            if (component2 != null) {
                component2.setSnapshot(snapshot);
                assert (snapshot.tag != null);
                component2.setTag(((PsiXmlTag)snapshot.tag).getPsiXmlTag());
            }
        }
        for (NlModel.TagSnapshotTreeNode child : node.getChildren()) {
            this.updateHierarchy(child, data);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tag";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewInfos";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newRootTag";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/model/DefaultModelUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/model/DefaultModelUpdater";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createTree";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordComponentMapping";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateFromTagSnapshot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "updateFromViewInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mapOldToNew";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "gatherTagsAndSnapshots";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTree";
                break;
            }
            case 11: {
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateHierarchy";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 11 -> new IllegalStateException(string2);
        };
    }

    private static class ModelUpdaterData {
        protected NlModel myModel;
        protected final Map<XmlTag, NlComponent> myTagToComponentMap = Maps.newIdentityHashMap();
        protected final Map<NlComponent, XmlTag> myComponentToTagMap = Maps.newIdentityHashMap();
        protected final Map<TagSnapshot, NlComponent> mySnapshotToComponent = Maps.newIdentityHashMap();
        protected final Map<XmlTag, TagSnapshot> myTagToSnapshot = new HashMap<XmlTag, TagSnapshot>();

        private ModelUpdaterData() {
        }
    }
}

