/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.tools.idea.common.model.NlComponentBackend;
import com.android.tools.idea.common.model.NlComponentBackendXmlKt;
import com.android.tools.idea.util.ReformatUtil;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlTag;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 $2\u00020\u0001:\u0001$B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B%\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0002\u0012\u0006\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000bJ\n\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016J\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0016J\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000eH\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u000eH\u0002J\b\u0010\u001b\u001a\u00020\u0005H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J$\u0010!\u001a\u00020\u001e2\u0006\u0010\u0015\u001a\u00020\u000e2\b\u0010\u0016\u001a\u0004\u0018\u00010\u000e2\b\u0010\"\u001a\u0004\u0018\u00010\u000eH\u0016J\u0010\u0010#\u001a\u00020 2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/common/model/NlComponentBackendXml;", "Lcom/android/tools/idea/common/model/NlComponentBackend;", "project", "Lcom/intellij/openapi/project/Project;", "tag", "Lcom/intellij/psi/xml/XmlTag;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/xml/XmlTag;)V", "pointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/xml/XmlTag;Lcom/intellij/psi/SmartPsiElementPointer;)V", "myProject", "(Lcom/intellij/openapi/project/Project;)V", "myTag", "myTagName", "", "myTagPointer", "getTag", "()Lcom/intellij/psi/xml/XmlTag;", "getAffectedFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getAttribute", "attribute", "namespace", "getAttributeImpl", "getDefaultNavigatable", "Lcom/intellij/pom/Navigatable;", "getStackTrace", "getTagDeprecated", "getTagName", "isValid", "", "reformatAndRearrange", "", "setAttribute", "value", "setTagElement", "Companion", "intellij.android.designer"})
public class NlComponentBackendXml
implements NlComponentBackend {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project myProject;
    private XmlTag myTag;
    private String myTagName;
    private SmartPsiElementPointer<XmlTag> myTagPointer;
    public static final boolean DEBUG = false;

    private NlComponentBackendXml(Project myProject) {
        this.myProject = myProject;
    }

    public NlComponentBackendXml(@NotNull Project project, @NotNull XmlTag tag2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tag2, (String)"tag");
        this(project);
        this.myTag = tag2;
        String string2 = tag2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag.name");
        this.myTagName = string2;
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this.myProject);
            XmlTag xmlTag = this.myTag;
            if (xmlTag == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTag");
                xmlTag = null;
            }
            SmartPsiElementPointer smartPsiElementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)xmlTag);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"getInstance(myProject).c\u2026tPsiElementPointer(myTag)");
            this.myTagPointer = smartPsiElementPointer;
        } else {
            application.runReadAction(() -> NlComponentBackendXml._init_$lambda$0(this));
        }
    }

    @VisibleForTesting
    public NlComponentBackendXml(@NotNull Project project, @NotNull XmlTag tag2, @NotNull SmartPsiElementPointer<XmlTag> pointer) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)tag2, (String)"tag");
        Intrinsics.checkNotNullParameter(pointer, (String)"pointer");
        this(project);
        this.myTag = tag2;
        String string2 = tag2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag.name");
        this.myTagName = string2;
        this.myTagPointer = pointer;
    }

    @Override
    public void setTagElement(@NotNull XmlTag tag2) {
        Intrinsics.checkNotNullParameter((Object)tag2, (String)"tag");
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            if (tag2.isValid()) {
                SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)tag2);
                Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"getInstance(myProject).c\u2026artPsiElementPointer(tag)");
                this.myTagPointer = smartPsiElementPointer;
                String string2 = tag2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag.getName()");
                this.myTagName = string2;
            }
        } else {
            application.runReadAction(() -> NlComponentBackendXml.setTagElement$lambda$1(tag2, this));
        }
        this.myTag = tag2;
    }

    @Override
    @NotNull
    public XmlTag getTagDeprecated() {
        XmlTag xmlTag;
        XmlTag tag2 = null;
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this.myTagPointer;
            if (smartPsiElementPointer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTagPointer");
                smartPsiElementPointer = null;
            }
            tag2 = (XmlTag)smartPsiElementPointer.getElement();
        } else {
            tag2 = (XmlTag)application.runReadAction(() -> NlComponentBackendXml.getTagDeprecated$lambda$2(this));
        }
        if ((xmlTag = tag2) == null && (xmlTag = this.myTag) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTag");
            xmlTag = null;
        }
        return xmlTag;
    }

    @Override
    @Nullable
    public XmlTag getTag() {
        XmlTag tag2;
        ApplicationManager.getApplication().assertReadAccessAllowed();
        SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this.myTagPointer;
        if (smartPsiElementPointer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTagPointer");
            smartPsiElementPointer = null;
        }
        return (tag2 = (XmlTag)smartPsiElementPointer.getElement()) != null && tag2.isValid() ? tag2 : null;
    }

    @Override
    @NotNull
    public String getTagName() {
        String string2 = this.myTagName;
        if (string2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTagName");
            string2 = null;
        }
        return string2;
    }

    @Override
    @Nullable
    public VirtualFile getAffectedFile() {
        Object object;
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            XmlTag xmlTag;
            SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this.myTagPointer;
            if (smartPsiElementPointer == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"myTagPointer");
                smartPsiElementPointer = null;
            }
            object = (xmlTag = (XmlTag)smartPsiElementPointer.getElement()) != null && (xmlTag = xmlTag.getContainingFile()) != null ? xmlTag.getVirtualFile() : null;
        } else {
            object = (VirtualFile)application.runReadAction(() -> NlComponentBackendXml.getAffectedFile$lambda$3(this));
        }
        return object;
    }

    @Override
    @Nullable
    public String getAttribute(@NotNull String attribute, @Nullable String namespace) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Application application = ApplicationManager.getApplication();
        if (application.isReadAccessAllowed()) {
            return this.getAttributeImpl(attribute, namespace);
        }
        return (String)application.runReadAction(() -> NlComponentBackendXml.getAttribute$lambda$4(this, attribute, namespace));
    }

    private final String getAttributeImpl(String attribute, String namespace) {
        XmlTag xmlTag = this.getTag();
        if (xmlTag == null) {
            NlComponentBackendXmlKt.access$getLOGGER$p().debug("Unable to get attribute from " + this.getTagName() + " because XmlTag is invalidated " + this.getStackTrace());
            return null;
        }
        return xmlTag.getAttributeValue(attribute, namespace);
    }

    @Override
    public boolean setAttribute(@NotNull String attribute, @Nullable String namespace, @Nullable String value2) {
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        Application application = ApplicationManager.getApplication();
        if (!application.isWriteAccessAllowed()) {
            NlComponentBackendXmlKt.access$getLOGGER$p().warn("Unable to set attribute to " + this.getTagName() + ". SetAttribute must be called within undo-transparent action " + this.getStackTrace());
            return false;
        }
        XmlTag xmlTag = this.getTag();
        if (xmlTag == null) {
            NlComponentBackendXmlKt.access$getLOGGER$p().debug("Unable to set attribute to " + this.getTagName() + " because XmlTag is invalidated " + this.getStackTrace());
            return false;
        }
        return xmlTag.setAttribute(attribute, namespace, value2) != null;
    }

    @Override
    public void reformatAndRearrange() {
        XmlTag xmlTag;
        XmlTag xmlTag2;
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this.myTagPointer;
        if (smartPsiElementPointer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTagPointer");
            smartPsiElementPointer = null;
        }
        if (((xmlTag2 = (xmlTag = (XmlTag)smartPsiElementPointer.getElement())) != null && (xmlTag2 = xmlTag2.getContainingFile()) != null ? xmlTag2.getVirtualFile() : null) == null) {
            NlComponentBackendXmlKt.access$getLOGGER$p().debug("Not reformatting " + this.getTagName() + " because its virtual file is null " + this.getStackTrace());
            return;
        }
        ReformatUtil.reformatAndRearrange((Project)this.myProject, (PsiElement)((PsiElement)xmlTag));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isValid() {
        if (!ApplicationManager.getApplication().isReadAccessAllowed()) return false;
        SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this.myTagPointer;
        if (smartPsiElementPointer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTagPointer");
            smartPsiElementPointer = null;
        }
        XmlTag xmlTag = (XmlTag)smartPsiElementPointer.getElement();
        if (xmlTag == null) return false;
        if (!xmlTag.isValid()) return false;
        return true;
    }

    @Override
    @Nullable
    public Navigatable getDefaultNavigatable() {
        XmlTag xmlTag = this.getTag();
        PsiElement psiElement = xmlTag != null ? xmlTag.getNavigationElement() : null;
        return psiElement instanceof Navigatable ? (Navigatable)psiElement : null;
    }

    private final String getStackTrace() {
        return "";
    }

    private static final void _init_$lambda$0(NlComponentBackendXml this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)this$0.myProject);
        XmlTag xmlTag = this$0.myTag;
        if (xmlTag == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTag");
            xmlTag = null;
        }
        SmartPsiElementPointer smartPsiElementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)xmlTag);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"getInstance(myProject).c\u2026tPsiElementPointer(myTag)");
        this$0.myTagPointer = smartPsiElementPointer;
    }

    private static final void setTagElement$lambda$1(XmlTag $tag, NlComponentBackendXml this$0) {
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($tag.isValid()) {
            SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.getInstance((Project)this$0.myProject).createSmartPsiElementPointer((PsiElement)$tag);
            Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"getInstance(myProject).c\u2026artPsiElementPointer(tag)");
            this$0.myTagPointer = smartPsiElementPointer;
            String string2 = $tag.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"tag.getName()");
            this$0.myTagName = string2;
        }
    }

    private static final XmlTag getTagDeprecated$lambda$2(NlComponentBackendXml this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this$0.myTagPointer;
        if (smartPsiElementPointer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTagPointer");
            smartPsiElementPointer = null;
        }
        return (XmlTag)smartPsiElementPointer.getElement();
    }

    private static final VirtualFile getAffectedFile$lambda$3(NlComponentBackendXml this$0) {
        XmlTag xmlTag;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        SmartPsiElementPointer<XmlTag> smartPsiElementPointer = this$0.myTagPointer;
        if (smartPsiElementPointer == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"myTagPointer");
            smartPsiElementPointer = null;
        }
        return (xmlTag = (XmlTag)smartPsiElementPointer.getElement()) != null && (xmlTag = xmlTag.getContainingFile()) != null ? xmlTag.getVirtualFile() : null;
    }

    private static final String getAttribute$lambda$4(NlComponentBackendXml this$0, String $attribute, String $namespace) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$attribute, (String)"$attribute");
        return this$0.getAttributeImpl($attribute, $namespace);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/common/model/NlComponentBackendXml$Companion;", "", "()V", "DEBUG", "", "getForTest", "Lcom/android/tools/idea/common/model/NlComponentBackendXml;", "project", "Lcom/intellij/openapi/project/Project;", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @TestOnly
        @NotNull
        public final NlComponentBackendXml getForTest(@NotNull Project project, @NotNull XmlTag xmlTag) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)xmlTag, (String)"xmlTag");
            return new NlComponentBackendXml(project, xmlTag);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

