/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueListener;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.google.common.collect.ImmutableList;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/common/surface/DesignSurfaceIssueListenerImpl;", "Lcom/android/tools/idea/common/error/IssueListener;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "onIssueSelected", "", "issue", "Lcom/android/tools/idea/common/error/Issue;", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nDesignSurfaceIssueListenerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DesignSurfaceIssueListenerImpl.kt\ncom/android/tools/idea/common/surface/DesignSurfaceIssueListenerImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,74:1\n766#2:75\n857#2,2:76\n1360#2:78\n1446#2,5:79\n1855#2,2:84\n*S KotlinDebug\n*F\n+ 1 DesignSurfaceIssueListenerImpl.kt\ncom/android/tools/idea/common/surface/DesignSurfaceIssueListenerImpl\n*L\n50#1:75\n50#1:76,2\n50#1:78\n50#1:79,5\n58#1:84,2\n*E\n"})
public final class DesignSurfaceIssueListenerImpl
implements IssueListener {
    @NotNull
    private final DesignSurface<?> surface;

    public DesignSurfaceIssueListenerImpl(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.surface = surface2;
    }

    @NotNull
    public final DesignSurface<?> getSurface() {
        return this.surface;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onIssueSelected(@NotNull Issue issue) {
        block6: {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            SceneManager it;
            void $this$filterTo$iv$iv;
            IssueSource source;
            block5: {
                PsiElement element;
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                source = issue.getSource();
                if (!(source instanceof NlComponentIssueSource)) break block5;
                NlComponent nlComponent = ((NlComponentIssueSource)source).getComponent();
                if (nlComponent == null) {
                    return;
                }
                NlComponent component2 = nlComponent;
                this.surface.getSelectionModel().setSelection(CollectionsKt.listOf((Object)component2));
                XmlTag xmlTag = component2.getBackend().getTag();
                Object object = element = xmlTag != null ? xmlTag.getNavigationElement() : null;
                if (!(element instanceof Navigatable) || !PsiNavigationSupport.getInstance().canNavigate(element)) break block6;
                ((Navigatable)element).navigate(false);
                break block6;
            }
            if (!(source instanceof VisualLintIssueProvider.VisualLintIssueSource)) break block6;
            this.surface.repaint();
            ImmutableList<?> immutableList = this.surface.getSceneManagers();
            Intrinsics.checkNotNullExpressionValue(immutableList, (String)"surface.sceneManagers");
            Iterable $this$filter$iv = (Iterable)immutableList;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (SceneManager)element$iv$iv;
                boolean bl = false;
                if (!((VisualLintIssueProvider.VisualLintIssueSource)source).getModels().contains(it.getModel())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$flatMap = false;
            $this$filterTo$iv$iv = $this$flatMap$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (SceneManager)element$iv$iv;
                boolean bl = false;
                List<SceneView> list = it.getSceneViews();
                Intrinsics.checkNotNullExpressionValue(list, (String)"it.sceneViews");
                Iterable list$iv$iv = list;
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            List sceneViews = (List)destination$iv$iv;
            if (sceneViews.isEmpty()) {
                return;
            }
            int minX = 0;
            minX = Integer.MAX_VALUE;
            int minY = 0;
            minY = Integer.MAX_VALUE;
            int maxX = 0;
            maxX = Integer.MIN_VALUE;
            int maxY = 0;
            maxY = Integer.MIN_VALUE;
            Iterable $this$forEach$iv = sceneViews;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SceneView it2 = (SceneView)element$iv;
                boolean bl = false;
                minX = Math.min(minX, it2.getX());
                minY = Math.min(minY, it2.getY());
                maxX = Math.max(maxX, it2.getX() + it2.getScaledContentSize().width);
                maxY = Math.max(maxY, it2.getY() + it2.getScaledContentSize().height);
            }
            double currentScale = this.surface.getScale();
            Dimension size = new Dimension((int)((double)(maxX - minX + 40) / currentScale), (int)((double)(maxY - minY + 40) / currentScale));
            double scale = DesignSurfaceHelper.getFitContentIntoWindowScale(this.surface, size);
            this.surface.setScale(scale);
            this.surface.setScrollPosition(minX - 20, minY - 20);
        }
    }
}

