/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.DragEnterEvent;
import com.android.tools.idea.common.surface.DragExistEvent;
import com.android.tools.idea.common.surface.DragOverEvent;
import com.android.tools.idea.common.surface.DropActionChangedEvent;
import com.android.tools.idea.common.surface.DropEvent;
import com.android.tools.idea.common.surface.Interactable;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionEvent;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.InteractionInformation;
import com.android.tools.idea.common.surface.InteractionNonInputEvent;
import com.android.tools.idea.common.surface.KeyPressedEvent;
import com.android.tools.idea.common.surface.KeyReleasedEvent;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.MouseDraggedEvent;
import com.android.tools.idea.common.surface.MouseMovedEvent;
import com.android.tools.idea.common.surface.MousePressedEvent;
import com.android.tools.idea.common.surface.MouseReleasedEvent;
import com.android.tools.idea.common.surface.MouseWheelMovedEvent;
import com.android.tools.idea.common.surface.MouseWheelStopEvent;
import com.android.tools.idea.common.surface.ScrollInteraction;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.surface.DragDropInteraction;
import com.android.tools.idea.uibuilder.surface.interaction.PanInteraction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class GuiInputHandler
implements Disposable {
    public static final DataKey<Component> CURSOR_RECEIVER = DataKey.create((String)(GuiInputHandler.class.getName() + ".cursorReceiver"));
    private static final int HOVER_DELAY_MS = Registry.intValue((String)"ide.tooltip.initialDelay");
    private static final int SCROLL_END_TIME_MS = 500;
    @NotNull
    private final Interactable myInteractable;
    @NotNull
    private final InteractionHandler myInteractionHandler;
    @Nullable
    private Interaction myCurrentInteraction;
    @Nullable
    private List<Layer> myLayers;
    protected int myLastMouseX;
    protected int myLastMouseY;
    @JdkConstants.InputEventMask
    protected int myLastModifiersEx;
    private final Timer myHoverTimer;
    private final Timer myScrollEndTimer;
    private final ActionListener myScrollEndListener;
    private final Listener myListener;
    private DropTarget myDropTarget;
    private boolean myIsListening;
    private boolean myIsInteractionCanceled;

    public GuiInputHandler(@NotNull Disposable disposableParent, @NotNull Interactable interactable, @NotNull InteractionHandler provider2) {
        if (disposableParent == null) {
            GuiInputHandler.$$$reportNull$$$0(0);
        }
        if (interactable == null) {
            GuiInputHandler.$$$reportNull$$$0(1);
        }
        if (provider2 == null) {
            GuiInputHandler.$$$reportNull$$$0(2);
        }
        this.myInteractable = interactable;
        this.myInteractionHandler = provider2;
        Disposer.register((Disposable)disposableParent, (Disposable)this);
        this.myListener = new Listener();
        this.myHoverTimer = new Timer(HOVER_DELAY_MS, null);
        this.myHoverTimer.setRepeats(false);
        this.myScrollEndTimer = new Timer(500, null);
        this.myScrollEndTimer.setRepeats(false);
        this.myScrollEndListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GuiInputHandler.this.myScrollEndTimer.removeActionListener(this);
                if (GuiInputHandler.this.myCurrentInteraction instanceof ScrollInteraction) {
                    GuiInputHandler.this.finishInteraction(new MouseWheelStopEvent(e, GuiInputHandler.this.getInteractionInformation()), false);
                }
            }
        };
    }

    public void dispose() {
        this.myHoverTimer.stop();
        this.myScrollEndTimer.stop();
    }

    @NotNull
    public Interactable getInteractable() {
        Interactable interactable = this.myInteractable;
        if (interactable == null) {
            GuiInputHandler.$$$reportNull$$$0(3);
        }
        return interactable;
    }

    public boolean isPanning() {
        return this.myCurrentInteraction instanceof PanInteraction;
    }

    public void startListening() {
        if (this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.myInteractable.getInteractionPane();
        layeredPane.addMouseMotionListener(this.myListener);
        layeredPane.addMouseWheelListener(this.myListener);
        layeredPane.addMouseListener(this.myListener);
        layeredPane.addKeyListener(this.myListener);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myDropTarget = new DropTarget(this.myInteractable.getInteractionPane(), 3, this.myListener, true, null);
        }
        this.myHoverTimer.addActionListener(this.myListener);
        this.myIsListening = true;
    }

    public void stopListening() {
        if (!this.myIsListening) {
            return;
        }
        JComponent layeredPane = this.myInteractable.getInteractionPane();
        layeredPane.removeMouseMotionListener(this.myListener);
        layeredPane.removeMouseWheelListener(this.myListener);
        layeredPane.removeMouseListener(this.myListener);
        layeredPane.removeKeyListener(this.myListener);
        if (this.myDropTarget != null) {
            this.myDropTarget.removeDropTargetListener(this.myListener);
        }
        this.myHoverTimer.removeActionListener(this.myListener);
        this.myHoverTimer.stop();
        this.myIsListening = false;
    }

    private void startInteraction(@NotNull InteractionEvent event, @Nullable Interaction interaction) {
        if (event == null) {
            GuiInputHandler.$$$reportNull$$$0(4);
        }
        if (this.myCurrentInteraction != null) {
            this.finishInteraction(event, true);
            assert (this.myCurrentInteraction == null);
        }
        if (interaction != null) {
            this.myCurrentInteraction = interaction;
            this.myCurrentInteraction.begin(event);
            this.myLayers = interaction.createOverlays();
        }
    }

    @NotNull
    List<Layer> getLayers() {
        Object object = this.myLayers != null ? this.myLayers : ImmutableList.of();
        if (object == null) {
            GuiInputHandler.$$$reportNull$$$0(5);
        }
        return object;
    }

    @JdkConstants.InputEventMask
    public int getLastModifiersEx() {
        return this.myLastModifiersEx;
    }

    @TestOnly
    public void setModifier(@JdkConstants.InputEventMask int modifier) {
        this.myLastModifiersEx = modifier;
    }

    private void updateMouseMoved(@NotNull MouseEvent event, int x, int y) {
        if (event == null) {
            GuiInputHandler.$$$reportNull$$$0(6);
        }
        if (this.myCurrentInteraction != null) {
            this.myCurrentInteraction.update(new MouseMovedEvent(event, this.getInteractionInformation()));
        } else {
            this.myInteractionHandler.hoverWhenNoInteraction(x, y, this.myLastModifiersEx);
        }
    }

    private void finishInteraction(@NotNull InteractionEvent event, boolean canceled) {
        if (event == null) {
            GuiInputHandler.$$$reportNull$$$0(7);
        }
        if (this.myCurrentInteraction != null) {
            if (canceled) {
                this.myCurrentInteraction.cancel(event);
            } else {
                this.myCurrentInteraction.commit(event);
            }
            if (this.myLayers != null) {
                for (Layer layer : this.myLayers) {
                    layer.dispose();
                }
                this.myLayers = null;
            }
            this.myCurrentInteraction = null;
            this.myLastModifiersEx = 0;
            this.myInteractionHandler.hoverWhenNoInteraction(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
            this.myInteractable.repaintComponent();
        }
    }

    void updateCursor(int x, int y, @JdkConstants.InputEventMask int modifiersEx) {
        Component cursorReceiver = this.myInteractable.getCursorReceiver();
        if (cursorReceiver == null) {
            return;
        }
        Cursor cursor = this.myCurrentInteraction == null ? this.myInteractionHandler.getCursorWhenNoInteraction(x, y, modifiersEx) : this.myCurrentInteraction.getCursor();
        cursorReceiver.setCursor(cursor != Cursor.getDefaultCursor() ? cursor : null);
    }

    public boolean isInteractionInProgress() {
        return this.myCurrentInteraction != null;
    }

    void setPanning(boolean panning) {
        Pannable pannable = this.myInteractable.getPannable();
        if (panning && !(this.myCurrentInteraction instanceof PanInteraction)) {
            this.startInteraction(new InteractionNonInputEvent(this.getInteractionInformation()), new PanInteraction(pannable));
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        } else if (!panning && this.myCurrentInteraction instanceof PanInteraction) {
            this.finishInteraction(new InteractionNonInputEvent(this.getInteractionInformation()), false);
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        }
    }

    private void setPanning(@NotNull InteractionEvent event, boolean panning) {
        if (event == null) {
            GuiInputHandler.$$$reportNull$$$0(8);
        }
        if (panning && !(this.myCurrentInteraction instanceof PanInteraction)) {
            Pannable pannable = this.myInteractable.getPannable();
            this.startInteraction(event, new PanInteraction(pannable));
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        } else if (!panning && this.myCurrentInteraction instanceof PanInteraction) {
            this.finishInteraction(event, false);
            this.updateCursor(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
        }
    }

    public boolean interceptPanInteraction(@NotNull MouseEvent event) {
        if (event == null) {
            GuiInputHandler.$$$reportNull$$$0(9);
        }
        boolean wheelClickDown = SwingUtilities.isMiddleMouseButton(event);
        if (this.isPanning() || wheelClickDown) {
            boolean leftClickDown = SwingUtilities.isLeftMouseButton(event);
            Component cursorHolder = this.myInteractable.getCursorReceiver();
            if (cursorHolder != null) {
                cursorHolder.setCursor(AdtUiCursorsProvider.getInstance().getCursor(leftClickDown || wheelClickDown ? AdtUiCursorType.GRABBING : AdtUiCursorType.GRAB));
            }
            return true;
        }
        return false;
    }

    public void cancelInteraction() {
        this.finishInteraction(new InteractionNonInputEvent(this.getInteractionInformation()), true);
    }

    @NotNull
    private InteractionInformation getInteractionInformation() {
        return new InteractionInformation(this.myLastMouseX, this.myLastMouseY, this.myLastModifiersEx);
    }

    @VisibleForTesting
    public Object getListener() {
        return this.myListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposableParent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interactable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/surface/GuiInputHandler";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/surface/GuiInputHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInteractable";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "startInteraction";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateMouseMoved";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "finishInteraction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setPanning";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "interceptPanInteraction";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 3, 5 -> new IllegalStateException(string2);
        };
    }

    private class Listener
    implements MouseMotionListener,
    MouseListener,
    KeyListener,
    DropTargetListener,
    ActionListener,
    MouseWheelListener {
        private Listener() {
        }

        @Override
        public void mouseClicked(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(0);
            }
            int x = event.getX();
            int y = event.getY();
            int clickCount = event.getClickCount();
            if (clickCount == 2 && event.getButton() == 1) {
                GuiInputHandler.this.myInteractionHandler.doubleClick(x, y, GuiInputHandler.this.myLastModifiersEx);
                return;
            }
            if (clickCount == 1 && event.getButton() == 1 && !event.isShiftDown() && !AdtUiUtils.isActionKeyDown((InputEvent)event)) {
                GuiInputHandler.this.myInteractionHandler.singleClick(x, y, GuiInputHandler.this.myLastModifiersEx);
            }
            if (event.isPopupTrigger()) {
                GuiInputHandler.this.myInteractionHandler.popupMenuTrigger(event);
            }
        }

        @Override
        public void mousePressed(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(1);
            }
            if (event.getID() == 501) {
                GuiInputHandler.this.myInteractable.getInteractionPane().requestFocusInWindow();
            }
            GuiInputHandler.this.myIsInteractionCanceled = false;
            GuiInputHandler.this.myLastMouseX = event.getX();
            GuiInputHandler.this.myLastMouseY = event.getY();
            GuiInputHandler.this.myLastModifiersEx = event.getModifiersEx();
            if (event.isPopupTrigger()) {
                GuiInputHandler.this.myInteractionHandler.popupMenuTrigger(event);
                event.consume();
                return;
            }
            if (SwingUtilities.isRightMouseButton(event)) {
                return;
            }
            if (GuiInputHandler.this.myCurrentInteraction instanceof PanInteraction) {
                GuiInputHandler.this.myCurrentInteraction.update(new MousePressedEvent(event, GuiInputHandler.this.getInteractionInformation()));
                GuiInputHandler.this.updateCursor(GuiInputHandler.this.myLastMouseX, GuiInputHandler.this.myLastMouseY, GuiInputHandler.this.myLastModifiersEx);
                return;
            }
            if (SwingUtilities.isMiddleMouseButton(event)) {
                Pannable pannable = GuiInputHandler.this.myInteractable.getPannable();
                GuiInputHandler.this.startInteraction(new MousePressedEvent(event, GuiInputHandler.this.getInteractionInformation()), new PanInteraction(pannable));
                GuiInputHandler.this.updateCursor(GuiInputHandler.this.myLastMouseX, GuiInputHandler.this.myLastMouseY, GuiInputHandler.this.myLastModifiersEx);
                return;
            }
            Interaction interaction = GuiInputHandler.this.myInteractionHandler.createInteractionOnPressed(GuiInputHandler.this.myLastMouseX, GuiInputHandler.this.myLastMouseY, GuiInputHandler.this.myLastModifiersEx);
            if (interaction != null) {
                GuiInputHandler.this.startInteraction(new MousePressedEvent(event, GuiInputHandler.this.getInteractionInformation()), interaction);
            }
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(2);
            }
            if (GuiInputHandler.this.myIsInteractionCanceled) {
                return;
            }
            if (event.isPopupTrigger()) {
                GuiInputHandler.this.myInteractionHandler.popupMenuTrigger(event);
                return;
            }
            if (GuiInputHandler.this.myCurrentInteraction instanceof PanInteraction) {
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    GuiInputHandler.this.finishInteraction(new MouseReleasedEvent(event, GuiInputHandler.this.getInteractionInformation()), true);
                } else {
                    GuiInputHandler.this.myCurrentInteraction.update(new MouseReleasedEvent(event, new InteractionInformation(event.getX(), event.getY(), event.getModifiersEx())));
                    GuiInputHandler.this.updateCursor(GuiInputHandler.this.myLastMouseX, GuiInputHandler.this.myLastMouseY, GuiInputHandler.this.myLastModifiersEx);
                }
                return;
            }
            if (GuiInputHandler.this.interceptPanInteraction(event)) {
                if (SwingUtilities.isMiddleMouseButton(event)) {
                    GuiInputHandler.this.setPanning(false);
                }
                return;
            }
            if (event.getButton() > 1 || SystemInfo.isMac && event.isControlDown()) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            int modifiersEx = event.getModifiersEx();
            if (GuiInputHandler.this.myCurrentInteraction == null) {
                GuiInputHandler.this.myInteractionHandler.mouseReleaseWhenNoInteraction(x, y, modifiersEx);
                GuiInputHandler.this.updateCursor(x, y, modifiersEx);
            } else {
                GuiInputHandler.this.finishInteraction(new MouseReleasedEvent(event, GuiInputHandler.this.getInteractionInformation()), false);
                GuiInputHandler.this.myCurrentInteraction = null;
            }
            GuiInputHandler.this.myInteractable.repaintComponent();
        }

        @Override
        public void mouseEntered(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(3);
            }
            GuiInputHandler.this.myHoverTimer.restart();
        }

        @Override
        public void mouseExited(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(4);
            }
            GuiInputHandler.this.myHoverTimer.stop();
            GuiInputHandler.this.myInteractionHandler.mouseExited();
        }

        @Override
        public void mouseDragged(MouseEvent event) {
            if (GuiInputHandler.this.myIsInteractionCanceled) {
                return;
            }
            int x = event.getX();
            int y = event.getY();
            if (GuiInputHandler.this.myCurrentInteraction instanceof PanInteraction) {
                GuiInputHandler.this.myCurrentInteraction.update(new MouseDraggedEvent(event, new InteractionInformation(x, y, event.getModifiersEx())));
                GuiInputHandler.this.updateCursor(x, y, event.getModifiersEx());
                return;
            }
            if (!SwingUtilities.isLeftMouseButton(event)) {
                return;
            }
            int modifiersEx = event.getModifiersEx();
            if (GuiInputHandler.this.myCurrentInteraction != null) {
                GuiInputHandler.this.myLastMouseX = x;
                GuiInputHandler.this.myLastMouseY = y;
                GuiInputHandler.this.myLastModifiersEx = modifiersEx;
                GuiInputHandler.this.myCurrentInteraction.update(new MouseDraggedEvent(event, GuiInputHandler.this.getInteractionInformation()));
                GuiInputHandler.this.updateCursor(x, y, modifiersEx);
                GuiInputHandler.this.myInteractable.getInteractionPane().scrollRectToVisible(new Rectangle(x - 50, y - 50, 100, 100));
                GuiInputHandler.this.myInteractable.repaintComponent();
            } else {
                x = GuiInputHandler.this.myLastMouseX;
                y = GuiInputHandler.this.myLastMouseY;
                GuiInputHandler.this.myLastModifiersEx = modifiersEx;
                Interaction interaction = GuiInputHandler.this.myInteractionHandler.createInteractionOnDrag(x, y, GuiInputHandler.this.myLastModifiersEx);
                if (interaction != null) {
                    GuiInputHandler.this.startInteraction(new MouseDraggedEvent(event, GuiInputHandler.this.getInteractionInformation()), interaction);
                }
                GuiInputHandler.this.updateCursor(x, y, modifiersEx);
            }
            GuiInputHandler.this.myHoverTimer.restart();
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            if (event == null) {
                Listener.$$$reportNull$$$0(5);
            }
            int x = event.getX();
            int y = event.getY();
            int modifiersEx = event.getModifiersEx();
            GuiInputHandler.this.myLastMouseX = x;
            GuiInputHandler.this.myLastMouseY = y;
            GuiInputHandler.this.myLastModifiersEx = modifiersEx;
            if (GuiInputHandler.this.myCurrentInteraction instanceof PanInteraction) {
                GuiInputHandler.this.myCurrentInteraction.update(new MouseMovedEvent(event, GuiInputHandler.this.getInteractionInformation()));
                GuiInputHandler.this.updateCursor(x, y, modifiersEx);
                return;
            }
            GuiInputHandler.this.updateMouseMoved(event, x, y);
            GuiInputHandler.this.updateCursor(x, y, modifiersEx);
            GuiInputHandler.this.myInteractable.repaintComponent();
            GuiInputHandler.this.myHoverTimer.restart();
        }

        @Override
        public void keyTyped(KeyEvent event) {
            GuiInputHandler.this.myLastModifiersEx = event.getModifiersEx();
        }

        @Override
        public void keyPressed(KeyEvent event) {
            int modifiersEx = event.getModifiersEx();
            int keyCode = event.getKeyCode();
            GuiInputHandler.this.myLastModifiersEx = modifiersEx;
            if (GuiInputHandler.this.myCurrentInteraction != null) {
                if (keyCode == 27) {
                    GuiInputHandler.this.finishInteraction(new KeyPressedEvent(event, GuiInputHandler.this.getInteractionInformation()), true);
                    GuiInputHandler.this.myIsInteractionCanceled = true;
                } else {
                    GuiInputHandler.this.myCurrentInteraction.update(new KeyPressedEvent(event, GuiInputHandler.this.getInteractionInformation()));
                }
                return;
            }
            Interaction interaction = GuiInputHandler.this.myInteractionHandler.keyPressedWithoutInteraction(event);
            if (interaction != null) {
                GuiInputHandler.this.startInteraction(new KeyPressedEvent(event, GuiInputHandler.this.getInteractionInformation()), interaction);
            }
        }

        @Override
        public void keyReleased(KeyEvent event) {
            GuiInputHandler.this.myLastModifiersEx = event.getModifiersEx();
            if (GuiInputHandler.this.myCurrentInteraction != null) {
                if (GuiInputHandler.this.myCurrentInteraction instanceof PanInteraction && event.getKeyCode() == DesignSurfaceShortcut.PAN.getKeyCode()) {
                    GuiInputHandler.this.setPanning(new KeyReleasedEvent(event, GuiInputHandler.this.getInteractionInformation()), false);
                    GuiInputHandler.this.updateCursor(GuiInputHandler.this.myLastMouseX, GuiInputHandler.this.myLastMouseY, GuiInputHandler.this.myLastModifiersEx);
                } else {
                    GuiInputHandler.this.myCurrentInteraction.update(new KeyReleasedEvent(event, GuiInputHandler.this.getInteractionInformation()));
                }
                return;
            }
            GuiInputHandler.this.myInteractionHandler.keyReleasedWithoutInteraction(event);
        }

        @Override
        public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
            if (dragEvent == null) {
                Listener.$$$reportNull$$$0(6);
            }
            if (GuiInputHandler.this.myCurrentInteraction == null) {
                Point location = dragEvent.getLocation();
                GuiInputHandler.this.myLastMouseX = location.x;
                GuiInputHandler.this.myLastMouseY = location.y;
                Interaction interaction = GuiInputHandler.this.myInteractionHandler.createInteractionOnDragEnter(dragEvent);
                GuiInputHandler.this.startInteraction(new DragEnterEvent(dragEvent, GuiInputHandler.this.getInteractionInformation()), interaction);
            }
        }

        @Override
        public void dragOver(DropTargetDragEvent dragEvent) {
            Point location = dragEvent.getLocation();
            GuiInputHandler.this.myLastMouseX = location.x;
            GuiInputHandler.this.myLastMouseY = location.y;
            NlDropEvent event = new NlDropEvent(dragEvent);
            if (GuiInputHandler.this.myCurrentInteraction == null) {
                event.reject();
                return;
            }
            GuiInputHandler.this.myCurrentInteraction.update(new DragOverEvent(dragEvent, GuiInputHandler.this.getInteractionInformation()));
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent event) {
            if (GuiInputHandler.this.myCurrentInteraction != null) {
                GuiInputHandler.this.myCurrentInteraction.update(new DropActionChangedEvent(event, GuiInputHandler.this.getInteractionInformation()));
            }
        }

        @Override
        public void dragExit(DropTargetEvent event) {
            if (GuiInputHandler.this.myCurrentInteraction instanceof DragDropInteraction) {
                GuiInputHandler.this.finishInteraction(new DragExistEvent(event, GuiInputHandler.this.getInteractionInformation()), true);
            }
        }

        @Override
        public void drop(@NotNull DropTargetDropEvent dropEvent) {
            if (dropEvent == null) {
                Listener.$$$reportNull$$$0(7);
            }
            Point location = dropEvent.getLocation();
            GuiInputHandler.this.myLastMouseX = location.x;
            GuiInputHandler.this.myLastMouseY = location.y;
            NlDropEvent event = new NlDropEvent(dropEvent);
            if (!(GuiInputHandler.this.myCurrentInteraction instanceof DragDropInteraction)) {
                event.reject();
                return;
            }
            GuiInputHandler.this.finishInteraction(new DropEvent(dropEvent, GuiInputHandler.this.getInteractionInformation()), false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() != GuiInputHandler.this.myHoverTimer) {
                return;
            }
            int x = GuiInputHandler.this.myLastMouseX;
            int y = GuiInputHandler.this.myLastMouseY;
            GuiInputHandler.this.myInteractionHandler.stayHovering(x, y);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            int scrollAmount;
            int x = e.getX();
            int y = e.getY();
            if (e.getScrollType() == 0) {
                scrollAmount = e.getUnitsToScroll();
            } else {
                int n = scrollAmount = e.getWheelRotation() < 0 ? -1 : 1;
            }
            if (!e.isShiftDown() && (SystemInfo.isMac && e.isMetaDown() || e.isControlDown())) {
                if (scrollAmount < 0) {
                    GuiInputHandler.this.myInteractionHandler.zoom(ZoomType.IN, x, y);
                } else if (scrollAmount > 0) {
                    GuiInputHandler.this.myInteractionHandler.zoom(ZoomType.OUT, x, y);
                }
                return;
            }
            if (GuiInputHandler.this.myCurrentInteraction == null) {
                Interaction scrollInteraction = GuiInputHandler.this.myInteractionHandler.createInteractionOnMouseWheelMoved(e);
                if (scrollInteraction == null) {
                    e.getComponent().getParent().dispatchEvent(e);
                    return;
                }
                GuiInputHandler.this.startInteraction(new MouseWheelMovedEvent(e, GuiInputHandler.this.getInteractionInformation()), scrollInteraction);
                GuiInputHandler.this.myScrollEndTimer.addActionListener(GuiInputHandler.this.myScrollEndListener);
            }
            boolean isScrollInteraction = GuiInputHandler.this.myCurrentInteraction instanceof ScrollInteraction;
            GuiInputHandler.this.myCurrentInteraction.update(new MouseWheelMovedEvent(e, GuiInputHandler.this.getInteractionInformation()));
            if (isScrollInteraction) {
                GuiInputHandler.this.myScrollEndTimer.restart();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dragEvent";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dropEvent";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/common/surface/GuiInputHandler$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseClicked";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mousePressed";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseReleased";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseEntered";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseExited";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dragEnter";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "drop";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

