/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.util;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.MoreObjects;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class NlTreeDumper {
    private final Map<NlComponent, Integer> myComponentIds;
    private final boolean myIncludeIdentity;
    private final boolean myShowBoundaries;

    public NlTreeDumper() {
        this(true, true);
    }

    public NlTreeDumper(boolean includeIdentity, boolean showBoundaries) {
        this.myComponentIds = includeIdentity ? new HashMap() : Collections.emptyMap();
        this.myIncludeIdentity = includeIdentity;
        this.myShowBoundaries = showBoundaries;
    }

    @NotNull
    public static String dumpTree(@NotNull List<NlComponent> roots) {
        if (roots == null) {
            NlTreeDumper.$$$reportNull$$$0(0);
        }
        String string2 = new NlTreeDumper(false, true).toTree(roots);
        if (string2 == null) {
            NlTreeDumper.$$$reportNull$$$0(1);
        }
        return string2;
    }

    @NotNull
    public String toTree(@NotNull List<NlComponent> roots) {
        if (roots == null) {
            NlTreeDumper.$$$reportNull$$$0(2);
        }
        StringBuilder sb = new StringBuilder(200);
        for (NlComponent root : roots) {
            this.describe(sb, root, 0, new HashSet<NlComponent>());
        }
        String string2 = sb.toString().trim();
        if (string2 == null) {
            NlTreeDumper.$$$reportNull$$$0(3);
        }
        return string2;
    }

    private void describe(@NotNull StringBuilder sb, @NotNull NlComponent component2, int depth, @NotNull HashSet<NlComponent> visited) {
        if (sb == null) {
            NlTreeDumper.$$$reportNull$$$0(4);
        }
        if (component2 == null) {
            NlTreeDumper.$$$reportNull$$$0(5);
        }
        if (visited == null) {
            NlTreeDumper.$$$reportNull$$$0(6);
        }
        boolean isLoop = !visited.add(component2);
        for (int i = 0; i < depth; ++i) {
            sb.append("    ");
        }
        if (isLoop) {
            sb.append("!!LOOP!! ");
        }
        sb.append(this.describe(component2)).append('\n');
        if (isLoop) {
            return;
        }
        for (NlComponent child : component2.getChildren()) {
            this.describe(sb, child, depth + 1, visited);
        }
    }

    @NotNull
    private String describe(@NotNull NlComponent root) {
        if (root == null) {
            NlTreeDumper.$$$reportNull$$$0(7);
        }
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((Object)root).omitNullValues().add("tag", (Object)("<" + root.getTagName() + ">"));
        if (this.myShowBoundaries && NlComponentHelperKt.getHasNlComponentInfo(root)) {
            helper.add("bounds", (Object)("[" + NlComponentHelperKt.getX(root) + "," + NlComponentHelperKt.getY(root) + ":" + NlComponentHelperKt.getW(root) + "x" + NlComponentHelperKt.getH(root)));
        }
        if (this.myIncludeIdentity) {
            helper.add("instance", this.getInstanceId(root));
        }
        String string2 = helper.toString();
        if (string2 == null) {
            NlTreeDumper.$$$reportNull$$$0(8);
        }
        return string2;
    }

    private int getInstanceId(@NotNull NlComponent root) {
        Integer id2;
        if (root == null) {
            NlTreeDumper.$$$reportNull$$$0(9);
        }
        if ((id2 = this.myComponentIds.get(root)) == null) {
            id2 = this.myComponentIds.size();
            this.myComponentIds.put(root, id2);
        }
        return id2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/common/util/NlTreeDumper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/common/util/NlTreeDumper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "dumpTree";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "toTree";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "describe";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dumpTree";
                break;
            }
            case 1: 
            case 3: 
            case 8: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "toTree";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "describe";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceId";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 3, 8 -> new IllegalStateException(string2);
        };
    }
}

