/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.annotator;

import com.android.tools.idea.compose.annotator.DeviceParameterQuickFix;
import com.android.tools.idea.compose.annotator.PreviewAnnotationCheck;
import com.android.tools.idea.compose.annotator.PreviewPickerAnnotationInspection;
import com.android.tools.idea.compose.annotator.PreviewPickerAnnotationInspectionKt;
import com.android.tools.idea.compose.annotator.UtilsKt;
import com.android.tools.idea.compose.annotator.check.common.BadType;
import com.android.tools.idea.compose.annotator.check.common.CheckResult;
import com.android.tools.idea.compose.annotator.check.common.Failure;
import com.android.tools.idea.compose.annotator.check.common.IssueReason;
import com.android.tools.idea.compose.annotator.check.common.Missing;
import com.android.tools.idea.compose.annotator.check.common.Repeated;
import com.android.tools.idea.compose.annotator.check.common.Unknown;
import com.android.tools.idea.compose.preview.BasePreviewAnnotationInspection;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/compose/annotator/PreviewPickerAnnotationInspection;", "Lcom/android/tools/idea/compose/preview/BasePreviewAnnotationInspection;", "()V", "runPreviewPickerChecks", "", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "previewAnnotation", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "isMultiPreview", "", "visitPreviewAnnotation", "annotationClass", "Lorg/jetbrains/kotlin/psi/KtClass;", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nPreviewPickerAnnotationInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreviewPickerAnnotationInspection.kt\ncom/android/tools/idea/compose/annotator/PreviewPickerAnnotationInspection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,215:1\n1477#2:216\n1502#2,3:217\n1505#2,3:227\n1855#2:230\n800#2,11:231\n1549#2:242\n1620#2,3:243\n1856#2:246\n361#3,7:220\n*S KotlinDebug\n*F\n+ 1 PreviewPickerAnnotationInspection.kt\ncom/android/tools/idea/compose/annotator/PreviewPickerAnnotationInspection\n*L\n87#1:216\n87#1:217,3\n87#1:227,3\n89#1:230\n98#1:231,11\n108#1:242\n108#1:243,3\n89#1:246\n87#1:220,7\n*E\n"})
public final class PreviewPickerAnnotationInspection
extends BasePreviewAnnotationInspection {
    @Override
    public void visitPreviewAnnotation(@NotNull ProblemsHolder holder, @NotNull KtNamedFunction function, @NotNull KtAnnotationEntry previewAnnotation, boolean isMultiPreview) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)previewAnnotation, (String)"previewAnnotation");
        this.runPreviewPickerChecks(holder, previewAnnotation, isMultiPreview);
    }

    @Override
    public void visitPreviewAnnotation(@NotNull ProblemsHolder holder, @NotNull KtClass annotationClass, @NotNull KtAnnotationEntry previewAnnotation, boolean isMultiPreview) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)annotationClass, (String)"annotationClass");
        Intrinsics.checkNotNullParameter((Object)previewAnnotation, (String)"previewAnnotation");
        this.runPreviewPickerChecks(holder, previewAnnotation, isMultiPreview);
    }

    /*
     * WARNING - void declaration
     */
    private final void runPreviewPickerChecks(ProblemsHolder holder, KtAnnotationEntry previewAnnotation, boolean isMultiPreview) {
        Object value$iv$iv$iv;
        Object element$iv$iv;
        Iterator $this$groupByTo$iv$iv;
        if (isMultiPreview) {
            return;
        }
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem((PsiElement)((PsiElement)previewAnnotation));
        if (!(androidModuleSystem != null ? UtilsKt.isPreviewPickerEnabled(androidModuleSystem) : false)) {
            return;
        }
        CheckResult result = PreviewAnnotationCheck.INSTANCE.checkPreviewAnnotationIfNeeded(previewAnnotation);
        if (!result.getHasIssues()) {
            return;
        }
        StringBuffer messageBuffer = new StringBuffer();
        Iterable $this$groupBy$iv = result.getIssues();
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator = $this$groupByTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object object;
            element$iv$iv = iterator.next();
            IssueReason it = (IssueReason)element$iv$iv;
            boolean bl = false;
            KClass key$iv$iv = JvmClassMappingKt.getKotlinClass(it.getClass());
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Map groupedIssues = destination$iv$iv;
        Iterable $this$forEach$iv = groupedIssues.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Iterable $this$filterIsInstance$iv;
            String string2;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            element$iv$iv = (KClass)entry.getKey();
            if (Intrinsics.areEqual(element$iv$iv, (Object)Reflection.getOrCreateKotlinClass(BadType.class))) {
                string2 = ComposePreviewBundle.message("picker.preview.annotator.lint.error.type", new Object[0]);
            } else if (Intrinsics.areEqual(element$iv$iv, (Object)Reflection.getOrCreateKotlinClass(Missing.class))) {
                string2 = ComposePreviewBundle.message("picker.preview.annotator.lint.error.missing", new Object[0]);
            } else if (Intrinsics.areEqual(element$iv$iv, (Object)Reflection.getOrCreateKotlinClass(Unknown.class))) {
                string2 = ComposePreviewBundle.message("picker.preview.annotator.lint.error.unknown", new Object[0]);
            } else if (Intrinsics.areEqual(element$iv$iv, (Object)Reflection.getOrCreateKotlinClass(Repeated.class))) {
                string2 = ComposePreviewBundle.message("picker.preview.annotator.lint.error.repeated", new Object[0]);
            } else {
                void $this$filterIsInstanceTo$iv$iv;
                if (!Intrinsics.areEqual(element$iv$iv, (Object)Reflection.getOrCreateKotlinClass(Failure.class))) continue;
                $this$filterIsInstance$iv = (Iterable)entry.getValue();
                boolean $i$f$filterIsInstance = false;
                Iterable key$iv$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv2 : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv2 instanceof Failure)) continue;
                    destination$iv$iv2.add(element$iv$iv2);
                }
                String failureMessage2 = CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv2), (CharSequence)"\n", null, null, (int)0, null, (Function1)runPreviewPickerChecks.1.messagePrefix.failureMessage.1.INSTANCE, (int)30, null);
                Logger.getInstance(PreviewPickerAnnotationInspection.class).warn("Failed when checking annotation: " + failureMessage2);
                continue;
            }
            String messagePrefix2 = string2 + ": ";
            PreviewPickerAnnotationInspectionKt.access$addSimpleMessage(messagePrefix2, (List)entry.getValue(), messageBuffer);
            if (Intrinsics.areEqual(entry.getKey(), (Object)Reflection.getOrCreateKotlinClass(BadType.class))) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)entry.getValue();
                boolean $i$f$map = false;
                $this$filterIsInstance$iv = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    value$iv$iv$iv = (IssueReason)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.android.tools.idea.compose.annotator.check.common.BadType");
                    collection.add((BadType)it);
                }
                PreviewPickerAnnotationInspectionKt.access$addMessageForBadTypeParameters((List)destination$iv$iv3, messageBuffer);
            }
            messageBuffer.append('\n');
        }
        if (((CharSequence)messageBuffer).length() > 0 && result.getProposedFix() != null) {
            Object element$iv;
            String string3 = messageBuffer.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"messageBuffer.toString()");
            String message = ((Object)StringsKt.trim((CharSequence)string3)).toString();
            element$iv = UastContextKt.toUElement((PsiElement)((PsiElement)previewAnnotation));
            UAnnotation uAnnotation = element$iv instanceof UAnnotation ? (UAnnotation)element$iv : null;
            if (uAnnotation == null) {
                return;
            }
            UAnnotation uElement = uAnnotation;
            UExpression uExpression = uElement.findDeclaredAttributeValue("device");
            if (uExpression == null) {
                return;
            }
            UExpression deviceValueExpression = uExpression;
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)((UElement)deviceValueExpression));
            if (psiElement == null) {
                return;
            }
            PsiElement deviceValueElement = psiElement;
            LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new DeviceParameterQuickFix(deviceValueElement, result.getProposedFix())};
            holder.registerProblem(deviceValueElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, localQuickFixArray);
        }
    }
}

