/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.pickers.base.tracking;

import com.android.annotations.concurrency.Slow;
import com.android.sdklib.devices.Device;
import com.android.tools.idea.compose.pickers.base.tracking.ComposePickerTracker;
import com.google.wireless.android.sdk.stats.EditorPickerEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u00002\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\fH$J\u0016\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\fH$J\b\u0010\u0011\u001a\u00020\u000fH\u0007J\u0006\u0010\u0012\u001a\u00020\u000fJ\u0006\u0010\u0013\u001a\u00020\u000fJ \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/idea/compose/pickers/base/tracking/BaseComposePickerTracker;", "Lcom/android/tools/idea/compose/pickers/base/tracking/ComposePickerTracker;", "()V", "allowSubmittingTrackingInfo", "", "isPickerVisible", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "modifications", "", "Lcom/android/tools/idea/compose/pickers/base/tracking/BaseComposePickerTracker$PickerModification;", "convertModificationsToTrackerActions", "", "Lcom/google/wireless/android/sdk/stats/EditorPickerEvent$EditorPickerAction;", "doLogUsageData", "", "actions", "logUsageData", "pickerClosed", "pickerShown", "registerModification", "name", "", "value", "Lcom/google/wireless/android/sdk/stats/EditorPickerEvent$EditorPickerAction$PreviewPickerModification$PreviewPickerValue;", "device", "Lcom/android/sdklib/devices/Device;", "PickerModification", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nBaseComposePickerTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseComposePickerTracker.kt\ncom/android/tools/idea/compose/pickers/base/tracking/BaseComposePickerTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,93:1\n8#2:94\n*S KotlinDebug\n*F\n+ 1 BaseComposePickerTracker.kt\ncom/android/tools/idea/compose/pickers/base/tracking/BaseComposePickerTracker\n*L\n34#1:94\n*E\n"})
public abstract class BaseComposePickerTracker
implements ComposePickerTracker {
    @NotNull
    private final Logger log;
    @NotNull
    private final List<PickerModification> modifications;
    private boolean allowSubmittingTrackingInfo;
    private boolean isPickerVisible;

    public BaseComposePickerTracker() {
        BaseComposePickerTracker $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger2 = Logger.getInstance(BaseComposePickerTracker.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(T::class.java)");
        this.log = logger2;
        this.modifications = new ArrayList();
    }

    @Override
    public final void pickerShown() {
        this.isPickerVisible = true;
    }

    @Override
    public final void pickerClosed() {
        if (this.isPickerVisible) {
            this.allowSubmittingTrackingInfo = true;
            this.isPickerVisible = false;
        }
    }

    @Override
    public final void registerModification(@NotNull String name, @NotNull EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue value2, @Nullable Device device) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        if (!this.isPickerVisible) {
            this.log.warn("Attempted to register a modification when the picker is not visible");
            return;
        }
        this.modifications.add(new PickerModification(name, value2, device));
    }

    @Override
    @Slow
    public final void logUsageData() {
        if (!this.allowSubmittingTrackingInfo) {
            this.log.warn("Attempted to submit usage data in an invalid state");
            return;
        }
        List<EditorPickerEvent.EditorPickerAction> actions2 = this.convertModificationsToTrackerActions(this.modifications);
        this.doLogUsageData(actions2);
        this.modifications.clear();
        this.allowSubmittingTrackingInfo = false;
    }

    protected abstract void doLogUsageData(@NotNull List<EditorPickerEvent.EditorPickerAction> var1);

    @NotNull
    protected abstract List<EditorPickerEvent.EditorPickerAction> convertModificationsToTrackerActions(@NotNull List<PickerModification> var1);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0084\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0011\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J)\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/compose/pickers/base/tracking/BaseComposePickerTracker$PickerModification;", "", "propertyName", "", "assignedValue", "Lcom/google/wireless/android/sdk/stats/EditorPickerEvent$EditorPickerAction$PreviewPickerModification$PreviewPickerValue;", "deviceBeforeModification", "Lcom/android/sdklib/devices/Device;", "(Ljava/lang/String;Lcom/google/wireless/android/sdk/stats/EditorPickerEvent$EditorPickerAction$PreviewPickerModification$PreviewPickerValue;Lcom/android/sdklib/devices/Device;)V", "getAssignedValue", "()Lcom/google/wireless/android/sdk/stats/EditorPickerEvent$EditorPickerAction$PreviewPickerModification$PreviewPickerValue;", "getDeviceBeforeModification", "()Lcom/android/sdklib/devices/Device;", "getPropertyName", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.compose-designer"})
    protected static final class PickerModification {
        @NotNull
        private final String propertyName;
        @NotNull
        private final EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue assignedValue;
        @Nullable
        private final Device deviceBeforeModification;

        public PickerModification(@NotNull String propertyName, @NotNull EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue assignedValue, @Nullable Device deviceBeforeModification) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            Intrinsics.checkNotNullParameter((Object)((Object)assignedValue), (String)"assignedValue");
            this.propertyName = propertyName;
            this.assignedValue = assignedValue;
            this.deviceBeforeModification = deviceBeforeModification;
        }

        @NotNull
        public final String getPropertyName() {
            return this.propertyName;
        }

        @NotNull
        public final EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue getAssignedValue() {
            return this.assignedValue;
        }

        @Nullable
        public final Device getDeviceBeforeModification() {
            return this.deviceBeforeModification;
        }

        @NotNull
        public final String component1() {
            return this.propertyName;
        }

        @NotNull
        public final EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue component2() {
            return this.assignedValue;
        }

        @Nullable
        public final Device component3() {
            return this.deviceBeforeModification;
        }

        @NotNull
        public final PickerModification copy(@NotNull String propertyName, @NotNull EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue assignedValue, @Nullable Device deviceBeforeModification) {
            Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
            Intrinsics.checkNotNullParameter((Object)((Object)assignedValue), (String)"assignedValue");
            return new PickerModification(propertyName, assignedValue, deviceBeforeModification);
        }

        public static /* synthetic */ PickerModification copy$default(PickerModification pickerModification, String string2, EditorPickerEvent.EditorPickerAction.PreviewPickerModification.PreviewPickerValue previewPickerValue, Device device, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = pickerModification.propertyName;
            }
            if ((n & 2) != 0) {
                previewPickerValue = pickerModification.assignedValue;
            }
            if ((n & 4) != 0) {
                device = pickerModification.deviceBeforeModification;
            }
            return pickerModification.copy(string2, previewPickerValue, device);
        }

        @NotNull
        public String toString() {
            return "PickerModification(propertyName=" + this.propertyName + ", assignedValue=" + this.assignedValue + ", deviceBeforeModification=" + this.deviceBeforeModification + ")";
        }

        public int hashCode() {
            int result = this.propertyName.hashCode();
            result = result * 31 + this.assignedValue.hashCode();
            result = result * 31 + (this.deviceBeforeModification == null ? 0 : this.deviceBeforeModification.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PickerModification)) {
                return false;
            }
            PickerModification pickerModification = (PickerModification)other;
            if (!Intrinsics.areEqual((Object)this.propertyName, (Object)pickerModification.propertyName)) {
                return false;
            }
            if (this.assignedValue != pickerModification.assignedValue) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.deviceBeforeModification, (Object)pickerModification.deviceBeforeModification);
        }
    }
}

