/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.pickers.preview.utils;

import com.android.resources.Density;
import com.android.resources.ScreenOrientation;
import com.android.resources.ScreenRound;
import com.android.resources.ScreenSize;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.DeviceManager;
import com.android.sdklib.devices.Hardware;
import com.android.sdklib.devices.Screen;
import com.android.sdklib.devices.Software;
import com.android.sdklib.devices.State;
import com.android.tools.idea.avdmanager.AvdScreenData;
import com.android.tools.idea.compose.pickers.preview.property.DeviceConfig;
import com.android.tools.idea.compose.pickers.preview.property.DeviceConfigKt;
import com.android.tools.idea.compose.pickers.preview.property.DimUnit;
import com.android.tools.idea.compose.pickers.preview.property.MutableDeviceConfig;
import com.android.tools.idea.compose.pickers.preview.property.Orientation;
import com.android.tools.idea.compose.pickers.preview.property.Shape;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.sdk.AndroidSdkData;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.StudioAndroidSdkData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\f\u0010\u000b\u001a\u00020\b*\u00020\fH\u0000\u001a&\u0010\r\u001a\u0004\u0018\u00010\b*\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0000\u001a&\u0010\u0012\u001a\u0004\u0018\u00010\b*\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u000e\u0010\u0013\u001a\u0004\u0018\u00010\b*\u00020\u0014H\u0000\u001a\f\u0010\u0015\u001a\u00020\f*\u00020\bH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"DEFAULT_DEVICE_ID", "", "DEFAULT_DEVICE_ID_WITH_PREFIX", "DEVICE_BY_ID_PREFIX", "DEVICE_BY_NAME_PREFIX", "DEVICE_BY_SPEC_PREFIX", "getSdkDevices", "", "Lcom/android/sdklib/devices/Device;", "module", "Lcom/intellij/openapi/module/Module;", "createDeviceInstance", "Lcom/android/tools/idea/compose/pickers/preview/property/DeviceConfig;", "findByIdOrName", "", "deviceDefinition", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "findOrParseFromDefinition", "getDefaultPreviewDevice", "Lcom/android/tools/idea/configurations/ConfigurationManager;", "toDeviceConfig", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nDeviceUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/idea/compose/pickers/preview/utils/DeviceUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1#2:231\n288#3,2:232\n288#3,2:234\n766#3:236\n857#3,2:237\n*S KotlinDebug\n*F\n+ 1 DeviceUtils.kt\ncom/android/tools/idea/compose/pickers/preview/utils/DeviceUtilsKt\n*L\n194#1:232,2\n202#1:234,2\n225#1:236\n225#1:237,2\n*E\n"})
public final class DeviceUtilsKt {
    @NotNull
    public static final String DEVICE_BY_ID_PREFIX = "id:";
    @NotNull
    public static final String DEVICE_BY_NAME_PREFIX = "name:";
    @NotNull
    public static final String DEVICE_BY_SPEC_PREFIX = "spec:";
    @NotNull
    public static final String DEFAULT_DEVICE_ID = "pixel_5";
    @NotNull
    public static final String DEFAULT_DEVICE_ID_WITH_PREFIX = "id:pixel_5";

    @NotNull
    public static final DeviceConfig toDeviceConfig(@NotNull Device $this$toDeviceConfig) {
        MutableDeviceConfig mutableDeviceConfig;
        Intrinsics.checkNotNullParameter((Object)$this$toDeviceConfig, (String)"<this>");
        MutableDeviceConfig $this$toDeviceConfig_u24lambda_u240 = mutableDeviceConfig = new MutableDeviceConfig(null, 0.0f, 0.0f, null, 0, null, 0.0f, null, null, 511, null);
        boolean bl = false;
        $this$toDeviceConfig_u24lambda_u240.setDimUnit(DimUnit.px);
        MutableDeviceConfig config = mutableDeviceConfig;
        State deviceState = $this$toDeviceConfig.getDefaultState();
        Screen screen = deviceState.getHardware().getScreen();
        config.setWidth(screen.getXDimension());
        config.setHeight(screen.getYDimension());
        config.setDpi(screen.getPixelDensity().getDpiValue());
        ScreenOrientation screenOrientation = deviceState.getOrientation();
        config.setOrientation((screenOrientation == null ? -1 : WhenMappings.$EnumSwitchMapping$0[screenOrientation.ordinal()]) == 1 ? Orientation.landscape : Orientation.portrait);
        if (screen.getScreenRound() == ScreenRound.ROUND) {
            Object object = StudioFlags.COMPOSE_PREVIEW_DEVICESPEC_INJECTOR.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"COMPOSE_PREVIEW_DEVICESPEC_INJECTOR.get()");
            if (((Boolean)object).booleanValue()) {
                config.setShape(Shape.Round);
                config.setChinSize(screen.getChin());
            } else {
                config.setShape(screen.getChin() != 0 ? Shape.Chin : Shape.Round);
            }
        } else {
            config.setShape(Shape.Normal);
        }
        if (!Intrinsics.areEqual((Object)$this$toDeviceConfig.getId(), (Object)"Custom")) {
            config.setParentDeviceId($this$toDeviceConfig.getId());
        }
        return config;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Device createDeviceInstance(@NotNull DeviceConfig $this$createDeviceInstance) {
        void $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243;
        void $this$createDeviceInstance_u24lambda_u245_u24lambda_u244;
        Screen screen;
        State $this$createDeviceInstance_u24lambda_u242_u24lambda_u241;
        State state;
        Device.Builder builder2;
        Intrinsics.checkNotNullParameter((Object)$this$createDeviceInstance, (String)"<this>");
        MutableDeviceConfig deviceConfig = !($this$createDeviceInstance instanceof MutableDeviceConfig) ? DeviceConfigKt.toMutableConfig($this$createDeviceInstance) : (MutableDeviceConfig)$this$createDeviceInstance;
        Device.Builder $this$createDeviceInstance_u24lambda_u242 = builder2 = new Device.Builder();
        boolean bl = false;
        $this$createDeviceInstance_u24lambda_u242.setTagId("");
        $this$createDeviceInstance_u24lambda_u242.setName("Custom");
        $this$createDeviceInstance_u24lambda_u242.setId("Custom");
        $this$createDeviceInstance_u24lambda_u242.setManufacturer("");
        $this$createDeviceInstance_u24lambda_u242.addSoftware(new Software());
        State state2 = state = new State();
        Device.Builder builder3 = $this$createDeviceInstance_u24lambda_u242;
        boolean bl2 = false;
        $this$createDeviceInstance_u24lambda_u242_u24lambda_u241.setDefaultState(true);
        $this$createDeviceInstance_u24lambda_u242_u24lambda_u241.setHardware(new Hardware());
        builder3.addState(state);
        Device customDevice = builder2.build();
        Device.Builder $this$createDeviceInstance_u24lambda_u245 = builder2 = customDevice.getDefaultState();
        boolean bl3 = false;
        $this$createDeviceInstance_u24lambda_u245.setOrientation(switch (WhenMappings.$EnumSwitchMapping$1[deviceConfig.getOrientation().ordinal()]) {
            case 1 -> ScreenOrientation.LANDSCAPE;
            case 2 -> ScreenOrientation.PORTRAIT;
            default -> throw new NoWhenBranchMatchedException();
        });
        $this$createDeviceInstance_u24lambda_u242_u24lambda_u241 = state = new Hardware();
        builder3 = $this$createDeviceInstance_u24lambda_u245;
        boolean bl4 = false;
        Screen screen2 = screen = new Screen();
        void var12_12 = $this$createDeviceInstance_u24lambda_u245_u24lambda_u244;
        boolean bl5 = false;
        Density density = AvdScreenData.getScreenDensity((boolean)false, (double)deviceConfig.getDpi(), (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)density, (String)"getScreenDensity(false, \u2026Config.dpi.toDouble(), 0)");
        Density resolvedDensity = density;
        deviceConfig.setDpi(resolvedDensity.getDpiValue());
        deviceConfig.setDimUnit(DimUnit.px);
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setXDimension(MathKt.roundToInt((float)deviceConfig.getWidth()));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setYDimension(MathKt.roundToInt((float)deviceConfig.getHeight()));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setPixelDensity(resolvedDensity);
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setDiagonalLength(Math.sqrt(1.0 * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getXDimension() * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getXDimension() + 1.0 * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getYDimension() * (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getYDimension()) / (double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getPixelDensity().getDpiValue());
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setScreenRound(deviceConfig.isRound() ? ScreenRound.ROUND : ScreenRound.NOTROUND);
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setChin(deviceConfig.getShape() == Shape.Chin ? 30 : (deviceConfig.isRound() ? MathKt.roundToInt((float)deviceConfig.getChinSize()) : 0));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setSize(ScreenSize.getScreenSize((Double)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getDiagonalLength()));
        $this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.setRatio(AvdScreenData.getScreenRatio((int)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getXDimension(), (int)$this$createDeviceInstance_u24lambda_u245_u24lambda_u244_u24lambda_u243.getYDimension()));
        var12_12.setScreen(screen);
        builder3.setHardware((Hardware)state);
        Intrinsics.checkNotNullExpressionValue((Object)customDevice, (String)"customDevice");
        return customDevice;
    }

    @Nullable
    public static final Device getDefaultPreviewDevice(@NotNull ConfigurationManager $this$getDefaultPreviewDevice) {
        Device device;
        Object v1;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$getDefaultPreviewDevice, (String)"<this>");
            ImmutableList immutableList = $this$getDefaultPreviewDevice.getDevices();
            Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"devices");
            Iterable iterable = (Iterable)immutableList;
            for (Object t : iterable) {
                Device device2 = (Device)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)device2.getId(), (Object)DEFAULT_DEVICE_ID)) continue;
                v1 = t;
                break block2;
            }
            v1 = null;
        }
        if ((device = (Device)v1) == null) {
            device = $this$getDefaultPreviewDevice.getDefaultDevice();
        }
        return device;
    }

    @Nullable
    public static final Device findOrParseFromDefinition(@NotNull Collection<Device> $this$findOrParseFromDefinition, @NotNull String deviceDefinition, @NotNull Logger logger2) {
        Device device;
        Intrinsics.checkNotNullParameter($this$findOrParseFromDefinition, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceDefinition, (String)"deviceDefinition");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        if (StringsKt.isBlank((CharSequence)deviceDefinition)) {
            device = null;
        } else {
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_SPEC_PREFIX, (boolean)false, (int)2, null)) {
                Device deviceBySpec;
                MutableDeviceConfig mutableDeviceConfig = DeviceConfig.Companion.toMutableDeviceConfigOrNull(deviceDefinition, $this$findOrParseFromDefinition);
                Object object = deviceBySpec = mutableDeviceConfig != null ? DeviceUtilsKt.createDeviceInstance(mutableDeviceConfig) : null;
                if (deviceBySpec == null) {
                    logger2.warn("Unable to parse device configuration: " + deviceDefinition);
                }
                return deviceBySpec;
            }
            device = DeviceUtilsKt.findByIdOrName($this$findOrParseFromDefinition, deviceDefinition, logger2);
        }
        return device;
    }

    public static /* synthetic */ Device findOrParseFromDefinition$default(Collection collection, String string2, Logger logger2, int n, Object object) {
        if ((n & 2) != 0) {
            Logger logger3 = Logger.getInstance(MutableDeviceConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(MutableDeviceConfig::class.java)");
            logger2 = logger3;
        }
        return DeviceUtilsKt.findOrParseFromDefinition(collection, string2, logger2);
    }

    @Nullable
    public static final Device findByIdOrName(@NotNull Collection<Device> $this$findByIdOrName, @NotNull String deviceDefinition, @NotNull Logger logger2) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$findByIdOrName, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)deviceDefinition, (String)"deviceDefinition");
        Intrinsics.checkNotNullParameter((Object)logger2, (String)"logger");
        Collection<Device> availableDevices = $this$findByIdOrName;
        if (StringsKt.isBlank((CharSequence)deviceDefinition)) {
            v0 = null;
        } else {
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_ID_PREFIX, (boolean)false, (int)2, null)) {
                Object v1;
                String id2;
                block8: {
                    id2 = StringsKt.removePrefix((String)deviceDefinition, (CharSequence)DEVICE_BY_ID_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)id2)) continue;
                        v1 = element$iv;
                        break block8;
                    }
                    v1 = null;
                }
                Device deviceById = v1;
                if (deviceById == null) {
                    logger2.warn("Unable to find device with id '" + id2 + "'");
                }
                return deviceById;
            }
            if (StringsKt.startsWith$default((String)deviceDefinition, (String)DEVICE_BY_NAME_PREFIX, (boolean)false, (int)2, null)) {
                Object v2;
                String name;
                block9: {
                    name = StringsKt.removePrefix((String)deviceDefinition, (CharSequence)DEVICE_BY_NAME_PREFIX);
                    Iterable $this$firstOrNull$iv = availableDevices;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Device it = (Device)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getDisplayName(), (Object)name)) continue;
                        v2 = element$iv;
                        break block9;
                    }
                    v2 = null;
                }
                Device deviceByName = v2;
                if (deviceByName == null) {
                    logger2.warn("Unable to find device with name '" + name + "'");
                }
                return deviceByName;
            }
            logger2.warn("Unsupported device definition: " + deviceDefinition);
            v0 = null;
        }
        return v0;
    }

    public static /* synthetic */ Device findByIdOrName$default(Collection collection, String string2, Logger logger2, int n, Object object) {
        if ((n & 2) != 0) {
            Logger logger3 = Logger.getInstance(MutableDeviceConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(MutableDeviceConfig::class.java)");
            logger2 = logger3;
        }
        return DeviceUtilsKt.findByIdOrName(collection, string2, logger2);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Device> getSdkDevices(@NotNull Module module2) {
        Object object;
        block7: {
            block6: {
                List list;
                Collection collection;
                DeviceManager deviceManager;
                Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
                object = AndroidFacet.getInstance((Module)module2);
                if (object == null) break block6;
                AndroidFacet facet = object;
                boolean bl = false;
                AndroidSdkData androidSdkData = StudioAndroidSdkData.Companion.getSdkData(facet);
                if (androidSdkData != null && (deviceManager = androidSdkData.getDeviceManager()) != null && (collection = deviceManager.getDevices(DeviceManager.ALL_DEVICES)) != null) {
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    Iterable iterable = collection;
                    boolean $i$f$filter = false;
                    void var8_8 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        Device it = (Device)element$iv$iv;
                        boolean bl2 = false;
                        if (!(!it.getIsDeprecated())) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                } else {
                    list = null;
                }
                object = list;
                if (list != null) break block7;
            }
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ScreenOrientation.values().length];
            try {
                nArray[ScreenOrientation.LANDSCAPE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Orientation.values().length];
            try {
                nArray[Orientation.landscape.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Orientation.portrait.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

