/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.analytics;

import com.android.tools.idea.compose.preview.analytics.PreviewCanvasTracker;
import com.android.tools.idea.compose.preview.analytics.PreviewCanvasTrackerKt;
import com.android.tools.idea.uibuilder.surface.layout.GridSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.GroupedGridSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.GroupedListSurfaceLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SingleDirectionLayoutManager;
import com.android.tools.idea.uibuilder.surface.layout.SurfaceLayoutManager;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.ComposePreviewCanvasEvent;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/compose/preview/analytics/PreviewCanvasTrackerImpl;", "Lcom/android/tools/idea/compose/preview/analytics/PreviewCanvasTracker;", "myExecutor", "Ljava/util/concurrent/Executor;", "myEventLogger", "Ljava/util/function/Consumer;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "(Ljava/util/concurrent/Executor;Ljava/util/function/Consumer;)V", "logSwitchLayout", "", "layout", "Lcom/android/tools/idea/uibuilder/surface/layout/SurfaceLayoutManager;", "intellij.android.compose-designer"})
public final class PreviewCanvasTrackerImpl
implements PreviewCanvasTracker {
    @NotNull
    private final Executor myExecutor;
    @NotNull
    private final Consumer<AndroidStudioEvent.Builder> myEventLogger;

    public PreviewCanvasTrackerImpl(@NotNull Executor myExecutor, @NotNull Consumer<AndroidStudioEvent.Builder> myEventLogger) {
        Intrinsics.checkNotNullParameter((Object)myExecutor, (String)"myExecutor");
        Intrinsics.checkNotNullParameter(myEventLogger, (String)"myEventLogger");
        this.myExecutor = myExecutor;
        this.myEventLogger = myEventLogger;
    }

    @Override
    public void logSwitchLayout(@NotNull SurfaceLayoutManager layout2) {
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        try {
            SurfaceLayoutManager surfaceLayoutManager = layout2;
            ComposePreviewCanvasEvent.LayoutName layoutName = surfaceLayoutManager instanceof SingleDirectionLayoutManager ? ComposePreviewCanvasEvent.LayoutName.LIST : (surfaceLayoutManager instanceof GridSurfaceLayoutManager ? ComposePreviewCanvasEvent.LayoutName.GRID : (surfaceLayoutManager instanceof GroupedListSurfaceLayoutManager ? ComposePreviewCanvasEvent.LayoutName.GROUPED_LIST : (surfaceLayoutManager instanceof GroupedGridSurfaceLayoutManager ? ComposePreviewCanvasEvent.LayoutName.GROUPED_GRID : ComposePreviewCanvasEvent.LayoutName.UNKNOWN_LAYOUT_NAME)));
            this.myExecutor.execute(() -> PreviewCanvasTrackerImpl.logSwitchLayout$lambda$0(layoutName, this));
        }
        catch (RejectedExecutionException e) {
            PreviewCanvasTrackerKt.access$getLOG().debug("Failed to report compose preview canvas metrics", (Throwable)e);
        }
    }

    private static final void logSwitchLayout$lambda$0(ComposePreviewCanvasEvent.LayoutName $layoutName, PreviewCanvasTrackerImpl this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)$layoutName), (String)"$layoutName");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ComposePreviewCanvasEvent event = ComposePreviewCanvasEvent.newBuilder().setEventType(ComposePreviewCanvasEvent.EventType.SELECT_LAYOUT).setLayoutName($layoutName).build();
        AndroidStudioEvent.Builder studioEvent = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.COMPOSE_PREVIEW_CANVAS_EVENT).setComposePreviewCanvasEvent(event);
        this$0.myEventLogger.accept(studioEvent);
    }
}

