/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import com.android.tools.idea.compose.preview.animation.AnimationPreviewState;
import com.android.tools.idea.compose.preview.animation.InspectorLayout;
import com.android.tools.idea.compose.preview.animation.InspectorPainter;
import com.android.tools.idea.compose.preview.animation.TimelineSliderUI;
import com.android.tools.idea.compose.preview.animation.Tooltip;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElement;
import com.google.wireless.android.sdk.stats.ComposeAnimationToolingEvent;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0016\u0018\u00002\u00020\u0001:\u00011B<\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012%\u0010\u0006\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010&\u001a\u00020\u001aH\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\u000e\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\u0010J\u0010\u0010-\u001a\u00020\f2\u0006\u0010.\u001a\u00020\u0010H\u0016J\b\u0010/\u001a\u00020\fH\u0002J\b\u00100\u001a\u00020\fH\u0016R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u00140\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR0\u0010\u0006\u001a!\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\t\u0012\b\b\n\u0012\u0004\b\b(\u000b\u0012\u0004\u0012\u00020\f0\u0007j\u0002`\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00062"}, d2={"Lcom/android/tools/idea/compose/preview/animation/TimelinePanel;", "Ljavax/swing/JSlider;", "tooltip", "Lcom/android/tools/idea/compose/preview/animation/Tooltip;", "previewState", "Lcom/android/tools/idea/compose/preview/animation/AnimationPreviewState;", "tracker", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/ComposeAnimationToolingEvent$ComposeAnimationToolingEventType;", "Lkotlin/ParameterName;", "name", "type", "", "Lcom/android/tools/idea/compose/preview/animation/ComposeAnimationEventTracker;", "(Lcom/android/tools/idea/compose/preview/animation/Tooltip;Lcom/android/tools/idea/compose/preview/animation/AnimationPreviewState;Lkotlin/jvm/functions/Function1;)V", "cachedMax", "", "cachedSliderWidth", "dragEndListeners", "", "Lkotlin/Function0;", "getDragEndListeners", "()Ljava/util/List;", "getPreviewState", "()Lcom/android/tools/idea/compose/preview/animation/AnimationPreviewState;", "sliderUI", "Lcom/android/tools/idea/compose/preview/animation/TimelineSliderUI;", "getSliderUI", "()Lcom/android/tools/idea/compose/preview/animation/TimelineSliderUI;", "getTooltip", "()Lcom/android/tools/idea/compose/preview/animation/Tooltip;", "getTracker", "()Lkotlin/jvm/functions/Function1;", "zoomValue", "getZoomValue", "()I", "setZoomValue", "(I)V", "createSliderUI", "getFont", "Ljava/awt/Font;", "getPreferredSize", "Ljava/awt/Dimension;", "scale", "z", "setMaximum", "maximum", "updateMajorTicks", "updateUI", "Thumb", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nTimelinePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelinePanel.kt\ncom/android/tools/idea/compose/preview/animation/TimelinePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,440:1\n1#2:441\n*E\n"})
public class TimelinePanel
extends JSlider {
    @NotNull
    private final Tooltip tooltip;
    @NotNull
    private final AnimationPreviewState previewState;
    @NotNull
    private final Function1<ComposeAnimationToolingEvent.ComposeAnimationToolingEventType, Unit> tracker;
    private int cachedSliderWidth;
    private int cachedMax;
    private int zoomValue;
    @NotNull
    private final List<Function0<Unit>> dragEndListeners;

    public TimelinePanel(@NotNull Tooltip tooltip, @NotNull AnimationPreviewState previewState2, @NotNull Function1<? super ComposeAnimationToolingEvent.ComposeAnimationToolingEventType, Unit> tracker2) {
        Intrinsics.checkNotNullParameter((Object)tooltip, (String)"tooltip");
        Intrinsics.checkNotNullParameter((Object)previewState2, (String)"previewState");
        Intrinsics.checkNotNullParameter(tracker2, (String)"tracker");
        super(0, 10000, 0);
        this.tooltip = tooltip;
        this.previewState = previewState2;
        this.tracker = tracker2;
        this.setPaintTicks(false);
        this.setPaintLabels(true);
        this.updateMajorTicks();
        this.setUI(this.createSliderUI());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent e) {
                this.updateMajorTicks();
            }
        });
        Thumb it = new Thumb();
        boolean bl = false;
        this.add(it);
        it.resizeThumb();
        this.setComponentZOrder(it, 0);
        this.addComponentListener(it.getResizeAdapter());
        this.zoomValue = 1;
        this.dragEndListeners = new ArrayList();
    }

    @NotNull
    public final Tooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final AnimationPreviewState getPreviewState() {
        return this.previewState;
    }

    @NotNull
    public final Function1<ComposeAnimationToolingEvent.ComposeAnimationToolingEventType, Unit> getTracker() {
        return this.tracker;
    }

    @NotNull
    public final TimelineSliderUI getSliderUI() {
        ComponentUI componentUI = this.ui;
        Intrinsics.checkNotNull((Object)componentUI, (String)"null cannot be cast to non-null type com.android.tools.idea.compose.preview.animation.TimelineSliderUI");
        return (TimelineSliderUI)componentUI;
    }

    public final int getZoomValue() {
        return this.zoomValue;
    }

    public final void setZoomValue(int n) {
        this.zoomValue = n;
    }

    public final void scale(int z) {
        this.zoomValue = z;
    }

    @NotNull
    public final List<Function0<Unit>> getDragEndListeners() {
        return this.dragEndListeners;
    }

    @NotNull
    public TimelineSliderUI createSliderUI() {
        return new TimelineSliderUI(this);
    }

    @Override
    public void updateUI() {
        this.updateLabelUIs();
    }

    @Override
    public void setMaximum(int maximum) {
        super.setMaximum(maximum);
        this.updateMajorTicks();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Dimension getPreferredSize() {
        int n;
        Iterable iterable = this.getSliderUI().getElements();
        int n2 = InspectorLayout.INSTANCE.timelineHeaderHeightScaled();
        int n3 = this.zoomValue * this.getWidth() - 50;
        int n4 = 0;
        for (Object t : iterable) {
            void it;
            TimelineElement timelineElement = (TimelineElement)t;
            n = n4;
            boolean bl = false;
            int n5 = it.heightScaled();
            n4 = n + n5;
        }
        n = n4;
        int n6 = n2 + n;
        int n7 = n3;
        return new Dimension(n7, n6);
    }

    @Override
    @NotNull
    public Font getFont() {
        Font font = UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, null);
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(UIUtil.FontSize.SMALL, null)");
        return font;
    }

    private final void updateMajorTicks() {
        if (this.getWidth() == this.cachedSliderWidth && this.getMaximum() == this.cachedMax) {
            return;
        }
        this.cachedSliderWidth = this.getWidth();
        this.cachedMax = this.getMaximum();
        int tickIncrement = InspectorPainter.Slider.getTickIncrement$default(InspectorPainter.Slider.INSTANCE, this, 0, 2, null);
        this.setMajorTickSpacing(tickIncrement);
        this.setLabelTable(tickIncrement == 0 ? this.getLabelTable() : (Dictionary)this.createStandardLabels(tickIncrement));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u0006\u0010\u000b\u001a\u00020\bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/TimelinePanel$Thumb;", "Ljavax/swing/JPanel;", "(Lcom/android/tools/idea/compose/preview/animation/TimelinePanel;)V", "resizeAdapter", "Ljava/awt/event/ComponentAdapter;", "getResizeAdapter", "()Ljava/awt/event/ComponentAdapter;", "paintComponent", "", "g", "Ljava/awt/Graphics;", "resizeThumb", "intellij.android.compose-designer"})
    public final class Thumb
    extends JPanel {
        @NotNull
        private final ComponentAdapter resizeAdapter = new ComponentAdapter(this){
            final /* synthetic */ Thumb this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentResized(@Nullable ComponentEvent e) {
                this.this$0.resizeThumb();
            }
        };

        public Thumb() {
            this.setBackground(UIUtil.TRANSPARENT_COLOR);
            this.setBorder((Border)new JBEmptyBorder(0));
            this.setOpaque(false);
        }

        @Override
        protected void paintComponent(@Nullable Graphics g) {
            super.paintComponent(g);
            Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
            InspectorPainter.Thumb.INSTANCE.paintThumbForHorizSlider((Graphics2D)g, ((Rectangle)TimelinePanel.this.getSliderUI().getThumbRect().invoke()).x + ((Rectangle)TimelinePanel.this.getSliderUI().getThumbRect().invoke()).width / 2, InspectorLayout.INSTANCE.timelineHeaderHeightScaled(), ((Rectangle)TimelinePanel.this.getSliderUI().getThumbRect().invoke()).height);
        }

        public final void resizeThumb() {
            this.setSize(new Dimension(TimelinePanel.this.getWidth(), TimelinePanel.this.getHeight()));
            this.setLocation(new Point(0, 0));
        }

        @NotNull
        public final ComponentAdapter getResizeAdapter() {
            return this.resizeAdapter;
        }
    }
}

