/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation.timeline;

import com.android.tools.idea.compose.preview.animation.AnimatedProperty;
import com.android.tools.idea.compose.preview.animation.InspectorColors;
import com.android.tools.idea.compose.preview.animation.InspectorLayout;
import com.android.tools.idea.compose.preview.animation.InspectorPainter;
import com.android.tools.idea.compose.preview.animation.timeline.ElementState;
import com.android.tools.idea.compose.preview.animation.timeline.PositionProxy;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElement;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElementStatus;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 52\u00020\u0001:\u00015BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\b\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\b2\u0006\u0010-\u001a\u00020\bH\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\bH\u0016J\u0010\u00101\u001a\u00020/2\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020/H\u0016R\u001e\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0019\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010%\u001a\u00020\bX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u001d\"\u0004\b'\u0010!R\u000e\u0010(\u001a\u00020#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010)\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/android/tools/idea/compose/preview/animation/timeline/ComponentCurve;", "Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElement;", "state", "Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;", "component", "Lcom/android/tools/idea/compose/preview/animation/AnimatedProperty$AnimatedComponent;", "", "minX", "", "maxX", "rowMinY", "curve", "Ljava/awt/geom/Path2D;", "colorIndex", "positionProxy", "Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "(Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;Lcom/android/tools/idea/compose/preview/animation/AnimatedProperty$AnimatedComponent;IIILjava/awt/geom/Path2D;ILcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;)V", "<set-?>", "Ljava/awt/Point;", "boxedLabelPosition", "getBoxedLabelPosition", "()Ljava/awt/Point;", "boxedLabelPositionWithoutOffset", "getComponent", "()Lcom/android/tools/idea/compose/preview/animation/AnimatedProperty$AnimatedComponent;", "curveBaseY", "getCurveBaseY$annotations", "()V", "getCurveBaseY", "()I", "curveOffset", "getCurveOffset", "setCurveOffset", "(I)V", "endDiamond", "Lcom/android/tools/idea/compose/preview/animation/InspectorPainter$Diamond;", "endDiamondNoOffset", "height", "getHeight", "setHeight", "startDiamond", "startDiamondNoOffset", "contains", "", "x", "y", "moveComponents", "", "actualDelta", "paint", "g", "Ljava/awt/Graphics2D;", "reset", "Companion", "intellij.android.compose-designer"})
public final class ComponentCurve
extends TimelineElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnimatedProperty.AnimatedComponent<Double> component;
    @NotNull
    private final Path2D curve;
    private final int colorIndex;
    private final int curveBaseY;
    @NotNull
    private InspectorPainter.Diamond startDiamond;
    @NotNull
    private InspectorPainter.Diamond endDiamond;
    @NotNull
    private final InspectorPainter.Diamond startDiamondNoOffset;
    @NotNull
    private final InspectorPainter.Diamond endDiamondNoOffset;
    @NotNull
    private final Point boxedLabelPositionWithoutOffset;
    @NotNull
    private Point boxedLabelPosition;
    private int height;
    private int curveOffset;

    public ComponentCurve(@NotNull ElementState state, @NotNull AnimatedProperty.AnimatedComponent<Double> component2, int minX, int maxX, int rowMinY, @NotNull Path2D curve, int colorIndex, @NotNull PositionProxy positionProxy2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)curve, (String)"curve");
        Intrinsics.checkNotNullParameter((Object)positionProxy2, (String)"positionProxy");
        super(state, minX, maxX, positionProxy2);
        this.component = component2;
        this.curve = curve;
        this.colorIndex = colorIndex;
        this.curveBaseY = rowMinY + InspectorLayout.INSTANCE.timelineCurveRowHeightScaled() - InspectorLayout.INSTANCE.curveBottomOffset();
        this.startDiamond = new InspectorPainter.Diamond(minX, this.curveBaseY, this.colorIndex);
        this.endDiamond = new InspectorPainter.Diamond(maxX, this.curveBaseY, this.colorIndex);
        this.startDiamondNoOffset = new InspectorPainter.Diamond(minX, this.curveBaseY, this.colorIndex);
        this.endDiamondNoOffset = new InspectorPainter.Diamond(maxX, this.curveBaseY, this.colorIndex);
        this.boxedLabelPosition = this.boxedLabelPositionWithoutOffset = new Point(minX + InspectorLayout.INSTANCE.getLabelOffset(), this.curveBaseY + InspectorLayout.INSTANCE.getLabelOffset());
        this.height = 75;
        this.moveComponents(this.getOffsetPx());
    }

    @NotNull
    public final AnimatedProperty.AnimatedComponent<Double> getComponent() {
        return this.component;
    }

    public final int getCurveBaseY() {
        return this.curveBaseY;
    }

    @VisibleForTesting
    public static /* synthetic */ void getCurveBaseY$annotations() {
    }

    @NotNull
    public final Point getBoxedLabelPosition() {
        return this.boxedLabelPosition;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int n) {
        this.height = n;
    }

    public final int getCurveOffset() {
        return this.curveOffset;
    }

    public final void setCurveOffset(int n) {
        this.curveOffset = n;
    }

    @Override
    public void moveComponents(int actualDelta) {
        this.startDiamond = new InspectorPainter.Diamond(this.getMinX() + this.getOffsetPx(), this.curveBaseY, this.colorIndex);
        this.endDiamond = new InspectorPainter.Diamond(this.getMaxX() + this.getOffsetPx(), this.curveBaseY, this.colorIndex);
        this.boxedLabelPosition = new Point(RangesKt.coerceIn((int)(this.boxedLabelPositionWithoutOffset.x + this.getOffsetPx()), (int)this.getPositionProxy().minimumXPosition(), (int)this.getPositionProxy().maximumXPosition()), this.boxedLabelPositionWithoutOffset.y);
        this.curveOffset += actualDelta;
        this.curve.transform(AffineTransform.getTranslateInstance(actualDelta, 0.0));
    }

    @Override
    public void reset() {
        super.reset();
        this.moveComponents(-this.curveOffset);
    }

    @Override
    public boolean contains(int x, int y) {
        return this.curve.contains(x, y) || this.startDiamond.contains(x, y) || this.endDiamond.contains(x, y);
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        g.setColor((Color)InspectorColors.INSTANCE.getGRAPH_COLORS().get(this.colorIndex % InspectorColors.INSTANCE.getGRAPH_COLORS().size()));
        g.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
        g.drawLine(this.getMinX() + this.getOffsetPx(), this.curveBaseY, this.getMaxX() + this.getOffsetPx(), this.curveBaseY);
        if (this.component.getLinkToNext()) {
            g.setStroke(InspectorLayout.INSTANCE.getDashedStroke());
            g.drawLine(this.getMinX() + this.getOffsetPx(), this.curveBaseY, this.getMinX() + this.getOffsetPx(), this.curveBaseY + this.heightScaled() - InspectorPainter.Diamond.Companion.diamondSize());
            g.drawLine(this.getMaxX() + this.getOffsetPx(), this.curveBaseY, this.getMaxX() + this.getOffsetPx(), this.curveBaseY + this.heightScaled() - InspectorPainter.Diamond.Companion.diamondSize());
            g.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
        }
        g.setColor(InspectorColors.INSTANCE.getGRAPH_COLORS_WITH_ALPHA().get(this.colorIndex % InspectorColors.INSTANCE.getGRAPH_COLORS().size()));
        Object prevAntiAliasHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(this.curve);
        if (this.getStatus() == TimelineElementStatus.Dragged || this.getStatus() == TimelineElementStatus.Hovered) {
            g.setColor(InspectorColors.INSTANCE.getLINE_OUTLINE_COLOR_ACTIVE());
            g.draw(this.curve);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, prevAntiAliasHint);
        this.startDiamond.paint(g, this.getStatus() == TimelineElementStatus.Dragged || this.getStatus() == TimelineElementStatus.Hovered);
        this.endDiamond.paint(g, this.getStatus() == TimelineElementStatus.Dragged || this.getStatus() == TimelineElementStatus.Hovered);
        if (this.getOffsetPx() != 0) {
            g.setStroke(InspectorLayout.INSTANCE.getDashedStroke());
            g.setColor(InspectorColors.INSTANCE.getGRAPH_COLORS_WITH_ALPHA().get(this.colorIndex % InspectorColors.INSTANCE.getGRAPH_COLORS().size()));
            if (this.getOffsetPx() > 0) {
                g.drawLine(this.getMinX() + InspectorPainter.Diamond.Companion.diamondSize() + 1, this.curveBaseY, this.getMinX() + this.getOffsetPx() - InspectorPainter.Diamond.Companion.diamondSize() - 1, this.curveBaseY);
                this.startDiamondNoOffset.paintOutline(g);
            } else if (this.getOffsetPx() < 0) {
                g.drawLine(this.getMaxX() - InspectorPainter.Diamond.Companion.diamondSize() - 1, this.curveBaseY, this.getMaxX() + this.getOffsetPx() + InspectorPainter.Diamond.Companion.diamondSize() + 1, this.curveBaseY);
                this.endDiamondNoOffset.paintOutline(g);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J<\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000b\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/compose/preview/animation/timeline/ComponentCurve$Companion;", "", "()V", "create", "Lcom/android/tools/idea/compose/preview/animation/timeline/ComponentCurve;", "state", "Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;", "property", "Lcom/android/tools/idea/compose/preview/animation/AnimatedProperty;", "", "componentId", "", "rowMinY", "positionProxy", "Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "colorIndex", "intellij.android.compose-designer"})
    @SourceDebugExtension(value={"SMAP\nComponentCurve.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentCurve.kt\ncom/android/tools/idea/compose/preview/animation/timeline/ComponentCurve$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,243:1\n215#2,2:244\n*S KotlinDebug\n*F\n+ 1 ComponentCurve.kt\ncom/android/tools/idea/compose/preview/animation/timeline/ComponentCurve$Companion\n*L\n86#1:244,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ComponentCurve create(@NotNull ElementState state, @NotNull AnimatedProperty<Double> property, int componentId, int rowMinY, @NotNull PositionProxy positionProxy2, int colorIndex) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter(property, (String)"property");
            Intrinsics.checkNotNullParameter((Object)positionProxy2, (String)"positionProxy");
            AnimatedProperty.AnimatedComponent<Double> component2 = property.getComponents().get(componentId);
            boolean bl = false;
            Path2D curve = new Path2D.Double();
            double animationYMin = component2.getMinValue();
            boolean isZeroDuration = property.getEndMs() == property.getStartMs();
            boolean isZeroHeight = ((Number)component2.getMinValue()).doubleValue() == ((Number)component2.getMaxValue()).doubleValue();
            boolean zeroDurationXOffset = isZeroDuration;
            int minX = positionProxy2.xPositionForValue(property.getStartMs());
            int maxX = positionProxy2.xPositionForValue(property.getEndMs());
            int minY = rowMinY + 10;
            int maxY = rowMinY + InspectorLayout.INSTANCE.timelineLineRowHeightScaled() - InspectorLayout.INSTANCE.curveBottomOffset();
            curve.moveTo((double)minX - (double)zeroDurationXOffset, maxY);
            if (isZeroDuration) {
                curve.lineTo((double)minX - (double)zeroDurationXOffset, minY);
                curve.lineTo((double)maxX + (double)zeroDurationXOffset, minY);
            } else if (!isZeroHeight) {
                double stepY = (double)(maxY - minY) / (component2.getMaxValue() - animationYMin);
                Map $this$forEach$iv = component2.getPoints();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    Integer ms = (Integer)entry.getKey();
                    Double value2 = (Double)entry.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)ms, (String)"ms");
                    curve.lineTo(positionProxy2.xPositionForValue(ms), (double)maxY - (value2 - animationYMin) * stepY);
                }
            }
            curve.lineTo((double)maxX + (double)zeroDurationXOffset, maxY);
            curve.lineTo((double)minX - (double)zeroDurationXOffset, maxY);
            return new ComponentCurve(state, component2, minX, maxX, rowMinY, curve, colorIndex, positionProxy2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

