/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation.timeline;

import com.android.tools.idea.compose.preview.animation.TooltipInfo;
import com.android.tools.idea.compose.preview.animation.timeline.ElementState;
import com.android.tools.idea.compose.preview.animation.timeline.PositionProxy;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElementStatus;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.intellij.openapi.Disposable;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics2D;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010%\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020'J\u0018\u0010%\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H&J\b\u0010*\u001a\u00020+H\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010-2\u0006\u0010&\u001a\u00020'H\u0016J\u0006\u0010.\u001a\u00020\u0005J\u000e\u0010/\u001a\u00020+2\u0006\u00100\u001a\u00020\u0005J\u0010\u00101\u001a\u00020+2\u0006\u00102\u001a\u00020\u0005H\u0016J\u0010\u00103\u001a\u00020+2\u0006\u00104\u001a\u000205H&J\b\u00106\u001a\u00020+H\u0016R$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0018\u0010\u0011\u001a\u00020\u0005X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u001a\u0010\u0018\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0013\"\u0004\b\u001a\u0010\u0015R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$\u00a8\u00067"}, d2={"Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElement;", "Lcom/intellij/openapi/Disposable;", "state", "Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;", "minX", "", "maxX", "positionProxy", "Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "(Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;IILcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;)V", "value", "", "frozen", "getFrozen", "()Z", "setFrozen", "(Z)V", "height", "getHeight", "()I", "setHeight", "(I)V", "getMaxX", "getMinX", "offsetPx", "getOffsetPx", "setOffsetPx", "getPositionProxy", "()Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "getState", "()Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;", "status", "Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElementStatus;", "getStatus", "()Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElementStatus;", "setStatus", "(Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElementStatus;)V", "contains", "point", "Ljava/awt/Point;", "x", "y", "dispose", "", "getTooltip", "Lcom/android/tools/idea/compose/preview/animation/TooltipInfo;", "heightScaled", "move", "deltaPx", "moveComponents", "actualDeltaPx", "paint", "g", "Ljava/awt/Graphics2D;", "reset", "intellij.android.compose-designer"})
public abstract class TimelineElement
implements Disposable {
    @NotNull
    private final ElementState state;
    private final int minX;
    private final int maxX;
    @NotNull
    private final PositionProxy positionProxy;
    private int offsetPx;
    @NotNull
    private TimelineElementStatus status;

    public TimelineElement(@NotNull ElementState state, int minX, int maxX, @NotNull PositionProxy positionProxy2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)positionProxy2, (String)"positionProxy");
        this.state = state;
        this.minX = minX;
        this.maxX = maxX;
        this.positionProxy = positionProxy2;
        this.status = TimelineElementStatus.Inactive;
        this.offsetPx = this.state.getValueOffset() > 0 ? this.positionProxy.xPositionForValue(this.positionProxy.minimumValue() + this.state.getValueOffset()) - this.positionProxy.minimumXPosition() : -this.positionProxy.xPositionForValue(this.positionProxy.minimumValue() - this.state.getValueOffset()) + this.positionProxy.minimumXPosition();
    }

    @NotNull
    public final ElementState getState() {
        return this.state;
    }

    public final int getMinX() {
        return this.minX;
    }

    public final int getMaxX() {
        return this.maxX;
    }

    @NotNull
    protected final PositionProxy getPositionProxy() {
        return this.positionProxy;
    }

    public final int getOffsetPx() {
        return this.offsetPx;
    }

    public final void setOffsetPx(int n) {
        this.offsetPx = n;
    }

    public abstract int getHeight();

    public abstract void setHeight(int var1);

    public final int heightScaled() {
        return JBUI.scale((int)this.getHeight());
    }

    public boolean getFrozen() {
        return this.state.getFrozen();
    }

    public void setFrozen(boolean value2) {
        this.state.setFrozen(value2);
    }

    @Nullable
    public TooltipInfo getTooltip(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return null;
    }

    @NotNull
    public TimelineElementStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull TimelineElementStatus timelineElementStatus) {
        Intrinsics.checkNotNullParameter((Object)((Object)timelineElementStatus), (String)"<set-?>");
        this.status = timelineElementStatus;
    }

    public abstract boolean contains(int var1, int var2);

    public abstract void paint(@NotNull Graphics2D var1);

    public final void move(int deltaPx) {
        int previousOffsetPx = this.offsetPx;
        this.offsetPx = IdeResourcesUtil.clamp((int)(this.offsetPx + deltaPx), (int)(this.positionProxy.minimumXPosition() - this.maxX), (int)(this.positionProxy.maximumXPosition() - this.minX));
        this.state.setValueOffset(this.offsetPx >= 0 ? this.positionProxy.valueForXPosition(this.minX + this.offsetPx) - this.positionProxy.valueForXPosition(this.minX) : this.positionProxy.valueForXPosition(this.maxX + this.offsetPx) - this.positionProxy.valueForXPosition(this.maxX));
        this.moveComponents(this.offsetPx - previousOffsetPx);
    }

    public void moveComponents(int actualDeltaPx) {
    }

    public void reset() {
        this.offsetPx = 0;
        this.state.setValueOffset(0);
    }

    public final boolean contains(@NotNull Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        return this.contains(point.x, point.y);
    }

    public void dispose() {
    }
}

