/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation.timeline;

import com.android.tools.idea.compose.preview.animation.InspectorColors;
import com.android.tools.idea.compose.preview.animation.InspectorLayout;
import com.android.tools.idea.compose.preview.animation.Transition;
import com.android.tools.idea.compose.preview.animation.timeline.ElementState;
import com.android.tools.idea.compose.preview.animation.timeline.PositionProxy;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElement;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElementStatus;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nB-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J \u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u001a\u0010\u000f\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineLine;", "Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElement;", "state", "Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;", "transition", "Lcom/android/tools/idea/compose/preview/animation/Transition;", "maxY", "", "positionProxy", "Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "(Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;Lcom/android/tools/idea/compose/preview/animation/Transition;ILcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;)V", "minX", "maxX", "rowMinY", "(Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;IIILcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;)V", "height", "getHeight", "()I", "setHeight", "(I)V", "middleY", "rectNoOffset", "Ljava/awt/Rectangle;", "contains", "", "x", "y", "paint", "", "g", "Ljava/awt/Graphics2D;", "paintCircle", "intellij.android.compose-designer"})
@SourceDebugExtension(value={"SMAP\nTimelineLine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimelineLine.kt\ncom/android/tools/idea/compose/preview/animation/timeline/TimelineLine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,150:1\n1#2:151\n*E\n"})
public final class TimelineLine
extends TimelineElement {
    private final int middleY;
    @NotNull
    private final Rectangle rectNoOffset;
    private int height;

    public TimelineLine(@NotNull ElementState state, int minX, int maxX, int rowMinY, @NotNull PositionProxy positionProxy2) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)positionProxy2, (String)"positionProxy");
        super(state, minX, maxX, positionProxy2);
        this.middleY = rowMinY + InspectorLayout.INSTANCE.timelineLineRowHeightScaled() / 2;
        this.rectNoOffset = new Rectangle(minX - InspectorLayout.INSTANCE.lineHalfHeightScaled() - InspectorLayout.INSTANCE.outlinePaddingScaled(), this.middleY - InspectorLayout.INSTANCE.lineHalfHeightScaled() - InspectorLayout.INSTANCE.outlinePaddingScaled(), maxX - minX + InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled());
        this.height = 75;
    }

    public TimelineLine(@NotNull ElementState state, @NotNull Transition transition2, int maxY, @NotNull PositionProxy positionProxy2) {
        int n;
        int n2;
        int n3;
        int it;
        TimelineLine timelineLine;
        ElementState elementState2;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)transition2, (String)"transition");
        Intrinsics.checkNotNullParameter((Object)positionProxy2, (String)"positionProxy");
        TimelineLine timelineLine2 = this;
        ElementState elementState3 = state;
        Integer n4 = transition2.getStartMillis();
        if (n4 != null) {
            int n5 = ((Number)n4).intValue();
            elementState2 = elementState3;
            timelineLine = timelineLine2;
            boolean bl = false;
            n3 = positionProxy2.xPositionForValue(it);
            timelineLine2 = timelineLine;
            elementState3 = elementState2;
            n2 = n3;
        } else {
            n2 = positionProxy2.minimumXPosition();
        }
        Integer n6 = transition2.getEndMillis();
        if (n6 != null) {
            it = ((Number)n6).intValue();
            n3 = n2;
            elementState2 = elementState3;
            timelineLine = timelineLine2;
            boolean bl = false;
            int n7 = positionProxy2.xPositionForValue(it);
            timelineLine2 = timelineLine;
            elementState3 = elementState2;
            n2 = n3;
            n = n7;
        } else {
            n = positionProxy2.maximumXPosition();
        }
        timelineLine2(elementState3, n2, n, maxY, positionProxy2);
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int n) {
        this.height = n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean contains(int x, int y) {
        int n = this.rectNoOffset.x + this.getOffsetPx();
        if (x > (int)this.rectNoOffset.getMaxX() + this.getOffsetPx()) return false;
        if (n > x) return false;
        boolean bl = true;
        if (!bl) return false;
        n = this.rectNoOffset.y;
        if (y > (int)this.rectNoOffset.getMaxY()) return false;
        if (n > y) return false;
        return true;
    }

    @Override
    public void paint(@NotNull Graphics2D g) {
        Graphics2D graphics2D;
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D $this$paint_u24lambda_u242 = graphics2D = (Graphics2D)graphics;
        boolean bl = false;
        $this$paint_u24lambda_u242.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getOffsetPx() != 0) {
            $this$paint_u24lambda_u242.setColor(InspectorColors.INSTANCE.getLINE_COLOR());
            $this$paint_u24lambda_u242.setStroke(InspectorLayout.INSTANCE.getDashedStroke());
            $this$paint_u24lambda_u242.drawRoundRect(this.rectNoOffset.x, this.rectNoOffset.y + InspectorLayout.INSTANCE.outlinePaddingScaled(), this.rectNoOffset.width, this.rectNoOffset.height - 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled());
            $this$paint_u24lambda_u242.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
        }
        int yOffset = this.getStatus() == TimelineElementStatus.Dragged ? -2 : 0;
        Rectangle rect = new Rectangle(this.rectNoOffset.x + this.getOffsetPx(), this.rectNoOffset.y + yOffset, this.rectNoOffset.width, this.rectNoOffset.height);
        if (this.getStatus() == TimelineElementStatus.Dragged || this.getStatus() == TimelineElementStatus.Hovered) {
            $this$paint_u24lambda_u242.setColor(InspectorColors.INSTANCE.getLINE_OUTLINE_COLOR_ACTIVE());
            $this$paint_u24lambda_u242.setStroke(InspectorLayout.INSTANCE.getSimpleStroke());
            $this$paint_u24lambda_u242.drawRoundRect(rect.x - InspectorLayout.INSTANCE.outlinePaddingScaled(), rect.y - InspectorLayout.INSTANCE.outlinePaddingScaled(), rect.width + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), rect.height + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() + 2 * InspectorLayout.INSTANCE.outlinePaddingScaled());
        }
        $this$paint_u24lambda_u242.setColor(InspectorColors.INSTANCE.getLINE_COLOR());
        $this$paint_u24lambda_u242.fillRoundRect(rect.x, rect.y, rect.width, rect.height, InspectorLayout.INSTANCE.lineHeightScaled(), InspectorLayout.INSTANCE.lineHeightScaled());
        this.paintCircle($this$paint_u24lambda_u242, this.getMinX() + this.getOffsetPx(), this.middleY + yOffset);
        this.paintCircle($this$paint_u24lambda_u242, this.getMaxX() + this.getOffsetPx(), this.middleY + yOffset);
    }

    private final void paintCircle(Graphics2D g, int x, int y) {
        Graphics2D graphics2D;
        Graphics2D $this$paintCircle_u24lambda_u243 = graphics2D = g;
        boolean bl = false;
        $this$paintCircle_u24lambda_u243.setColor((Color)InspectorColors.INSTANCE.getLINE_CIRCLE_OUTLINE_COLOR());
        $this$paintCircle_u24lambda_u243.fillOval(x - InspectorLayout.INSTANCE.lineHalfHeightScaled(), y - InspectorLayout.INSTANCE.lineHalfHeightScaled(), InspectorLayout.INSTANCE.lineHeightScaled(), InspectorLayout.INSTANCE.lineHeightScaled());
        $this$paintCircle_u24lambda_u243.setColor(InspectorColors.INSTANCE.getLINE_CIRCLE_COLOR());
        $this$paintCircle_u24lambda_u243.fillOval(x - InspectorLayout.INSTANCE.lineHalfHeightScaled() + InspectorLayout.INSTANCE.outlinePaddingScaled(), y - InspectorLayout.INSTANCE.lineHalfHeightScaled() + InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() - 2 * InspectorLayout.INSTANCE.outlinePaddingScaled(), InspectorLayout.INSTANCE.lineHeightScaled() - 2 * InspectorLayout.INSTANCE.outlinePaddingScaled());
    }
}

