/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.designinfo;

import com.android.ide.common.gradle.Version;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.compose.preview.designinfo.ProviderStatus;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.project.SyncTimestampUtil;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"PROVIDERS_STATUS_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/android/tools/idea/compose/preview/designinfo/ProviderStatus;", "findDesignInfoProviders", "", "moduleToSearch", "Lcom/intellij/openapi/module/Module;", "hasDesignInfoProviders", "module", "intellij.android.compose-designer"})
public final class DesignInfoProvidersUtilsKt {
    @NotNull
    private static final Key<ProviderStatus> PROVIDERS_STATUS_KEY;

    public static final boolean hasDesignInfoProviders(@NotNull Module module2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Project project = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
        long lastSync = SyncTimestampUtil.getLastSyncTimestamp((Project)project);
        ProviderStatus providerStatus = (ProviderStatus)module2.getUserData(PROVIDERS_STATUS_KEY);
        if (providerStatus != null && lastSync == providerStatus.getSyncTimeStamp()) {
            bl = providerStatus.getHasProviders();
        } else {
            boolean bl2;
            boolean it = bl2 = DesignInfoProvidersUtilsKt.findDesignInfoProviders(module2);
            boolean bl3 = false;
            module2.putUserData(PROVIDERS_STATUS_KEY, (Object)new ProviderStatus(it, lastSync));
            bl = bl2;
        }
        return bl;
    }

    private static final boolean findDesignInfoProviders(Module moduleToSearch) {
        Version version;
        if (!((Boolean)StudioFlags.COMPOSE_CONSTRAINT_VISUALIZATION.get()).booleanValue()) {
            return false;
        }
        GradleCoordinate gradleCoordinate = ProjectSystemUtil.getModuleSystem((Module)moduleToSearch).getResolvedDependency(GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT_COMPOSE.getCoordinate("+"));
        Version version2 = version = gradleCoordinate != null ? gradleCoordinate.getLowerBoundVersion() : null;
        if (version == null) {
            return false;
        }
        Version gradleCoordinate2 = version;
        return gradleCoordinate2.compareTo(Version.Companion.parse("1.0.0-alpha06")) >= 0;
    }

    static {
        Key key = Key.create((String)ProviderStatus.class.getName());
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(ProviderStatus::class.java.name)");
        PROVIDERS_STATUS_KEY = key;
    }
}

