/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.AndroidStudioKotlinPluginUtils;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.LerpDouble;
import com.android.tools.idea.common.scene.LerpPoint;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SinglePositionableContentLayoutManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.configurations.StudioConfigurationStateManager;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.NavSceneManagerKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceActionHandler;
import com.android.tools.idea.naveditor.surface.NavInteractionHandler;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.lang.ref.SoftReference;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NavDesignSurface
extends DesignSurface<NavSceneManager> {
    private static final int SCROLL_DURATION_MS = 300;
    private static final Object CONNECTION_CLIENT_PROPERTY_KEY = new Object();
    private static final String FAILED_DEPENDENCY = "Failed to add navigation dependency";
    private static final String FAILED_DEPENDENCY_TITLE = "Failed to Add Dependency";
    private NlComponent myCurrentNavigation;
    @VisibleForTesting
    AtomicReference<Future<?>> myScheduleRef;
    private DesignerEditorPanel myEditorPanel;
    private static final WeakHashMap<AndroidFacet, SoftReference<ConfigurationManager>> ourConfigurationManagers = new WeakHashMap();
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI_KTX.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI_KTX.getCoordinate("+"));

    @TestOnly
    public NavDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(0);
        }
        if (parentDisposable == null) {
            NavDesignSurface.$$$reportNull$$$0(1);
        }
        this(project, null, parentDisposable);
    }

    public NavDesignSurface(@NotNull Project project, @Nullable DesignerEditorPanel editorPanel2, @NotNull Disposable parentDisposable) {
        if (project == null) {
            NavDesignSurface.$$$reportNull$$$0(2);
        }
        if (parentDisposable == null) {
            NavDesignSurface.$$$reportNull$$$0(3);
        }
        super(project, parentDisposable, surface2 -> new NavActionManager((NavDesignSurface)surface2), NavInteractionHandler::new, surface2 -> new SinglePositionableContentLayoutManager(), surface2 -> new NavDesignSurfaceActionHandler((NavDesignSurface)surface2), DesignSurface.ZoomControlsPolicy.VISIBLE);
        this.myScheduleRef = new AtomicReference();
        this.myEditorPanel = editorPanel2;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavDesignSurface.this.removeComponentListener(this);
                NavDesignSurface.this.requestRender();
            }
        });
        this.getSelectionModel().addListener((SelectionModel unused, List<NlComponent> selection) -> this.updateCurrentNavigation(selection));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRender() {
        SceneManager manager = (SceneManager)Iterables.getFirst(this.getSceneManagers(), null);
        CompletableFuture<Void> completableFuture = manager != null ? manager.requestRenderAsync() : CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            NavDesignSurface.$$$reportNull$$$0(4);
        }
        return completableFuture;
    }

    @Override
    public void dispose() {
        Future<?> future = this.getScheduleRef().get();
        if (future != null) {
            future.cancel(false);
        }
        this.getScheduleRef().set(null);
        super.dispose();
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        Point2D.Float p2d;
        SceneComponent sceneComponent;
        Scene scene;
        NlComponent selection;
        if (dataId == null) {
            NavDesignSurface.$$$reportNull$$$0(5);
        }
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId) && (selection = this.getSelectionModel().getPrimary()) != null && NavComponentHelperKt.isAction(selection) && (scene = this.getScene()) != null && (sceneComponent = scene.getSceneComponent(selection)) != null && (p2d = NavActionHelperKt.getAnyPoint(sceneComponent, SceneContext.get(this.getFocusedSceneView()))) != null) {
            return new Point((int)p2d.x, (int)p2d.y);
        }
        return super.getData(dataId);
    }

    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        CompletableFuture<Void> completableFuture = this.forceRefresh();
        if (completableFuture == null) {
            NavDesignSurface.$$$reportNull$$$0(6);
        }
        return completableFuture;
    }

    @NotNull
    public CompletableFuture<Void> forceRefresh() {
        CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
        if (completableFuture == null) {
            NavDesignSurface.$$$reportNull$$$0(7);
        }
        return completableFuture;
    }

    @Override
    @NotNull
    protected NavSceneManager createSceneManager(@NotNull NlModel model2) {
        if (model2 == null) {
            NavDesignSurface.$$$reportNull$$$0(8);
        }
        return new NavSceneManager(model2, this);
    }

    @Override
    @Nullable
    public NavSceneManager getSceneManager() {
        return (NavSceneManager)super.getSceneManager();
    }

    @Override
    public CompletableFuture<?> goingToSetModel(final NlModel model2) {
        model2.getConfiguration().getResourceResolver();
        final AndroidFacet facet = model2.getFacet();
        final CompletableFuture result = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (NavDesignSurface.tryToCreateSchema(facet)) {
                result.complete(null);
            } else if (this.requestAddDependency(facet)) {
                ListenableFuture syncResult = ProjectSystemUtil.getSyncManager((Project)this.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
                Futures.addCallback((ListenableFuture)syncResult, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object unused) {
                        application.executeOnPooledThread(() -> {
                            if (!NavDesignSurface.tryToCreateSchema(facet)) {
                                NavDesignSurface.this.showFailToAddMessage(result, model2);
                            } else {
                                result.complete(null);
                            }
                        });
                    }

                    public void onFailure(@Nullable Throwable t) {
                        NavDesignSurface.this.showFailToAddMessage(result, model2);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            } else {
                this.showFailToAddMessage(result, model2);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        CompletableFuture<Void> future = super.setModel(model2);
        NavUsageTracker.Companion.getInstance(model2).createEvent(NavEditorEvent.NavEditorEventType.OPEN_FILE).withNavigationContents().log();
        return future;
    }

    private void showFailToAddMessage(@NotNull CompletableFuture<?> result, final @NotNull NlModel model2) {
        if (result == null) {
            NavDesignSurface.$$$reportNull$$$0(9);
        }
        if (model2 == null) {
            NavDesignSurface.$$$reportNull$$$0(10);
        }
        if (this.myEditorPanel != null) {
            ProjectSystemSyncManager.SyncResultListener syncFailedListener = new ProjectSystemSyncManager.SyncResultListener(){

                public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result) {
                    if (result == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (NavDesignSurface.tryToCreateSchema(model2.getFacet())) {
                            NavDesignSurface.this.myEditorPanel.initNeleModel();
                            ((MessageBusConnection)NavDesignSurface.this.myEditorPanel.getClientProperty(CONNECTION_CLIENT_PROPERTY_KEY)).disconnect();
                            NavDesignSurface.this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, null);
                        }
                    });
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/android/tools/idea/naveditor/surface/NavDesignSurface$3", "syncEnded"));
                }
            };
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, connection);
            connection.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)syncFailedListener);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.onFailedToAddDependency());
        result.completeExceptionally(new Exception(FAILED_DEPENDENCY));
    }

    private void onFailedToAddDependency() {
        Messages.showErrorDialog((Project)this.getProject(), (String)FAILED_DEPENDENCY, (String)FAILED_DEPENDENCY_TITLE);
        if (this.myEditorPanel != null) {
            this.myEditorPanel.getWorkBench().loadingStopped(FAILED_DEPENDENCY);
        }
    }

    private boolean requestAddDependency(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(11);
        }
        List<GradleCoordinate> dependencies = NavDesignSurface.getDependencies(facet.getModule());
        AtomicBoolean didAdd = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                didAdd.set(DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)facet.getModule(), (List)dependencies, (boolean)true, (boolean)false).isEmpty());
            }
            catch (Throwable t) {
                Logger.getInstance(NavDesignSurface.class).warn("Failed to add dependencies", t);
                didAdd.set(false);
            }
        });
        return didAdd.get();
    }

    @NotNull
    public static List<GradleCoordinate> getDependencies(@NotNull Module module2) {
        if (module2 == null) {
            NavDesignSurface.$$$reportNull$$$0(12);
        }
        boolean isKotlin = AndroidStudioKotlinPluginUtils.hasKotlinFacet((Module)module2);
        if (MigrateToAndroidxUtil.isAndroidx((Project)module2.getProject())) {
            List<GradleCoordinate> list = isKotlin ? ANDROIDX_NAVIGATION_DEPENDENCIES_KTX : ANDROIDX_NAVIGATION_DEPENDENCIES;
            if (list == null) {
                NavDesignSurface.$$$reportNull$$$0(13);
            }
            return list;
        }
        List<GradleCoordinate> list = isKotlin ? NAVIGATION_DEPENDENCIES_KTX : NAVIGATION_DEPENDENCIES;
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(14);
        }
        return list;
    }

    private static boolean tryToCreateSchema(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(15);
        }
        Module module2 = facet.getModule();
        return (Boolean)DumbService.getInstance((Project)module2.getProject()).runReadActionInSmartMode(() -> {
            try {
                NavigationSchema.createIfNecessary((Module)module2);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }

    @Override
    public void activate() {
        super.activate();
        NlModel model2 = this.getModel();
        if (model2 != null) {
            Module module2 = model2.getModule();
            try {
                NavigationSchema.createIfNecessary((Module)module2);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get((Module)module2);
            if (!schema.quickValidate()) {
                if (this.myEditorPanel == null) {
                    return;
                }
                this.myEditorPanel.getWorkBench().showLoading("Refreshing Navigators...");
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        schema.rebuildSchema().get();
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().hideLoading());
                    }
                    catch (Exception e) {
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().loadingStopped("Error refreshing Navigators"));
                    }
                });
            } else {
                schema.rebuildSchema();
            }
        }
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component2 -> new DnDTransferComponent(component2.getTagName(), component2.getTagDeprecated().getText(), 0, 0)).collect(ImmutableList.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if (!this.validateCurrentNavigation().booleanValue()) {
            this.refreshRoot();
        }
        NlComponent nlComponent = this.myCurrentNavigation;
        if (nlComponent == null) {
            NavDesignSurface.$$$reportNull$$$0(16);
        }
        return nlComponent;
    }

    private Boolean validateCurrentNavigation() {
        NlComponent current = this.myCurrentNavigation;
        if (current == null || current.getModel() != this.getModel()) {
            return false;
        }
        while (current.getParent() != null) {
            NlComponent parent = current.getParent();
            if (!parent.getChildren().contains(current)) {
                return false;
            }
            current = parent;
        }
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        assert (components.size() == 1);
        return current == components.get(0);
    }

    public void setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        if (currentNavigation == null) {
            NavDesignSurface.$$$reportNull$$$0(17);
        }
        this.myCurrentNavigation = currentNavigation;
        this.getSceneManager().update();
        this.getSceneManager().layout(false);
        this.zoomToFit();
        currentNavigation.getModel().notifyModified(NlModel.ChangeType.UPDATE_HIERARCHY);
        this.repaint();
    }

    @Override
    protected Dimension getScrollToVisibleOffset() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean isLayoutDisabled() {
        return false;
    }

    @Override
    public boolean setScale(double scale, int x, int y) {
        SceneView view2 = this.getFocusedSceneView();
        if (view2 == null) {
            return false;
        }
        Point oldViewPosition = this.getScrollPosition();
        if (x < 0 || y < 0) {
            x = oldViewPosition.x + this.getViewport().getViewportComponent().getWidth() / 2;
            y = oldViewPosition.y + this.getViewport().getViewportComponent().getHeight() / 2;
        }
        int androidX = Coordinates.getAndroidXDip(view2, x);
        int androidY = Coordinates.getAndroidYDip(view2, y);
        boolean ret = super.setScale(scale, x, y);
        int shiftedX = Coordinates.getSwingXDip(view2, androidX);
        int shiftedY = Coordinates.getSwingYDip(view2, androidY);
        this.getViewport().setViewPosition(new Point(oldViewPosition.x + shiftedX - x, oldViewPosition.y + shiftedY - y));
        return ret;
    }

    @Override
    protected boolean isKeepingScaleWhenReopen() {
        return false;
    }

    @Override
    protected double getMinScale() {
        return this.isEmpty() ? 1.0 : 0.1;
    }

    @Override
    protected double getMaxScale() {
        return this.isEmpty() ? 1.0 : 3.0;
    }

    @Override
    public boolean canZoomToFit() {
        if (this.isEmpty()) {
            return false;
        }
        Double fitScale = this.getFitScale();
        Double scale = this.getScale();
        return Math.abs(fitScale - scale) > 0.005;
    }

    @Override
    public double getFitScale() {
        Dimension size = new Dimension();
        SceneView view2 = this.getFocusedSceneView();
        if (view2 != null) {
            SceneComponent root = view2.getScene().getRoot();
            if (root == null) {
                size.setSize(0, 0);
            } else {
                Rectangle boundingBox = NavSceneManagerKt.getBoundingBox(root);
                size.setSize(boundingBox.getSize());
            }
        } else {
            size.setSize(0, 0);
        }
        double scale = DesignSurfaceHelper.getFitContentIntoWindowScale(this, size);
        return Math.min(scale, 1.0);
    }

    private boolean isEmpty() {
        NavSceneManager sceneManager = this.getSceneManager();
        return sceneManager == null || sceneManager.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyComponentActivate(@NotNull NlComponent component2) {
        VirtualFile virtualFile2;
        PsiFile file2;
        PsiClass psiClass;
        String className;
        NavEditorEvent.NavEditorEventType metricsEventType;
        String id2;
        if (component2 == null) {
            NavDesignSurface.$$$reportNull$$$0(18);
        }
        if (this.myCurrentNavigation == component2) {
            return;
        }
        if (NavComponentHelperKt.isNavigation(component2)) {
            if (!NavComponentHelperKt.isInclude(component2)) {
                this.setCurrentNavigation(component2);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_NESTED).log();
                return;
            }
            id2 = component2.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_INCLUDE;
            if (id2 == null) {
                return;
            }
        } else {
            id2 = component2.getAttribute("http://schemas.android.com/tools", "layout");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_LAYOUT;
        }
        if (id2 != null) {
            VirtualFile virtualFile3;
            File file3;
            String fileName;
            Configuration configuration = (Configuration)Iterables.getOnlyElement(this.getConfigurations(), null);
            ResourceResolver resolver = configuration != null ? configuration.getResourceResolver() : null;
            ResourceValue value2 = resolver != null ? resolver.findResValue(id2, false) : null;
            String string2 = fileName = value2 != null ? value2.getValue() : null;
            if (fileName != null && (file3 = new File(fileName)).exists() && (virtualFile3 = VfsUtil.findFileByIoFile((File)file3, (boolean)false)) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile3, true);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(metricsEventType).log();
                return;
            }
        }
        if ((className = component2.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file2 = psiClass.getContainingFile()) != null && (virtualFile2 = file2.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
            NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_CLASS).log();
            return;
        }
        super.notifyComponentActivate(component2);
    }

    @Override
    @UiThread
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        NavSceneManager sceneManager;
        boolean isFitZoom;
        if (type == null) {
            NavDesignSurface.$$$reportNull$$$0(19);
        }
        this.getAnalyticsManager().trackZoom(type);
        boolean scaled = super.zoom(type, x, y);
        boolean bl = isFitZoom = type == ZoomType.FIT;
        if ((scaled || isFitZoom) && (sceneManager = this.getSceneManager()) != null) {
            sceneManager.layout(false);
            this.validateScrollArea();
        }
        if (isFitZoom) {
            Dimension visibleSize = this.getExtentSize();
            Dimension size = this.getViewSize();
            this.setScrollPosition((size.width - visibleSize.width) / 2, (size.height - visibleSize.height) / 2);
        }
        return scaled;
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(20);
        }
        Scene scene = this.getScene();
        SceneView view2 = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view2 == null) {
            return;
        }
        Rectangle selectionBounds = NavSceneManagerKt.getBoundingBox(list.stream().map(nlComponent -> scene.getSceneComponent((NlComponent)nlComponent)).filter(sceneComponent -> sceneComponent != null).collect(Collectors.toList()));
        Dimension swingViewportSize = this.getExtentSize();
        int swingStartCenterXInViewport = Coordinates.getSwingX(view2, (int)selectionBounds.getCenterX()) - this.getScrollPosition().x;
        int swingStartCenterYInViewport = Coordinates.getSwingY(view2, (int)selectionBounds.getCenterY()) - this.getScrollPosition().y;
        Point start = new Point(swingStartCenterXInViewport, swingStartCenterYInViewport);
        Point end = new Point(swingViewportSize.width / 2, swingViewportSize.height / 2);
        LerpPoint lerpPoint = new LerpPoint(start, end, this.getScrollDurationMs());
        double fitSelectionScale = DesignSurfaceHelper.getFitContentIntoWindowScale(this, selectionBounds.getSize());
        fitSelectionScale = Math.min(fitSelectionScale, 1.0);
        LerpDouble zoomLerp = new LerpDouble(view2.getScale(), fitSelectionScale, this.getScrollDurationMs());
        if (this.getScheduleRef().get() != null) {
            this.getScheduleRef().get().cancel(false);
        }
        Runnable action2 = () -> UIUtil.invokeAndWaitIfNeeded(() -> {
            long time = System.currentTimeMillis();
            Point pointSwingValue = (Point)lerpPoint.getValue(time);
            int targetSwingX = Coordinates.getSwingX(view2, (int)selectionBounds.getCenterX());
            int targetSwingY = Coordinates.getSwingY(view2, (int)selectionBounds.getCenterY());
            this.setScrollPosition(targetSwingX - pointSwingValue.x, targetSwingY - pointSwingValue.y);
            this.setScale((Double)zoomLerp.getValue(time), targetSwingX, targetSwingY);
            if (lerpPoint.isComplete(time)) {
                this.getScheduleRef().get().cancel(false);
                this.getScheduleRef().set(null);
            }
        });
        this.getScheduleRef().set(AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(action2, 0L, 10L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    @NotNull
    AtomicReference<Future<?>> getScheduleRef() {
        AtomicReference<Future<?>> atomicReference = this.myScheduleRef;
        if (atomicReference == null) {
            NavDesignSurface.$$$reportNull$$$0(21);
        }
        return atomicReference;
    }

    int getScrollDurationMs() {
        return 300;
    }

    public void refreshRoot() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            return;
        }
        NlComponent match = (NlComponent)model2.getComponents().get(0);
        if (this.myCurrentNavigation != null) {
            boolean includingParent = false;
            TagSnapshot currentSnapshot = this.myCurrentNavigation.getSnapshot();
            NlComponent currentParent = this.myCurrentNavigation.getParent();
            for (NlComponent component2 : model2.flattenComponents()::iterator) {
                if (!NavComponentHelperKt.isNavigation(component2)) continue;
                if (component2 == this.myCurrentNavigation) {
                    return;
                }
                TagSnapshot componentSnapshot = component2.getSnapshot();
                if (currentSnapshot != null && currentSnapshot == componentSnapshot) {
                    match = component2;
                    break;
                }
                if (includingParent || !Objects.equals(component2.getId(), this.myCurrentNavigation.getId())) continue;
                match = component2;
                NlComponent componentParent = component2.getParent();
                if (componentParent == null != (currentParent == null) || componentParent != null && !Objects.equals(componentParent.getId(), currentParent.getId())) continue;
                includingParent = true;
            }
        }
        if (this.myCurrentNavigation != match) {
            this.myCurrentNavigation = match;
            this.getSelectionModel().setSelection((List<? extends NlComponent>)ImmutableList.of((Object)this.myCurrentNavigation));
        }
    }

    @Override
    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet) {
        if (facet == null) {
            NavDesignSurface.$$$reportNull$$$0(22);
        }
        SoftReference<ConfigurationManager> ref = ourConfigurationManagers.get(facet);
        ConfigurationManager result = null;
        if (ref != null) {
            result = ref.get();
        }
        if (result == null) {
            result = new MyConfigurationManager(facet.getModule());
            ourConfigurationManagers.put(facet, new SoftReference<ConfigurationManager>(result));
        }
        ConfigurationManager configurationManager2 = result;
        if (configurationManager2 == null) {
            NavDesignSurface.$$$reportNull$$$0(23);
        }
        return configurationManager2;
    }

    @Override
    protected boolean getSupportPinchAndZoom() {
        return false;
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlComponent root = this.getCurrentNavigation();
        List<NlComponent> list = root.flatten().filter(component2 -> component2 == root || NavComponentHelperKt.isDestination(component2) && component2.getParent() == root || NavComponentHelperKt.isAction(component2) && (component2.getParent() == root || component2.getParent() != null && component2.getParent().getParent() == root || NavComponentHelperKt.getActionType(component2, root) == ActionType.EXIT_DESTINATION)).collect(Collectors.toList());
        if (list == null) {
            NavDesignSurface.$$$reportNull$$$0(24);
        }
        return list;
    }

    private void updateCurrentNavigation(@NotNull List<NlComponent> selection) {
        if (selection == null) {
            NavDesignSurface.$$$reportNull$$$0(25);
        }
        if (selection.isEmpty()) {
            return;
        }
        if (this.getSelectableComponents().stream().anyMatch(selection::contains)) {
            return;
        }
        NlComponent selected = selection.get(0);
        NlComponent next = selected.getParent();
        if (next == null) {
            next = selected;
        }
        while (next != null && !NavComponentHelperKt.isNavigation(next)) {
            next = next.getParent();
        }
        if (next != null) {
            this.setCurrentNavigation(next);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 6, 7, 13, 14, 16, 21, 23, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: 
            case 15: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentNavigation";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/naveditor/surface/NavDesignSurface";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "requestRender";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "forceUserRequestedRefresh";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "forceRefresh";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentNavigation";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getScheduleRef";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationManager";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectableComponents";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 16: 
            case 21: 
            case 23: 
            case 24: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createSceneManager";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showFailToAddMessage";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "requestAddDependency";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "tryToCreateSchema";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setCurrentNavigation";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyComponentActivate";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "zoom";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "scrollToCenter";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationManager";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updateCurrentNavigation";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 4, 6, 7, 13, 14, 16, 21, 23, 24 -> new IllegalStateException(string2);
        };
    }

    private static class MyConfigurationManager
    extends ConfigurationManager {
        MyConfigurationManager(@NotNull Module module2) {
            if (module2 == null) {
                MyConfigurationManager.$$$reportNull$$$0(0);
            }
            super(module2);
        }

        public ConfigurationStateManager getStateManager() {
            return new StudioConfigurationStateManager();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/naveditor/surface/NavDesignSurface$MyConfigurationManager", "<init>"));
        }
    }
}

