/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview.viewmodels;

import com.android.ide.common.rendering.api.Bridge;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.idea.editors.build.ProjectBuildStatusManager;
import com.android.tools.idea.editors.build.ProjectStatus;
import com.android.tools.idea.editors.shortcuts.UtilsKt;
import com.android.tools.idea.preview.PreviewBundle;
import com.android.tools.idea.preview.mvvm.PreviewView;
import com.android.tools.idea.preview.mvvm.PreviewViewModel;
import com.android.tools.idea.preview.mvvm.PreviewViewModelStatus;
import com.android.tools.idea.preview.viewmodels.CommonPreviewViewModelKt;
import com.android.tools.idea.projectsystem.BuildUtilsKt;
import com.intellij.notification.Notification;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\\\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012!\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010\u00a2\u0006\u0002\u0010\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020+H\u0016J\b\u0010.\u001a\u00020+H\u0016J\b\u0010/\u001a\u00020+H\u0016J\b\u00100\u001a\u00020+H\u0016J\u0010\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020+H\u0016J\u0018\u00105\u001a\u00020+2\u0006\u00106\u001a\u00020\u000e2\u0006\u00107\u001a\u000208H\u0016J\b\u00109\u001a\u00020+H\u0016J\b\u0010:\u001a\u00020+H\u0016J\u0010\u0010;\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u000eH\u0016J\b\u0010<\u001a\u00020+H\u0002J\b\u0010=\u001a\u00020+H\u0002J\b\u0010>\u001a\u00020+H\u0002R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001dR\u0014\u0010#\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001dR\u0014\u0010$\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001dR)\u0010\u000f\u001a\u001d\u0012\u0013\u0012\u00110\u0011\u00a2\u0006\f\b\u0012\u0012\b\b\u0013\u0012\u0004\b\b(\u0014\u0012\u0004\u0012\u00020\u00150\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010%\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/idea/preview/viewmodels/CommonPreviewViewModel;", "Lcom/android/tools/idea/preview/mvvm/PreviewViewModel;", "Lcom/android/tools/idea/preview/mvvm/PreviewViewModelStatus;", "previewView", "Lcom/android/tools/idea/preview/mvvm/PreviewView;", "projectBuildStatusManager", "Lcom/android/tools/idea/editors/build/ProjectBuildStatusManager;", "project", "Lcom/intellij/openapi/project/Project;", "psiFilePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiFile;", "hasRenderErrors", "Lkotlin/Function0;", "", "previewRefreshNotificationFactory", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "durationString", "Lcom/intellij/notification/Notification;", "(Lcom/android/tools/idea/preview/mvvm/PreviewView;Lcom/android/tools/idea/editors/build/ProjectBuildStatusManager;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/SmartPsiElementPointer;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "buildAndRefreshAction", "Lcom/android/tools/adtui/stdui/ActionData;", "getBuildAndRefreshAction", "()Lcom/android/tools/adtui/stdui/ActionData;", "hasErrorsAndNeedsBuild", "getHasErrorsAndNeedsBuild", "()Z", "hasPreviews", "Ljava/util/concurrent/atomic/AtomicBoolean;", "hasRendered", "hasSyntaxErrors", "getHasSyntaxErrors", "isOutOfDate", "isRefreshing", "previewedFile", "getPreviewedFile", "()Lcom/intellij/psi/PsiFile;", "refreshCallsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "activate", "", "afterPreviewsRefreshed", "beforePreviewsRefreshed", "buildFailed", "buildStarted", "buildSucceeded", "checkForNativeCrash", "runnable", "Ljava/lang/Runnable;", "onEnterSmartMode", "refreshCompleted", "isCancelled", "durationNanos", "", "refreshFinished", "refreshStarted", "setHasPreviews", "updateNotifications", "updateView", "updateViewAndNotifications", "intellij.android.preview-designer"})
public class CommonPreviewViewModel
implements PreviewViewModel,
PreviewViewModelStatus {
    @NotNull
    private final PreviewView previewView;
    @NotNull
    private final ProjectBuildStatusManager projectBuildStatusManager;
    @NotNull
    private final Project project;
    @NotNull
    private final SmartPsiElementPointer<PsiFile> psiFilePointer;
    @NotNull
    private final Function0<Boolean> hasRenderErrors;
    @NotNull
    private final Function1<String, Notification> previewRefreshNotificationFactory;
    @NotNull
    private final AtomicInteger refreshCallsCount;
    @NotNull
    private final AtomicBoolean hasRendered;
    @NotNull
    private final AtomicBoolean hasPreviews;

    public CommonPreviewViewModel(@NotNull PreviewView previewView2, @NotNull ProjectBuildStatusManager projectBuildStatusManager2, @NotNull Project project, @NotNull SmartPsiElementPointer<PsiFile> psiFilePointer2, @NotNull Function0<Boolean> hasRenderErrors, @NotNull Function1<? super String, ? extends Notification> previewRefreshNotificationFactory) {
        Intrinsics.checkNotNullParameter((Object)previewView2, (String)"previewView");
        Intrinsics.checkNotNullParameter((Object)projectBuildStatusManager2, (String)"projectBuildStatusManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(psiFilePointer2, (String)"psiFilePointer");
        Intrinsics.checkNotNullParameter(hasRenderErrors, (String)"hasRenderErrors");
        Intrinsics.checkNotNullParameter(previewRefreshNotificationFactory, (String)"previewRefreshNotificationFactory");
        this.previewView = previewView2;
        this.projectBuildStatusManager = projectBuildStatusManager2;
        this.project = project;
        this.psiFilePointer = psiFilePointer2;
        this.hasRenderErrors = hasRenderErrors;
        this.previewRefreshNotificationFactory = previewRefreshNotificationFactory;
        this.refreshCallsCount = new AtomicInteger(0);
        this.hasRendered = new AtomicBoolean(false);
        this.hasPreviews = new AtomicBoolean(false);
    }

    @Override
    public boolean checkForNativeCrash(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (Bridge.hasNativeCrash()) {
            String message = "The preview has been disabled following a crash in the rendering engine. If the problem persists, please report the issue.";
            ActionData actionData2 = new ActionData("Re-enable rendering", (Function0)new Function0<Unit>(this, runnable){
                final /* synthetic */ CommonPreviewViewModel this$0;
                final /* synthetic */ Runnable $runnable;
                {
                    this.this$0 = $receiver;
                    this.$runnable = $runnable;
                    super(0);
                }

                public final void invoke() {
                    Bridge.setNativeCrash((boolean)false);
                    CommonPreviewViewModel.access$getPreviewView$p(this.this$0).showLoadingMessage("Loading...");
                    this.$runnable.run();
                }
            });
            this.previewView.showErrorMessage(message, null, actionData2);
            return true;
        }
        return false;
    }

    @Override
    public void refreshStarted() {
        this.refreshCallsCount.incrementAndGet();
        this.updateNotifications();
    }

    @Override
    public void refreshFinished() {
        this.refreshCallsCount.decrementAndGet();
        this.updateNotifications();
    }

    @Override
    public void beforePreviewsRefreshed() {
        this.updateViewAndNotifications();
    }

    @Override
    public void afterPreviewsRefreshed() {
        this.hasRendered.set(true);
        this.updateViewAndNotifications();
    }

    public void buildStarted() {
        this.updateViewAndNotifications();
    }

    public void buildSucceeded() {
        this.updateViewAndNotifications();
    }

    public void buildFailed() {
        this.updateViewAndNotifications();
    }

    @Override
    public void setHasPreviews(boolean hasPreviews) {
        this.hasPreviews.set(hasPreviews);
    }

    @Override
    public void refreshCompleted(boolean isCancelled, long durationNanos) {
        this.updateViewAndNotifications();
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, durationNanos){
            final /* synthetic */ CommonPreviewViewModel this$0;
            final /* synthetic */ long $durationNanos;
            {
                this.this$0 = $receiver;
                this.$durationNanos = $durationNanos;
                super(0);
            }

            public final void invoke() {
                if (CommonPreviewViewModel.access$getHasRendered$p(this.this$0).get()) {
                    Duration duration = Duration.ofMillis(this.$durationNanos / (long)1000000);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(durationNanos / 1_000_000)");
                    String durationString = CommonPreviewViewModelKt.access$toDisplayString(duration);
                    Notification notification = (Notification)CommonPreviewViewModel.access$getPreviewRefreshNotificationFactory$p(this.this$0).invoke((Object)durationString);
                    Notifications.Bus.notify((Notification)notification, (Project)CommonPreviewViewModel.access$getProject$p(this.this$0));
                }
            }
        }), (int)1, null);
    }

    @Override
    public void onEnterSmartMode() {
        this.updateViewAndNotifications();
    }

    @Override
    public void activate() {
        this.updateViewAndNotifications();
    }

    private final void updateNotifications() {
        UIUtil.invokeLaterIfNeeded(() -> CommonPreviewViewModel.updateNotifications$lambda$0(this));
    }

    private final void updateViewAndNotifications() {
        UIUtil.invokeLaterIfNeeded(() -> CommonPreviewViewModel.updateViewAndNotifications$lambda$1(this));
    }

    private final ActionData getBuildAndRefreshAction() {
        String actionDataText = PreviewBundle.INSTANCE.message("panel.needs.build.action.text", new Object[0]) + UtilsKt.asString$default(UtilsKt.getBuildAndRefreshShortcut(), null, null, 3, null);
        return new ActionData(actionDataText, (Function0)new Function0<Unit>(this){
            final /* synthetic */ CommonPreviewViewModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    PsiFile psiFile2 = (PsiFile)CommonPreviewViewModel.access$getPsiFilePointer$p(this.this$0).getElement();
                    if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) break block0;
                    PsiFile psiFile3 = psiFile2;
                    CommonPreviewViewModel commonPreviewViewModel = this.this$0;
                    PsiFile it = psiFile3;
                    boolean bl = false;
                    BuildUtilsKt.requestBuild((Project)CommonPreviewViewModel.access$getProject$p(commonPreviewViewModel), (VirtualFile)it);
                }
            }
        });
    }

    private final void updateView() {
        if (this.hasRendered.get()) {
            this.previewView.showContent();
        } else if (DumbService.Companion.getInstance(this.project).isDumb()) {
            this.previewView.showLoadingMessage(PreviewBundle.INSTANCE.message("panel.indexing", new Object[0]));
        } else if (this.projectBuildStatusManager.isBuilding()) {
            this.previewView.showLoadingMessage(PreviewBundle.INSTANCE.message("panel.building", new Object[0]));
        } else if (Intrinsics.areEqual((Object)this.projectBuildStatusManager.getStatus(), (Object)ProjectStatus.NeedsBuild.INSTANCE)) {
            this.previewView.showErrorMessage(PreviewBundle.INSTANCE.message("panel.needs.build", new Object[0]), null, this.getBuildAndRefreshAction());
        } else {
            this.previewView.showLoadingMessage(PreviewBundle.INSTANCE.message("panel.initializing", new Object[0]));
        }
    }

    @Override
    public boolean isRefreshing() {
        return this.refreshCallsCount.get() > 0;
    }

    @Override
    public boolean getHasErrorsAndNeedsBuild() {
        return this.hasPreviews.get() && (!this.hasRendered.get() || (Boolean)this.hasRenderErrors.invoke() != false);
    }

    @Override
    public boolean getHasSyntaxErrors() {
        return WolfTheProblemSolver.getInstance((Project)this.project).isProblemFile(this.psiFilePointer.getVirtualFile());
    }

    @Override
    public boolean isOutOfDate() {
        return this.projectBuildStatusManager.getStatus() instanceof ProjectStatus.OutOfDate;
    }

    @Override
    @Nullable
    public PsiFile getPreviewedFile() {
        return (PsiFile)this.psiFilePointer.getElement();
    }

    private static final void updateNotifications$lambda$0(CommonPreviewViewModel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.previewView.updateToolbar();
        if (!this$0.project.isDisposed()) {
            EditorNotifications.getInstance((Project)this$0.project).updateNotifications(this$0.psiFilePointer.getVirtualFile());
        }
    }

    private static final void updateViewAndNotifications$lambda$1(CommonPreviewViewModel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.updateView();
        this$0.updateNotifications();
    }

    public static final /* synthetic */ PreviewView access$getPreviewView$p(CommonPreviewViewModel $this) {
        return $this.previewView;
    }

    public static final /* synthetic */ AtomicBoolean access$getHasRendered$p(CommonPreviewViewModel $this) {
        return $this.hasRendered;
    }

    public static final /* synthetic */ Function1 access$getPreviewRefreshNotificationFactory$p(CommonPreviewViewModel $this) {
        return $this.previewRefreshNotificationFactory;
    }

    public static final /* synthetic */ Project access$getProject$p(CommonPreviewViewModel $this) {
        return $this.project;
    }

    public static final /* synthetic */ SmartPsiElementPointer access$getPsiFilePointer$p(CommonPreviewViewModel $this) {
        return $this.psiFilePointer;
    }
}

