/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.error.IssueProviderListener;
import com.android.tools.idea.uibuilder.editor.ResourceFileTrafficLightRendererKt;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\bH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0014R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\t\u001a.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f*\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\u000e\u00a2\u0006\u0002\b\r0\n\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "errorCountArray", "", "severities", "", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "createUIController", "Lcom/intellij/openapi/editor/markup/UIController;", "getErrorCounts", "getStatus", "Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "refresh", "", "editorMarkupModel", "Lcom/intellij/openapi/editor/impl/EditorMarkupModelImpl;", "ResourceFileUIController", "intellij.android.designer"})
@SourceDebugExtension(value={"SMAP\nResourceFileTrafficLightRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceFileTrafficLightRenderer.kt\ncom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n1855#2,2:132\n819#2:134\n847#2,2:135\n1549#2:137\n1620#2,3:138\n*S KotlinDebug\n*F\n+ 1 ResourceFileTrafficLightRenderer.kt\ncom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender\n*L\n70#1:132,2\n84#1:134\n84#1:135,2\n84#1:137\n84#1:138,3\n*E\n"})
public final class ResourceFileTrafficLightRender
extends TrafficLightRenderer {
    @NotNull
    private final List<HighlightSeverity> severities;
    @NotNull
    private final int[] errorCountArray;

    public ResourceFileTrafficLightRender(@NotNull PsiFile file2, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(file2.getProject(), editor.getDocument());
        List list = this.getSeverityRegistrar().getAllSeverities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"severityRegistrar.allSeverities");
        this.severities = list;
        this.errorCountArray = new int[this.severities.size()];
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(IssueProviderListener.TOPIC, (arg_0, arg_1) -> ResourceFileTrafficLightRender._init_$lambda$1(this, editor, file2, arg_0, arg_1));
    }

    protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
        super.refresh(editorMarkupModel);
        if (editorMarkupModel == null) {
            return;
        }
        ArraysKt.fill$default((int[])this.errorCountArray, (int)0, (int)0, (int)0, (int)6, null);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        List<Issue> list = IssuePanelService.Companion.getInstance(project).getSharedPanelIssues();
        if (list == null) {
            return;
        }
        List<Issue> issues = list;
        Iterable $this$forEach$iv = issues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Issue it = (Issue)element$iv;
            boolean bl = false;
            int index = this.severities.indexOf(it.getSeverity());
            if (index <= -1) continue;
            int[] nArray = this.errorCountArray;
            int n = nArray[index];
            nArray[index] = n + 1;
        }
    }

    @NotNull
    public int[] getErrorCounts() {
        return this.errorCountArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnalyzerStatus getStatus() {
        void $this$mapTo$iv$iv;
        int it;
        Iterable $this$filterNotTo$iv$iv;
        AnalyzerStatus analyzerStatus = super.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)analyzerStatus, (String)"super.getStatus()");
        AnalyzerStatus status = analyzerStatus;
        Iterable $this$filterNot$iv = (Iterable)RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((int[])this.errorCountArray)));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (this.errorCountArray[it] == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getSeverityRegistrar().getSeverityByIndex(it));
        }
        List nonZeroSeverities = (List)destination$iv$iv;
        List items = new ArrayList();
        List currentItems = status.getExpandedStatus();
        if (currentItems.size() != nonZeroSeverities.size()) {
            return status;
        }
        int n = currentItems.size();
        for (int index = 0; index < n; ++index) {
            StatusItem item = (StatusItem)currentItems.get(index);
            Icon icon2 = (Icon)ResourceFileTrafficLightRendererKt.access$getSEVERITY_TO_ICON$p().get(nonZeroSeverities.get(index));
            if (icon2 == null) {
                icon2 = item.getIcon();
            }
            Icon icon3 = icon2;
            items.add(new StatusItem(item.getText(), icon3, item.getDetailsText()));
        }
        status.withExpandedStatus(items);
        return status;
    }

    @NotNull
    protected UIController createUIController() {
        return (UIController)new ResourceFileUIController();
    }

    private static final void lambda$1$lambda$0(ResourceFileTrafficLightRender this$0, Editor $editor, PsiFile $file) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        if (!this$0.getProject().isDisposed()) {
            ErrorStripeUpdateManager.getInstance((Project)this$0.getProject()).repaintErrorStripePanel($editor, $file);
        }
    }

    private static final void _init_$lambda$1(ResourceFileTrafficLightRender this$0, Editor $editor, PsiFile $file, Object object, List list) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$editor, (String)"$editor");
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
        Intrinsics.checkNotNullParameter((Object)list, (String)"<anonymous parameter 1>");
        ApplicationManager.getApplication().invokeLater(() -> ResourceFileTrafficLightRender.lambda$1$lambda$0(this$0, $editor, $file));
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender$ResourceFileUIController;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "(Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender;)V", "toggleProblemsView", "", "intellij.android.designer"})
    private final class ResourceFileUIController
    extends TrafficLightRenderer.DefaultUIController {
        public ResourceFileUIController() {
            super((TrafficLightRenderer)ResourceFileTrafficLightRender.this);
        }

        public void toggleProblemsView() {
            Project project = ResourceFileTrafficLightRender.this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            IssuePanelService issuePanelService = IssuePanelService.Companion.getInstance(project);
            IssuePanelService.setSharedIssuePanelVisibility$default(issuePanelService, !issuePanelService.isShowingIssuePanel(null), null, 2, null);
        }
    }
}

