/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.UtilsKt;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.rendering.StudioRenderService;
import com.android.tools.idea.rendering.StudioRenderServiceKt;
import com.android.tools.idea.rendering.parsers.PsiXmlTag;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.model.NlModelHelperKt;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.rendering.parsers.RenderXmlTag;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Dimension;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewEditorImpl
extends ViewEditor {
    private final Configuration myConfiguration;
    private final NlModel myModel;
    private final SceneManager mySceneManager;
    private final Scene myScene;
    @VisibleForTesting
    private Collection<ViewInfo> myRootViews;

    public ViewEditorImpl(@NotNull SceneView sceneView) {
        if (sceneView == null) {
            ViewEditorImpl.$$$reportNull$$$0(0);
        }
        this(sceneView.getSceneManager().getModel(), sceneView.getScene());
    }

    public ViewEditorImpl(@NotNull NlModel model2, @Nullable Scene scene) {
        if (model2 == null) {
            ViewEditorImpl.$$$reportNull$$$0(1);
        }
        this.myConfiguration = model2.getConfiguration();
        this.myModel = model2;
        this.myScene = scene;
        this.mySceneManager = scene != null ? scene.getSceneManager() : null;
    }

    @Override
    @Nullable
    public AndroidVersion getCompileSdkVersion() {
        return StudioAndroidModuleInfo.getInstance((AndroidFacet)this.myModel.getFacet()).getBuildSdkVersion();
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion = StudioAndroidModuleInfo.getInstance((AndroidFacet)this.myModel.getFacet()).getMinSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(2);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion = StudioAndroidModuleInfo.getInstance((AndroidFacet)this.myModel.getFacet()).getTargetSdkVersion();
        if (androidVersion == null) {
            ViewEditorImpl.$$$reportNull$$$0(3);
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        Configuration configuration = this.myConfiguration;
        if (configuration == null) {
            ViewEditorImpl.$$$reportNull$$$0(4);
        }
        return configuration;
    }

    @Override
    @NotNull
    public NlModel getModel() {
        NlModel nlModel = this.myModel;
        if (nlModel == null) {
            ViewEditorImpl.$$$reportNull$$$0(5);
        }
        return nlModel;
    }

    @Override
    @NotNull
    public LayoutlibSceneManager getSceneBuilder() {
        assert (this.mySceneManager != null) : "ViewEditorImpl incorrectly configured";
        LayoutlibSceneManager layoutlibSceneManager = (LayoutlibSceneManager)this.mySceneManager;
        if (layoutlibSceneManager == null) {
            ViewEditorImpl.$$$reportNull$$$0(6);
        }
        return layoutlibSceneManager;
    }

    @Override
    @NotNull
    public Collection<ViewInfo> getRootViews() {
        if (this.myRootViews != null) {
            Collection<ViewInfo> collection = this.myRootViews;
            if (collection == null) {
                ViewEditorImpl.$$$reportNull$$$0(7);
            }
            return collection;
        }
        RenderResult result = this.getSceneBuilder().getRenderResult();
        if (result == null) {
            List<ViewInfo> list = Collections.emptyList();
            if (list == null) {
                ViewEditorImpl.$$$reportNull$$$0(8);
            }
            return list;
        }
        ImmutableList immutableList = result.getRootViews();
        if (immutableList == null) {
            ViewEditorImpl.$$$reportNull$$$0(9);
        }
        return immutableList;
    }

    @VisibleForTesting
    public void setRootViews(@NotNull Collection<ViewInfo> rootViews) {
        if (rootViews == null) {
            ViewEditorImpl.$$$reportNull$$$0(10);
        }
        this.myRootViews = rootViews;
    }

    @Override
    @NotNull
    public CompletableFuture<Map<NlComponent, Dimension>> measureChildren(@NotNull NlComponent parent, @Nullable RenderTask.AttributeFilter filter2) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(11);
        }
        if (!parent.getBackend().isValid()) {
            CompletableFuture<Map<NlComponent, Dimension>> completableFuture = CompletableFuture.completedFuture(Collections.emptyMap());
            if (completableFuture == null) {
                ViewEditorImpl.$$$reportNull$$$0(12);
            }
            return completableFuture;
        }
        if (parent.getChildCount() == 0) {
            CompletableFuture<Map<NlComponent, Dimension>> completableFuture = CompletableFuture.completedFuture(Collections.emptyMap());
            if (completableFuture == null) {
                ViewEditorImpl.$$$reportNull$$$0(13);
            }
            return completableFuture;
        }
        HashMap tagToComponent = Maps.newHashMapWithExpectedSize((int)parent.getChildCount());
        for (NlComponent child : parent.getChildren()) {
            tagToComponent.put(child.getTagDeprecated(), child);
        }
        NlModel model2 = this.myModel;
        XmlFile xmlFile = model2.getFile();
        Module module2 = model2.getModule();
        RenderService renderService = StudioRenderService.getInstance((Project)module2.getProject());
        CompletableFuture taskFuture = StudioRenderServiceKt.taskBuilder((RenderService)renderService, (AndroidFacet)model2.getFacet(), (Configuration)this.getConfiguration()).withPsiFile(xmlFile).build();
        XmlTag parentTag = parent.getTagDeprecated();
        CompletionStage completionStage = taskFuture.thenCompose(task2 -> {
            if (task2 == null) {
                return CompletableFuture.completedFuture(Collections.emptyMap());
            }
            return ((CompletableFuture)task2.measureChildren((RenderXmlTag)new PsiXmlTag(parentTag), filter2).whenCompleteAsync((map2, ex) -> task2.dispose(), (Executor)AppExecutorUtil.getAppExecutorService())).thenApply(map2 -> {
                if (map2 == null) {
                    return Collections.emptyMap();
                }
                HashMap<NlComponent, Dimension> unweightedSizes = new HashMap<NlComponent, Dimension>();
                for (Map.Entry entry : map2.entrySet()) {
                    ViewInfo viewInfo = (ViewInfo)entry.getValue();
                    viewInfo = RenderService.getSafeBounds((ViewInfo)viewInfo);
                    Dimension size = new Dimension(viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
                    NlComponent child = (NlComponent)tagToComponent.get(entry.getKey());
                    if (child == null) continue;
                    unweightedSizes.put(child, size);
                }
                return unweightedSizes;
            });
        });
        if (completionStage == null) {
            ViewEditorImpl.$$$reportNull$$$0(14);
        }
        return completionStage;
    }

    @VisibleForTesting
    static boolean isPublicAndUnRestricted(@NotNull PsiClass psiClass) {
        PsiModifierList modifiers;
        if (psiClass == null) {
            ViewEditorImpl.$$$reportNull$$$0(15);
        }
        if ((modifiers = psiClass.getModifierList()) == null) {
            return false;
        }
        if (!modifiers.hasModifierProperty("public")) {
            return false;
        }
        for (PsiAnnotation annotation : modifiers.getAnnotations()) {
            if (!AnnotationDetectorKt.RESTRICT_TO_ANNOTATION.isEquals(annotation.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Scene getScene() {
        assert (this.myScene != null) : "ViewEditorImpl incorrectly configured";
        Scene scene = this.myScene;
        if (scene == null) {
            ViewEditorImpl.$$$reportNull$$$0(16);
        }
        return scene;
    }

    @Override
    public boolean canInsertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(17);
        }
        if (children == null) {
            ViewEditorImpl.$$$reportNull$$$0(18);
        }
        return this.getModel().canAddComponents(children, parent, ViewEditorImpl.getChild(parent, index));
    }

    @Override
    public void insertChildren(@NotNull NlComponent parent, @NotNull List<NlComponent> children, int index, @NotNull InsertType insertType) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(19);
        }
        if (children == null) {
            ViewEditorImpl.$$$reportNull$$$0(20);
        }
        if (insertType == null) {
            ViewEditorImpl.$$$reportNull$$$0(21);
        }
        UtilsKt.addComponentsAndSelectedIfCreated(this.getModel(), children, parent, ViewEditorImpl.getChild(parent, index), insertType, this.myScene.getDesignSurface().getSelectionModel());
    }

    @Nullable
    private static NlComponent getChild(@NotNull NlComponent parent, int index) {
        if (parent == null) {
            ViewEditorImpl.$$$reportNull$$$0(22);
        }
        return 0 <= index && index < parent.getChildCount() ? parent.getChild(index) : null;
    }

    @Override
    public boolean moduleDependsOnAppCompat() {
        return NlModelHelperKt.moduleDependsOnAppCompat(this.myModel);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sceneView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootViews";
                break;
            }
            case 11: 
            case 17: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewEditorImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMinSdkVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetSdkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfiguration";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSceneBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootViews";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "measureChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getScene";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setRootViews";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "measureChildren";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isPublicAndUnRestricted";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "canInsertChildren";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "insertChildren";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 2, 3, 4, 5, 6, 7, 8, 9, 12, 13, 14, 16 -> new IllegalStateException(string2);
        };
    }
}

