/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.BuiltinViewHandlerProvider;
import com.android.tools.idea.uibuilder.handlers.MergeDelegateHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerProvider;
import com.android.tools.idea.uibuilder.menu.MenuViewHandlerManager;
import com.android.tools.idea.uibuilder.model.ClassResolutionUtilsKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelper;
import com.android.tools.idea.uibuilder.statelist.ItemHandler;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidSlowOperations;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class ViewHandlerManager
implements Disposable {
    @VisibleForTesting
    static final ExtensionPointName<ViewHandlerProvider> EP_NAME = ExtensionPointName.create((String)"com.android.tools.idea.uibuilder.handlers.viewHandlerProvider");
    private static final String HANDLER_CLASS_SUFFIX = "Handler";
    private final Project myProject;
    private final Map<String, ViewHandler> myHandlers;
    public static final ViewHandler NONE = new ViewHandler();
    private final Map<ViewHandler, List<ViewAction>> myToolbarActions;
    private final Map<ViewHandler, List<ViewAction>> myMenuActions;

    @NotNull
    public static ViewHandlerManager get(@NotNull Project project) {
        if (project == null) {
            ViewHandlerManager.$$$reportNull$$$0(0);
        }
        ViewHandlerManager manager = (ViewHandlerManager)project.getService(ViewHandlerManager.class);
        assert (manager != null);
        ViewHandlerManager viewHandlerManager = manager;
        if (viewHandlerManager == null) {
            ViewHandlerManager.$$$reportNull$$$0(1);
        }
        return viewHandlerManager;
    }

    @NotNull
    public static ViewHandlerManager get(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ViewHandlerManager.$$$reportNull$$$0(2);
        }
        return ViewHandlerManager.get(facet.getModule().getProject());
    }

    public ViewHandlerManager(@NotNull Project project) {
        if (project == null) {
            ViewHandlerManager.$$$reportNull$$$0(3);
        }
        this.myHandlers = new HashMap<String, ViewHandler>();
        this.myToolbarActions = new HashMap<ViewHandler, List<ViewAction>>();
        this.myMenuActions = new HashMap<ViewHandler, List<ViewAction>>();
        this.myProject = project;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull NlComponent component2) {
        String tag2;
        if (component2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(4);
        }
        switch (tag2 = component2.getTagName()) {
            case "item": {
                ViewHandler handler = MenuViewHandlerManager.getHandler(component2);
                if (handler != null) {
                    return handler;
                }
                return new ItemHandler();
            }
            case "merge": {
                ViewHandler groupHandler;
                String parentTag = component2.getAttribute("http://schemas.android.com/tools", "parentTag");
                if (parentTag != null && (groupHandler = this.getHandler(parentTag)) instanceof ViewGroupHandler) {
                    return new MergeDelegateHandler((ViewGroupHandler)groupHandler);
                }
                return this.getHandler("merge");
            }
        }
        return this.getHandler(tag2);
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull NlComponent component2) {
        ViewHandler handler;
        if (component2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(5);
        }
        ViewHandler viewHandler = (handler = this.getHandler(component2)) != null ? handler : NONE;
        if (viewHandler == null) {
            ViewHandlerManager.$$$reportNull$$$0(6);
        }
        return viewHandler;
    }

    @NotNull
    public ViewHandler getHandlerOrDefault(@NotNull String viewTag) {
        ViewHandler handler;
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(7);
        }
        ViewHandler viewHandler = (handler = this.getHandler(viewTag)) != null ? handler : NONE;
        if (viewHandler == null) {
            ViewHandlerManager.$$$reportNull$$$0(8);
        }
        return viewHandler;
    }

    @Nullable
    public ViewHandler getHandler(@NotNull String viewTag) {
        ViewHandler handler;
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(9);
        }
        if ((handler = this.myHandlers.get(viewTag)) == null) {
            String tag2;
            if (viewTag.indexOf(46) != -1 && !(tag2 = NlComponentHelper.INSTANCE.viewClassToTag(viewTag)).equals(viewTag) && (handler = this.getHandler(tag2)) != null) {
                this.myHandlers.put(viewTag, handler);
                return handler;
            }
            handler = this.createHandler(viewTag);
            this.myHandlers.put(viewTag, handler);
        }
        return handler != NONE ? handler : null;
    }

    public void registerHandler(@NotNull String viewTag, @NotNull ViewHandler handler) {
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(10);
        }
        if (handler == null) {
            ViewHandlerManager.$$$reportNull$$$0(11);
        }
        this.myHandlers.put(viewTag, handler);
    }

    @Nullable
    public ViewGroupHandler findLayoutHandler(@NotNull NlComponent component2, boolean strict) {
        if (component2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(12);
        }
        NlComponent curr = component2;
        if (strict) {
            curr = curr.getParent();
        }
        while (curr != null) {
            ViewHandler handler = this.getHandler(curr);
            if (handler instanceof ViewGroupHandler) {
                return (ViewGroupHandler)handler;
            }
            curr = curr.getParent();
        }
        return null;
    }

    private ViewHandler createHandler(@NotNull String viewTag) {
        ViewHandler builtInHandler;
        if (viewTag == null) {
            ViewHandlerManager.$$$reportNull$$$0(13);
        }
        if ((builtInHandler = BuiltinViewHandlerProvider.INSTANCE.findHandler(viewTag)) != null) {
            return builtInHandler;
        }
        ViewHandler extensionHandler = EP_NAME.getExtensionList((AreaInstance)this.myProject).stream().map(extension -> extension.findHandler(viewTag)).filter(Objects::nonNull).limit(2L).reduce(null, (a, b) -> {
            if (a != null && b != null) {
                Logger.getInstance(ViewHandler.class).warn("Multiple ViewHandlers returned by extensions for tag " + viewTag);
                return a;
            }
            return a != null ? a : b;
        });
        if (extensionHandler != null) {
            return extensionHandler;
        }
        Logger.getInstance(ViewHandler.class).debug("No built-in or extension defined ViewHandlers found for " + viewTag);
        try {
            String defaultHandlerPkgPrefix = "com.android.tools.idea.uibuilder.handlers.";
            String handlerClass = defaultHandlerPkgPrefix + viewTag + HANDLER_CLASS_SUFFIX;
            Class<?> cls = Class.forName(handlerClass);
            return (ViewHandler)cls.newInstance();
        }
        catch (Exception exception) {
            Logger.getInstance(ViewHandler.class).debug("Looking for user code defined handlers for " + viewTag);
            return (ViewHandler)ApplicationManager.getApplication().runReadAction(() -> {
                if (this.myProject.isDisposed()) {
                    return NONE;
                }
                try {
                    PsiClass[] viewClasses = (PsiClass[])AndroidSlowOperations.allowSlowOperationsInIdea(() -> ClassResolutionUtilsKt.findClassesForViewTag(this.myProject, viewTag));
                    if (viewClasses.length > 0) {
                        String handlerName = viewTag + HANDLER_CLASS_SUFFIX;
                        PsiClass[] handlerClasses = (PsiClass[])AndroidSlowOperations.allowSlowOperationsInIdea(() -> JavaPsiFacade.getInstance((Project)this.myProject).findClasses(handlerName, GlobalSearchScope.allScope((Project)this.myProject)));
                        if (handlerClasses.length == 0) {
                            for (PsiClass cls : viewClasses) {
                                String fqn;
                                PsiClass superClass = cls.getSuperClass();
                                if (superClass == null || (fqn = superClass.getQualifiedName()) == null) continue;
                                return this.getHandler(NlComponentHelper.INSTANCE.viewClassToTag(fqn));
                            }
                        } else {
                            for (PsiClass cls : handlerClasses) {
                                Logger.getInstance(ViewHandler.class).debug(String.format("Found view handler %s  of type %s", cls.getQualifiedName(), cls.getClass().getName()));
                            }
                        }
                    }
                }
                catch (IndexNotReadyException ignore) {
                    return NONE;
                }
                return NONE;
            });
        }
    }

    public List<ViewAction> getToolbarActions(@NotNull ViewHandler handler) {
        List<ViewAction> actions2;
        if (handler == null) {
            ViewHandlerManager.$$$reportNull$$$0(14);
        }
        if ((actions2 = this.myToolbarActions.get(handler)) == null) {
            actions2 = new ArrayList<ViewAction>();
            handler.addToolbarActions(actions2);
            this.myToolbarActions.put(handler, actions2);
        }
        return actions2;
    }

    @NotNull
    public List<ViewAction> getPopupMenuActions(@NotNull SceneComponent component2, @NotNull ViewHandler handler) {
        List<ViewAction> actions2;
        if (component2 == null) {
            ViewHandlerManager.$$$reportNull$$$0(15);
        }
        if (handler == null) {
            ViewHandlerManager.$$$reportNull$$$0(16);
        }
        if ((actions2 = this.myMenuActions.get(handler)) == null && handler.addPopupMenuActions(component2, actions2 = new ArrayList<ViewAction>())) {
            this.myMenuActions.put(handler, actions2);
        }
        List<ViewAction> list = actions2;
        if (list == null) {
            ViewHandlerManager.$$$reportNull$$$0(17);
        }
        return list;
    }

    public void dispose() {
        this.myHandlers.clear();
    }

    @TestOnly
    void clearCache() {
        this.myHandlers.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 8, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewHandlerManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "viewTag";
                break;
            }
            case 11: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewHandlerManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandlerOrDefault";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getPopupMenuActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getHandler";
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getHandlerOrDefault";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "registerHandler";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findLayoutHandler";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createHandler";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getToolbarActions";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getPopupMenuActions";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 1, 6, 8, 17 -> new IllegalStateException(string2);
        };
    }
}

