/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.google.common.collect.ImmutableList;
import icons.StudioIcons;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewTagHandler
extends ViewHandler {
    private static final String DIVIDER_BACKGROUND = "?android:attr/listDivider";
    public static final Predicate<String> SUITABLE_LAYOUT_CLASS = ViewTagHandler::isViewSuitableForLayout;

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        ImmutableList immutableList = ImmutableList.of((Object)"class", (Object)"style");
        if (immutableList == null) {
            ViewTagHandler.$$$reportNull$$$0(0);
        }
        return immutableList;
    }

    @Override
    @NotNull
    public String getTitle(@NotNull String tagName) {
        if (tagName == null) {
            ViewTagHandler.$$$reportNull$$$0(1);
        }
        return "<view>";
    }

    @Override
    @NotNull
    public String getTitle(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(2);
        }
        return "<view>";
    }

    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        if (tagName == null) {
            ViewTagHandler.$$$reportNull$$$0(3);
        }
        if (xmlType == null) {
            ViewTagHandler.$$$reportNull$$$0(4);
        }
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return "<view/>";
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        String string2 = super.getXml(tagName, xmlType);
        if (string2 == null) {
            ViewTagHandler.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        if (newChild == null) {
            ViewTagHandler.$$$reportNull$$$0(6);
        }
        if (insertType == null) {
            ViewTagHandler.$$$reportNull$$$0(7);
        }
        if (insertType == InsertType.CREATE && newChild.getAttribute(null, "class") == null && !ViewTagHandler.isVerticalDivider(newChild) && !ViewTagHandler.isHorizontalDivider(newChild)) {
            String src = ViewTagHandler.browseClasses(newChild.getModel(), null);
            if (src != null) {
                NlWriteCommandActionUtil.run(newChild, "Setting layout attribute", () -> newChild.setAttribute(null, "class", src));
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    @NotNull
    public Icon getIcon(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(8);
        }
        if (!component2.getTagName().equals("view")) {
            Icon icon2 = super.getIcon(component2);
            if (icon2 == null) {
                ViewTagHandler.$$$reportNull$$$0(9);
            }
            return icon2;
        }
        if (ViewTagHandler.isVerticalDivider(component2)) {
            Icon icon3 = StudioIcons.LayoutEditor.Palette.VERTICAL_DIVIDER;
            if (icon3 == null) {
                ViewTagHandler.$$$reportNull$$$0(10);
            }
            return icon3;
        }
        if (ViewTagHandler.isHorizontalDivider(component2)) {
            Icon icon4 = StudioIcons.LayoutEditor.Palette.HORIZONTAL_DIVIDER;
            if (icon4 == null) {
                ViewTagHandler.$$$reportNull$$$0(11);
            }
            return icon4;
        }
        Icon icon5 = StudioIcons.LayoutEditor.Palette.VIEW;
        if (icon5 == null) {
            ViewTagHandler.$$$reportNull$$$0(12);
        }
        return icon5;
    }

    private static boolean isVerticalDivider(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(13);
        }
        return DIVIDER_BACKGROUND.equals(component2.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component2, "layout_width");
    }

    private static boolean isHorizontalDivider(@NotNull NlComponent component2) {
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(14);
        }
        return DIVIDER_BACKGROUND.equals(component2.getAttribute("http://schemas.android.com/apk/res/android", "background")) && ViewTagHandler.hasShortWidth(component2, "layout_height");
    }

    private static boolean hasShortWidth(@NotNull NlComponent component2, @NotNull String attributeName) {
        String value2;
        if (component2 == null) {
            ViewTagHandler.$$$reportNull$$$0(15);
        }
        if (attributeName == null) {
            ViewTagHandler.$$$reportNull$$$0(16);
        }
        if ((value2 = component2.getAttribute("http://schemas.android.com/apk/res/android", attributeName)) == null) {
            return false;
        }
        switch (value2) {
            case "1": 
            case "1px": 
            case "1dp": 
            case "1dip": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static String browseClasses(@NotNull NlModel model2, @Nullable String existingValue) {
        if (model2 == null) {
            ViewTagHandler.$$$reportNull$$$0(17);
        }
        return ViewEditor.displayClassInput(model2, "Views", Collections.singleton("android.view.View"), SUITABLE_LAYOUT_CLASS, existingValue);
    }

    private static boolean isViewSuitableForLayout(@NotNull String qualifiedName) {
        if (qualifiedName == null) {
            ViewTagHandler.$$$reportNull$$$0(18);
        }
        return !qualifiedName.startsWith("android.") || qualifiedName.startsWith("android.support.") || qualifiedName.startsWith("androidx.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 6, 7, 8, 13, 14, 15, 16, 17, 18 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/ViewTagHandler";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
            case 2: 
            case 8: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newChild";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertType";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInspectorProperties";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/ViewTagHandler";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getXml";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTitle";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getXml";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "onCreate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isVerticalDivider";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isHorizontalDivider";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasShortWidth";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "browseClasses";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isViewSuitableForLayout";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string2);
            case 1, 2, 3, 4, 6, 7, 8, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string2);
        };
    }
}

