/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.assistant;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.resources.FileResourceNameValidator;
import com.android.ide.common.resources.ResourceItem;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.adtui.HorizontalSpinner;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.StudioResourceRepositoryManager;
import com.android.tools.idea.uibuilder.assistant.AssistantPopupPanel;
import com.android.tools.idea.uibuilder.assistant.ComponentAssistantFactory;
import com.android.tools.idea.uibuilder.handlers.assistant.AssistantUiKt;
import com.android.tools.idea.uibuilder.handlers.assistant.Template;
import com.android.tools.idea.uibuilder.handlers.assistant.TemplateTag;
import com.google.common.collect.ImmutableList;
import com.google.common.io.Files;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.JBIntSpinner;
import com.intellij.ui.components.JBList;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ListModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecyclerViewAssistant
extends AssistantPopupPanel {
    private static final Logger LOG = Logger.getInstance(RecyclerViewAssistant.class);
    private static final int ITEM_COUNT_DEFAULT = 10;
    private static final ImmutableList<Template> TEMPLATES = ImmutableList.of((Object)Template.NONE_TEMPLATE, (Object)Template.fromStream("E-mail Client", RecyclerViewAssistant.class.getResourceAsStream("templates/email.xml"), EnumSet.of(TemplateTag.SUPPORT_LIBRARY, TemplateTag.CONSTRAINT_LAYOUT)), (Object)Template.fromStream("E-mail Client", RecyclerViewAssistant.class.getResourceAsStream("templates/email-androidx.xml"), EnumSet.of(TemplateTag.ANDROIDX, TemplateTag.CONSTRAINT_LAYOUT)), (Object)Template.fromStream("One Line", RecyclerViewAssistant.class.getResourceAsStream("templates/one_line.xml")), (Object)Template.fromStream("One Line w/ Avatar", RecyclerViewAssistant.class.getResourceAsStream("templates/one_line_avatar.xml")), (Object)Template.fromStream("Two Lines", RecyclerViewAssistant.class.getResourceAsStream("templates/two_lines.xml")), (Object)Template.fromStream("Two Lines w/ Avatar", RecyclerViewAssistant.class.getResourceAsStream("templates/two_lines_avatar.xml")), (Object)Template.fromStream("Three Lines", RecyclerViewAssistant.class.getResourceAsStream("templates/three_lines.xml")), (Object)Template.fromStream("Three Lines w/ Avatar", RecyclerViewAssistant.class.getResourceAsStream("templates/three_lines_avatar.xml")), (Object)Template.fromStream("Grid", RecyclerViewAssistant.class.getResourceAsStream("templates/avatar.xml"), EnumSet.of(TemplateTag.GRID)));
    private static final int LONGEST_TEMPLATE = TEMPLATES.stream().map(template -> template.component2().length()).max(Integer::compare).orElse(0);
    private final NlComponent myComponent;
    private final String myOriginalListItemValue;
    private final String myOriginalLayoutManager;
    private final String myOriginalSpanCountValue;
    private final Project myProject;
    private final String myResourceName;
    private final HorizontalSpinner<Template> mySpinner;
    private final JBIntSpinner myItemCount;
    @Nullable
    private PsiFile myCreatedFile;

    private static int getIndexOfMatchingTemplate(@NotNull Template[] availableTemplates, @NotNull AndroidFacet facet, @NotNull ResourceReference reference) {
        File layoutFile;
        List items;
        if (facet == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(0);
        }
        if (reference == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(1);
        }
        if (availableTemplates == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(2);
        }
        if ((items = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet).getResources(reference)).isEmpty()) {
            return -1;
        }
        ResourceItem item = (ResourceItem)items.get(0);
        File file2 = layoutFile = item.getSource() != null ? item.getSource().toFile() : null;
        if (layoutFile == null || layoutFile.length() > (long)LONGEST_TEMPLATE) {
            return -1;
        }
        try {
            String strValue = Files.toString((File)layoutFile, (Charset)StandardCharsets.UTF_8);
            for (int i = 0; i < availableTemplates.length; ++i) {
                if (!availableTemplates[i].hasSameContent(strValue)) continue;
                return i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return -1;
    }

    public RecyclerViewAssistant(@NotNull ComponentAssistantFactory.Context context) {
        if (context == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(3);
        }
        this.myComponent = context.getComponent();
        AndroidFacet facet = this.myComponent.getModel().getFacet();
        this.myProject = facet.getModule().getProject();
        Object[] availableTemplates = (Template[])TEMPLATES.stream().filter(template -> template.availableFor(this.myComponent.getModel().getModule())).toArray(Template[]::new);
        this.mySpinner = HorizontalSpinner.forModel((ListModel)JBList.createDefaultListModel((Object[])availableTemplates));
        String itemCountAttribute = this.myComponent.getAttribute("http://schemas.android.com/tools", "itemCount");
        int count = RecyclerViewAssistant.parseItemCountAttribute(itemCountAttribute);
        this.myItemCount = new JBIntSpinner(count, 0, 50);
        this.myItemCount.setOpaque(false);
        ((JSpinner.NumberEditor)this.myItemCount.getEditor()).getTextField().setEditable(false);
        ((JSpinner.NumberEditor)this.myItemCount.getEditor()).getTextField().setHorizontalAlignment(10);
        JPanel content2 = new JPanel((LayoutManager)new VerticalFlowLayout());
        content2.setOpaque(false);
        content2.add(AssistantUiKt.assistantLabel("Item template"));
        content2.add((Component)this.mySpinner);
        content2.add(AssistantUiKt.assistantLabel("Item count"));
        content2.add((Component)this.myItemCount);
        String resourceName = null;
        String originalLayoutManager = this.myComponent.getAttribute("http://schemas.android.com/tools", "layoutManager");
        String originalListItem = this.myComponent.getAttribute("http://schemas.android.com/tools", "listitem");
        if (originalListItem != null) {
            int originalTemplateIndex;
            ResourceReference reference;
            ResourceUrl url = ResourceUrl.parse((String)originalListItem);
            ResourceReference resourceReference = reference = url != null ? url.resolve(ResourceNamespace.TODO(), ResourceNamespace.Resolver.EMPTY_RESOLVER) : null;
            if (reference != null && (originalTemplateIndex = RecyclerViewAssistant.getIndexOfMatchingTemplate((Template[])availableTemplates, facet, reference)) >= 0) {
                this.mySpinner.setSelectedIndex(originalTemplateIndex);
                resourceName = reference.getName();
                originalLayoutManager = null;
                originalListItem = null;
            }
        }
        this.myResourceName = resourceName == null ? RecyclerViewAssistant.getTemplateName(facet, "recycler_view_item") : resourceName;
        this.myOriginalListItemValue = originalListItem;
        this.myOriginalLayoutManager = originalLayoutManager;
        this.myOriginalSpanCountValue = this.myComponent.getAttribute("http://schemas.android.com/tools", "spanCount");
        if (this.myOriginalSpanCountValue != null) {
            try {
                this.myItemCount.setNumber(Integer.parseUnsignedInt(this.myOriginalSpanCountValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.addContent(content2);
        ApplicationManager.getApplication().invokeLater(this::fireSelectionUpdated);
        this.mySpinner.addListSelectionListener(event -> {
            if (event.getValueIsAdjusting()) {
                return;
            }
            this.fireSelectionUpdated();
        });
        this.myItemCount.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                RecyclerViewAssistant.setItemCount(RecyclerViewAssistant.this.myComponent, RecyclerViewAssistant.this.myItemCount.getNumber());
            }
        });
    }

    private static int parseItemCountAttribute(@Nullable String attribute) {
        if (attribute != null) {
            try {
                return Integer.parseInt(attribute);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 10;
    }

    private void fireSelectionUpdated() {
        Template template = (Template)this.mySpinner.getModel().getElementAt(this.mySpinner.getSelectedIndex());
        if (template == Template.NONE_TEMPLATE) {
            this.setOriginalState();
        } else {
            this.myCreatedFile = RecyclerViewAssistant.setTemplate(this.myProject, this.myComponent, this.myResourceName, template);
        }
    }

    @NotNull
    private static String getTemplateName(@NotNull AndroidFacet facet, @NotNull String templateRootName) {
        String resourceName;
        if (facet == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(4);
        }
        if (templateRootName == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(5);
        }
        LocalResourceRepository LocalResourceRepository2 = StudioResourceRepositoryManager.getAppResources((AndroidFacet)facet);
        String resourceNameRoot = FileResourceNameValidator.getValidResourceFileName((String)templateRootName);
        int index = 0;
        do {
            resourceName = resourceNameRoot + (String)(index < 1 ? "" : "_" + index);
            ++index;
        } while (!LocalResourceRepository2.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, resourceName).isEmpty());
        String string2 = resourceName;
        if (string2 == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(6);
        }
        return string2;
    }

    @Nullable
    private static PsiFile setTemplate(@NotNull Project project, @NotNull NlComponent component2, @NotNull String resourceName, @NotNull Template template) {
        if (project == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(7);
        }
        if (component2 == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(8);
        }
        if (resourceName == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(9);
        }
        if (template == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(10);
        }
        String content2 = template.getMyTemplate();
        VirtualFile resourceDir = component2.getModel().getVirtualFile().getParent().getParent();
        assert (resourceDir != null);
        return (PsiFile)WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            PsiManager manager;
            PsiFile psiFile2;
            List files = IdeResourcesUtil.findOrCreateStateListFiles((Project)project, (VirtualFile)resourceDir, (ResourceFolderType)ResourceFolderType.LAYOUT, (ResourceType)ResourceType.LAYOUT, (String)resourceName, Collections.singletonList("layout"));
            if (files == null || files.isEmpty()) {
                return null;
            }
            VirtualFile file2 = (VirtualFile)files.get(0);
            CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{file2});
            try (OutputStream stream = file2.getOutputStream(null);){
                stream.write(content2.getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOG.debug((Throwable)e);
            }
            component2.setAttribute("http://schemas.android.com/tools", "listitem", "@layout/" + resourceName);
            component2.setAttribute("http://schemas.android.com/tools", "spanCount", template.hasTag(TemplateTag.GRID) ? "5" : null);
            component2.setAttribute("http://schemas.android.com/tools", "layoutManager", template.hasTag(TemplateTag.GRID) ? "GridLayoutManager" : null);
            VirtualFile virtualFile2 = component2.getBackend().getAffectedFile();
            if (virtualFile2 != null) {
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile2});
            }
            if ((psiFile2 = (manager = PsiManager.getInstance((Project)project)).findFile(file2)) != null) {
                manager.reloadFromDisk(psiFile2);
            }
            return psiFile2;
        });
    }

    private static void setItemCount(@NotNull NlComponent component2, int newCount) {
        if (component2 == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(11);
        }
        NlWriteCommandActionUtil.run(component2, "Set itemCount", () -> {
            String itemCountNewValue = 10 == newCount ? null : Integer.toString(newCount);
            component2.setAttribute("http://schemas.android.com/tools", "itemCount", itemCountNewValue);
        });
    }

    private void setOriginalState() {
        if (this.myCreatedFile == null) {
            return;
        }
        AndroidFacet facet = this.myComponent.getModel().getFacet();
        Project project = facet.getModule().getProject();
        ApplicationManager.getApplication().invokeLater(() -> WriteCommandAction.runWriteCommandAction((Project)project, () -> {
            this.myCreatedFile.delete();
            this.myCreatedFile = null;
            this.myComponent.setAttribute("http://schemas.android.com/tools", "listitem", this.myOriginalListItemValue);
            this.myComponent.setAttribute("http://schemas.android.com/tools", "spanCount", this.myOriginalSpanCountValue);
            this.myComponent.setAttribute("http://schemas.android.com/tools", "layoutManager", this.myOriginalLayoutManager);
            CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{this.myComponent.getTagDeprecated().getContainingFile().getVirtualFile()});
        }));
    }

    @NotNull
    public static JComponent createComponent(@NotNull ComponentAssistantFactory.Context context) {
        if (context == null) {
            RecyclerViewAssistant.$$$reportNull$$$0(12);
        }
        return new RecyclerViewAssistant(context);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableTemplates";
                break;
            }
            case 3: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRootName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/handlers/assistant/RecyclerViewAssistant";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceName";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/assistant/RecyclerViewAssistant";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getIndexOfMatchingTemplate";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateName";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setTemplate";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setItemCount";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createComponent";
                break;
            }
        }
        String string2 = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string2);
            case 6 -> new IllegalStateException(string2);
        };
    }
}

