/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.AndroidXConstants;
import com.android.ide.common.gradle.Version;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.model.StudioAndroidModuleInfo;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstraintComponentUtilities {
    public static final HashMap<String, String> ourReciprocalAttributes;
    public static final Map<String, String> ourOtherSideAttributes;
    public static final HashMap<String, String> ourMapMarginAttributes;
    private static final HashMap<String, AnchorTarget.Type> ourMapSideToOriginAnchors;
    public static final ArrayList<String> ourLeftAttributes;
    public static final ArrayList<String> ourTopAttributes;
    public static final ArrayList<String> ourRightAttributes;
    public static final ArrayList<String> ourBottomAttributes;
    public static final ArrayList<String> ourStartAttributes;
    public static final ArrayList<String> ourEndAttributes;
    public static final ArrayList<String> ourBaselineAttributes;
    private static final ArrayList<String> ourHorizontalAttributes;
    private static final ArrayList<String> ourVerticalAttributes;
    public static final HashMap<String, String> ourLayoutUriToPrefix;
    public static final ArrayList<Pair<String, String>> ourLayoutAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourConstraintAttributes;
    private static final HashMap<String, String> ourLTRConvertedAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourLTRConstraintAnchorsToMargin;
    public static final HashMap<String, AnchorTarget.Type> ourLTRMapSideToTargetAnchors;
    private static final HashMap<String, String> ourRTLConvertedAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourRTLConstraintAnchorsToMargin;
    public static final HashMap<String, AnchorTarget.Type> ourRTLMapSideToTargetAnchors;
    public static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialAttributes;
    public static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialLTRAttributes;
    public static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialRTLAttributes;
    public static final String[] ourConstraintLayoutAttributesToClear;
    private static final String[] ourLayoutAttributesToClear;
    private static String[][] ATTRIB_MATRIX;
    private static String[][] ATTRIB_CLEAR;
    private static String[] ATTRIB_MARGIN;
    private static String[] ATTRIB_MARGIN_LR;

    public static String getAttribute(AnchorTarget.Type source, AnchorTarget.Type destination, boolean useRtlAttributes, boolean isRtl) {
        String converted;
        if (source == AnchorTarget.Type.BASELINE && destination == AnchorTarget.Type.BASELINE) {
            return "layout_constraintBaseline_toBaselineOf";
        }
        String attribute = ourConstraintAttributes.get(Pair.of((Object)((Object)source), (Object)((Object)destination)));
        if (useRtlAttributes && (converted = isRtl ? ourRTLConvertedAttributes.get(attribute) : ourLTRConvertedAttributes.get(attribute)) != null) {
            attribute = converted;
        }
        return attribute;
    }

    public static void clearAnchor(AnchorTarget.Type type, NlAttributesHolder transaction, boolean useRtlAttributes, boolean isRtl) {
        switch (type) {
            case LEFT: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                if (!useRtlAttributes) break;
                if (isRtl) {
                    ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialRTLAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                    break;
                }
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialLTRAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                break;
            }
            case RIGHT: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                if (!useRtlAttributes) break;
                if (isRtl) {
                    ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialRTLAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                    break;
                }
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialLTRAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                break;
            }
            case TOP: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourTopAttributes, transaction);
                break;
            }
            case BOTTOM: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourBottomAttributes, transaction);
                break;
            }
            case BASELINE: {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
            }
        }
    }

    public static boolean isAnchorConnected(AnchorTarget.Type type, NlComponent component2, boolean useRtlAttributes, boolean isRtl) {
        if (type == AnchorTarget.Type.BASELINE) {
            return component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        }
        boolean isConnected = false;
        Pair<String, String> pair = ourPotentialAttributes.get((Object)type);
        if (pair != null) {
            isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
            isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
        }
        if (useRtlAttributes) {
            if (isRtl) {
                pair = ourPotentialRTLAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            } else {
                pair = ourPotentialLTRAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            }
        }
        return isConnected;
    }

    public static ConstraintAnchorTarget getOriginAnchor(Scene scene, NlComponent targetComponent, String attribute) {
        AnchorTarget.Type type = ourMapSideToOriginAnchors.get(attribute);
        SceneComponent component2 = scene.getSceneComponent(targetComponent);
        if (component2 != null) {
            return ConstraintComponentUtilities.getAnchorTarget(component2, type);
        }
        return null;
    }

    public static ConstraintAnchorTarget getTargetAnchor(Scene scene, NlComponent targetComponent, String attribute, boolean supportsRtl, boolean isInRtl) {
        SceneComponent component2 = scene.getSceneComponent(targetComponent);
        if (component2 == null) {
            return null;
        }
        if (supportsRtl) {
            if (isInRtl) {
                return ConstraintComponentUtilities.getAnchorTarget(component2, ourRTLMapSideToTargetAnchors.get(attribute));
            }
            return ConstraintComponentUtilities.getAnchorTarget(component2, ourLTRMapSideToTargetAnchors.get(attribute));
        }
        return ConstraintComponentUtilities.getAnchorTarget(component2, ourLTRMapSideToTargetAnchors.get(attribute));
    }

    public static ConstraintAnchorTarget getAnchorTarget(@NotNull SceneComponent component2, @NotNull AnchorTarget.Type type) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(0);
        }
        if (type == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(1);
        }
        for (Target target : component2.getTargets()) {
            if (!(target instanceof ConstraintAnchorTarget) || ((ConstraintAnchorTarget)target).getType() != type) continue;
            return (ConstraintAnchorTarget)target;
        }
        return null;
    }

    private static boolean hasConstraints(NlComponent component2, String uri, ArrayList<String> constraints) {
        int count = constraints.size();
        for (int i = 0; i < count; ++i) {
            if (component2.getLiveAttribute(uri, constraints.get(i)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHorizontalConstraints(NlComponent component2) {
        return ConstraintComponentUtilities.hasConstraints(component2, "http://schemas.android.com/apk/res-auto", ourHorizontalAttributes);
    }

    public static boolean hasVerticalConstraints(NlComponent component2) {
        return ConstraintComponentUtilities.hasConstraints(component2, "http://schemas.android.com/apk/res-auto", ourVerticalAttributes);
    }

    public static int getDpValue(@NotNull NlComponent component2, String value2) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(2);
        }
        if (value2 != null && (resourceResolver = (configuration = component2.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value2, configuration);
            return px == null ? 0 : Coordinates.pxToDp(component2.getModel(), (int)px);
        }
        return 0;
    }

    public static int getGuidelineMode(SceneComponent component2) {
        NlComponent nlComponent = component2.getAuthoritativeNlComponent();
        String begin = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        if (begin != null) {
            return 0;
        }
        if (end != null) {
            return 1;
        }
        return 16;
    }

    private static NlComponent getOriginalComponent(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(3);
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_REFERENCE)) {
            NlComponent parent = component2.getParent();
            assert (parent != null);
            if (NlComponentHelperKt.isOrHasSuperclass(parent, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS)) {
                parent = parent.getParent();
                assert (parent != null);
                if (NlComponentHelperKt.isOrHasSuperclass(parent, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT)) {
                    for (NlComponent child : parent.getChildren()) {
                        if (child.getId() == null || !child.getId().equals(component2.getId())) continue;
                        return child;
                    }
                }
            }
        }
        return component2;
    }

    public static void clearAttributes(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(4);
        }
        ComponentModification modification = new ComponentModification(component2, "Cleared all constraints");
        ConstraintComponentUtilities.clearAllAttributes(component2, modification);
        modification.commit();
    }

    public static void setDpAttribute(String uri, String attribute, NlAttributesHolder transaction, int value2) {
        if (value2 > 0) {
            String position = String.format("%ddp", value2);
            transaction.setAttribute(uri, attribute, position);
        }
    }

    public static void clearAttributes(String uri, ArrayList<String> attributes, NlAttributesHolder transaction) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute(uri, attribute, null);
        }
    }

    public static void clearAttributes(String uri, String[] attributes, NlAttributesHolder transaction) {
        for (int i = 0; i < attributes.length; ++i) {
            transaction.setAttribute(uri, attributes[i], null);
        }
    }

    public static void clearAttributes(String uri, Pair<String, String> attributes, NlAttributesHolder transaction) {
        transaction.setAttribute(uri, (String)attributes.getFirst(), null);
        transaction.setAttribute(uri, (String)attributes.getSecond(), null);
    }

    private static void clearConnections(NlComponent component2, ArrayList<String> attributes, NlAttributesHolder transaction) {
        NlComponent parent;
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", attribute, null);
        }
        if (attributes == ourLeftAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourRightAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourStartAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourEndAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourTopAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else if (attributes == ourBottomAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        }
        if (!ConstraintComponentUtilities.hasHorizontalConstraints(component2)) {
            int offsetX = 0;
            parent = component2.getParent();
            if (parent != null) {
                offsetX = NlComponentHelperKt.getX(component2) - NlComponentHelperKt.getX(parent);
                offsetX = Coordinates.pxToDp(component2.getModel(), offsetX);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        }
        if (!ConstraintComponentUtilities.hasVerticalConstraints(component2)) {
            int offsetY = 0;
            parent = component2.getParent();
            if (parent != null) {
                offsetY = NlComponentHelperKt.getY(component2) - NlComponentHelperKt.getY(parent);
                offsetY = Coordinates.pxToDp(component2.getModel(), offsetY);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
        }
    }

    public static boolean clearSelectedConstraint(@NotNull DesignSurface<?> surface2) {
        if (surface2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(5);
        }
        SelectionModel selectionModel = surface2.getSelectionModel();
        Object secondarySelection = selectionModel.getSecondarySelection();
        Scene scene = surface2.getScene();
        if (secondarySelection instanceof SecondarySelector.Constraint && scene != null) {
            SecondarySelector.Constraint constraint = (SecondarySelector.Constraint)((Object)secondarySelection);
            AnchorTarget.Type type = null;
            switch (constraint) {
                case LEFT: {
                    type = AnchorTarget.Type.LEFT;
                    break;
                }
                case TOP: {
                    type = AnchorTarget.Type.TOP;
                    break;
                }
                case RIGHT: {
                    type = AnchorTarget.Type.RIGHT;
                    break;
                }
                case BOTTOM: {
                    type = AnchorTarget.Type.BOTTOM;
                    break;
                }
                case BASELINE: {
                    type = AnchorTarget.Type.BASELINE;
                }
            }
            SceneComponent component2 = scene.getSceneComponent(selectionModel.getPrimary());
            if (component2 == null) {
                return false;
            }
            AnchorTarget selectedTarget = AnchorTarget.findAnchorTarget(component2, type);
            if (selectedTarget != null) {
                NlComponent nlComponent = component2.getNlComponent();
                ComponentModification modification = new ComponentModification(nlComponent, "Constraint Disconnected");
                ConstraintComponentUtilities.clearAnchor(type, modification, component2.useRtlAttributes(), scene.isInRTL());
                ConstraintComponentUtilities.cleanup(modification, nlComponent);
                modification.commit();
                scene.markNeedsLayout(2);
                selectionModel.clearSecondary();
                return true;
            }
        }
        return false;
    }

    private static void clearAllAttributes(NlComponent component2, NlAttributesHolder transaction) {
        if (ConstraintComponentUtilities.isWidthConstrained(component2) && ConstraintComponentUtilities.isHorizontalResizable(component2)) {
            String fixedWidth = String.format("%ddp", ConstraintComponentUtilities.getDpWidth(component2));
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fixedWidth);
        }
        if (ConstraintComponentUtilities.isHeightConstrained(component2) && ConstraintComponentUtilities.isVerticalResizable(component2)) {
            String fixedHeight = String.format("%ddp", ConstraintComponentUtilities.getDpHeight(component2));
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fixedHeight);
        }
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourConstraintLayoutAttributesToClear, transaction);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res/android", ourLayoutAttributesToClear, transaction);
        component2 = ConstraintComponentUtilities.getOriginalComponent(component2);
        int offsetX = Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getX(component2) - (component2.isRoot() ? 0 : NlComponentHelperKt.getX(component2.getParent())));
        int offsetY = Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getY(component2) - (component2.isRoot() ? 0 : NlComponentHelperKt.getY(component2.getParent())));
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
    }

    public static void updateOnDelete(NlComponent component2, String targetId) {
        ComponentModification transaction = null;
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourLeftAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourTopAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourRightAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourBottomAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourBaselineAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourStartAttributes, transaction, targetId);
        if ((transaction = ConstraintComponentUtilities.updateOnDelete(component2, ourEndAttributes, transaction, targetId)) != null) {
            transaction.commit();
        }
    }

    private static ComponentModification updateOnDelete(NlComponent component2, ArrayList<String> attributes, ComponentModification modification, String targetId) {
        if (ConstraintComponentUtilities.isConnectedTo(component2, attributes, targetId)) {
            if (modification == null) {
                modification = new ComponentModification(component2, "Update on Delete");
            }
            ConstraintComponentUtilities.clearConnections(component2, attributes, modification);
        }
        return modification;
    }

    private static boolean isConnectedTo(NlComponent component2, ArrayList<String> attributes, String targetId) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            String target = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", attribute);
            if ((target = NlComponent.extractId(target)) == null || !target.equalsIgnoreCase(targetId)) continue;
            return true;
        }
        return false;
    }

    public static void ensureHorizontalPosition(NlComponent component2, NlAttributesHolder transaction) {
        if (ConstraintComponentUtilities.hasHorizontalConstraints(component2)) {
            return;
        }
        int dx = ConstraintComponentUtilities.getXfromParent(component2);
        if (dx > 0) {
            String position = String.format("%ddp", Coordinates.pxToDp(component2.getModel(), dx));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", position);
        }
    }

    public static void ensureVerticalPosition(NlComponent component2, NlAttributesHolder transaction) {
        if (ConstraintComponentUtilities.hasVerticalConstraints(component2)) {
            return;
        }
        int dy = ConstraintComponentUtilities.getYfromParent(component2);
        if (dy > 0) {
            String position = String.format("%ddp", Coordinates.pxToDp(component2.getModel(), dy));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", position);
        }
    }

    private static int getXfromParent(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(6);
        }
        return NlComponentHelperKt.getX(component2) - (component2.getParent() != null ? NlComponentHelperKt.getX(component2.getParent()) : 0);
    }

    private static int getYfromParent(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(7);
        }
        return NlComponentHelperKt.getY(component2) - (component2.getParent() != null ? NlComponentHelperKt.getY(component2.getParent()) : 0);
    }

    public static boolean isConstraintModelGreaterThan(@NotNull ViewEditor editor, String version) {
        if (editor == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(8);
        }
        GoogleMavenArtifactId artifact = GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT;
        Version v = NlDependencyManager.getInstance().getModuleDependencyVersion(artifact, editor.getModel().getFacet());
        if (v == null) {
            return true;
        }
        return v.compareTo(Version.Companion.parse(version)) > 0;
    }

    public static int getDpX(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(9);
        }
        return Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getX(component2));
    }

    private static boolean hasAttributes(@NotNull NlAttributesHolder transaction, String uri, ArrayList<String> attributes) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(10);
        }
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            if (transaction.getAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    public static String getConnectionId(@NotNull NlComponent component2, String uri, ArrayList<String> attributes) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(11);
        }
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = component2.getLiveAttribute(uri, attributes.get(i));
            if (attribute == null) continue;
            return NlComponent.extractId(attribute);
        }
        return null;
    }

    private static boolean hasLeft(@NotNull NlAttributesHolder transaction) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(12);
        }
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
    }

    private static boolean hasTop(@NotNull NlAttributesHolder transaction) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(13);
        }
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
    }

    private static boolean hasRight(@NotNull NlAttributesHolder transaction) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(14);
        }
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
    }

    private static boolean hasBottom(@NotNull NlAttributesHolder transaction) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(15);
        }
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
    }

    private static boolean hasStart(@NotNull NlAttributesHolder transaction) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(16);
        }
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourStartAttributes);
    }

    private static boolean hasEnd(@NotNull NlAttributesHolder transaction) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(17);
        }
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourEndAttributes);
    }

    private static boolean isInFlow(@NotNull NlComponent component2) {
        NlComponent parent;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(18);
        }
        if ((parent = component2.getParent()) == null) {
            return false;
        }
        String componentId = component2.getId();
        for (NlComponent child : parent.getChildren()) {
            String attr2;
            if (!NlComponentHelperKt.isOrHasSuperclass(child, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_FLOW) || (attr2 = child.getAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) == null) continue;
            for (String id2 : attr2.split(",")) {
                if (!id2.equals(componentId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void cleanup(@NotNull NlAttributesHolder transaction, @NotNull NlComponent component2) {
        if (transaction == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(19);
        }
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(20);
        }
        boolean hasLeft = ConstraintComponentUtilities.hasLeft(transaction);
        boolean hasRight = ConstraintComponentUtilities.hasRight(transaction);
        boolean hasTop = ConstraintComponentUtilities.hasTop(transaction);
        boolean hasBottom = ConstraintComponentUtilities.hasBottom(transaction);
        boolean hasBaseline = transaction.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        boolean hasStart = ConstraintComponentUtilities.hasStart(transaction);
        boolean hasEnd = ConstraintComponentUtilities.hasEnd(transaction);
        boolean inFlow = ConstraintComponentUtilities.isInFlow(component2);
        AndroidModuleInfo moduleInfo = StudioAndroidModuleInfo.getInstance((AndroidFacet)component2.getModel().getFacet());
        boolean remove_left_right = moduleInfo.getMinSdkVersion().isGreaterOrEqualThan(17);
        String margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
        if (margin != null && margin.equalsIgnoreCase("0dp")) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
        }
        if ((margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight")) != null && margin.equalsIgnoreCase("0dp")) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
        }
        if (!hasStart) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            if (!hasLeft) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            }
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            }
        }
        if (!hasEnd) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
            if (!hasRight) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            }
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            }
        }
        if (!(hasLeft && hasRight || hasStart && hasEnd)) {
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        }
        if (!(hasLeft || hasRight || hasStart || hasEnd)) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX") == null && !inFlow) {
                ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, ConstraintComponentUtilities.pixelToDP(component2, ConstraintComponentUtilities.getXfromParent(component2)));
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_chainStyle", null);
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
        }
        if (!hasTop) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            }
        }
        if (!hasBottom) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            }
        }
        if (!(hasTop || hasBottom || hasBaseline)) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY") == null && !inFlow) {
                ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, ConstraintComponentUtilities.pixelToDP(component2, ConstraintComponentUtilities.getYfromParent(component2)));
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_chainStyle", null);
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
        if (ConstraintComponentUtilities.isGuideLine(component2) || ConstraintComponentUtilities.isBarrier(component2) || ConstraintComponentUtilities.isGroup(component2)) {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
        if (remove_left_right) {
            boolean end;
            boolean start;
            boolean bl = start = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
            if (start) {
                boolean left;
                boolean bl2 = left = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
                if (left) {
                    transaction.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
                }
            }
            boolean bl3 = end = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
            if (end) {
                boolean right2;
                boolean bl4 = right2 = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
                if (right2) {
                    transaction.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
                }
            }
        }
    }

    public static boolean isGuideLine(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(21);
        }
        return AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(component2.getTagName());
    }

    private static boolean isBarrier(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(22);
        }
        return AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER.isEqualsIgnoreCase(component2.getTagName());
    }

    private static boolean isGroup(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(23);
        }
        return AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.isEqualsIgnoreCase(component2.getTagName());
    }

    @Nullable
    public static SceneComponent findChainHead(@NotNull SceneComponent component2, @NotNull ArrayList<String> sideA, @NotNull ArrayList<String> sideB) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(24);
        }
        if (sideA == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(25);
        }
        if (sideB == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(26);
        }
        int maxAttempts = 1000;
        for (int i = 0; i < 1000; ++i) {
            NlComponent nlComponent = component2.getAuthoritativeNlComponent();
            String attributeA = ConstraintComponentUtilities.getConnectionId(nlComponent, "http://schemas.android.com/apk/res-auto", sideA);
            if (attributeA == null) {
                return component2;
            }
            SceneComponent target = component2.getScene().getSceneComponent(attributeA);
            if (target == null) {
                return component2;
            }
            String attributeB = ConstraintComponentUtilities.getConnectionId(target.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideB);
            if (attributeB == null) {
                return component2;
            }
            if (!attributeB.equalsIgnoreCase(nlComponent.getId())) {
                return component2;
            }
            component2 = target;
        }
        return null;
    }

    public static boolean isInChain(ArrayList<String> sideA, ArrayList<String> sideB, SceneComponent component2) {
        String attributeB;
        SceneComponent target;
        String attributeA = ConstraintComponentUtilities.getConnectionId(component2.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideA);
        return attributeA != null && (target = component2.getScene().getSceneComponent(attributeA)) != null && (attributeB = ConstraintComponentUtilities.getConnectionId(target.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideB)) != null && attributeB.equalsIgnoreCase(component2.getAuthoritativeNlComponent().getId());
    }

    @Nullable
    public static NlComponent findChainHead(@NotNull NlComponent component2, @Nullable ArrayList<String> sideA, @Nullable ArrayList<String> sideB) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(27);
        }
        int maxAttempts = 1000;
        for (int i = 0; i < 1000; ++i) {
            String attributeA = ConstraintComponentUtilities.getConnectionId(component2, "http://schemas.android.com/apk/res-auto", sideA);
            if (attributeA == null) {
                return component2;
            }
            NlComponent parent = component2.getParent();
            assert (parent != null);
            List<NlComponent> list = parent.getChildren();
            NlComponent target = ConstraintComponentUtilities.getComponent(list, attributeA);
            if (target == null) {
                return component2;
            }
            String attributeB = ConstraintComponentUtilities.getConnectionId(target, "http://schemas.android.com/apk/res-auto", sideB);
            if (attributeB == null) {
                return component2;
            }
            if (!attributeB.equalsIgnoreCase(component2.getId())) {
                return component2;
            }
            component2 = target;
        }
        return null;
    }

    public static NlComponent getComponent(List<NlComponent> list, String id2) {
        for (NlComponent nlComponent : list) {
            if (!id2.equals(nlComponent.getId())) continue;
            return nlComponent;
        }
        return null;
    }

    public static boolean isInChain(@NotNull ArrayList<String> sideA, @NotNull ArrayList<String> sideB, @NotNull NlComponent component2) {
        String attributeB;
        List<NlComponent> list;
        NlComponent target;
        if (sideA == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(28);
        }
        if (sideB == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(29);
        }
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(30);
        }
        String attributeA = ConstraintComponentUtilities.getConnectionId(component2, "http://schemas.android.com/apk/res-auto", sideA);
        NlComponent parent = component2.getParent();
        return attributeA != null && parent != null && (target = ConstraintComponentUtilities.getComponent(list = parent.getChildren(), attributeA)) != null && (attributeB = ConstraintComponentUtilities.getConnectionId(target, "http://schemas.android.com/apk/res-auto", sideB)) != null && attributeB.equalsIgnoreCase(component2.getId());
    }

    public static int getDpY(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(31);
        }
        return Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getY(component2));
    }

    public static int getDpWidth(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(32);
        }
        return Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getW(component2));
    }

    public static int getDpHeight(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(33);
        }
        return Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getH(component2));
    }

    public static int pixelToDP(@NotNull NlComponent component2, int size) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(34);
        }
        return Coordinates.pxToDp(component2.getModel(), size);
    }

    public static int getDpBaseline(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(35);
        }
        return Coordinates.pxToDp(component2.getModel(), NlComponentHelperKt.getBaseline(component2));
    }

    public static boolean hasBaseline(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(36);
        }
        return NlComponentHelperKt.getBaseline(component2) > 0;
    }

    public static boolean isLine(@NotNull NlComponent component2) {
        ViewInfo viewInfo;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(37);
        }
        if ((viewInfo = NlComponentHelperKt.getViewInfo(component2)) == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE)) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER);
    }

    public static boolean isVerticalLine(@NotNull NlComponent component2) {
        String dir;
        String orientation2;
        ViewInfo viewInfo;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(38);
        }
        if ((viewInfo = NlComponentHelperKt.getViewInfo(component2)) == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("vertical")) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER) && (dir = component2.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection")) != null && (dir.equalsIgnoreCase("left") || dir.equalsIgnoreCase("right") || dir.equalsIgnoreCase("start") || dir.equalsIgnoreCase("end"));
    }

    public static boolean isHorizontalLine(@NotNull NlComponent component2) {
        String dir;
        String orientation2;
        ViewInfo viewInfo;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(39);
        }
        if ((viewInfo = NlComponentHelperKt.getViewInfo(component2)) == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("horizontal")) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER) && (dir = component2.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection")) != null && (dir.equalsIgnoreCase("top") || dir.equalsIgnoreCase("bottom"));
    }

    public static boolean isHorizontalGuideline(@NotNull NlComponent component2) {
        String orientation2;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(40);
        }
        return NlComponentHelperKt.getViewInfo(component2) != null && NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("horizontal");
    }

    public static boolean isVerticalGuideline(@NotNull NlComponent component2) {
        String orientation2;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(41);
        }
        return NlComponentHelperKt.getViewInfo(component2) != null && NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component2.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("vertical");
    }

    private static boolean isHeightConstrained(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(42);
        }
        String tb = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf");
        String tt = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf");
        if (tt == null && tb == null) {
            return false;
        }
        String bb = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf");
        String bt = component2.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf");
        return bt != null || bb != null;
    }

    private static boolean isWidthConstrained(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(43);
        }
        String se = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toEndOf");
        String ss = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toStartOf");
        String ee = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf");
        String es = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toStartOf");
        if (ee != null || es != null || se != null || ss != null) {
            return !(ee == null && es == null || se == null && ss == null);
        }
        String ll = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf");
        String lr = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf");
        String rr = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf");
        String rl = component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf");
        return !(ll == null && lr == null || rl == null && rr == null);
    }

    public static boolean isHorizontalResizable(@NotNull NlComponent component2) {
        String dimension;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(44);
        }
        if ((dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_width")) == null) {
            return false;
        }
        return dimension.equalsIgnoreCase("0dp");
    }

    public static boolean isVerticalResizable(@NotNull NlComponent component2) {
        String dimension;
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(45);
        }
        if ((dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_height")) == null) {
            return false;
        }
        return dimension.equalsIgnoreCase("0dp");
    }

    public static boolean hasUserResizedHorizontally(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(46);
        }
        String dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        assert (dimension != null || "include".equals(component2.getTagName()));
        return dimension != null && !dimension.equalsIgnoreCase("wrap_content");
    }

    public static boolean hasUserResizedVertically(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(47);
        }
        String dimension = component2.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        assert (dimension != null || "include".equals(component2.getTagName()));
        return dimension != null && !dimension.equalsIgnoreCase("wrap_content");
    }

    public static int getMargin(@NotNull NlComponent component2, String margin_attr) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(48);
        }
        int margin = 0;
        String marginString = component2.getLiveAttribute("http://schemas.android.com/apk/res/android", margin_attr);
        if (marginString == null) {
            marginString = "layout_marginLeft".equalsIgnoreCase(margin_attr) ? component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart") : component2.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
        }
        if (marginString == null || marginString.startsWith("@")) {
            // empty if block
        }
        return Coordinates.pxToDp(component2.getModel(), margin);
    }

    public static void setScoutAbsoluteDpX(@NotNull NlComponent component2, int dp, boolean apply) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(49);
        }
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/tools", "layout_editor_absoluteX", dp, apply);
    }

    public static void setScoutAbsoluteDpY(@NotNull NlComponent component2, int dp, boolean apply) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(50);
        }
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/tools", "layout_editor_absoluteY", dp, apply);
    }

    public static void setScoutAbsoluteDpWidth(@NotNull NlComponent component2, int dp, boolean apply) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(51);
        }
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/apk/res/android", "layout_width", dp, apply);
    }

    public static void setScoutAbsoluteDpHeight(@NotNull NlComponent component2, int dp, boolean apply) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(52);
        }
        ConstraintComponentUtilities.setScoutAttributeValue(component2, "http://schemas.android.com/apk/res/android", "layout_height", dp, apply);
    }

    public static void setScoutVerticalBiasPercent(@NotNull NlComponent component2, float value2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(53);
        }
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", Float.toString(value2));
        transaction.apply();
    }

    public static void setScoutHorizontalBiasPercent(@NotNull NlComponent component2, float value2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(54);
        }
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", Float.toString(value2));
        transaction.apply();
    }

    private static void setScoutAttributeValue(@NotNull NlComponent component2, @NotNull String uri, @NotNull String attribute, int dp, boolean apply) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(55);
        }
        if (uri == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(56);
        }
        if (attribute == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(57);
        }
        if (dp <= 0) {
            return;
        }
        String position = String.format("%ddp", dp);
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute(uri, attribute, position);
        if (apply) {
            transaction.apply();
        }
    }

    public static void scoutClearAttributes(@NotNull NlComponent component2, ArrayList<String> attributes) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(58);
        }
        AttributesTransaction transaction = component2.startAttributeTransaction();
        ConstraintComponentUtilities.clearConnections(component2, attributes, transaction);
        transaction.apply();
    }

    public static void setScoutAttributeValue(@NotNull NlComponent component2, @NotNull String uri, @NotNull String attribute, @NotNull String value2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(59);
        }
        if (uri == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(60);
        }
        if (attribute == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(61);
        }
        if (value2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(62);
        }
        AttributesTransaction transaction = component2.startAttributeTransaction();
        transaction.setAttribute(uri, attribute, value2);
        transaction.apply();
    }

    public static boolean isConstraintLayout(@NotNull NlComponent component2) {
        if (component2 == null) {
            ConstraintComponentUtilities.$$$reportNull$$$0(63);
        }
        return NlComponentHelperKt.isOrHasSuperclass(component2, AndroidXConstants.CONSTRAINT_LAYOUT) || AndroidXConstants.CONSTRAINT_LAYOUT.isEquals(component2.getTagDeprecated().getName());
    }

    public static void clearAttributes(String uri, ArrayList<String> attributes, MTag.TagWriter tagwriter) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            tagwriter.setAttribute(uri, attribute, null);
        }
    }

    public static void scoutConstraintSetConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, int margin) {
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + sourceDirection + " to " + targetDirection);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        MTag.TagWriter tagwriter = MotionSceneUtils.getTagWriter(source);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, tagwriter);
        Object targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        tagwriter.setAttribute("http://schemas.android.com/apk/res-auto", attrib, (String)targetId);
        if (srcIndex <= Direction.BASELINE.ordinal() && margin > 0) {
            tagwriter.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN[srcIndex], margin + "dp");
            if (ATTRIB_MARGIN_LR[srcIndex] != null) {
                tagwriter.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN_LR[srcIndex], margin + "dp");
            }
        }
        tagwriter.commit("create connection");
        String str = switch (sourceDirection) {
            case Direction.BASELINE -> "baseline";
            case Direction.BOTTOM -> "bottom";
            case Direction.LEFT -> "left";
            case Direction.RIGHT -> "right";
            case Direction.TOP -> "north";
            default -> null;
        };
        if (str != null) {
            DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
        }
    }

    public static void scoutConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, int margin) {
        if (MotionSceneUtils.isUnderConstraintSet(source)) {
            ConstraintComponentUtilities.scoutConstraintSetConnect(source, sourceDirection, target, targetDirection, margin);
            return;
        }
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + sourceDirection + " to " + targetDirection);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        AttributesTransaction transaction = source.startAttributeTransaction();
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, (NlAttributesHolder)transaction);
        Object targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", attrib, (String)targetId);
        if (srcIndex <= Direction.BASELINE.ordinal() && margin > 0) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN[srcIndex], margin + "dp");
            if (ATTRIB_MARGIN_LR[srcIndex] != null) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN_LR[srcIndex], margin + "dp");
            }
        }
        transaction.apply();
        String str = switch (sourceDirection) {
            case Direction.BASELINE -> "baseline";
            case Direction.BOTTOM -> "bottom";
            case Direction.LEFT -> "left";
            case Direction.RIGHT -> "right";
            case Direction.TOP -> "north";
            default -> null;
        };
        if (str != null) {
            DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
        }
    }

    public static void scoutChainConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, ArrayList<String[]> attrList) {
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + sourceDirection + " to " + targetDirection);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        AttributesTransaction transaction = source.startAttributeTransaction();
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, (NlAttributesHolder)transaction);
        Object targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", attrib, (String)targetId);
        for (int i = 0; i < attrList.size(); ++i) {
            String[] bundle = attrList.get(i);
            transaction.setAttribute(bundle[0], bundle[1], bundle[2]);
        }
        transaction.apply();
        String str = null;
        switch (sourceDirection) {
            case BASELINE: {
                str = "baseline";
                break;
            }
            case BOTTOM: {
                str = "bottom";
                break;
            }
            case LEFT: {
                str = "left";
                break;
            }
            case RIGHT: {
                str = "right";
                break;
            }
            case TOP: {
                str = "north";
            }
        }
        DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
    }

    public static boolean wouldCreateLoop(NlComponent source, Direction sourceDirection, NlComponent target) {
        if (source.getParent() == null) {
            return true;
        }
        List<NlComponent> sisters = source.getParent().getChildren();
        switch (sourceDirection) {
            case BOTTOM: 
            case TOP: {
                HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(source, sisters, ourBottomAttributes, ourTopAttributes, ourBaselineAttributes);
                return connected.contains(target);
            }
            case LEFT: 
            case RIGHT: {
                HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(source, sisters, ourRightAttributes, ourLeftAttributes, ourStartAttributes, ourEndAttributes);
                return connected.contains(target);
            }
            case BASELINE: {
                HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(source, sisters, ourBottomAttributes, ourTopAttributes, ourBaselineAttributes);
                return connected.contains(target);
            }
        }
        return false;
    }

    @SafeVarargs
    private static HashSet<String> getConnected(NlComponent c, List<NlComponent> sisters, ArrayList<String> ... list) {
        int lastCount;
        HashSet<String> set = new HashSet<String>();
        set.add(c.getId());
        do {
            lastCount = set.size();
            for (NlComponent sister : sisters) {
                for (int i = 0; i < list.length; ++i) {
                    String str = ConstraintComponentUtilities.getConnectionId(sister, "http://schemas.android.com/apk/res-auto", list[i]);
                    if (!set.contains(str)) continue;
                    set.add(sister.getId());
                }
            }
        } while (set.size() > lastCount);
        return set;
    }

    @SafeVarargs
    private static boolean isConnected(NlComponent component2, ArrayList<String> ... list) {
        for (int i = 0; i < list.length; ++i) {
            int count = list[i].size();
            for (int k = 0; k < count; ++k) {
                if (null == component2.getLiveAttribute("http://schemas.android.com/apk/res-auto", list[i].get(k))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean useLeftRight(NlComponent component2) {
        if (ConstraintComponentUtilities.isConnected(component2, ourStartAttributes, ourEndAttributes)) {
            return false;
        }
        return ConstraintComponentUtilities.isConnected(component2, ourLeftAttributes, ourRightAttributes);
    }

    static {
        ourLayoutUriToPrefix = new HashMap();
        ourLayoutUriToPrefix.put("http://schemas.android.com/apk/res/android", "android:");
        ourLayoutUriToPrefix.put("http://schemas.android.com/apk/res-auto", "app:");
        ourLayoutAttributes = new ArrayList();
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_width"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_height"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginStart"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginEnd"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginLeft"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginRight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginTop"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginBottom"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintEnd_toStartOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintEnd_toEndOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintStart_toStartOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintStart_toEndOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintLeft_toLeftOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintLeft_toRightOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintRight_toLeftOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintRight_toRightOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintTop_toTopOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintTop_toBottomOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBottom_toTopOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBottom_toBottomOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBaseline_toBaselineOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_bias"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_bias"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_chainStyle"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_chainStyle"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_weight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_weight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintDimensionRatio"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"horizontal"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"vertical"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginStart"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginEnd"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginLeft"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginRight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginTop"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginBottom"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintWidth_default"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHeight_default"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minHeight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_maxWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_maxHeight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/tools", (Object)"layout_editor_absoluteX"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/tools", (Object)"layout_editor_absoluteY"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_begin"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_end"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_percent"));
        ourConstraintAttributes = new HashMap();
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_constraintLeft_toLeftOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_constraintLeft_toRightOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_constraintRight_toLeftOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_constraintRight_toRightOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.TOP), (Object)((Object)AnchorTarget.Type.TOP)), "layout_constraintTop_toTopOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.TOP), (Object)((Object)AnchorTarget.Type.BOTTOM)), "layout_constraintTop_toBottomOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.BOTTOM), (Object)((Object)AnchorTarget.Type.TOP)), "layout_constraintBottom_toTopOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.BOTTOM), (Object)((Object)AnchorTarget.Type.BOTTOM)), "layout_constraintBottom_toBottomOf");
        ourLTRConvertedAttributes = new HashMap();
        ourLTRConstraintAnchorsToMargin = new HashMap();
        ourLTRMapSideToTargetAnchors = new HashMap();
        ourLTRConvertedAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintStart_toStartOf");
        ourLTRConvertedAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintStart_toEndOf");
        ourLTRConvertedAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintEnd_toStartOf");
        ourLTRConvertedAttributes.put("layout_constraintRight_toRightOf", "layout_constraintEnd_toEndOf");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginStart");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginStart");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginEnd");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginEnd");
        ourLTRMapSideToTargetAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourLTRMapSideToTargetAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.TOP);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourLTRMapSideToTargetAnchors.put("layout_constraintStart_toStartOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintStart_toEndOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintEnd_toStartOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintEnd_toEndOf", AnchorTarget.Type.RIGHT);
        ourRTLConvertedAttributes = new HashMap();
        ourRTLConstraintAnchorsToMargin = new HashMap();
        ourRTLMapSideToTargetAnchors = new HashMap();
        ourRTLConvertedAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintEnd_toEndOf");
        ourRTLConvertedAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintEnd_toStartOf");
        ourRTLConvertedAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintStart_toEndOf");
        ourRTLConvertedAttributes.put("layout_constraintRight_toRightOf", "layout_constraintStart_toStartOf");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginEnd");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginEnd");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginStart");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginStart");
        ourRTLMapSideToTargetAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourRTLMapSideToTargetAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.TOP);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourRTLMapSideToTargetAnchors.put("layout_constraintStart_toStartOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintStart_toEndOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintEnd_toStartOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintEnd_toEndOf", AnchorTarget.Type.LEFT);
        ourPotentialAttributes = new HashMap();
        ourPotentialAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintLeft_toRightOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintRight_toLeftOf", (Object)"layout_constraintRight_toRightOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.TOP, (Pair<String, String>)Pair.of((Object)"layout_constraintTop_toTopOf", (Object)"layout_constraintTop_toBottomOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.BOTTOM, (Pair<String, String>)Pair.of((Object)"layout_constraintBottom_toTopOf", (Object)"layout_constraintBottom_toBottomOf"));
        ourPotentialLTRAttributes = new HashMap();
        ourPotentialLTRAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintStart_toStartOf", (Object)"layout_constraintStart_toEndOf"));
        ourPotentialLTRAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintEnd_toStartOf", (Object)"layout_constraintEnd_toEndOf"));
        ourPotentialRTLAttributes = new HashMap();
        ourPotentialRTLAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintEnd_toEndOf", (Object)"layout_constraintEnd_toStartOf"));
        ourPotentialRTLAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintStart_toEndOf", (Object)"layout_constraintStart_toStartOf"));
        ourConstraintLayoutAttributesToClear = new String[]{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf", "layout_constraintStart_toEndOf", "layout_constraintStart_toStartOf", "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_goneMarginLeft", "layout_goneMarginTop", "layout_goneMarginRight", "layout_goneMarginBottom", "layout_goneMarginStart", "layout_goneMarginEnd", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintWidth_default", "layout_constraintHeight_default", "layout_constraintWidth_min", "layout_constraintWidth_max", "layout_constraintHeight_min", "layout_constraintHeight_max", "layout_constraintLeft_creator", "layout_constraintTop_creator", "layout_constraintRight_creator", "layout_constraintBottom_creator", "layout_constraintBaseline_creator", "layout_constraintDimensionRatio", "layout_constraintHorizontal_weight", "layout_constraintVertical_weight", "layout_constraintHorizontal_chainStyle", "layout_constraintVertical_chainStyle"};
        ourLayoutAttributesToClear = new String[]{"layout_margin", "layout_marginLeft", "layout_marginStart", "layout_marginRight", "layout_marginEnd", "layout_marginTop", "layout_marginBottom", "layout_marginStart"};
        ourReciprocalAttributes = new HashMap();
        ourReciprocalAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf");
        ourReciprocalAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintLeft_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf");
        ourReciprocalAttributes.put("layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintTop_toBottomOf", "layout_constraintTop_toTopOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf");
        ourReciprocalAttributes.put("layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf");
        ourReciprocalAttributes.put("layout_constraintStart_toEndOf", "layout_constraintStart_toStartOf");
        ourReciprocalAttributes.put("layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf");
        ourReciprocalAttributes.put("layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf");
        ourOtherSideAttributes = new ImmutableMap.Builder().put((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintRight_toRightOf").put((Object)"layout_constraintRight_toRightOf", (Object)"layout_constraintLeft_toLeftOf").put((Object)"layout_constraintEnd_toEndOf", (Object)"layout_constraintStart_toStartOf").put((Object)"layout_constraintStart_toStartOf", (Object)"layout_constraintEnd_toEndOf").put((Object)"layout_constraintTop_toTopOf", (Object)"layout_constraintBottom_toBottomOf").put((Object)"layout_constraintBottom_toBottomOf", (Object)"layout_constraintTop_toTopOf").build();
        ourMapMarginAttributes = new HashMap();
        ourMapMarginAttributes.put("layout_constraintLeft_toLeftOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintLeft_toRightOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintRight_toLeftOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintRight_toRightOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintTop_toTopOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintTop_toBottomOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintBottom_toTopOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintBottom_toBottomOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintStart_toStartOf", "layout_marginStart");
        ourMapMarginAttributes.put("layout_constraintStart_toEndOf", "layout_marginStart");
        ourMapMarginAttributes.put("layout_constraintEnd_toStartOf", "layout_marginEnd");
        ourMapMarginAttributes.put("layout_constraintEnd_toEndOf", "layout_marginEnd");
        ourMapSideToOriginAnchors = new HashMap();
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourLeftAttributes = new ArrayList();
        ourLeftAttributes.add("layout_constraintLeft_toLeftOf");
        ourLeftAttributes.add("layout_constraintLeft_toRightOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintRight_toLeftOf");
        ourRightAttributes.add("layout_constraintRight_toRightOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
        ourBaselineAttributes = new ArrayList();
        ourBaselineAttributes.add("layout_constraintBaseline_toBaselineOf");
        ourStartAttributes = new ArrayList();
        ourStartAttributes.add("layout_constraintStart_toStartOf");
        ourStartAttributes.add("layout_constraintStart_toEndOf");
        ourEndAttributes = new ArrayList();
        ourEndAttributes.add("layout_constraintEnd_toStartOf");
        ourEndAttributes.add("layout_constraintEnd_toEndOf");
        ourHorizontalAttributes = new ArrayList();
        ourHorizontalAttributes.add("layout_constraintLeft_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintLeft_toRightOf");
        ourHorizontalAttributes.add("layout_constraintRight_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintRight_toRightOf");
        ourHorizontalAttributes.add("layout_constraintStart_toStartOf");
        ourHorizontalAttributes.add("layout_constraintStart_toEndOf");
        ourHorizontalAttributes.add("layout_constraintEnd_toStartOf");
        ourHorizontalAttributes.add("layout_constraintEnd_toEndOf");
        ourVerticalAttributes = new ArrayList();
        ourVerticalAttributes.add("layout_constraintTop_toTopOf");
        ourVerticalAttributes.add("layout_constraintTop_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBottom_toTopOf");
        ourVerticalAttributes.add("layout_constraintBottom_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBaseline_toBaselineOf");
        ATTRIB_MATRIX = new String[][]{{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", null, null, null}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", null, null, null}, {null, null, "layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", null}, {null, null, "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", null}, {null, null, null, null, "layout_constraintBaseline_toBaselineOf"}};
        ATTRIB_CLEAR = new String[][]{{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBaseline_toBaselineOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf"}, {"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_toStartOf"}, {"layout_constraintBaseline_toBaselineOf"}};
        ATTRIB_MARGIN = new String[]{"layout_marginTop", "layout_marginBottom", "layout_marginStart", "layout_marginEnd"};
        ATTRIB_MARGIN_LR = new String[]{null, null, "layout_marginLeft", "layout_marginRight"};
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surface";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transaction";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sideA";
                break;
            }
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sideB";
                break;
            }
            case 56: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/handlers/constraint/ConstraintComponentUtilities";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAnchorTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getDpValue";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "clearAttributes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "clearSelectedConstraint";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getXfromParent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getYfromParent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstraintModelGreaterThan";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getDpX";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "hasAttributes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getConnectionId";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "hasLeft";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "hasTop";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "hasRight";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[2] = "hasBottom";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "hasStart";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "hasEnd";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "isInFlow";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "cleanup";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "isGuideLine";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isBarrier";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "isGroup";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "findChainHead";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "isInChain";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "getDpY";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[2] = "getDpWidth";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "getDpHeight";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[2] = "pixelToDP";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "getDpBaseline";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "hasBaseline";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "isLine";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[2] = "isVerticalLine";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "isHorizontalLine";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "isHorizontalGuideline";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "isVerticalGuideline";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[2] = "isHeightConstrained";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "isWidthConstrained";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "isHorizontalResizable";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[2] = "isVerticalResizable";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUserResizedHorizontally";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "hasUserResizedVertically";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "getMargin";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "setScoutAbsoluteDpX";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[2] = "setScoutAbsoluteDpY";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[2] = "setScoutAbsoluteDpWidth";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[2] = "setScoutAbsoluteDpHeight";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[2] = "setScoutVerticalBiasPercent";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[2] = "setScoutHorizontalBiasPercent";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray2;
                objectArray2[2] = "setScoutAttributeValue";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[2] = "scoutClearAttributes";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[2] = "isConstraintLayout";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

